/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jd.config.ConfigEntry;
import jd.config.ConfigGroup;

public class ConfigContainer
implements Serializable {
    private static final long serialVersionUID = 6583843494325603616L;
    public static final int TYPE_TEXTFIELD = 0;
    public static final int TYPE_BUTTON = 2;
    public static final int TYPE_CHECKBOX = 3;
    public static final int TYPE_LABEL = 4;
    public static final int TYPE_SEPARATOR = 6;
    public static final int TYPE_SPINNER = 8;
    public static final int TYPE_TEXTAREA = 10;
    public static final int TYPE_PASSWORDFIELD = 11;
    public static final int TYPE_COMPONENT = 12;
    public static final int TYPE_COMBOBOX_INDEX = 15;
    private final List<ConfigEntry> content = new ArrayList<ConfigEntry>();
    private String title;
    private ConfigGroup group;
    private Icon icon;

    public ConfigContainer() {
    }

    public ConfigContainer(String title) {
        this();
        this.title = title;
    }

    public int indexOf(ConfigEntry entry) {
        return this.content.indexOf(entry);
    }

    public void addEntry(ConfigEntry entry) {
        if (entry.getGroup() == null) {
            entry.setGroup(this.group);
        }
        this.content.add(entry);
    }

    public void addEntry(ConfigEntry entry, int index) {
        if (entry.getGroup() == null) {
            entry.setGroup(this.group);
        }
        if (index < 0 || index > this.content.size()) {
            this.content.add(entry);
        } else {
            this.content.add(index, entry);
        }
    }

    public List<ConfigEntry> getEntries() {
        return this.content;
    }

    public String getTitle() {
        return this.title;
    }

    public void setGroup(ConfigGroup configGroup) {
        this.group = configGroup;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }
}

