/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import jd.controlling.ClipboardMonitoring;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class WindowsClipboardChangeDetector
extends ClipboardMonitoring.ClipboardChangeDetector {
    private final User32 user32 = (User32)Native.load((String)"user32", User32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    private volatile Integer lastClipboardSequenceNumber = null;
    private final psapi psapi = (psapi)Native.load((String)"psapi", psapi.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    private final Kernel32 kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    private final Pattern[] blackListPatterns;
    private final boolean isProcessBlacklisted;

    protected WindowsClipboardChangeDetector(AtomicReference<AtomicBoolean> skipChangeFlag, LogSource logger) {
        super(skipChangeFlag);
        String[] blackList = CFG_GUI.CFG.getClipboardProcessBlacklist();
        ArrayList<Pattern> blackListPatterns = new ArrayList<Pattern>();
        if (blackList != null) {
            for (String entry : blackList) {
                try {
                    blackListPatterns.add(Pattern.compile(entry));
                }
                catch (Throwable th) {
                    logger.log(th);
                }
            }
        }
        this.blackListPatterns = blackListPatterns.toArray(new Pattern[0]);
        this.isProcessBlacklisted = this.blackListPatterns.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getClipboardOwnerProcess() {
        WinDef.HWND hWnd = this.user32.GetClipboardOwner();
        if (hWnd != null) {
            IntByReference pid = new IntByReference();
            this.user32.GetWindowThreadProcessId(hWnd, pid);
            Pointer process = this.kernel32.OpenProcess(1040, false, pid.getValue());
            if (process != null) {
                try {
                    Pointer zero = new Pointer(0L);
                    byte[] exePathname = new byte[1024];
                    int result = this.psapi.GetModuleFileNameExA(process, zero, exePathname, 512);
                    String ret = Native.toString((byte[])exePathname).substring(0, result);
                    if (ret != null) {
                        String string = ret.trim();
                        return string;
                    }
                }
                finally {
                    this.kernel32.CloseHandle(process);
                }
            }
        }
        return null;
    }

    private final boolean isProcessBlacklisted(String process) {
        for (Pattern blackListPattern : this.blackListPatterns) {
            if (!blackListPattern.matcher(process).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void slowDown(Throwable e) {
    }

    @Override
    protected int getCurrentWaitTimeout() {
        return 100;
    }

    @Override
    protected void restart() {
        super.restart();
    }

    @Override
    protected void reset() {
        this.lastClipboardSequenceNumber = null;
    }

    private final boolean isChangeBlacklisted() {
        if (this.isProcessBlacklisted) {
            String process = this.getClipboardOwnerProcess();
            return process != null && this.isProcessBlacklisted(process);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClipboardMonitoring.ClipboardChangeDetector.CHANGE_FLAG hasChanges() {
        int currentClipboardSequenceNumber = this.user32.GetClipboardSequenceNumber();
        if (currentClipboardSequenceNumber != 0 && (this.lastClipboardSequenceNumber == null || currentClipboardSequenceNumber != this.lastClipboardSequenceNumber)) {
            this.lastClipboardSequenceNumber = currentClipboardSequenceNumber;
            if (this.isChangeBlacklisted()) {
                return ClipboardMonitoring.ClipboardChangeDetector.CHANGE_FLAG.BLACKLISTED;
            }
            if (this.isSkipFlagSet()) {
                return ClipboardMonitoring.ClipboardChangeDetector.CHANGE_FLAG.SKIP;
            }
            return ClipboardMonitoring.ClipboardChangeDetector.CHANGE_FLAG.DETECTED;
        }
        try {
            WindowsClipboardChangeDetector windowsClipboardChangeDetector = this;
            synchronized (windowsClipboardChangeDetector) {
                this.wait(this.getCurrentWaitTimeout());
            }
            return ClipboardMonitoring.ClipboardChangeDetector.CHANGE_FLAG.FALSE;
        }
        catch (InterruptedException e) {
            return ClipboardMonitoring.ClipboardChangeDetector.CHANGE_FLAG.INTERRUPTED;
        }
    }

    private static interface psapi
    extends StdCallLibrary {
        public int GetModuleFileNameExA(Pointer var1, Pointer var2, byte[] var3, int var4);
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public Pointer OpenProcess(int var1, boolean var2, int var3);

        public boolean CloseHandle(Pointer var1);
    }

    private static interface User32
    extends StdCallLibrary {
        public int GetClipboardSequenceNumber();

        public WinDef.HWND GetClipboardOwner();

        public int GetWindowThreadProcessId(WinDef.HWND var1, IntByReference var2);
    }
}

