/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import org.appwork.utils.Files;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;

public class DiskSpaceChecker {
    protected final DiskSpaceReservation diskSpaceReservation;
    protected final Object requestor;
    protected final CopyOnWriteArrayList<String> roots = new CopyOnWriteArrayList();

    public DiskSpaceChecker(DiskSpaceReservation diskSpaceReservation, Object requestor) {
        this.diskSpaceReservation = diskSpaceReservation;
        this.requestor = requestor;
        this.findRoots();
    }

    public String getRoot() {
        if (this.roots.size() > 0) {
            return this.roots.get(0);
        }
        return null;
    }

    protected void findRoots() {
        File dest = this.getDestination();
        File normalRoot = Files.guessRoot((File)dest);
        if (normalRoot != null) {
            this.roots.addIfAbsent(normalRoot.toString());
        }
        try {
            File realRoot = Files.guessRoot((File)dest.getCanonicalFile());
            if (realRoot != null) {
                this.roots.addIfAbsent(realRoot.toString());
            }
        }
        catch (IOException e) {
            this.log(e);
        }
    }

    protected void log(Throwable e) {
        this.getLogger().log(e);
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public long getSize() {
        return this.getDiskSpaceReservation().getSize();
    }

    public long getUsableSpace() {
        return Files.getUsableSpace((File)this.getDestination());
    }

    public DiskSpaceReservation getDiskSpaceReservation() {
        return this.diskSpaceReservation;
    }

    protected File getDestination() {
        return this.getDiskSpaceReservation().getDestination();
    }

    protected LogInterface getLogger() {
        return this.getDiskSpaceReservation().getLogger();
    }

    public boolean isSameRoot(String ... root) {
        HashSet<String> remainingRoots = new HashSet<String>(this.getRoots());
        List<String> roots = Arrays.asList(root);
        boolean sameRoot = remainingRoots.removeAll(roots);
        if (CrossSystem.isWindows() && !sameRoot) {
            for (String otherRoot : roots) {
                String matchingRoot = null;
                for (String testRoot : remainingRoots) {
                    if (!testRoot.equalsIgnoreCase(otherRoot)) continue;
                    matchingRoot = testRoot;
                    break;
                }
                if (matchingRoot == null || !remainingRoots.remove(matchingRoot)) continue;
                break;
            }
            sameRoot = this.getRoots().size() > remainingRoots.size();
        }
        return sameRoot;
    }

    public boolean isSameRoot(DiskSpaceChecker checker) {
        if (checker == null) {
            return false;
        }
        if (checker == this) {
            return true;
        }
        return this.isSameRoot(checker.getRoots().toArray(new String[0]));
    }

    public Object getRequestor() {
        return this.requestor;
    }
}

