/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jd.controlling.downloadcontroller.DiskSpaceChecker;
import jd.controlling.downloadcontroller.DiskSpaceChecker17;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.ContainerRuntime;
import org.appwork.utils.os.hardware.HardwareType;
import org.appwork.utils.os.hardware.HardwareTypeInterface;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.GeneralSettings;

public class DiskSpaceManager {
    private final List<DiskSpaceChecker> reservations = new ArrayList<DiskSpaceChecker>();
    private final GeneralSettings config = (GeneralSettings)JsonConfig.create(GeneralSettings.class);

    public synchronized DISKSPACERESERVATIONRESULT check(DiskSpaceReservation reservation) {
        return this.checkAndReserve(reservation, null);
    }

    private DISKSPACERESERVATIONRESULT handle(DiskSpaceChecker checker, DISKSPACERESERVATIONRESULT result, Long requestedDiskSpace) {
        DiskSpaceReservation reservation = checker.getDiskSpaceReservation();
        LogInterface logger = reservation.getLogger();
        logger.info("DiskSpaceManager:Result:" + (Object)((Object)result) + "|File:" + reservation.getDestination() + "|Root(s):" + checker.getRoots() + "|Requestor:" + checker.getRequestor() + "|RequestedSpace:" + (requestedDiskSpace != null ? SizeFormatter.formatBytes((long)requestedDiskSpace) : null) + "|UsableSpace:" + SizeFormatter.formatBytes((long)checker.getUsableSpace()));
        return result;
    }

    public synchronized DISKSPACERESERVATIONRESULT checkAndReserve(DiskSpaceReservation reservation, Object requestor) {
        if (reservation == null) {
            throw new IllegalArgumentException("reservation must not be null!");
        }
        DiskSpaceChecker checker = JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7) ? new DiskSpaceChecker17(reservation, requestor) : new DiskSpaceChecker(reservation, requestor);
        if (!this.config.isFreeSpaceCheckEnabled()) {
            return this.handle(checker, DISKSPACERESERVATIONRESULT.OK, null);
        }
        if (reservation.getDestination() == null) {
            return this.handle(checker, DISKSPACERESERVATIONRESULT.INVALIDDESTINATION, null);
        }
        String bestRootMatch = checker.getRoot();
        if (bestRootMatch == null || !new File(bestRootMatch).isDirectory() && !new File(bestRootMatch).equals(reservation.getDestination())) {
            return this.handle(checker, DISKSPACERESERVATIONRESULT.INVALIDDESTINATION, null);
        }
        try {
            HardwareTypeInterface hardwareType = HardwareType.getHardware();
            if (hardwareType != null && !ContainerRuntime.isInsideDocker()) {
                switch (hardwareType.getHardwareType()) {
                    case QNAP: 
                    case SYNOLOGY: {
                        if (!checker.isSameRoot("/")) break;
                        return this.handle(checker, DISKSPACERESERVATIONRESULT.INVALIDDESTINATION, null);
                    }
                }
            }
        }
        catch (Throwable e) {
            reservation.getLogger().log(e);
        }
        long forcedFreeSpaceOnDisk = Math.max(0L, (long)this.config.getForcedFreeSpaceOnDisk() * 1024L * 1024L);
        long requestedDiskSpace = Math.max(0L, reservation.getSize()) + forcedFreeSpaceOnDisk;
        for (DiskSpaceChecker reservedDiskSpace : this.reservations) {
            if (!reservedDiskSpace.isSameRoot(checker)) continue;
            requestedDiskSpace += Math.max(0L, reservedDiskSpace.getSize());
        }
        long freeDiskSpace = checker.getUsableSpace();
        if (freeDiskSpace >= 0L && freeDiskSpace < requestedDiskSpace) {
            return this.handle(checker, DISKSPACERESERVATIONRESULT.FAILED, requestedDiskSpace);
        }
        if (requestor != null) {
            this.reservations.add(checker);
        }
        return this.handle(checker, DISKSPACERESERVATIONRESULT.OK, requestedDiskSpace);
    }

    public synchronized long getReservedDiskSpace(final File path, Object requestor) {
        DiskSpaceReservation reservation = new DiskSpaceReservation(){

            @Override
            public Object getOwner() {
                return null;
            }

            @Override
            public LogInterface getLogger() {
                return LogController.CL(true);
            }

            @Override
            public File getDestination() {
                return path;
            }

            @Override
            public long getSize() {
                return 0L;
            }
        };
        DiskSpaceChecker checker = JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7) ? new DiskSpaceChecker17(reservation, requestor) : new DiskSpaceChecker(reservation, requestor);
        String bestRootMatch = checker.getRoot();
        if (bestRootMatch == null || !new File(bestRootMatch).isDirectory() && !new File(bestRootMatch).equals(reservation.getDestination())) {
            return -1L;
        }
        long requestedDiskSpace = Math.max(0L, reservation.getSize());
        for (DiskSpaceChecker reservedDiskSpace : this.reservations) {
            if (!reservedDiskSpace.isSameRoot(checker)) continue;
            requestedDiskSpace += Math.max(0L, reservedDiskSpace.getSize());
        }
        return requestedDiskSpace;
    }

    public synchronized boolean free(DiskSpaceReservation reservation, Object requestor) {
        DiskSpaceChecker reservedDiskSpace = this.getDiskSpaceChecker(reservation);
        return reservedDiskSpace != null && reservedDiskSpace.getRequestor() == requestor && this.reservations.remove(reservedDiskSpace);
    }

    public synchronized boolean isReservedBy(DiskSpaceReservation reservation, Object requestor) {
        DiskSpaceChecker reservedDiskSpace = this.getDiskSpaceChecker(reservation);
        return reservedDiskSpace != null && reservedDiskSpace.getRequestor() == requestor;
    }

    public synchronized boolean holdsReservations(Object requestor) {
        for (DiskSpaceChecker reservedDiskSpace : this.reservations) {
            if (reservedDiskSpace.getRequestor() != requestor) continue;
            return true;
        }
        return false;
    }

    public synchronized void freeAllReservationsBy(Object requestor) {
        Iterator<DiskSpaceChecker> it = this.reservations.iterator();
        while (it.hasNext()) {
            DiskSpaceChecker reservedDiskSpace = it.next();
            if (reservedDiskSpace == null || reservedDiskSpace.getRequestor() != requestor) continue;
            it.remove();
        }
    }

    private synchronized DiskSpaceChecker getDiskSpaceChecker(DiskSpaceReservation reservation) {
        if (reservation != null) {
            for (DiskSpaceChecker reservedDiskSpace : this.reservations) {
                if (reservedDiskSpace.getDiskSpaceReservation() != reservation) continue;
                return reservedDiskSpace;
            }
        }
        return null;
    }

    public synchronized boolean isReserved(DiskSpaceReservation reservation) {
        return this.getDiskSpaceChecker(reservation) != null;
    }

    public static enum DISKSPACERESERVATIONRESULT {
        UNSUPPORTED,
        OK,
        INVALIDDESTINATION,
        FAILED;

    }
}

