/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jd.controlling.downloadcontroller.BadDestinationException;
import jd.controlling.downloadcontroller.DownloadControllerConfig;
import jd.controlling.downloadcontroller.DownloadControllerStorable;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.FilePackageStorable;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.controlling.packagecontroller.PackageController;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.DownloadLinkStorable;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import org.appwork.controlling.SingleReachableState;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.simplejson.JSonFactory;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.Eventsender;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.io.J7FileList;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.DownloadLinkAggregator;
import org.jdownloader.controlling.DownloadLinkWalker;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.download.DownloadControllerEvent;
import org.jdownloader.controlling.download.DownloadControllerEventAddedPackage;
import org.jdownloader.controlling.download.DownloadControllerEventDataUpdate;
import org.jdownloader.controlling.download.DownloadControllerEventRemovedLinkList;
import org.jdownloader.controlling.download.DownloadControllerEventRemovedPackage;
import org.jdownloader.controlling.download.DownloadControllerEventSender;
import org.jdownloader.controlling.download.DownloadControllerEventStructureRefresh;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.controlling.lists.DupeManager;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.settings.CleanAfterDownloadAction;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DownloadController
extends PackageController<FilePackage, DownloadLink> {
    private final transient DownloadControllerEventSender eventSender = new DownloadControllerEventSender();
    private final DelayedRunnable downloadSaver;
    private final DelayedRunnable changesSaver;
    private final CopyOnWriteArrayList<File> downloadLists = new CopyOnWriteArrayList();
    public static final ScheduledExecutorService TIMINGQUEUE = DelayedRunnable.getNewScheduledExecutorService();
    private final DupeManager dupeController = new DupeManager();
    public static final SingleReachableState DOWNLOADLIST_LOADED = new SingleReachableState("DOWNLOADLIST_COMPLETE");
    private static final DownloadController INSTANCE = new DownloadController();
    private static final Object SAVELOADLOCK = new Object();

    public static DownloadController getInstance() {
        return INSTANCE;
    }

    @Override
    public void moveOrAddAt(final FilePackage pkg, final List<DownloadLink> movechildren, final int moveChildrenindex, final int pkgIndex) {
        this.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                HashMap<FilePackage, ArrayList<DownloadLink>> sourceMap = new HashMap<FilePackage, ArrayList<DownloadLink>>();
                for (DownloadLink downloadLink : movechildren) {
                    ArrayList<DownloadLink> list = (ArrayList<DownloadLink>)sourceMap.get(downloadLink.getParentNode());
                    if (list == null) {
                        list = new ArrayList<DownloadLink>();
                        sourceMap.put(downloadLink.getParentNode(), list);
                    }
                    list.add(downloadLink);
                }
                DownloadController.super.moveOrAddAt(pkg, movechildren, moveChildrenindex, pkgIndex);
                for (Map.Entry entry : sourceMap.entrySet()) {
                    DownloadWatchDog.getInstance().handleMovedDownloadLinks(pkg, (FilePackage)entry.getKey(), (List)entry.getValue());
                }
                return null;
            }
        });
    }

    private DownloadController() {
        final AtomicBoolean saveFlag = new AtomicBoolean(false);
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public long getMaxDuration() {
                return 0L;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                boolean idle = DownloadWatchDog.getInstance().isIdle();
                DownloadController.this.saveDownloadLinks(true);
                if (idle) {
                    return;
                }
                for (int retry = 10; retry > 0 && !DownloadWatchDog.getInstance().isIdle(); --retry) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                DownloadController.this.saveDownloadLinks(true);
            }

            public String toString() {
                return "ShutdownEvent: Save Downloadlist";
            }
        });
        DownloadControllerConfig cfg = (DownloadControllerConfig)JsonConfig.create(DownloadControllerConfig.class);
        long minimumDelay = Math.max(DebugMode.TRUE_IN_IDE_ELSE_FALSE ? 1L : 5000L, cfg.getMinimumSaveDelay());
        long maximumDelay = cfg.getMaximumSaveDelay();
        maximumDelay = maximumDelay <= 0L ? -1L : Math.max(maximumDelay, minimumDelay);
        this.changesSaver = new DelayedRunnable(TIMINGQUEUE, minimumDelay, maximumDelay){
            private final boolean ignoreShutDown = false;
            {
                super(x0, x1, x2);
                this.ignoreShutDown = false;
            }

            public void run() {
                if (DownloadController.this.isSavingAllowed(false)) {
                    super.run();
                }
            }

            public String getID() {
                return "DownloadController:Save_Changes";
            }

            public void delayedrun() {
                if (saveFlag.compareAndSet(false, true)) {
                    try {
                        DownloadController.this.saveDownloadLinks(false);
                    }
                    finally {
                        saveFlag.set(false);
                    }
                }
            }
        };
        this.downloadSaver = new DelayedRunnable(TIMINGQUEUE, Math.max(60000L, minimumDelay), Math.max(300000L, maximumDelay)){
            private final boolean ignoreShutDown = false;
            {
                super(x0, x1, x2);
                this.ignoreShutDown = false;
            }

            public void run() {
                if (DownloadController.this.isSavingAllowed(false)) {
                    super.run();
                }
            }

            public String getID() {
                return "DownloadController:Save_Download";
            }

            public void delayedrun() {
                if (saveFlag.compareAndSet(false, true)) {
                    try {
                        DownloadController.this.saveDownloadLinks(false);
                    }
                    finally {
                        saveFlag.set(false);
                    }
                }
            }
        };
        this.eventSender.addListener(new DownloadControllerListener(){

            @Override
            public void onDownloadControllerAddedPackage(FilePackage pkg) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerStructureRefresh(FilePackage pkg) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerStructureRefresh() {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerRemovedPackage(FilePackage pkg) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
                DownloadController.this.changesSaver.run();
            }

            @Override
            public void onDownloadControllerUpdatedData(FilePackage pkg) {
                DownloadController.this.changesSaver.run();
            }
        });
    }

    public void requestSaving() {
        this.downloadSaver.run();
    }

    @Override
    protected void _controllerPackageNodeAdded(FilePackage pkg, Queue.QueuePriority priority) {
        this.dupeController.invalidate();
        this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventStructureRefresh());
        this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventAddedPackage(pkg));
    }

    public Eventsender<DownloadControllerListener, DownloadControllerEvent> getEventSender() {
        return this.eventSender;
    }

    @Override
    protected void _controllerPackageNodeRemoved(FilePackage pkg, Queue.QueuePriority priority) {
        this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventRemovedPackage(pkg));
    }

    @Override
    protected void _controllerParentlessLinks(FilePackage pkg, List<DownloadLink> links, Queue.QueuePriority priority) {
        this.dupeController.invalidate();
        this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventRemovedLinkList(new ArrayList<DownloadLink>(links)));
    }

    @Override
    public void removePackage(FilePackage pkg) {
        super.removePackage(pkg);
    }

    @Override
    public void removeChildren(List<DownloadLink> removechildren) {
        super.removeChildren(removechildren);
    }

    @Override
    public void removeChildren(FilePackage pkg, List<DownloadLink> children, boolean doNotifyParentlessLinks) {
        super.removeChildren(pkg, children, doNotifyParentlessLinks);
    }

    @Override
    protected void _controllerStructureChanged(Queue.QueuePriority priority) {
        this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventStructureRefresh());
    }

    public void addAll(List<FilePackage> fps) {
        this.addAllAt(fps, 0);
    }

    public void addAllAt(final List<FilePackage> fps, final int index) {
        if (fps == null || fps.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                int counter = index;
                boolean createFolder = CFG_GENERAL.CREATE_FOLDER_TRIGGER.getValue() == GeneralSettings.CreateFolderTrigger.ON_LINKS_ADDED;
                HashSet<String> created = new HashSet<String>();
                for (FilePackage fp : fps) {
                    String folder;
                    if (createFolder && created.add(folder = fp.getDownloadDirectory())) {
                        File folderFile = new File(folder);
                        if (folderFile.exists()) {
                            DownloadController.this.logger.info("Skip folder creation: " + folderFile + " already exists");
                        } else {
                            try {
                                DownloadWatchDog.getInstance().validateDestination(folderFile);
                                if (folderFile.mkdirs()) {
                                    DownloadController.this.logger.info("Create folder: " + folderFile);
                                } else {
                                    DownloadController.this.logger.info("Could not create folder: " + folderFile);
                                }
                            }
                            catch (BadDestinationException e) {
                                DownloadController.this.logger.info("Not allowed to create folder: " + e.getFile());
                            }
                        }
                    }
                    DownloadController.this.addmovePackageAt(fp, counter++);
                }
                return null;
            }
        });
    }

    public void addListener(DownloadControllerListener l) {
        this.eventSender.addListener(l);
    }

    public void addListener(DownloadControllerListener l, boolean weak) {
        this.eventSender.addListener(l, weak);
    }

    @Override
    public ArrayList<FilePackage> getPackages() {
        return this.packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDownloadLinkwithURL(String url) {
        if (url == null) {
            return false;
        }
        String correctUrl = url.trim();
        for (FilePackage fp : this.getPackagesCopy()) {
            boolean readL2 = fp.getModifyLock().readLock();
            try {
                for (DownloadLink dl : fp.getChildren()) {
                    if (!correctUrl.equalsIgnoreCase(dl.getPluginPatternMatcher())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                fp.getModifyLock().readUnlock(readL2);
            }
        }
        return false;
    }

    private ArrayList<File> findAvailableDownloadLists() {
        this.logger.info("Collect Lists");
        File[] filesInCfg = null;
        File cfg = Application.getResource((String)"cfg/");
        if (Application.getJavaVersion() >= Application.JAVA17) {
            try {
                filesInCfg = J7FileList.findFiles((Pattern)Pattern.compile("^downloadList.*?\\.zip$", 2), (File)cfg, (boolean)true).toArray(new File[0]);
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
        }
        if (filesInCfg == null || filesInCfg.length == 0) {
            filesInCfg = Application.getResource((String)"cfg/").listFiles();
        }
        ArrayList<Long> sortedAvailable = new ArrayList<Long>();
        ArrayList<File> ret = new ArrayList<File>();
        if (filesInCfg != null) {
            for (File downloadList : filesInCfg) {
                String counter;
                String name = downloadList.getName();
                if (!name.startsWith("downloadList") || !downloadList.isFile() || (counter = new Regex(name, "downloadList(\\d+)\\.zip$").getMatch(0)) == null) continue;
                sortedAvailable.add(Long.parseLong(counter));
            }
            Collections.sort(sortedAvailable, Collections.reverseOrder());
        }
        for (Long loadOrder : sortedAvailable) {
            ret.add(Application.getResource((String)("cfg/downloadList" + loadOrder + ".zip")));
        }
        if (Application.getResource((String)"cfg/downloadList.zip").exists()) {
            ret.add(Application.getResource((String)"cfg/downloadList.zip"));
        }
        this.logger.info("Lists: " + ret);
        this.downloadLists.addAll(ret);
        return ret;
    }

    public void initDownloadLinks() {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                DownloadController.this.logger.info("Init DownloadList");
                LinkedList lpackages = null;
                Object loadedList = null;
                for (Object downloadList : DownloadController.this.findAvailableDownloadLists()) {
                    try {
                        lpackages = DownloadController.this.load((File)downloadList);
                        if (lpackages == null) continue;
                        loadedList = downloadList;
                        break;
                    }
                    catch (Throwable e) {
                        DownloadController.this.logger.log(e);
                    }
                }
                if (lpackages != null) {
                    int links = 0;
                    for (FilePackage fp : lpackages) {
                        links += fp.size();
                    }
                    DownloadController.this.logger.info("LinkList found: " + lpackages.size() + "/" + links);
                } else {
                    DownloadController.this.logger.info("LinkList empty!");
                    lpackages = new LinkedList();
                }
                try {
                    DownloadController.this.importList(lpackages);
                }
                catch (Throwable e) {
                    if (loadedList != null) {
                        File backupTo = new File(((File)loadedList).getAbsolutePath() + ".backup");
                        boolean backupSucceeded = false;
                        Long size = null;
                        try {
                            if (((File)loadedList).exists()) {
                                size = ((File)loadedList).length();
                                if (size > 0L) {
                                    if (!((File)loadedList).renameTo(backupTo)) {
                                        IO.copyFile((File)loadedList, (File)backupTo);
                                        backupSucceeded = backupTo.exists();
                                        if (backupSucceeded && ((File)loadedList).exists() && !((File)loadedList).delete()) {
                                            ((File)loadedList).deleteOnExit();
                                        }
                                    } else {
                                        backupSucceeded = backupTo.exists();
                                    }
                                } else {
                                    ((File)loadedList).delete();
                                }
                            }
                        }
                        catch (Throwable e2) {
                            DownloadController.this.logger.log(e2);
                        }
                        if (backupSucceeded) {
                            DownloadController.this.logger.severe("Could backup " + loadedList + "<to>" + backupTo);
                        } else {
                            DownloadController.this.logger.severe("Could not backup " + loadedList + "<to>" + backupTo + " because size=" + size);
                        }
                    }
                    DownloadController.this.logger.log(e);
                }
                finally {
                    DOWNLOADLIST_LOADED.setReached();
                }
                return null;
            }
        });
    }

    public void importList(final LinkedList<FilePackage> lpackages) {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            protected Void run() throws RuntimeException {
                if (lpackages != null) {
                    DownloadController.this.preProcessFilePackages(lpackages, true);
                    for (FilePackage filePackage : lpackages) {
                        filePackage.setControlledBy(DownloadController.this);
                    }
                    DownloadController.this.writeLock();
                    try {
                        DownloadController.this.packages.addAll(0, lpackages);
                    }
                    finally {
                        DownloadController.this.writeUnlock();
                    }
                    DownloadController.this.updateUniqueAlltimeIDMaps(lpackages);
                    DownloadController.this.dupeController.invalidate();
                    long version = DownloadController.this.backendChanged.incrementAndGet();
                    DownloadController.this.childrenChanged.set(version);
                    DownloadController.this.structureChanged.set(version);
                    DownloadController.this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventStructureRefresh());
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<FilePackage> load(File file) {
        Object object = SAVELOADLOCK;
        synchronized (object) {
            try {
                return this.loadFile(file, false);
            }
            catch (Throwable e) {
                File renameTo = new File(file.getAbsolutePath() + ".backup");
                boolean backup = false;
                try {
                    if (file.exists()) {
                        if (!file.renameTo(renameTo)) {
                            IO.copyFile((File)file, (File)renameTo);
                        }
                        backup = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.logger.severe("Could backup " + file + " to " + renameTo + " ->" + backup);
                this.logger.log(e);
                return null;
            }
        }
    }

    public LinkedList<FilePackage> loadFile(File file, boolean rescueMode) throws IOException {
        this.logger.info("Load List: " + file);
        if (file == null || !file.exists()) {
            return null;
        }
        LinkedList<FilePackage> ret = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        SimpleMapper mapper = new SimpleMapper(){

            protected JSonFactory newJsonFactory(String jsonString) {
                return new JSonFactory(jsonString){

                    protected String dedupeString(String string) {
                        return string;
                    }
                };
            }

            protected void initMapper() {
            }
        };
        try {
            fis = new FileInputStream(file);
            zis = new ZipInputStream(new BufferedInputStream(fis, 0x100000));
            HashMap<Integer, LoadedPackage> packageMap = new HashMap<Integer, LoadedPackage>();
            DownloadControllerStorable dcs = null;
            TypeRef<DownloadLinkStorable> downloadLinkStorableTypeRef = new TypeRef<DownloadLinkStorable>(){};
            TypeRef<FilePackageStorable> filePackageStorable = new TypeRef<FilePackageStorable>(){};
            TypeRef<DownloadControllerStorable> downloadControllerStorable = new TypeRef<DownloadControllerStorable>(){};
            ZipEntry entry = null;
            final ZipInputStream finalZis = zis;
            BufferedInputStream entryInputStream = new BufferedInputStream(new InputStream(){

                @Override
                public int read() throws IOException {
                    return finalZis.read();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return finalZis.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    return finalZis.skip(n);
                }

                @Override
                public int available() throws IOException {
                    return finalZis.available();
                }

                @Override
                public boolean markSupported() {
                    return false;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public synchronized void mark(int readlimit) {
                }
            }, 1024){

                @Override
                public void close() throws IOException {
                }
            };
            int entries = 0;
            Pattern entryType = Pattern.compile("(\\d+)(?:_(\\d+))?|extraInfo", 2);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            Charset UTF8 = Charset.forName("UTF-8");
            while ((entry = zis.getNextEntry()) != null) {
                try {
                    LoadedPackage loadedPackage;
                    Integer packageIndex;
                    ++entries;
                    Matcher entryName = entryType.matcher(entry.getName());
                    if (!entryName.matches()) continue;
                    if (entryName.group(2) != null) {
                        packageIndex = Integer.valueOf(entryName.group(1));
                        int childIndex = Integer.parseInt(entryName.group(2));
                        loadedPackage = (LoadedPackage)packageMap.get(packageIndex);
                        if (loadedPackage == null) {
                            loadedPackage = new LoadedPackage(null);
                            packageMap.put(packageIndex, loadedPackage);
                        }
                        bos.reset();
                        IO.readStream((int)((int)entry.getSize()), (InputStream)entryInputStream, (ByteArrayOutputStream)bos);
                        DownloadLinkStorable storable = (DownloadLinkStorable)mapper.stringToObject(new String(bos.toByteArray(), 0, bos.size(), UTF8), (TypeRef)downloadLinkStorableTypeRef);
                        if (storable != null) {
                            loadedPackage.downloadLinks.add(new LoadedPackage.IndexedDownloadLink(childIndex, storable._getDownloadLink()));
                            continue;
                        }
                        throw new WTFException("restored a null DownloadLinkLinkStorable");
                    }
                    if (entryName.group(1) != null) {
                        packageIndex = Integer.valueOf(entry.getName());
                        bos.reset();
                        IO.readStream((int)((int)entry.getSize()), (InputStream)entryInputStream, (ByteArrayOutputStream)bos);
                        FilePackageStorable storable = (FilePackageStorable)mapper.stringToObject(new String(bos.toByteArray(), 0, bos.size(), UTF8), (TypeRef)filePackageStorable);
                        if (storable != null) {
                            loadedPackage = (LoadedPackage)packageMap.get(packageIndex);
                            if (loadedPackage != null) continue;
                            packageMap.put(packageIndex, new LoadedPackage(storable._getFilePackage()));
                            continue;
                        }
                        throw new WTFException("restored a null FilePackageStorable");
                    }
                    dcs = (DownloadControllerStorable)mapper.inputStreamToObject((InputStream)entryInputStream, (TypeRef)downloadControllerStorable);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    if (entry != null) {
                        this.logger.info("Entry:" + entry + "|EntryIndex:" + entries + "|Size:" + entry.getSize() + "|Compressed Size:" + entry.getCompressedSize());
                    }
                    if (rescueMode) break;
                    throw e;
                }
            }
            if (entries == 0) {
                throw new WTFException("Empty/Invalid Zip:" + file + "|Size:" + file.length());
            }
            ArrayList packageIndices = new ArrayList(packageMap.keySet());
            Collections.sort(packageIndices);
            ArrayList<FilePackage> ret2 = new ArrayList<FilePackage>(packageIndices.size());
            for (Integer packageIndex : packageIndices) {
                LoadedPackage loadedPackage = (LoadedPackage)packageMap.get(packageIndex);
                FilePackage filePackage = loadedPackage.getLoadedPackage();
                if (filePackage != null) {
                    ret2.add(filePackage);
                    continue;
                }
                throw new WTFException("FilePackage at Index " + packageIndex + " is missing!");
            }
            if (dcs != null && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isConvertRelativePathsJDRoot()) {
                try {
                    String newRoot;
                    String oldRootPath = dcs.getRootPath();
                    if (!StringUtils.isEmpty((String)oldRootPath) && !oldRootPath.equals(newRoot = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath())) {
                        for (FilePackage pkg : ret2) {
                            String pkgPath;
                            if (!CrossSystem.isAbsolutePath((String)pkg.getDownloadDirectory()) || !(pkgPath = LinkTreeUtils.getDownloadDirectory(pkg).getAbsolutePath()).startsWith(oldRootPath + "/") && !pkgPath.startsWith(oldRootPath + "\\")) continue;
                            String restPath = pkgPath.substring(oldRootPath.length());
                            restPath = restPath.replaceFirst("^(/+|\\\\+)", "");
                            String newPath = new File(newRoot, restPath = CrossSystem.fixPathSeparators((String)restPath)).getAbsolutePath();
                            if (StringUtils.equals((String)pkgPath, (String)newPath)) continue;
                            pkg.setDownloadDirectory(newPath);
                        }
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
            ret = new LinkedList<FilePackage>(ret2);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                } else if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable packageMap) {}
        }
        return ret;
    }

    public void processFinalLinkState(DownloadLink localLink) {
        FinalLinkState currentFinalLinkState = localLink.getFinalLinkState();
        if (currentFinalLinkState != null) {
            if (currentFinalLinkState == FinalLinkState.PLUGIN_DEFECT) {
                localLink.setFinalLinkState(null);
            }
            return;
        }
    }

    public void checkPluginUpdates() {
        if (!DOWNLOADLIST_LOADED.isReached()) {
            return;
        }
        DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                DownloadController.this.QUEUE.addWait(new QueueAction<Void, RuntimeException>(){
                    private final PluginFinder finder;
                    {
                        this.finder = new PluginFinder((LogInterface)DownloadController.this.logger);
                    }

                    protected Void run() throws RuntimeException {
                        DownloadController.this.getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

                            @Override
                            public int returnMaxResults() {
                                return 0;
                            }

                            private final void updatePluginInstance(DownloadLink link) {
                                String newDefaultHost;
                                long newDefaultVersion;
                                long currentDefaultVersion;
                                String currentDefaultHost;
                                PluginForHost defaultPlugin = link.getDefaultPlugin();
                                if (defaultPlugin != null) {
                                    currentDefaultHost = defaultPlugin.getLazyP().getHost();
                                    currentDefaultVersion = defaultPlugin.getLazyP().getVersion();
                                } else {
                                    currentDefaultHost = null;
                                    currentDefaultVersion = -1L;
                                }
                                PluginForHost newDefaultPlugin = finder.assignPlugin(link, true);
                                if (newDefaultPlugin != null) {
                                    newDefaultVersion = newDefaultPlugin.getLazyP().getVersion();
                                    newDefaultHost = newDefaultPlugin.getLazyP().getHost();
                                } else {
                                    newDefaultVersion = -1L;
                                    newDefaultHost = null;
                                }
                                if (!(newDefaultPlugin == null || currentDefaultVersion == newDefaultVersion && StringUtils.equals((String)currentDefaultHost, (String)newDefaultHost))) {
                                    DownloadController.this.logger.info("Update Plugin for: " + link.getName() + ":" + link.getHost() + ":" + currentDefaultVersion + " to " + newDefaultPlugin.getLazyP().getDisplayName() + ":" + newDefaultPlugin.getLazyP().getVersion());
                                    if (link.getFinalLinkState() == FinalLinkState.PLUGIN_DEFECT) {
                                        link.setFinalLinkState(null);
                                    }
                                }
                            }

                            @Override
                            public boolean acceptNode(final DownloadLink node) {
                                SingleDownloadController controller = node.getDownloadLinkController();
                                if (controller != null) {
                                    controller.getJobsAfterDetach().add(new DownloadWatchDogJob(){

                                        @Override
                                        public void execute(DownloadSession currentSession) {
                                            this.updatePluginInstance(node);
                                        }

                                        @Override
                                        public void interrupt() {
                                        }

                                        @Override
                                        public boolean isHighPriority() {
                                            return false;
                                        }
                                    });
                                } else {
                                    this.updatePluginInstance(node);
                                }
                                return false;
                            }
                        });
                        return null;
                    }
                });
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return false;
            }
        });
    }

    public void preProcessFilePackages(LinkedList<FilePackage> fps, boolean allowCleanup) {
        if (fps == null || fps.size() == 0) {
            return;
        }
        Iterator iterator = fps.iterator();
        PluginFinder pluginFinder = new PluginFinder((LogInterface)this.logger);
        boolean cleanupStartup = allowCleanup && CleanAfterDownloadAction.CLEANUP_ONCE_AT_STARTUP.equals((Object)CFG_GENERAL.CFG.getCleanupAfterDownloadAction());
        boolean cleanupFileExists = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getCleanupFileExists();
        while (iterator.hasNext()) {
            FilePackage fp = (FilePackage)iterator.next();
            if (fp.getChildren() == null || fp.getChildren().size() == 0) {
                iterator.remove();
                continue;
            }
            ArrayList<DownloadLink> removeList = new ArrayList<DownloadLink>();
            for (DownloadLink localLink : fp.getChildren()) {
                if (cleanupStartup) {
                    if (FinalLinkState.CheckFinished(localLink.getFinalLinkState())) {
                        this.logger.info("Remove " + localLink.getView().getDisplayName() + " because Finished and CleanupOnStartup!");
                        removeList.add(localLink);
                        continue;
                    }
                    if (cleanupFileExists && FinalLinkState.FAILED_EXISTS.equals((Object)localLink.getFinalLinkState())) {
                        this.logger.info("Remove " + localLink.getView().getDisplayName() + " because FileExists and CleanupOnStartup!");
                        removeList.add(localLink);
                        continue;
                    }
                }
                this.processFinalLinkState(localLink);
                pluginFinder.assignPlugin(localLink, true);
            }
            if (removeList.size() <= 0) continue;
            fp.getChildren().removeAll(removeList);
        }
    }

    public void removeListener(DownloadControllerListener l) {
        this.eventSender.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(List<FilePackage> packages, File file) throws IOException {
        Object object = SAVELOADLOCK;
        synchronized (object) {
            int bufferSize;
            if (file == null) {
                if (this.downloadLists.size() > 0) {
                    String counter = new Regex(this.downloadLists.get(0).getName(), "downloadList(\\d+)\\.zip").getMatch(0);
                    long count = 1L;
                    if (counter != null) {
                        count = Long.parseLong(counter) + 1L;
                    }
                    file = Application.getResource((String)("cfg/downloadList" + count + ".zip"));
                }
                if (file == null) {
                    file = Application.getResource((String)"cfg/downloadList.zip");
                }
            }
            if (this.downloadLists.size() > 0) {
                long fileLength = this.downloadLists.get(0).length();
                if (fileLength > 0L) {
                    int paddedFileLength = ((int)fileLength / 32768 + 1) * 32768;
                    bufferSize = Math.max(32768, Math.min(0x100000, paddedFileLength));
                } else {
                    bufferSize = 32768;
                }
            } else {
                bufferSize = 32768;
            }
            if (packages == null || file == null) {
                return false;
            }
            if (file.exists()) {
                if (file.isDirectory()) {
                    throw new IOException("File " + file + " is a directory");
                }
                if (!FileCreationManager.getInstance().delete(file, null)) {
                    throw new IOException("Could not delete file " + file);
                }
            } else if (!file.getParentFile().exists() && !FileCreationManager.getInstance().mkdir(file.getParentFile())) {
                throw new IOException("Could not create parentFolder for file " + file);
            }
            String packageFormat = packages.size() >= 10 ? String.format("%%0%dd", (int)Math.log10(packages.size()) + 1) : "%02d";
            SimpleMapper mapper = new SimpleMapper(){

                protected JSonFactory newJsonFactory(String jsonString) {
                    return new JSonFactory(jsonString){

                        protected String dedupeString(String string) {
                            return string;
                        }
                    };
                }

                protected void initMapper() {
                }

                public boolean isPrettyPrintEnabled() {
                    return false;
                }
            };
            boolean deleteFile = true;
            ZipOutputStream zos = null;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file){

                    @Override
                    public void close() throws IOException {
                        try {
                            if (this.getChannel().isOpen()) {
                                this.getChannel().force(true);
                            }
                        }
                        finally {
                            super.close();
                        }
                    }
                };
                final ZipOutputStream finalZos = zos = new ZipOutputStream(new BufferedOutputStream(fos, bufferSize));
                OutputStream entryOutputStream = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        finalZos.write(b);
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        finalZos.write(b, off, len);
                    }

                    @Override
                    public void close() throws IOException {
                        finalZos.flush();
                    }

                    @Override
                    public void flush() throws IOException {
                        finalZos.flush();
                    }
                };
                int packageIndex = 0;
                for (FilePackage pkg : packages) {
                    boolean readL = pkg.getModifyLock().readLock();
                    try {
                        int childrenSize = pkg.getChildren().size();
                        if (childrenSize <= 0) continue;
                        String packageEntryID = String.format(packageFormat, packageIndex++);
                        FilePackageStorable packageStorable = new FilePackageStorable(pkg, false);
                        ZipEntry packageEntry = new ZipEntry(packageEntryID);
                        packageEntry.setMethod(8);
                        zos.putNextEntry(packageEntry);
                        mapper.writeObject(entryOutputStream, (Object)packageStorable);
                        zos.closeEntry();
                        String childFormat = childrenSize >= 10 ? String.format("%%0%dd", (int)Math.log10(childrenSize) + 1) : "%02d";
                        int childIndex = 0;
                        for (DownloadLink link : pkg.getChildren()) {
                            DownloadLinkStorable linkStorable = new DownloadLinkStorable(link);
                            String childEntryID = String.format(childFormat, childIndex++);
                            ZipEntry linkEntry = new ZipEntry(packageEntryID + "_" + childEntryID);
                            linkEntry.setMethod(8);
                            zos.putNextEntry(linkEntry);
                            mapper.writeObject(entryOutputStream, (Object)linkStorable);
                            zos.closeEntry();
                        }
                    }
                    finally {
                        pkg.getModifyLock().readUnlock(readL);
                    }
                }
                DownloadControllerStorable dcs = new DownloadControllerStorable();
                try {
                    dcs.setRootPath(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath());
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                ZipEntry downloadControllerEntry = new ZipEntry("extraInfo");
                downloadControllerEntry.setMethod(8);
                zos.putNextEntry(downloadControllerEntry);
                JSonStorage.getMapper().writeObject(entryOutputStream, (Object)dcs);
                zos.closeEntry();
                zos.close();
                zos = null;
                fos = null;
                deleteFile = false;
                try {
                    int keepXOld = Math.max(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getKeepXOldLists(), 0);
                    while (this.downloadLists.size() > keepXOld) {
                        File remove = this.downloadLists.remove(this.downloadLists.size() - 1);
                        if (remove == null) continue;
                        boolean delete = FileCreationManager.getInstance().delete(remove, null);
                        if (!LogController.getInstance().isDebugMode()) continue;
                        this.logger.info("Delete outdated DownloadList: " + remove + " " + delete);
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                finally {
                    this.downloadLists.add(0, file);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            finally {
                block46: {
                    try {
                        if (zos != null) {
                            zos.close();
                            break block46;
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                }
                if (deleteFile && file.exists()) {
                    FileCreationManager.getInstance().delete(file, null);
                }
            }
            return false;
        }
    }

    private boolean isSavingAllowed(boolean ignoreShutDown) {
        return DOWNLOADLIST_LOADED.isReached() && (ignoreShutDown || !ShutdownController.getInstance().isShuttingDown());
    }

    private void saveDownloadLinks(boolean ignoreShutDown) {
        if (!this.isSavingAllowed(ignoreShutDown)) {
            return;
        }
        try {
            this.save(this.getPackagesCopy(), null);
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
    }

    @Override
    public void nodeUpdated(AbstractNode source, AbstractNodeNotifier.NOTIFY notify, Object param) {
        super.nodeUpdated(source, notify, param);
        switch (notify) {
            case PROPERTY_CHANGE: {
                if (param instanceof DownloadLinkProperty) {
                    DownloadLinkProperty eventPropery = (DownloadLinkProperty)param;
                    switch (eventPropery.getProperty()) {
                        case VARIANT: 
                        case URL_CONTENT: {
                            this.dupeController.invalidate();
                            break;
                        }
                        case EXTRACTION_STATUS: {
                            long filesize;
                            File file;
                            DownloadLink downloadLink;
                            if (ExtractionStatus.SUCCESSFUL.equals(eventPropery.getValue()) && (downloadLink = eventPropery.getDownloadLink()) != null && !FinalLinkState.CheckFinished(downloadLink.getFinalLinkState()) && (file = new File(downloadLink.getFileOutput())).isFile() && (filesize = file.length()) > 0L) {
                                DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

                                    @Override
                                    public boolean isHighPriority() {
                                        return false;
                                    }

                                    @Override
                                    public void interrupt() {
                                    }

                                    private void setFinished(DownloadLink downloadLink2) {
                                        downloadLink2.setVerifiedFileSize(filesize);
                                        downloadLink2.setDownloadCurrent(filesize);
                                        downloadLink2.setFinalLinkState(FinalLinkState.FINISHED_MIRROR);
                                    }

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        SingleDownloadController con = downloadLink.getDownloadLinkController();
                                        if (con == null) {
                                            this.setFinished(downloadLink);
                                        } else {
                                            con.getJobsAfterDetach().add(new DownloadWatchDogJob(){

                                                @Override
                                                public void interrupt() {
                                                }

                                                @Override
                                                public void execute(DownloadSession currentSession) {
                                                    this.setFinished(downloadLink);
                                                }

                                                @Override
                                                public boolean isHighPriority() {
                                                    return false;
                                                }
                                            });
                                            con.abort();
                                        }
                                    }
                                });
                            }
                            eventPropery.getDownloadLink().getParentNode().getView().requestUpdate();
                            break;
                        }
                        case NAME: 
                        case RESET: 
                        case RESUME: 
                        case ENABLED: 
                        case AVAILABILITY: 
                        case PRIORITY: 
                        case PLUGIN_PROGRESS: {
                            eventPropery.getDownloadLink().getParentNode().getView().requestUpdate();
                        }
                    }
                }
                this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventDataUpdate(source, param));
                break;
            }
            case STRUCTURE_CHANGE: {
                this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventStructureRefresh(source, param));
            }
        }
    }

    @Override
    protected void _controllerPackageNodeStructureChanged(FilePackage pkg, Queue.QueuePriority priority) {
        this.eventSender.fireEvent((DefaultEvent)new DownloadControllerEventStructureRefresh(pkg));
    }

    public void set(final DownloadLinkWalker filter) {
        DownloadController.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

            @Override
            public int returnMaxResults() {
                return 0;
            }

            @Override
            public boolean acceptNode(DownloadLink node) {
                if (filter.accept(node.getFilePackage()) && filter.accept(node)) {
                    filter.handle(node);
                }
                return false;
            }
        });
    }

    public static void removePackageIfFinished(final Object asker, final LogSource logger, final FilePackage fp) {
        DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (new DownloadLinkAggregator(fp).isFinished()) {
                    List<DownloadLink> noVetos = DownloadController.getInstance().askForRemoveVetos(asker, fp);
                    DownloadController.getInstance().removeChildren(noVetos);
                } else {
                    logger.info("Package is not finished");
                }
                return null;
            }
        });
    }

    @Override
    public boolean hasNotificationListener() {
        return true;
    }

    public boolean hasDownloadLinkByID(String linkID) {
        return this.dupeController.hasID(linkID);
    }

    private static final class LoadedPackage {
        private FilePackage filePackage = null;
        private final ArrayList<IndexedDownloadLink> downloadLinks = new ArrayList();
        private static final Comparator<IndexedDownloadLink> COMPARATOR = new Comparator<IndexedDownloadLink>(){

            @Override
            private final int compare(int x, int y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            @Override
            public int compare(IndexedDownloadLink o1, IndexedDownloadLink o2) {
                return this.compare(o1.getIndex(), o2.getIndex());
            }
        };

        private LoadedPackage(FilePackage filePackage) {
            this.setFilePackage(filePackage);
        }

        private final void setFilePackage(FilePackage filePackage) {
            this.filePackage = filePackage;
        }

        private FilePackage getLoadedPackage() {
            FilePackage filePackage = this.filePackage;
            if (filePackage != null) {
                if (filePackage.getChildren().size() == 0) {
                    Collections.sort(this.downloadLinks, COMPARATOR);
                    for (int index = 0; index < this.downloadLinks.size(); ++index) {
                        DownloadLink downloadLink = this.downloadLinks.get(index).getDownloadLink();
                        filePackage.getChildren().add(downloadLink);
                        downloadLink.setParentNode(filePackage);
                    }
                }
                return filePackage;
            }
            return null;
        }

        protected static final class IndexedDownloadLink {
            private final int index;
            private final DownloadLink downloadLink;

            private IndexedDownloadLink(int index, DownloadLink downloadLink) {
                this.index = index;
                this.downloadLink = downloadLink;
            }

            private final int getIndex() {
                return this.index;
            }

            private final DownloadLink getDownloadLink() {
                return this.downloadLink;
            }
        }
    }
}

