/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class DownloadSpeedManager {
    private final CopyOnWriteArrayList<ManagedThrottledConnectionHandler> connectionHandlers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ManagedThrottledConnectionHandler> removedHandlers = new CopyOnWriteArrayList();
    private NullsafeAtomicReference<Thread> watchDogThread = new NullsafeAtomicReference(null);
    protected final int updateSpeed = 2000;
    protected final AtomicInteger bandwidth = new AtomicInteger(0);
    protected final SpeedMeterInterface speedMeter = new AverageSpeedMeter(10);
    protected final AtomicLong traffic = new AtomicLong(0L);
    protected final AtomicInteger connections = new AtomicInteger(0);
    protected final AtomicInteger limit = new AtomicInteger(0);

    public void addConnectionHandler(ManagedThrottledConnectionHandler handler) {
        if (handler != null && this.connectionHandlers.addIfAbsent(handler)) {
            handler.setManagedBy(this);
            this.startWatchDog();
        }
    }

    public void removeConnectionHandler(ManagedThrottledConnectionHandler handler) {
        if (handler != null && this.connectionHandlers.remove(handler)) {
            handler.setManagedBy(null);
            this.removedHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWatchDog() {
        NullsafeAtomicReference<Thread> nullsafeAtomicReference = this.watchDogThread;
        synchronized (nullsafeAtomicReference) {
            Thread thread = (Thread)this.watchDogThread.get();
            if (thread != null && thread.isAlive()) {
                return;
            }
            thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        this.setName("DownloadSpeedManager");
                        DownloadSpeedManager.this.speedMeter.resetSpeedmeter();
                        HashMap<ManagedThrottledConnectionHandler, ManagedThrottledConnectionHelper> speedAssignHelpMap = new HashMap<ManagedThrottledConnectionHandler, ManagedThrottledConnectionHelper>();
                        ArrayList<ManagedThrottledConnectionHandler> removedHandlers = new ArrayList<ManagedThrottledConnectionHandler>();
                        ArrayList<ThrottledConnectionHelp> currentHelpers = new ArrayList<ThrottledConnectionHelp>();
                        block7: while (true) {
                            int currentLimit;
                            ManagedThrottledConnectionHelper managerHelper;
                            NullsafeAtomicReference nullsafeAtomicReference = DownloadSpeedManager.this.watchDogThread;
                            synchronized (nullsafeAtomicReference) {
                                if (DownloadSpeedManager.this.connectionHandlers.size() == 0 && DownloadSpeedManager.this.removedHandlers.size() == 0) {
                                    if (DownloadSpeedManager.this.watchDogThread.compareAndSet((Object)Thread.currentThread(), null)) {
                                        DownloadSpeedManager.this.bandwidth.set(0);
                                        DownloadSpeedManager.this.connections.set(0);
                                        DownloadSpeedManager.this.speedMeter.resetSpeedmeter();
                                    }
                                    break;
                                }
                            }
                            long sleepTime = Math.max(1000, 2000);
                            try {
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException e) {
                                LoggerFactory.getDefaultLogger().log((Throwable)e);
                            }
                            int newBandwidth = 0;
                            long lastRoundTraffic = DownloadSpeedManager.this.traffic.get();
                            currentHelpers.clear();
                            removedHandlers.clear();
                            for (ManagedThrottledConnectionHandler manager : DownloadSpeedManager.this.removedHandlers) {
                                removedHandlers.add(manager);
                                managerHelper = (ManagedThrottledConnectionHelper)speedAssignHelpMap.remove(manager);
                                long trafficDifference = 0L;
                                long bandWidth = 0L;
                                if (managerHelper != null) {
                                    long latestTimeStamp = managerHelper.lastTimeStamp.getAndSet(System.currentTimeMillis());
                                    long latestTraffic = managerHelper.lastTraffic.getAndSet(manager.getTraffic());
                                    trafficDifference = Math.max(0L, managerHelper.lastTraffic.get() - latestTraffic);
                                    long timeDifference = Math.max(0L, managerHelper.lastTimeStamp.get() - latestTimeStamp);
                                    if (timeDifference > 0L) {
                                        bandWidth = (int)(trafficDifference * 1000L / timeDifference);
                                    }
                                } else {
                                    trafficDifference = manager.getTraffic();
                                    bandWidth = trafficDifference * 1000L / sleepTime;
                                }
                                newBandwidth = (int)((long)newBandwidth + bandWidth);
                                DownloadSpeedManager.this.traffic.addAndGet(trafficDifference);
                            }
                            DownloadSpeedManager.this.removedHandlers.removeAll(removedHandlers);
                            for (ManagedThrottledConnectionHandler manager : DownloadSpeedManager.this.connectionHandlers) {
                                managerHelper = (ManagedThrottledConnectionHelper)speedAssignHelpMap.get(manager);
                                if (managerHelper == null) {
                                    managerHelper = new ManagedThrottledConnectionHelper(manager);
                                    speedAssignHelpMap.put(manager, managerHelper);
                                    managerHelper.lastTimeStamp.set(System.currentTimeMillis());
                                    managerHelper.lastTraffic.set(manager.getTraffic());
                                } else {
                                    long latestTimeStamp = managerHelper.lastTimeStamp.getAndSet(System.currentTimeMillis());
                                    long latestTraffic = managerHelper.lastTraffic.getAndSet(manager.getTraffic());
                                    long trafficDifference = Math.max(0L, managerHelper.lastTraffic.get() - latestTraffic);
                                    long timeDifference = Math.max(0L, managerHelper.lastTimeStamp.get() - latestTimeStamp);
                                    if (timeDifference > 0L) {
                                        newBandwidth += (int)(trafficDifference * 1000L / timeDifference);
                                    }
                                    DownloadSpeedManager.this.traffic.addAndGet(trafficDifference);
                                }
                                for (ThrottledConnection connection : manager.getConnections()) {
                                    ThrottledConnectionHelp connectionHelper = managerHelper.connections.get(connection);
                                    if (connectionHelper == null) {
                                        connectionHelper = new ThrottledConnectionHelp(connection);
                                        connectionHelper.lastTimeStamp.set(System.currentTimeMillis());
                                        connectionHelper.lastTraffic.set(connection.transfered());
                                    } else {
                                        connectionHelper.lastTimeStamp.getAndSet(System.currentTimeMillis());
                                        connectionHelper.lastTraffic.getAndSet(connection.transfered());
                                    }
                                    currentHelpers.add(connectionHelper);
                                }
                            }
                            DownloadSpeedManager.this.bandwidth.set(newBandwidth);
                            DownloadSpeedManager.this.speedMeter.putBytes(Math.max(0L, DownloadSpeedManager.this.traffic.get() - lastRoundTraffic), sleepTime);
                            DownloadSpeedManager.this.connections.set(currentHelpers.size());
                            int left = currentHelpers.size();
                            int limitLeft = currentLimit = DownloadSpeedManager.this.limit.get();
                            for (ThrottledConnectionHelp helper : currentHelpers) {
                                int newLimit = limitLeft / left;
                                helper.currentLimit = currentLimit > 0 ? Math.max(10, newLimit) : 0;
                                --left;
                                limitLeft -= helper.currentLimit;
                            }
                            Iterator iterator = currentHelpers.iterator();
                            while (true) {
                                ThrottledConnectionHelp helper;
                                if (!iterator.hasNext()) continue block7;
                                helper = (ThrottledConnectionHelp)iterator.next();
                                helper.connection.setLimit(helper.currentLimit);
                            }
                            break;
                        }
                    }
                    catch (Throwable e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                }
            };
            this.watchDogThread.set((Object)thread);
            thread.start();
        }
    }

    public void setLimit(int newLimit) {
        this.limit.set(Math.max(0, newLimit));
    }

    public int getLimit() {
        return this.limit.get();
    }

    public int getSpeed() {
        return this.bandwidth.get();
    }

    public SpeedMeterInterface getSpeedMeter() {
        return this.speedMeter;
    }

    public long getTraffic() {
        return this.traffic.get();
    }

    public int connections() {
        return this.connections.get();
    }

    private static class ThrottledConnectionHelp {
        protected final ThrottledConnection connection;
        protected int currentLimit = 0;
        protected final AtomicLong lastTraffic = new AtomicLong(0L);
        protected final AtomicLong lastTimeStamp = new AtomicLong(0L);

        private ThrottledConnectionHelp(ThrottledConnection connection) {
            this.connection = connection;
        }
    }

    private static class ManagedThrottledConnectionHelper {
        protected final ManagedThrottledConnectionHandler manager;
        protected final HashMap<ThrottledConnection, ThrottledConnectionHelp> connections = new HashMap();
        protected final AtomicLong lastTraffic = new AtomicLong(0L);
        protected final AtomicLong lastTimeStamp = new AtomicLong(0L);

        private ManagedThrottledConnectionHelper(ManagedThrottledConnectionHandler manager) {
            this.manager = manager;
        }
    }
}

