/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jd.controlling.downloadcontroller.FileIsLockedException;

public class FileAccessManager {
    private HashMap<File, Object> locks = new HashMap();

    public synchronized boolean unlock(File file, Object lockHolder) {
        Object currentHolder = this.getLockHolder(file);
        if (currentHolder != null && lockHolder == currentHolder) {
            this.locks.remove(file);
            return true;
        }
        return false;
    }

    public synchronized void lock(File file, Object newLockHolder) throws FileIsLockedException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null!");
        }
        if (newLockHolder == null) {
            throw new IllegalArgumentException("newLockHolder must not be null!");
        }
        Object currentHolder = this.getLockHolder(file);
        if (currentHolder != null) {
            if (currentHolder == newLockHolder) {
                return;
            }
            throw new FileIsLockedException(currentHolder);
        }
        this.locks.put(file, newLockHolder);
    }

    public synchronized boolean isLockedBy(File file, Object lockHolder) {
        if (lockHolder == null) {
            return false;
        }
        return this.locks.get(file) == lockHolder;
    }

    public synchronized boolean holdsLocks(Object lockHolder) {
        return this.locks.values().contains(lockHolder);
    }

    public synchronized void unlockAllHeldby(Object lockHolder) {
        Iterator<Map.Entry<File, Object>> it = this.locks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<File, Object> next = it.next();
            if (next.getValue() != lockHolder) continue;
            it.remove();
        }
    }

    public synchronized Object getLockHolder(File file) {
        return this.locks.get(file);
    }

    public synchronized boolean isLocked(File file) {
        return this.locks.containsKey(file);
    }
}

