/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import jd.controlling.downloadcontroller.IfFilenameTooLongDialogInterface;
import jd.plugins.DownloadLink;
import jd.plugins.ParsedFilename;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.IfFilenameTooLongAction;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class IfFilenameTooLongDialog
extends AbstractDialog<IfFilenameTooLongAction>
implements IfFilenameTooLongDialogInterface,
FocusListener {
    private final String path;
    private IfFilenameTooLongAction result;
    private final String packagename;
    private JRadioButton skip;
    private JRadioButton rename;
    final JTextField textfieldFilenameNew;
    private final JLabel newFilenameCharactersLeft = new JLabel("");
    private final String packageID;
    private final DownloadLink downloadLink;
    private final String autoShortenedFilename;
    private final String autoShortenedFilenameWithoutExt;
    private final ParsedFilename parsedOriginalFilename;
    final AtomicBoolean userChangedSelection = new AtomicBoolean(false);
    ItemListener userSelectionListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            IfFilenameTooLongDialog.this.userChangedSelection.set(true);
            IfFilenameTooLongDialog.this.updateNewFilenameCharactersLeftTextAndColor();
            IfFilenameTooLongDialog.this.stopTimer();
        }
    };

    public boolean isRemoteAPIEnabled() {
        return true;
    }

    @Override
    public String getPackagename() {
        return this.packagename;
    }

    @Override
    public String getPackageID() {
        return this.packageID;
    }

    public IfFilenameTooLongDialog(DownloadLink link, ParsedFilename originalFilenameParsed, String autoShortenedFilenameSuggestion) {
        super(36, "Filename is too long", null, null, null);
        this.packagename = link.getFilePackage().getName();
        this.packageID = link.getFilePackage().getPackageKey();
        this.path = link.getFileOutput();
        this.downloadLink = link;
        this.parsedOriginalFilename = originalFilenameParsed;
        this.autoShortenedFilename = autoShortenedFilenameSuggestion;
        String ext = originalFilenameParsed.getExtensionAdvanced();
        this.autoShortenedFilenameWithoutExt = ext != null ? autoShortenedFilenameSuggestion.substring(0, autoShortenedFilenameSuggestion.length() - ext.length()) : autoShortenedFilenameSuggestion;
        this.textfieldFilenameNew = new JTextField(this.autoShortenedFilenameWithoutExt);
        this.setTimeout(60000);
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    public String getDontShowAgainKey() {
        return null;
    }

    protected IfFilenameTooLongAction createReturnValue() {
        if (this.okButton != null) {
            this.okButton.removeFocusListener(this);
            if (!this.okButton.isEnabled()) {
                return IfFilenameTooLongAction.SKIP_FILE;
            }
        }
        return this.result;
    }

    protected String getDontShowAgainLabelText() {
        return _GUI.T.IfFileExistsDialog_getDontShowAgainLabelText_();
    }

    public JComponent layoutDialogContent() {
        String textfieldConstraints = "growx, pushx, wmin 100";
        MigPanel p = new MigPanel("ins 0,wrap 1, wmax 500", "", "");
        ExtTextArea txt = new ExtTextArea();
        txt.setLabelMode(true);
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setText("The filename is too long to be saved on your filesystem.\r\nHow would you like to proceed?");
        p.add((Component)txt, (Object)"growx, pushx, wmin 100");
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel("Current filename:")), (Object)"split 2,sg 1");
        JTextField textfieldFilenameCurrent = new JTextField(this.downloadLink.getName());
        textfieldFilenameCurrent.setEditable(false);
        p.add((Component)textfieldFilenameCurrent, (Object)"growx, pushx, wmin 100");
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel("Auto shortened filename:")), (Object)"split 2,sg 1");
        JTextField textfieldFilenameAutoShortened = new JTextField(this.autoShortenedFilename);
        textfieldFilenameAutoShortened.setEditable(false);
        p.add((Component)textfieldFilenameAutoShortened, (Object)"growx, pushx, wmin 100");
        String ext = this.parsedOriginalFilename.getExtensionAdvanced();
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel("Custom shortened filename:")), (Object)"split 3,sg 1");
        p.add((Component)this.textfieldFilenameNew, (Object)"growx, pushx, wmin 100");
        JTextField extField = new JTextField(ext != null ? ext : "NO_EXT");
        extField.setEditable(false);
        p.add((Component)extField, (Object)"growx, pushx, wmin 100");
        p.add((Component)SwingUtils.toBold((JLabel)this.newFilenameCharactersLeft));
        this.updateNewFilenameCharactersLeftTextAndColor();
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel("Filesize:")), (Object)"split 2,sg 1");
        GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit = (GraphicalUserInterfaceSettings.SIZEUNIT)((Object)CFG_GUI.MAX_SIZE_UNIT.getValue());
        p.add((Component)new JLabel(GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(maxSizeUnit, this.downloadLink.getView().getBytesTotal())));
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_package())), (Object)"split 2,sg 1");
        JTextField textfieldPackagename = new JTextField(this.packagename);
        textfieldPackagename.setEditable(false);
        p.add((Component)textfieldPackagename, (Object)"growx, pushx, wmin 100");
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_hoster())), (Object)"split 2,sg 1");
        p.add((Component)new JLabel(this.downloadLink.getDomainInfo().getTld()));
        ButtonGroup group = new ButtonGroup();
        this.skip = new JRadioButton(_GUI.T.IfFileExistsDialog_layoutDialogContent_skip_());
        this.skip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFilenameTooLongDialog.this.result = IfFilenameTooLongAction.SKIP_FILE;
                IfFilenameTooLongDialog.this.updateNewFilenameCharactersLeftTextAndColor();
            }
        });
        this.rename = new JRadioButton("Use shortened filename");
        this.rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFilenameTooLongDialog.this.result = IfFilenameTooLongAction.RENAME_FILE;
                IfFilenameTooLongDialog.this.updateNewFilenameCharactersLeftTextAndColor();
            }
        });
        group.add(this.skip);
        group.add(this.rename);
        p.add((Component)new JSeparator(), (Object)"pushx,growx");
        p.add((Component)this.skip, (Object)"gapleft 10");
        p.add((Component)this.rename, (Object)"gapleft 10");
        IfFilenameTooLongAction def = IfFilenameTooLongAction.SKIP_FILE;
        switch (def) {
            case RENAME_FILE: {
                this.rename.setSelected(true);
                break;
            }
            default: {
                this.skip.setSelected(true);
            }
        }
        this.skip.addItemListener(this.userSelectionListener);
        this.rename.addItemListener(this.userSelectionListener);
        if (this.okButton != null) {
            this.okButton.addFocusListener(this);
        }
        this.textfieldFilenameNew.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IfFilenameTooLongDialog.this.onFilenameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IfFilenameTooLongDialog.this.onFilenameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IfFilenameTooLongDialog.this.onFilenameChanged();
            }
        });
        this.setTextFieldLimit(this.textfieldFilenameNew);
        this.result = def;
        return p;
    }

    private int getEffectiveMaxNewFilenameLength() {
        return this.autoShortenedFilenameWithoutExt.length();
    }

    private void setTextFieldLimit(final JTextField textField) {
        ((AbstractDocument)textField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                if (!this.isValidLength(fb, string, 0)) {
                    IfFilenameTooLongDialog.this.triggerWarning(textField);
                    return;
                }
                super.insertString(fb, offset, string, attr);
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                if (fb.getDocument().getLength() - length < 1) {
                    IfFilenameTooLongDialog.this.triggerWarning(textField);
                    return;
                }
                super.remove(fb, offset, length);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
                if (!this.isValidLength(fb, string, length)) {
                    IfFilenameTooLongDialog.this.triggerWarning(textField);
                    return;
                }
                super.replace(fb, offset, length, string, attr);
            }

            private boolean isValidLength(DocumentFilter.FilterBypass fb, String string, int lengthToRemove) {
                if (string == null) {
                    return false;
                }
                int maxlen = IfFilenameTooLongDialog.this.getEffectiveMaxNewFilenameLength();
                int newlen = fb.getDocument().getLength() - lengthToRemove + string.length();
                return newlen <= maxlen;
            }
        });
    }

    private void triggerWarning(final JTextField textField) {
        Toolkit.getDefaultToolkit().beep();
        textField.setForeground(Color.RED);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                new EDTRunner(){

                    protected void runInEDT() {
                        textField.setForeground(Color.BLACK);
                    }
                };
            }
        }.start();
    }

    private void onFilenameChanged() {
        this.autoSelectRenameIfAllowed();
        this.updateNewFilenameCharactersLeftTextAndColor();
        this.stopTimer();
    }

    private void autoSelectRenameIfAllowed() {
        if (this.userChangedSelection.get()) {
            return;
        }
        if (!this.filenameHasChanged()) {
            return;
        }
        this.rename.setSelected(true);
        this.userChangedSelection.set(false);
        this.result = IfFilenameTooLongAction.RENAME_FILE;
    }

    private void updateNewFilenameCharactersLeftTextAndColor() {
        int charactersLeft = this.getEffectiveMaxNewFilenameLength() - this.textfieldFilenameNew.getText().length();
        if (this.result == IfFilenameTooLongAction.RENAME_FILE && this.userChangedSelection.get() && charactersLeft <= 0) {
            this.newFilenameCharactersLeft.setForeground(Color.RED);
        } else {
            this.newFilenameCharactersLeft.setForeground(Color.BLACK);
        }
        this.newFilenameCharactersLeft.setText(String.format("Characters left: %d", charactersLeft));
    }

    private boolean filenameHasChanged() {
        return !StringUtils.equals((String)this.autoShortenedFilenameWithoutExt, (String)this.textfieldFilenameNew.getText());
    }

    @Override
    public IfFilenameTooLongAction getAction() {
        return this.result;
    }

    @Override
    public String getFilePath() {
        return this.path;
    }

    public IfFilenameTooLongDialogInterface show() {
        return (IfFilenameTooLongDialogInterface)UIOManager.I().show(IfFilenameTooLongDialogInterface.class, (UserIODefinition)this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        DownloadsTableModel.getInstance().setSelectedObject(this.downloadLink);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public String getHost() {
        return this.downloadLink.getHost();
    }

    @Override
    public String getNewFilename() {
        String newFilename = this.textfieldFilenameNew.getText();
        if (newFilename == null) {
            return null;
        }
        String ext = this.parsedOriginalFilename.getExtensionAdvanced();
        if (ext != null && !StringUtils.endsWithCaseInsensitive((String)newFilename, (String)ext)) {
            newFilename = newFilename + ext;
        }
        return newFilename;
    }
}

