/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.BadFilePathException;
import jd.controlling.downloadcontroller.DeferredRunnableException;
import jd.controlling.downloadcontroller.DiskSpaceManager;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadSpeedManager;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.NoInternetConnection;
import jd.controlling.downloadcontroller.SingleDownloadReturnState;
import jd.controlling.downloadcontroller.event.DownloadWatchdogEvent;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.SelectProxyByURLHook;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.OfflineException;
import jd.http.Browser;
import jd.http.BrowserSettingsThread;
import jd.http.NoGateWayException;
import jd.http.ProxySelectorInterface;
import jd.http.StaticProxySelector;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import jd.plugins.LinkStatus;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.HashResult;
import org.appwork.utils.Exceptions;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.StringUtils;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.NetworkInterfaceException;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.tasks.AbstractPluginSubTask;
import org.jdownloader.plugins.tasks.PluginProgressTask;
import org.jdownloader.plugins.tasks.PluginSubTask;
import org.jdownloader.translate._JDT;

public class SingleDownloadController
extends BrowserSettingsThread
implements DownloadControllerListener {
    private final AtomicBoolean abortFlag = new AtomicBoolean(false);
    private final NullsafeAtomicReference<PluginForHost> processingPlugin = new NullsafeAtomicReference(null);
    private static final HashMap<String, WaitingQueueItem> LAST_DOWNLOAD_START_TIMESTAMPS = new HashMap();
    private final DownloadLink downloadLink;
    private final Account account;
    private volatile long startTimestamp = -1L;
    private final DownloadLinkCandidate candidate;
    private final DownloadWatchDog watchDog;
    private final LinkStatus linkStatus;
    private volatile HashResult hashResult = null;
    private final CopyOnWriteArrayList<DownloadWatchDogJob> jobsAfterDetach = new CopyOnWriteArrayList();
    private final WaitingQueueItem queueItem;
    private final long sizeBefore;
    private final ArrayList<PluginSubTask> tasks = new ArrayList();
    private volatile HTTPProxy usedProxy;
    private volatile boolean resumed;
    private final DownloadSession session;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final Set<String> stackTraces = new HashSet<String>();
    private volatile String sessionDownloadDirectory;
    private volatile String sessionDownloadFilename;

    public WaitingQueueItem getQueueItem() {
        return this.queueItem;
    }

    public CopyOnWriteArrayList<DownloadWatchDogJob> getJobsAfterDetach() {
        return this.jobsAfterDetach;
    }

    public synchronized void start() {
        this.queueItem.queueLinks.add(this.downloadLink);
        super.start();
    }

    public HashResult getHashResult() {
        return this.hashResult;
    }

    public void setHashResult(HashResult hashResult) {
        this.hashResult = hashResult;
    }

    public LinkStatus getLinkStatus() {
        return this.linkStatus;
    }

    public DownloadInterface getDownloadInstance() {
        PluginForHost plugin = (PluginForHost)this.processingPlugin.get();
        if (plugin != null) {
            return plugin.getDownloadInterface();
        }
        return null;
    }

    public DownloadLinkCandidate getDownloadLinkCandidate() {
        return this.candidate;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void lockFile(File file) throws FileIsLockedException {
        DownloadWatchDog.getInstance().getSession().getFileAccessManager().lock(file, this);
    }

    public boolean unlockFile(File file) {
        return DownloadWatchDog.getInstance().getSession().getFileAccessManager().unlock(file, this);
    }

    public DownloadSpeedManager getConnectionHandler() {
        return this.watchDog.getDownloadSpeedManager();
    }

    protected SingleDownloadController(DownloadLinkCandidate candidate, DownloadWatchDog watchDog) {
        super("Download: " + candidate.getLink().getView().getDisplayName() + "_" + candidate.getLink().getHost());
        this.setPriority(1);
        this.watchDog = watchDog;
        this.candidate = candidate;
        super.setProxySelector((ProxySelectorInterface)candidate.getProxySelector());
        this.downloadLink = candidate.getLink();
        this.sizeBefore = Math.max(0L, this.downloadLink.getView().getBytesLoaded());
        this.account = candidate.getCachedAccount().getAccount();
        String host = candidate.getCachedAccount().getPlugin().getHost();
        WaitingQueueItem queueItem = LAST_DOWNLOAD_START_TIMESTAMPS.get(host);
        if (queueItem == null) {
            queueItem = new WaitingQueueItem();
            LAST_DOWNLOAD_START_TIMESTAMPS.put(host, queueItem);
        }
        this.queueItem = queueItem;
        this.linkStatus = new LinkStatus(this.downloadLink);
        this.session = watchDog.getSession();
        this.setName("Download: " + this.downloadLink.getView().getDisplayName() + "_" + this.downloadLink.getHost());
    }

    public AbstractProxySelectorImpl getProxySelector() {
        return this.candidate.getProxySelector();
    }

    public boolean isDebug() {
        return true;
    }

    public boolean isVerbose() {
        return true;
    }

    public Account getAccount() {
        return this.account;
    }

    public boolean isAborting() {
        return this.abortFlag.get();
    }

    public boolean isActive() {
        return this.processingPlugin.isValueSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        super.interrupt();
        LogInterface logger = this.getLogger();
        if (logger != null) {
            Exception exception = new Exception("SingleDownloadController.interrupt");
            String stackTrace = Exceptions.getStackTrace((Throwable)exception);
            Set<String> set = this.stackTraces;
            synchronized (set) {
                if (this.stackTraces.add(stackTrace)) {
                    logger.log((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abort() {
        LogInterface logger;
        if (!this.isActive()) {
            return;
        }
        if (this.abortFlag.compareAndSet(false, true)) {
            Thread abortThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (SingleDownloadController.this.isActive() && SingleDownloadController.this.isAlive()) {
                        try {
                            DownloadInterface dli = SingleDownloadController.this.getDownloadInstance();
                            if (dli != null) {
                                dli.stopDownload();
                            }
                        }
                        catch (Throwable e) {
                            LogSource.exception((LogInterface)SingleDownloadController.this.logger, (Throwable)e);
                        }
                        NullsafeAtomicReference nullsafeAtomicReference = SingleDownloadController.this.processingPlugin;
                        synchronized (nullsafeAtomicReference) {
                            if (!SingleDownloadController.this.isActive() || !SingleDownloadController.this.isAlive()) {
                                return;
                            }
                            SingleDownloadController.this.interrupt();
                            try {
                                SingleDownloadController.this.processingPlugin.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            abortThread.setDaemon(true);
            abortThread.setName("Abort: " + this.downloadLink.getView().getDisplayName() + "_" + (Object)((Object)this.downloadLink.getUniqueID()));
            abortThread.start();
        }
        if ((logger = this.getLogger()) != null) {
            Exception exception = new Exception("SingleDownloadController.abort");
            String stackTrace = Exceptions.getStackTrace((Throwable)exception);
            Set<String> set = this.stackTraces;
            synchronized (set) {
                if (this.stackTraces.add(stackTrace)) {
                    logger.log((Throwable)exception);
                }
            }
        }
    }

    public DownloadLink getDownloadLink() {
        return this.candidate.getLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginForHost finalizeProcessingPlugin() {
        PluginForHost plugin;
        NullsafeAtomicReference<PluginForHost> nullsafeAtomicReference = this.processingPlugin;
        synchronized (nullsafeAtomicReference) {
            PluginClassLoader.setThreadPluginClassLoaderChild(null, null);
            plugin = (PluginForHost)this.processingPlugin.getAndClear();
            this.processingPlugin.notifyAll();
        }
        return plugin;
    }

    private Browser getPluginBrowser(Plugin plugin) {
        return plugin.createNewBrowserInstance();
    }

    protected void invalidateLastChallengeResponse(LogSource logger, PluginForHost plugin) {
        if (plugin != null) {
            try {
                plugin.invalidateLastChallengeResponse();
            }
            catch (Throwable ignore) {
                logger.log(ignore);
            }
        }
    }

    protected void validateLastChallengeResponse(LogSource logger, PluginForHost plugin) {
        if (plugin != null) {
            try {
                plugin.validateLastChallengeResponse();
            }
            catch (Throwable ignore) {
                logger.log(ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private SingleDownloadReturnState download(final LogSource downloadLogger) {
        block79: {
            handlePlugin = null;
            downloadLogger.info("DownloadCandidate: " + this.candidate);
            linkPlugin = null;
            if (AccountCache.ACCOUNTTYPE.MULTI.equals((Object)this.candidate.getCachedAccount().getType())) {
                defaultCL = this.session.getPluginClassLoaderChild(this.downloadLink.getDefaultPlugin());
                PluginClassLoader.setThreadPluginClassLoaderChild(defaultCL, defaultCL);
                linkPlugin = this.downloadLink.getDefaultPlugin().getLazyP().newInstance(defaultCL);
                br = this.getPluginBrowser(linkPlugin);
                linkPlugin.setBrowser(br);
                linkPlugin.setLogger((LogInterface)downloadLogger);
                linkPlugin.setDownloadLink(this.downloadLink);
                linkPlugin.init();
                availableStatus = this.downloadLink.getAvailableStatus();
                lastAvailableStatusChange = this.downloadLink.getLastAvailableStatusChange();
                availableStatusChangeTimeout = linkPlugin.getAvailableStatusTimeout(this.downloadLink, availableStatus);
                if (lastAvailableStatusChange + availableStatusChangeTimeout < System.currentTimeMillis()) {
                    try {
                        this.processingPlugin.set((Object)linkPlugin);
                        try {
                            availableStatus = linkPlugin.checkLink(this.downloadLink);
                            if (DownloadLink.AvailableStatus.FALSE == availableStatus) {
                                throw new PluginException(32);
                            }
                        }
                        catch (Throwable e) {
                            downloadLogger.log(e);
                            throw e;
                        }
                    }
                    catch (Browser.BrowserException e) {
                    }
                    catch (SkipReasonException e) {
                        if (SkipReason.CAPTCHA.equals((Object)e.getSkipReason())) {
                            this.invalidateLastChallengeResponse(downloadLogger, linkPlugin);
                            break block79;
                        }
                        throw e;
                    }
                    catch (PluginException e) {
                        switch (e.getLinkStatus()) {
                            case 256: 
                            case 2048: 
                            case 4096: {
                                availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                                ** break;
lbl41:
                                // 1 sources

                                break;
                            }
                            case 32: {
                                availableStatus = DownloadLink.AvailableStatus.FALSE;
                                throw e;
                            }
                            case 8: {
                                this.invalidateLastChallengeResponse(downloadLogger, linkPlugin);
                                ** break;
lbl48:
                                // 1 sources

                                break;
                            }
                            default: {
                                availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                                throw e;
                            }
                        }
                    }
                    finally {
                        this.processingPlugin.set(null);
                        this.downloadLink.setAvailableStatus(availableStatus);
                        this.validateLastChallengeResponse(downloadLogger, linkPlugin);
                    }
                }
            }
        }
        handleCL = this.session.getPluginClassLoaderChild(this.candidate.getCachedAccount().getPlugin());
        PluginClassLoader.setThreadPluginClassLoaderChild(handleCL, handleCL);
        handlePlugin = this.candidate.getCachedAccount().getPlugin().getLazyP().newInstance(handleCL);
        br = this.getPluginBrowser(handlePlugin);
        handlePlugin.setBrowser(br);
        handlePlugin.setLogger((LogInterface)downloadLogger);
        handlePlugin.setDownloadLink(this.downloadLink);
        handlePlugin.init();
        try {
            this.processingPlugin.set((Object)handlePlugin);
            this.downloadLink.setLivePlugin(handlePlugin);
            try {
                if (linkPlugin != null) {
                    linkPlugin.preHandle(this.downloadLink, this.account, handlePlugin);
                }
                finalHandlePlugin = handlePlugin;
                this.watchDog.localFileCheck(this, new ExceptionRunnable(){

                    @Override
                    public void run() throws Exception {
                        final File partFile = new File(SingleDownloadController.this.downloadLink.getFileOutput() + ".part");
                        long doneSize = Math.max(partFile.exists() ? partFile.length() : 0L, SingleDownloadController.this.downloadLink.getView().getBytesLoaded());
                        final long remainingSize = SingleDownloadController.this.downloadLink.getView().getBytesTotal() - Math.max(0L, doneSize);
                        DiskSpaceReservation reservation = new DiskSpaceReservation(){

                            @Override
                            public File getDestination() {
                                return partFile;
                            }

                            @Override
                            public long getSize() {
                                return remainingSize + Math.max(0L, finalHandlePlugin.calculateAdditionalRequiredDiskSpace(SingleDownloadController.this.downloadLink));
                            }

                            @Override
                            public Object getOwner() {
                                return SingleDownloadController.this;
                            }

                            @Override
                            public LogInterface getLogger() {
                                return downloadLogger;
                            }
                        };
                        DiskSpaceManager.DISKSPACERESERVATIONRESULT result = SingleDownloadController.this.watchDog.validateDiskFree(reservation);
                        switch (result) {
                            case FAILED: {
                                throw new SkipReasonException(SkipReason.DISK_FULL);
                            }
                            case INVALIDDESTINATION: {
                                throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                            }
                        }
                    }
                }, null);
                this.startTimestamp = System.currentTimeMillis();
                handlePlugin.handle(this.downloadLink, this.account);
                if (linkPlugin != null) {
                    linkPlugin.postHandle(this.downloadLink, this.account, handlePlugin);
                }
            }
            catch (Throwable e) {
                downloadLogger.log(e);
                throw e;
            }
            finally {
                try {
                    if (linkPlugin != null) {
                        linkPlugin.clean();
                    }
                }
                catch (Throwable ignore) {
                    downloadLogger.log(ignore);
                }
            }
        }
        catch (DeferredRunnableException e) {
            if (e.getExceptionRunnable() != null) {
                e.getExceptionRunnable().run();
            }
            throw e;
        }
        lastAvailableStatusChange = ret = new SingleDownloadReturnState(this, null, this.finalizeProcessingPlugin());
        try {
            this.downloadLink.setLivePlugin(null);
            WaitingQueueItem.access$000(this.queueItem).remove(this.downloadLink);
            if (handlePlugin != null) {
                if (!this.isAborting()) {
                    this.validateLastChallengeResponse(downloadLogger, handlePlugin);
                }
                this.resumed = (di = handlePlugin.getDownloadInterface()) != null && di.isResumedDownload() != false;
                try {
                    handlePlugin.clean();
                }
                catch (Throwable ignore) {
                    downloadLogger.log(ignore);
                }
            }
            if ((fp = this.downloadLink.getFilePackage()) != null && !FilePackage.isDefaultFilePackage(fp) && (view = fp.getView()) != null) {
                view.requestUpdate();
            }
        }
        catch (Throwable e) {
            downloadLogger.log(e);
        }
        return lastAvailableStatusChange;
        catch (Throwable throwable) {
            try {
                lastPlugin = this.finalizeProcessingPlugin();
                try {
                    throw throwable;
                }
                catch (InterruptedIOException e) {
                    if (this.isAborting()) {
                        throwable /* !! */  = new PluginException(4, null, e);
                    }
                }
                catch (Browser.BrowserException browserException) {
                    if (this.isConnectionOffline(lastPlugin, browserException)) {
                        throwable /* !! */  = new NoInternetConnection(browserException).fillInStackTrace();
                    } else if (Exceptions.containsInstanceOf((Throwable)browserException, (Class[])new Class[]{InterruptedIOException.class}) && this.isAborting()) {
                        throwable /* !! */  = new PluginException(4, null, browserException);
                    } else if (browserException.getCause() != null) {
                        throwable /* !! */  = browserException.getCause();
                    }
                }
                catch (SkipReasonException skipReasonException) {
                    switch (4.$SwitchMap$org$jdownloader$plugins$SkipReason[skipReasonException.getSkipReason().ordinal()]) {
                        case 1: {
                            this.invalidateLastChallengeResponse(downloadLogger, lastPlugin);
                            break;
                        }
                    }
                }
                catch (BadFilePathException e) {
                    throwable /* !! */  = e.getReason() == BadFilePathException.PathFailureReason.PATH_TOO_LONG ? new SkipReasonException(SkipReason.INVALID_DESTINATION_TOO_LONG_PATH) : (e.getReason() == BadFilePathException.PathFailureReason.PATH_SEGMENT_TOO_LONG ? new SkipReasonException(SkipReason.INVALID_DESTINATION_TOO_LONG_FILENAME) : (e.getReason() == BadFilePathException.PathFailureReason.PATH_TOO_LONG ? new SkipReasonException(SkipReason.INVALID_DESTINATION_TOO_LONG_PATH) : (e.getReason() == BadFilePathException.PathFailureReason.PERMISSION_PROBLEM ? new SkipReasonException(SkipReason.INVALID_DESTINATION_PERMISSION_ISSUE, _JDT.T.DownloadLink_setSkipped_statusmessage_invalid_path_permission_issue_file(e.getProblematicPathSegment().getName())) : new SkipReasonException(SkipReason.INVALID_DESTINATION))));
                }
                catch (PluginException pluginException) {
                    switch (pluginException.getLinkStatus()) {
                        case 8: {
                            this.invalidateLastChallengeResponse(downloadLogger, lastPlugin);
                            break;
                        }
                    }
                }
                catch (Throwable pluginException) {
                    // empty catch block
                }
                var6_20 = ret = new SingleDownloadReturnState(this, throwable /* !! */ , lastPlugin);
            }
            catch (Throwable var15_39) {
                try {
                    this.downloadLink.setLivePlugin(null);
                    WaitingQueueItem.access$000(this.queueItem).remove(this.downloadLink);
                    if (handlePlugin != null) {
                        if (!this.isAborting()) {
                            this.validateLastChallengeResponse(downloadLogger, handlePlugin);
                        }
                        this.resumed = (di = handlePlugin.getDownloadInterface()) != null && di.isResumedDownload() != false;
                        try {
                            handlePlugin.clean();
                        }
                        catch (Throwable ignore) {
                            downloadLogger.log(ignore);
                        }
                    }
                    if ((fp = this.downloadLink.getFilePackage()) != null && !FilePackage.isDefaultFilePackage(fp) && (view = fp.getView()) != null) {
                        view.requestUpdate();
                    }
                }
                catch (Throwable e) {
                    downloadLogger.log(e);
                }
                throw var15_39;
            }
            try {
                this.downloadLink.setLivePlugin(null);
                WaitingQueueItem.access$000(this.queueItem).remove(this.downloadLink);
                if (handlePlugin != null) {
                    if (!this.isAborting()) {
                        this.validateLastChallengeResponse(downloadLogger, handlePlugin);
                    }
                    this.resumed = (di = handlePlugin.getDownloadInterface()) != null && di.isResumedDownload() != false;
                    try {
                        handlePlugin.clean();
                    }
                    catch (Throwable ignore) {
                        downloadLogger.log(ignore);
                    }
                }
                if ((fp = this.downloadLink.getFilePackage()) != null && !FilePackage.isDefaultFilePackage(fp) && (view = fp.getView()) != null) {
                    view.requestUpdate();
                }
            }
            catch (Throwable e) {
                downloadLogger.log(e);
            }
            return var6_20;
        }
    }

    public PluginForHost getProcessingPlugin() {
        return (PluginForHost)this.processingPlugin.get();
    }

    public boolean isResumed() {
        return this.resumed;
    }

    public HTTPProxy getUsedProxy() {
        return this.usedProxy;
    }

    private boolean isConnectionOffline(PluginForHost plugin, Throwable e) {
        if (Exceptions.getInstanceof((Throwable)e, InterruptedException.class) != null) {
            return false;
        }
        if (Exceptions.getInstanceof((Throwable)e, NoRouteToHostException.class) != null) {
            return true;
        }
        if (Exceptions.getInstanceof((Throwable)e, NetworkInterfaceException.class) != null) {
            return true;
        }
        if (Exceptions.getInstanceof((Throwable)e, NoGateWayException.class) != null) {
            return true;
        }
        if (this.isAborting()) {
            return false;
        }
        Browser.BrowserException browserException = (Browser.BrowserException)Exceptions.getInstanceof((Throwable)e, Browser.BrowserException.class);
        HTTPProxy proxy = null;
        if (browserException != null) {
            Throwable cause = browserException.getCause();
            if (cause == null) {
                return false;
            }
            if (browserException.getRequest() != null) {
                proxy = browserException.getRequest().getProxy();
            }
        } else {
            return false;
        }
        if (proxy == null && plugin != null && plugin.getBrowser() != null && plugin.getBrowser().getRequest() != null) {
            proxy = plugin.getBrowser().getRequest().getProxy();
        }
        if (proxy == null) {
            proxy = this.getUsedProxy();
        }
        AbstractProxySelectorImpl proxySelector = proxy != null ? new StaticProxySelector(proxy) : this.getProxySelector();
        BalancedWebIPCheck onlineCheck = new BalancedWebIPCheck(proxySelector);
        try {
            onlineCheck.getExternalIP();
        }
        catch (OfflineException e2) {
            return true;
        }
        catch (IPCheckException iPCheckException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LogSource downloadLogger = null;
        SelectProxyByURLHook hook = null;
        PluginProgressTask task = new PluginProgressTask(null);
        long id = UniqueAlltimeID.next();
        AbstractProxySelectorImpl ps = this.getProxySelector();
        try {
            if (ps != null) {
                final Thread currentThread = Thread.currentThread();
                hook = new SelectProxyByURLHook(){

                    @Override
                    public void onProxyChoosen(URL url, List<HTTPProxy> ret) {
                        if (currentThread == Thread.currentThread()) {
                            SingleDownloadController.this.usedProxy = ret.get(0);
                        }
                    }
                };
                ps.addSelectProxyByUrlHook(hook);
            }
            String logID = this.downloadLink.getDefaultPlugin().getHost() + "_" + this.downloadLink.getDefaultPlugin().getLazyP().getClassName();
            if (AccountCache.ACCOUNTTYPE.MULTI.equals((Object)this.candidate.getCachedAccount().getType())) {
                logID = logID + "_" + this.candidate.getCachedAccount().getPlugin().getHost();
            }
            downloadLogger = LogController.getFastPluginLogger(logID);
            downloadLogger.info("StartDownloadMarker:" + id);
            downloadLogger.info("Start Download of:" + this.downloadLink.getPluginPatternMatcher() + " | ID:" + id);
            super.setLogger((LogInterface)downloadLogger);
            try {
                this.watchDog.getEventSender().fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.LINK_STARTED, this, this.candidate));
            }
            catch (Throwable e) {
                downloadLogger.log(e);
            }
            task.open();
            this.addTask(task);
            SingleDownloadReturnState returnState = this.download(downloadLogger);
            if (this.isAborting()) {
                SingleDownloadController.interrupted();
            }
            this.watchDog.detach(this, returnState);
        }
        catch (Throwable throwable) {
            try {
                if (ps != null && hook != null) {
                    ps.removeSelectProxyByUrlHook(hook);
                }
                task.reopen();
                task.close();
            }
            finally {
                this.finalizeProcessingPlugin();
                this.finished.set(true);
            }
            if (downloadLogger != null) {
                downloadLogger.info("StopDownloadMarker:" + id);
            }
            throw throwable;
        }
        try {
            if (ps != null && hook != null) {
                ps.removeSelectProxyByUrlHook(hook);
            }
            task.reopen();
            task.close();
        }
        finally {
            this.finalizeProcessingPlugin();
            this.finished.set(true);
        }
        if (downloadLogger != null) {
            downloadLogger.info("StopDownloadMarker:" + id);
        }
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void setLogger(LogInterface logger) {
    }

    public long getSizeBefore() {
        return this.sizeBefore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(PluginSubTask subTask) {
        if (subTask != null) {
            ArrayList<PluginSubTask> arrayList = this.tasks;
            synchronized (arrayList) {
                this.tasks.add(subTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDetach(DownloadLink downloadLink) {
        DownloadController.getInstance().getEventSender().removeListener((EventListener)this);
        ArrayList<PluginSubTask> arrayList = this.tasks;
        synchronized (arrayList) {
            for (PluginSubTask t : this.tasks) {
                t.close();
            }
        }
    }

    public void onAttach(DownloadLink downloadLink) {
        DownloadController.getInstance().getEventSender().addListener((EventListener)this, true);
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
        block10: {
            try {
                if (downloadlink != this.downloadLink) {
                    return;
                }
                if (property.getProperty() != DownloadLinkProperty.Property.PLUGIN_PROGRESS) break block10;
                PluginProgress newProgress = (PluginProgress)property.getValue();
                ArrayList<PluginSubTask> arrayList = this.tasks;
                synchronized (arrayList) {
                    AbstractPluginSubTask task = null;
                    for (PluginSubTask t : this.tasks) {
                        if (!(t instanceof PluginProgressTask)) continue;
                        if (((PluginProgressTask)t).getProgress() != newProgress) {
                            t.close();
                            continue;
                        }
                        task = (PluginProgressTask)t;
                    }
                    if (task == null) {
                        task = new PluginProgressTask(newProgress);
                        task.open();
                        this.addTask(task);
                    } else {
                        task.reopen();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PluginSubTask> getTasks() {
        ArrayList<PluginSubTask> arrayList = this.tasks;
        synchronized (arrayList) {
            return new ArrayList<PluginSubTask>(this.tasks);
        }
    }

    public void setSessionDownloadDirectory(String downloadDirectory) {
        this.sessionDownloadDirectory = downloadDirectory;
    }

    public String getSessionDownloadDirectory() {
        return this.sessionDownloadDirectory;
    }

    public void setSessionDownloadFilename(String downloadFilename) {
        if (!StringUtils.equals((String)this.sessionDownloadFilename, (String)downloadFilename)) {
            this.sessionDownloadFilename = downloadFilename;
            if (this.downloadLink.hasNotificationListener()) {
                this.downloadLink.firePropertyChange(new DownloadLinkProperty(this.downloadLink, DownloadLinkProperty.Property.NAME, downloadFilename));
            }
        }
    }

    public String getSessionDownloadFilename() {
        return this.sessionDownloadFilename;
    }

    public File getFileOutput(boolean ignoreUnsafe, boolean ignoreCustom) {
        String name = this.getSessionDownloadFilename();
        if (StringUtils.isEmpty((String)name) && (name = this.downloadLink.getName(ignoreUnsafe, true)) == null) {
            return null;
        }
        if (!ignoreCustom) {
            String customAppend;
            String tmpName = this.downloadLink.getInternalTmpFilename();
            if (!StringUtils.isEmpty((String)tmpName)) {
                name = tmpName;
            }
            if (!StringUtils.isEmpty((String)(customAppend = this.downloadLink.getInternalTmpFilenameAppend()))) {
                name = name + customAppend;
            }
        }
        return new File(this.getSessionDownloadDirectory(), name);
    }

    public static class WaitingQueueItem {
        public final AtomicLong lastStartTimestamp = new AtomicLong(0L);
        public final AtomicLong lastConnectionTimestamp = new AtomicLong(System.currentTimeMillis());
        private final CopyOnWriteArrayList<DownloadLink> queueLinks = new CopyOnWriteArrayList();

        public int indexOf(DownloadLink link) {
            return this.queueLinks.indexOf(link);
        }
    }
}

