/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.faviconcontroller;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jd.captcha.utils.GifDecoder;
import jd.controlling.faviconcontroller.FavIconRequestor;
import jd.controlling.faviconcontroller.FavIconsConfig;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.plugins.PluginForHost;
import net.sf.image4j.codec.ico.ICODecoder;
import org.appwork.resources.MultiResolutionImageHelper;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.PublicSuffixList;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.updatev2.gui.LAFOptions;

public class FavIcons {
    private static final int BASE_SIZE = 16;
    private static final ThreadPoolExecutor THREAD_POOL;
    private static final AtomicInteger THREADCOUNTER;
    private static final Object LOCK;
    private static final LinkedHashMap<String, List<FavIconRequestor>> QUEUE;
    private static final HashMap<String, ImageIcon> FAILED_ICONS;
    private static final HashSet<String> REFRESHED_ICONS;
    private static final HashMap<String, ImageIcon> DEFAULT_ICONS;
    private static final FavIconsConfig CONFIG;
    private static final long REFRESH_TIMEOUT = 604800000L;
    private static final long RETRY_TIMEOUT = 604800000L;

    public static Icon getFavIcon(String host, FavIconRequestor requestor) {
        return FavIcons.getFavIcon(host, requestor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getFavIcon(String host, FavIconRequestor requestor, boolean updatePermission) {
        if (host == null) {
            return null;
        }
        Icon image = null;
        Object object = LOCK;
        synchronized (object) {
            URL url = NewTheme.I().getIconURL("fav/" + host);
            if (url != null) {
                image = new AbstractIcon("fav/" + host, -1);
            }
            if (image == null && (url = NewTheme.I().getIconURL("fav/big." + host)) != null) {
                image = new AbstractIcon("fav/big." + host, -1);
            }
            if (image != null) {
                try {
                    long lastModified;
                    File file;
                    if (REFRESHED_ICONS.add(host) && "file".equalsIgnoreCase(url.getProtocol()) && (!(file = new File(url.toURI())).isFile() || file.canWrite()) && (lastModified = file.lastModified()) > 0L && System.currentTimeMillis() - lastModified > 604800000L && file.isFile()) {
                        file.setLastModified(System.currentTimeMillis());
                        if (updatePermission) {
                            FavIcons.add(host, requestor);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return image;
            }
        }
        if (image == null && updatePermission) {
            image = FavIcons.add(host, requestor);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getDefaultIcon(String host, boolean clearAfterGet) {
        LogSource logger = FavIcons.getLogger(host, null);
        try {
            ImageIcon imageIcon = FavIcons.getDefaultIcon(logger, host, clearAfterGet);
            return imageIcon;
        }
        finally {
            logger.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getDefaultIcon(LogSource logger, String host, boolean clearAfterGet) {
        ImageIcon ret = null;
        Object object = LOCK;
        synchronized (object) {
            ret = DEFAULT_ICONS.get(host);
            if (ret == null) {
                ret = new ImageIcon(FavIcons.createDefaultFavIcon(logger, host));
                if (!clearAfterGet) {
                    DEFAULT_ICONS.put(host, ret);
                }
            } else if (clearAfterGet) {
                DEFAULT_ICONS.remove(host);
            }
        }
        return ret;
    }

    private static LogSource getLogger(String host, FavIconRequestor requestor) {
        LogSource ret = LogController.getFastPluginLogger("FavIcons");
        if (CONFIG.isDebugFlag()) {
            ret.setInstantFlush(true);
        }
        return ret;
    }

    private static LazyHostPlugin getPlugin(String host) {
        String domain;
        LazyHostPlugin existingHostPlugin = new PluginFinder()._assignHost(host);
        if (existingHostPlugin == null && !host.equalsIgnoreCase(domain = PublicSuffixList.getInstance().getDomain(host))) {
            existingHostPlugin = new PluginFinder()._assignHost(domain);
        }
        return existingHostPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ImageIcon add(final String host, FavIconRequestor requestor) {
        ImageIcon icon;
        AtomicReference<Object> loggerReference;
        LogSource logger;
        block10: {
            ImageIcon imageIcon;
            logger = FavIcons.getLogger(host, requestor);
            loggerReference = new AtomicReference<Object>();
            try {
                icon = null;
                Object object = LOCK;
                // MONITORENTER : object
                if (!FAILED_ICONS.containsKey(host)) break block10;
                icon = FAILED_ICONS.get(host);
                if (icon == null) {
                    icon = FavIcons.getDefaultIcon(logger, host, true);
                    FAILED_ICONS.put(host, icon);
                }
                imageIcon = icon;
                // MONITOREXIT : object
                if (loggerReference.getAndSet(null) != logger) return imageIcon;
            }
            catch (Throwable throwable) {
                if (loggerReference.getAndSet(null) != logger) throw throwable;
                logger.close();
                throw throwable;
            }
            logger.close();
            return imageIcon;
        }
        icon = FavIcons.getDefaultIcon(logger, host, false);
        List<FavIconRequestor> ret = QUEUE.get(host);
        boolean enqueueFavIcon = false;
        if (ret == null) {
            ret = new ArrayList<FavIconRequestor>();
            QUEUE.put(host, ret);
            enqueueFavIcon = true;
        }
        if (requestor != null) {
            ret.add(requestor);
        }
        if (enqueueFavIcon) {
            loggerReference.getAndSet(null);
            THREAD_POOL.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ArrayList<String> tryHosts = new ArrayList<String>();
                        BufferedImage favicon = null;
                        String[] siteSupportedNames = null;
                        LazyHostPlugin existingHostPlugin = FavIcons.getPlugin(host);
                        if (existingHostPlugin != null) {
                            if (existingHostPlugin.hasFeature(LazyPlugin.FEATURE.INTERNAL)) {
                                Object object = LOCK;
                                synchronized (object) {
                                    QUEUE.remove(host);
                                    if (!REFRESHED_ICONS.contains(host) && FAILED_ICONS.get(host) == null) {
                                        FAILED_ICONS.put(host, FavIcons.getDefaultIcon(logger, host, true));
                                    }
                                }
                                return;
                            }
                            if (existingHostPlugin.hasFeature(LazyPlugin.FEATURE.FAVICON)) {
                                try {
                                    Object result;
                                    PluginForHost pluginInstance = existingHostPlugin.newInstance(null, false);
                                    pluginInstance.setLogger((LogInterface)logger);
                                    siteSupportedNames = pluginInstance.siteSupportedNames();
                                    if (siteSupportedNames == null) {
                                        siteSupportedNames = new String[]{};
                                    }
                                    if ((result = pluginInstance.getFavIcon(host)) instanceof Image) {
                                        favicon = IconIO.toBufferedImage((Image)((Image)result));
                                        logger.clear();
                                    } else if (result instanceof String) {
                                        tryHosts.add((String)result);
                                    } else if (result instanceof Collection) {
                                        for (Object elem : (Collection)result) {
                                            if (!(elem instanceof String)) continue;
                                            tryHosts.add((String)elem);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    logger.log((Throwable)e);
                                }
                            }
                        }
                        if (favicon == null) {
                            if (existingHostPlugin != null) {
                                tryHosts.add(existingHostPlugin.getHost());
                            }
                            if (!tryHosts.contains(host)) {
                                tryHosts.add(host);
                            }
                            if (!host.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                                String domain = PublicSuffixList.getInstance() != null ? PublicSuffixList.getInstance().getDomain(host) : null;
                                String tryHost = host;
                                int index = 0;
                                while ((index = tryHost.indexOf(".")) >= 0 && tryHost.length() >= index + 1) {
                                    tryHost = tryHost.substring(index + 1);
                                    if (domain != null && !tryHost.contains(domain) || tryHost.indexOf(46) == -1) break;
                                    if (tryHosts.contains(tryHost)) continue;
                                    tryHosts.add(tryHost);
                                }
                            }
                            favicon = FavIcons.downloadFavIcon(logger, tryHosts, siteSupportedNames);
                        }
                        Object object = LOCK;
                        synchronized (object) {
                            List requestors = (List)QUEUE.remove(host);
                            if (favicon == null) {
                                if (!REFRESHED_ICONS.contains(host) && FAILED_ICONS.get(host) == null) {
                                    FAILED_ICONS.put(host, FavIcons.getDefaultIcon(logger, host, true));
                                }
                            } else {
                                FileOutputStream fos = null;
                                File outputFile = null;
                                try {
                                    AbstractIcon image;
                                    outputFile = Application.getResource((String)(NewTheme.I().getPath() + "/images/fav/" + host + ".png"));
                                    FileCreationManager.getInstance().mkdir(outputFile.getParentFile());
                                    fos = new FileOutputStream(outputFile);
                                    ImageProvider.writeImage((RenderedImage)favicon, (String)"png", (OutputStream)fos);
                                    fos.close();
                                    fos = null;
                                    outputFile = null;
                                    if (requestors != null && requestors.size() > 0 && (image = new AbstractIcon("fav/" + host, -1)) != null) {
                                        for (FavIconRequestor requestor : requestors) {
                                            requestor.setFavIcon(image);
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    logger.log(e);
                                }
                                finally {
                                    try {
                                        if (fos != null) {
                                            fos.close();
                                        }
                                    }
                                    catch (Throwable image) {}
                                    if (outputFile != null) {
                                        outputFile.delete();
                                    }
                                }
                            }
                        }
                    }
                    finally {
                        logger.close();
                    }
                }
            });
        }
        ImageIcon imageIcon = icon;
        // MONITOREXIT : object
        if (loggerReference.getAndSet(null) != logger) return imageIcon;
        logger.close();
        return imageIcon;
    }

    private static Image createDefaultFavIcon(LogSource logger, String host) {
        Image base = FavIcons.createDefaultFavIcon(logger, host, 16, 16);
        if (!MultiResolutionImageHelper.isSupported()) {
            return base;
        }
        double highest = MultiResolutionImageHelper.getHighestMonitorScaling();
        if (highest <= 1.0) {
            return base;
        }
        Image bigger = FavIcons.createDefaultFavIcon(logger, host, (int)Math.round(16.0 * highest), (int)Math.round(16.0 * highest));
        return MultiResolutionImageHelper.create(Arrays.asList(base, bigger));
    }

    private static Image createDefaultFavIcon(LogSource logger, String host, int w, int h) {
        int size = w - 7;
        Color fg = Color.BLACK;
        Color bg = Color.WHITE;
        logger.info("createDefaultFavIcon: " + host);
        try {
            Color c;
            if (!Application.isHeadless() && (c = LAFOptions.getInstance().getColorForPanelHeaderBackground()) != null) {
                bg = c;
            }
        }
        catch (Throwable e) {
            logger.log(e);
        }
        BufferedImage image = IconIO.createEmptyImage((int)w, (int)h);
        Graphics2D g = image.createGraphics();
        try {
            String fontName = ImageProvider.getDrawFontName();
            g.setFont(new Font(fontName, 1, size));
            FontMetrics fontmetrics = g.getFontMetrics();
            String tld = Files.getExtension((String)host);
            if (tld != null) {
                tld = tld.toLowerCase(Locale.ENGLISH);
            }
            String dummy = host.toUpperCase();
            try {
                dummy = dummy.substring(0, dummy.lastIndexOf("."));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            dummy = dummy.replaceAll("[\\d\\WEIOAJU]", "");
            try {
                dummy = "" + dummy.charAt(0) + dummy.charAt(dummy.length() / 2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (dummy.length() <= 0 || dummy.length() > 2) {
                dummy = host.substring(0, Math.min(host.length(), 2));
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font(fontName, 1, size));
            RoundRectangle2D.Float roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, w - 1, h - 1, 5.0f, 5.0f);
            g.setColor(bg);
            g.fill(roundedRectangle);
            g.setColor(bg.darker());
            g.draw(roundedRectangle);
            g.setColor(fg);
            Rectangle2D bounds = fontmetrics.getStringBounds(dummy, g);
            g.drawString(dummy, (int)((double)w - bounds.getWidth()) / 2, (int)(-bounds.getY() + ((double)h - bounds.getHeight()) / 2.0) - (tld == null ? 0 : 1));
            if (tld != null) {
                g.setFont(new Font(fontName, 0, w - 10));
                bounds = fontmetrics.getStringBounds("." + tld, g);
                g.drawString("." + tld, (int)((double)w - bounds.getWidth()) - 2, h - 2);
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Throwable e) {
            logger.log(e);
            if (ImageProvider.isBuggyFontEnvironment((Throwable)e)) {
                BufferedImage bufferedImage = IconIO.toBufferedImage((Icon)new AbstractIcon("error", 16));
                return bufferedImage;
            }
            throw new RuntimeException(e);
        }
        finally {
            g.dispose();
        }
    }

    private static int countColors(BufferedImage image) {
        HashSet<Integer> color = new HashSet<Integer>();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                color.add(image.getRGB(x, y));
            }
        }
        return color.size();
    }

    private static BufferedImage returnBestImage(List<BufferedImage> images) {
        if (images != null && images.size() > 0) {
            BufferedImage ret = null;
            int size = -1;
            int colors = -1;
            for (BufferedImage img : images) {
                BufferedImage croppedImage = FavIcons.getCroppedImage(img, false);
                if (croppedImage == null || ret != null && croppedImage.getHeight() * croppedImage.getWidth() <= size && FavIcons.countColors(croppedImage) <= colors) continue;
                ret = croppedImage;
                size = ret.getHeight() * ret.getWidth();
                colors = FavIcons.countColors(ret);
            }
            if (ret != null && ret.getHeight() > 1 && ret.getWidth() > 1) {
                return ret;
            }
        }
        return null;
    }

    public static BufferedImage getCroppedImage(BufferedImage source, boolean keepAspectRation) {
        if (source != null) {
            try {
                WritableRaster alphaRaster = source.getAlphaRaster();
                if (alphaRaster != null) {
                    boolean sameAspectRatio;
                    int j;
                    int i;
                    int[] alphaPixel = new int[alphaRaster.getNumBands()];
                    int width = alphaRaster.getWidth();
                    int height = alphaRaster.getHeight();
                    block2: for (i = 0; i < width; ++i) {
                        for (j = 0; j < height; ++j) {
                            if (alphaRaster.getPixel(i, j, alphaPixel)[0] != 0) break block2;
                        }
                    }
                    int x0 = i;
                    block4: for (j = 0; j < height; ++j) {
                        for (i = 0; i < width; ++i) {
                            if (alphaRaster.getPixel(i, j, alphaPixel)[0] != 0) break block4;
                        }
                    }
                    int y0 = j;
                    block6: for (i = width - 1; i >= 0; --i) {
                        for (j = 0; j < height; ++j) {
                            if (alphaRaster.getPixel(i, j, alphaPixel)[0] != 0) break block6;
                        }
                    }
                    int x1 = i + 1;
                    block8: for (j = height - 1; j >= 0; --j) {
                        for (i = 0; i < width; ++i) {
                            if (alphaRaster.getPixel(i, j, alphaPixel)[0] != 0) break block8;
                        }
                    }
                    int y1 = j + 1;
                    if (x0 == width && y0 == height) {
                        return source;
                    }
                    if (x0 == 0 && y0 == 0 && x1 - x0 == width && y1 - y0 == height) {
                        return source;
                    }
                    boolean bl = sameAspectRatio = Math.abs((double)width / (double)height - (double)(x1 - x0) / (double)(y1 - y0)) < 1.0E-5;
                    if (!keepAspectRation || sameAspectRatio) {
                        return source.getSubimage(x0, y0, x1 - x0, y1 - y0);
                    }
                    return source;
                }
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
        return source;
    }

    private static boolean isSameDomain(String[] siteSupportedNames, String domain, URL url) {
        if (siteSupportedNames != null && siteSupportedNames.length > 0) {
            for (String siteSupportedName : siteSupportedNames) {
                if (!StringUtils.equalsIgnoreCase((String)siteSupportedName, (String)domain) && !StringUtils.equalsIgnoreCase((String)siteSupportedName, (String)url.getHost())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSameDomain(Browser br, String host, String[] siteSupportedNames) throws IOException {
        URL url;
        if (host.matches("(?i)^https?://.+")) {
            host = new URL(host).getHost();
        }
        URL uRL = url = br != null ? br._getURL() : null;
        if (url == null) {
            return false;
        }
        if (!StringUtils.containsIgnoreCase((String)url.getHost(), (String)host)) {
            LazyHostPlugin existingHostPlugin;
            String domain = br.getHost();
            if (!StringUtils.containsIgnoreCase((String)domain, (String)host)) {
                String compareHost;
                String domainTld = PublicSuffixList.getInstance().getTopLevelDomain(domain);
                String hostTld = PublicSuffixList.getInstance().getTopLevelDomain(host);
                String compareDomain = domain.replaceAll("\\." + domainTld + "$", "");
                if (StringUtils.equalsIgnoreCase((String)compareDomain, (String)(compareHost = host.replaceAll("\\." + hostTld + "$", "")))) {
                    return true;
                }
            }
            if (siteSupportedNames == null && (existingHostPlugin = FavIcons.getPlugin(host)) != null) {
                LogInterface logger = br.getLogger();
                try {
                    PluginForHost pluginInstance = existingHostPlugin.newInstance(null, false);
                    pluginInstance.setBrowser(br.cloneBrowser());
                    pluginInstance.setLogger(br.getLogger());
                    siteSupportedNames = pluginInstance.siteSupportedNames();
                }
                catch (Exception e) {
                    logger.log((Throwable)e);
                }
            }
            if (FavIcons.isSameDomain(siteSupportedNames, domain, url)) {
                return true;
            }
            CrawlerPluginController.getInstance();
            List<LazyCrawlerPlugin> crawlerPlugins = CrawlerPluginController.list(true);
            for (LazyCrawlerPlugin crawlerPlugin : crawlerPlugins) {
                String[] siteSupported = crawlerPlugin.getSitesSupported();
                if (!FavIcons.isSameDomain(siteSupported, domain, url)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isFavIconURL(String host) {
        try {
            if (!host.matches("(?i)^https?://.+")) {
                return false;
            }
            String path = new URL(host).getFile();
            return path.matches("(?i).+\\.(ico|png|svg|jpg)$");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static BufferedImage download_FavIconTag(String host, String[] siteSupportedNames, LogInterface logger) throws IOException {
        BufferedImage ret;
        Browser favBr = new Browser();
        if (CONFIG.isDebugFlag()) {
            favBr.setDebug(true);
            favBr.setVerbose(true);
        }
        favBr.setLogger(logger);
        favBr.setConnectTimeout(10000);
        favBr.setReadTimeout(10000);
        ArrayList<String> websites = new ArrayList<String>();
        if (!FavIcons.isFavIconURL(host)) {
            if (host.matches("(?i)^https?://.+")) {
                websites.add(host);
            } else {
                websites.addAll(Arrays.asList("https://" + host, "http://" + host));
            }
        }
        block5: for (String website : websites) {
            boolean retryFlag = true;
            boolean retryCount = false;
            while (retryFlag) {
                retryFlag = false;
                try {
                    BufferedImage ret2;
                    favBr.getPage(website);
                    if (favBr.getRedirectLocation() != null) {
                        favBr.followRedirect(true);
                        if (!FavIcons.isSameDomain(favBr, host, siteSupportedNames)) {
                            throw new IOException("redirect to different domain?" + favBr._getURL().getHost() + "!=" + host);
                        }
                    }
                    if ((ret2 = FavIcons.download_FavIconTag(favBr, host)) == null) continue block5;
                    return ret2;
                }
                catch (Browser.BrowserException e) {
                    logger.log((Throwable)e);
                    Request reg = e.getRequest();
                    if (reg == null || reg.getHttpConnection() == null || reg.getHttpConnection().getResponseCode() != 429 || retryCount) continue;
                    try {
                        int timeout = 2000;
                        String retryAfter = reg.getHttpConnection().getHeaderField("Retry-After");
                        if (retryAfter != null && retryAfter.matches("^\\s*\\d+\\s*$")) {
                            timeout = Math.max(timeout, Math.min(Integer.parseInt(retryAfter) * 1000, 20000));
                        }
                        Thread.sleep(timeout);
                        retryFlag = true;
                        retryCount = true;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException e) {
                    logger.log((Throwable)e);
                }
            }
        }
        if (websites.size() == 0 && (ret = FavIcons.download_FavIconTag(favBr, host)) != null) {
            return ret;
        }
        return null;
    }

    public static BufferedImage download_FavIconTag(Browser favBr, String host) throws IOException {
        Set<String> favIconURLs = FavIcons.getFavIconURLs(favBr, host);
        LogInterface logger = favBr.getLogger();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        for (String favIconURL : favIconURLs) {
            boolean retryFlag = true;
            int retryCount = 0;
            while (retryFlag) {
                retryFlag = false;
                try {
                    Browser brc = favBr.cloneBrowser();
                    BufferedImage ret = FavIcons.download_FavIconTag(brc, favIconURL, host);
                    if (ret == null) continue;
                    images.add(ret);
                }
                catch (Browser.BrowserException e) {
                    logger.log((Throwable)e);
                    Request reg = e.getRequest();
                    if (reg == null || reg.getHttpConnection() == null || reg.getHttpConnection().getResponseCode() != 429 || retryCount >= true) continue;
                    try {
                        int timeout = 2000;
                        String retryAfter = reg.getHttpConnection().getHeaderField("Retry-After");
                        if (retryAfter != null && retryAfter.matches("^\\s*\\d+\\s*$")) {
                            timeout = Math.max(timeout, Math.min(Integer.parseInt(retryAfter) * 1000, 20000));
                        }
                        Thread.sleep(timeout);
                        retryFlag = true;
                        ++retryCount;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (IOException e) {
                    logger.log((Throwable)e);
                }
            }
        }
        BufferedImage best = FavIcons.returnBestImage(images);
        return best;
    }

    public static Set<String> getFavIconURLs(Browser favBr, String host) throws IOException {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        if (FavIcons.isFavIconURL(host)) {
            ret.add(host);
        } else {
            String requestHtml = favBr.toString().replaceAll("(?s)<!--.*?-->", "");
            for (String rel : new String[]{"icon", "shortcut icon", "apple-touch-icon"}) {
                String url;
                String[] urls = new Regex(requestHtml, "(?i)rel\\s*=\\s*('|\")" + rel + "('|\")[^>]*href\\s*=\\s*('|\")([^>'\"]*\\.(ico|png|svg|jpg|gif)[^>'\"]*)('|\")").getColumn(3);
                if (urls != null && urls.length > 0) {
                    ret.addAll(Arrays.asList(urls));
                }
                if ((urls = new Regex(requestHtml, "(?i)href\\s*=\\s*('|\")([^>'\"]*\\.(ico|png|svg|jpg|gif)[^>'\"]*)('|\")[^>]*rel\\s*=\\s*('|\")" + rel + "('|\")").getColumn(1)) != null && urls.length > 0) {
                    ret.addAll(Arrays.asList(urls));
                }
                if (ret.size() != 0 || StringUtils.isEmpty((String)(url = new Regex(requestHtml, "(?i)rel\\s*=\\s*('|\")" + rel + "('|\")[^>]*href\\s*=\\s*[^>]*//([^>'\"]*\\.(ico|png|svg|jpg|gif)[^>'\"]*)('|\")").getMatch(2)))) continue;
                if (!url.equalsIgnoreCase(host)) {
                    url = "http://" + url;
                }
                ret.add(url);
            }
            ret.add("/favicon.ico");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage download_FavIconTag(Browser favBr, String url, String host) throws IOException {
        con = null;
        bytes = null;
        logger = favBr.getLogger();
        if (StringUtils.isEmpty((String)url) != false) return null;
        favBr.setFollowRedirects(true);
        favBr.getHeaders().put("Accept-Encoding", null);
        con = favBr.openGetConnection(url);
        bytes = IO.readStream((int)-1, (InputStream)con.getInputStream());
        if (!con.isOK() || StringUtils.containsIgnoreCase((String)con.getContentType(), (String)"text") || bytes == null || bytes.length == 0) {
            var6_6 = null;
            if (con == null) return var6_6;
        }
        ** GOTO lbl23
        {
            block26: {
                catch (Throwable var10_18) {
                    throw var10_18;
                }
                try {
                    con.disconnect();
                    return var6_6;
                }
                catch (Throwable var7_10) {
                    // empty catch block
                }
                return var6_6;
lbl23:
                // 1 sources

                try {
                    ret = null;
                    if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
                        img = FavIcons.downloadImage(con, logger, new ByteArrayInputStream(bytes));
                        if (img != null) {
                            ret = new ArrayList<BufferedImage>();
                            ret.add(img);
                        }
                    } else if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70 && (gifDecoder = new GifDecoder()).read((InputStream)new ByteArrayInputStream(bytes)) == 0 && (img = gifDecoder.getImage()) != null) {
                        ret = new ArrayList<E>();
                        ret.add(img);
                    }
                    if (ret == null) {
                        try {
                            ret = ICODecoder.read((InputStream)new ByteArrayInputStream(bytes));
                        }
                        catch (IOException e) {
                            max = new Regex(e.getMessage(), "Failed to read image #\\s*(\\d+)").getMatch(0);
                            if (max == null) throw e;
                            if (Integer.parseInt(max) <= 1) throw e;
                            copy = (byte[])bytes.clone();
                            ret = ICODecoder.read((InputStream)new ByteArrayInputStream(copy));
                        }
                    }
                    if ((img = FavIcons.returnBestImage(ret)) == null) break block26;
                    var8_14 = img;
                    if (con == null) return var8_14;
                }
                catch (Throwable e) {}
                img = FavIcons.downloadImage(con, logger, new ByteArrayInputStream(bytes));
                if (img == null || img.getHeight() <= 1 || img.getWidth() <= 1) ** GOTO lbl-1000
                var8_14 = img;
                if (con == null) return var8_14;
                try {
                    con.disconnect();
                    return var8_14;
                }
                catch (Throwable var9_17) {
                    // empty catch block
                }
                return var8_14;
lbl-1000:
                // 1 sources

                {
                    logger.log(e);
                    return null;
                }
                try {
                    con.disconnect();
                    return var8_14;
                }
                catch (Throwable var9_16) {
                    // empty catch block
                }
                return var8_14;
            }
            throw new Throwable("Try again with other ImageLoader");
        }
    }

    public static BufferedImage downloadFavIcon(LogSource logger, List<String> hosts, String[] siteSupportedNames) {
        for (String host : hosts) {
            BufferedImage ret = FavIcons.downloadFavIcon(logger, host, siteSupportedNames);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Deprecated
    public static BufferedImage downloadFavIcon(String host) {
        LogSource logger = LogController.getFastPluginLogger("FavIcons");
        try {
            if (CONFIG.isDebugFlag()) {
                logger.setInstantFlush(true);
            }
            BufferedImage bufferedImage = FavIcons.downloadFavIcon(logger, host, null);
            return bufferedImage;
        }
        finally {
            logger.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage downloadFavIcon(LogSource logger, String host, String[] siteSupportedNames) {
        logger.info("Download FavIcon for " + host);
        BufferedImage ret = null;
        try {
            ret = FavIcons.download_FavIconTag(host, siteSupportedNames, (LogInterface)logger);
        }
        catch (Throwable ignore) {
            logger.log(ignore);
        }
        finally {
            if (ret != null) {
                logger.clear();
            } else {
                logger.severe("Could not download FavIcon for " + host);
            }
        }
        return ret;
    }

    private static BufferedImage downloadImage(URLConnectionAdapter con, LogInterface logger, InputStream is) {
        try {
            BufferedImage ret = null;
            if (StringUtils.endsWithCaseInsensitive((String)con.getURL().getPath(), (String)".svg")) {
                try {
                    Image img = IconIO.getSvgFactory().getImageFromSVG(is, null, 64, 64, null);
                    if (img == null) {
                        return null;
                    }
                    ret = IconIO.toBufferedImage((Image)img);
                }
                catch (IOException e) {
                    logger.log((Throwable)e);
                    return null;
                }
            }
            if (ret == null) {
                ret = ImageIO.read(is);
            }
            if (ret == null) {
                GifDecoder d = new GifDecoder();
                is.reset();
                if (d.read(is) == 0) {
                    ret = d.getImage();
                }
            }
            return ret;
        }
        catch (Throwable e) {
            logger.log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        THREADCOUNTER = new AtomicInteger(0);
        LOCK = new Object();
        QUEUE = new LinkedHashMap();
        FAILED_ICONS = new HashMap();
        REFRESHED_ICONS = new HashSet();
        DEFAULT_ICONS = new HashMap();
        CONFIG = (FavIconsConfig)JsonConfig.create(FavIconsConfig.class);
        int maxThreads = Math.max(CONFIG.getMaxThreads(), 1);
        int keepAlive = Math.max(CONFIG.getThreadKeepAlive(), 100);
        THREAD_POOL = new ThreadPoolExecutor(0, maxThreads, (long)keepAlive, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("FavIconLoader:" + THREADCOUNTER.incrementAndGet());
                return t;
            }
        }, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy()){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                super.beforeExecute(t, r);
                int working = THREAD_POOL.getActiveCount();
                int active = THREAD_POOL.getPoolSize();
                int max = THREAD_POOL.getMaximumPoolSize();
                if (active < max && working == active) {
                    THREAD_POOL.setCorePoolSize(Math.min(max, active + 1));
                }
            }
        };
        THREAD_POOL.allowCoreThreadTimeOut(true);
        ArrayList<String> FAILED_ARRAY_LIST = ((FavIconsConfig)JsonConfig.create(FavIconsConfig.class)).getFailedHosts();
        if (FAILED_ARRAY_LIST == null || System.currentTimeMillis() - CONFIG.getLastRefresh() > 604800000L) {
            CONFIG.setLastRefresh(System.currentTimeMillis());
            FAILED_ARRAY_LIST = new ArrayList();
            CONFIG.setFailedHosts(FAILED_ARRAY_LIST);
        }
        Object object = LOCK;
        synchronized (object) {
            for (String host : FAILED_ARRAY_LIST) {
                FAILED_ICONS.put(host, null);
            }
        }
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public String toString() {
                return "ShutdownEvent: Save Favicons";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onShutdown(ShutdownRequest shutdownRequest) {
                ArrayList<String> failedHosts;
                Object object = LOCK;
                synchronized (object) {
                    failedHosts = new ArrayList<String>(FAILED_ICONS.keySet());
                }
                CONFIG.setFailedHosts(failedHosts);
            }
        });
    }
}

