/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.util.Iterator;
import java.util.List;
import jd.controlling.linkcollector.LinkCollectingInformation;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkOriginDetails;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.ArchiveInfo;
import jd.controlling.linkcrawler.BrokenCrawlerHandler;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.CrawledLinkProperty;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.CrawlingCrawledLink;
import jd.controlling.linkcrawler.LinkCrawlerRule;
import jd.controlling.linkcrawler.PackageInfo;
import jd.controlling.linkcrawler.UnknownCrawledLinkHandler;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.http.Browser;
import jd.plugins.Account;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.LinkInfo;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import org.appwork.utils.StringUtils;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.filter.FilterRule;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;

public class CrawledLink
implements AbstractPackageChildrenNode<CrawledPackage>,
CheckableLink,
AbstractNodeNotifier,
Iterable<CrawledLink> {
    private volatile byte properties = 1;
    private volatile CrawledPackage parent = null;
    private LinkOriginDetails origin;
    private volatile long created = -1L;
    protected volatile Object link = null;
    private volatile String name = null;
    private volatile ArchiveInfo archiveInfo;
    private volatile UniqueAlltimeID previousParent = null;
    private volatile String[] sourceUrls;
    private volatile LinkInfo linkInfo = null;

    protected final synchronized boolean setProperty(boolean b, PROPERTY property) {
        byte properties = this.properties;
        this.properties = b ? (byte)(this.properties | 1 << property.ordinal()) : (byte)(this.properties & ~(1 << property.ordinal()));
        return this.properties != properties;
    }

    protected final boolean getProperty(PROPERTY property) {
        return (this.properties & 1 << property.ordinal()) != 0;
    }

    public boolean isCrawlDeep() {
        return this.getProperty(PROPERTY.CRAWL_DEEP);
    }

    public void setCrawlDeep(boolean crawlDeep) {
        this.setProperty(crawlDeep, PROPERTY.CRAWL_DEEP);
    }

    public boolean isAutoConfirmEnabled() {
        return this.getProperty(PROPERTY.AUTO_CONFIRM);
    }

    public void setOrigin(LinkOriginDetails source) {
        this.origin = source;
    }

    public LinkOriginDetails getOrigin() {
        return this.origin;
    }

    public void setAutoConfirmEnabled(boolean autoAddEnabled) {
        this.setProperty(autoAddEnabled, PROPERTY.AUTO_CONFIRM);
    }

    public boolean isAutoStartEnabled() {
        return this.getProperty(PROPERTY.AUTO_START);
    }

    public void setAutoStartEnabled(boolean autoStartEnabled) {
        this.setProperty(autoStartEnabled, PROPERTY.AUTO_START);
    }

    public boolean isForcedAutoStartEnabled() {
        return this.getProperty(PROPERTY.FORCED_AUTO_START);
    }

    public void setForcedAutoStartEnabled(boolean forcedAutoStartEnabled) {
        this.setProperty(forcedAutoStartEnabled, PROPERTY.FORCED_AUTO_START);
    }

    public UnknownCrawledLinkHandler getUnknownHandler() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getUnknownHandler();
        }
        return null;
    }

    public void setUnknownHandler(UnknownCrawledLinkHandler unknownHandler) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, unknownHandler != null);
        if (crawling != null) {
            crawling.setUnknownHandler(unknownHandler);
        }
    }

    public PackageInfo getDesiredPackageInfo() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getDesiredPackageInfo();
        }
        return null;
    }

    public void setDesiredPackageInfo(PackageInfo desiredPackageInfo) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, desiredPackageInfo != null && !desiredPackageInfo.isEmpty());
        if (crawling != null) {
            if (desiredPackageInfo == null || desiredPackageInfo.isEmpty()) {
                crawling.setDesiredPackageInfo(null);
            } else {
                crawling.setDesiredPackageInfo(desiredPackageInfo);
            }
        }
    }

    public String getLinkID() {
        String linkID;
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null && (linkID = dlLink.getLinkID()) != null) {
            return linkID;
        }
        return this.getURL();
    }

    public LinkCollectingJob getSourceJob() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getSourceJob();
        }
        return null;
    }

    public long getJobID() {
        DownloadLink link = this.getDownloadLink();
        if (link != null) {
            return link.getJobID();
        }
        return -1L;
    }

    public void setSourceJob(LinkCollectingJob sourceJob) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, sourceJob != null);
        if (crawling != null) {
            crawling.setSourceJob(sourceJob);
        }
    }

    public long getSize() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getView().getBytesTotal();
        }
        return -1L;
    }

    public PluginForHost gethPlugin() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getDefaultPlugin();
        }
        return null;
    }

    @Override
    public DownloadLink getDownloadLink() {
        Object llink = this.link;
        if (llink instanceof DownloadLink) {
            return (DownloadLink)llink;
        }
        return null;
    }

    public String getUrlLink() {
        Object llink = this.link;
        if (llink instanceof CharSequence) {
            return llink.toString();
        }
        return null;
    }

    public CryptedLink getCryptedLink() {
        Object llink = this.link;
        if (llink instanceof CryptedLink) {
            return (CryptedLink)llink;
        }
        return null;
    }

    public LinkCrawlerRule getMatchingRule() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getMatchingRule();
        }
        return null;
    }

    public void setMatchingRule(LinkCrawlerRule matchingRule) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, matchingRule != null);
        if (crawling != null) {
            crawling.setMatchingRule(matchingRule);
        }
    }

    protected CrawledLink() {
    }

    public CrawledLink(DownloadLink dlLink) {
        this.setDownloadLink(dlLink);
    }

    protected void passwordForward(DownloadLink dlLink) {
        List<String> lst;
        if (dlLink != null && (lst = dlLink.getSourcePluginPasswordList()) != null && lst.size() > 0) {
            this.getArchiveInfo().getExtractionPasswords().addAll(lst);
        }
    }

    public void setDownloadLink(DownloadLink dlLink) {
        this.link = dlLink;
        this.passwordForward(dlLink);
    }

    public CrawledLink(CryptedLink cLink) {
        this.link = cLink;
    }

    public CrawledLink(CharSequence url) {
        this.link = url;
    }

    @Override
    public String getName() {
        String lname = this.name;
        if (lname != null) {
            if (lname.contains("<jd:")) {
                CrawledPackage lparent = this.getParentNode();
                String packageName = null;
                if (lparent != null) {
                    packageName = lparent.getName();
                }
                return this.fixFilename(PackagizerController.replaceDynamicTags(lname, packageName, this));
            }
            return lname;
        }
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getView().getDisplayName();
        }
        String url = this.getURL();
        String name = Plugin.extractFileNameFromURL(url);
        if (name != null) {
            return name;
        }
        return "RAWURL:" + url;
    }

    public int getChunks() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getChunks();
        }
        return -1;
    }

    public void setChunks(int chunks) {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            dlLink.setChunks(chunks);
        }
    }

    public void setName(String name) {
        if (StringUtils.equals((String)name, (String)this.name)) {
            return;
        }
        DownloadLink link = this.getDownloadLink();
        if (link != null) {
            if (StringUtils.equals((String)name, (String)link.getName())) {
                name = null;
            }
            if (StringUtils.equals((String)name, (String)this.name)) {
                return;
            }
        }
        if (name != null) {
            if (!name.contains("<jd:")) {
                name = this.fixFilename(name);
            }
            if (StringUtils.equals((String)name, (String)this.name)) {
                return;
            }
        }
        this.name = StringUtils.isEmpty((String)name) ? null : name;
        this.setLinkInfo(null);
        if (this.hasNotificationListener()) {
            this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, CrawledLinkProperty.Property.NAME, this.getName()));
        }
    }

    protected String fixFilename(String filename) {
        return LinknameCleaner.cleanFilename(filename);
    }

    public String _getName() {
        return this.name;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    public String getHost() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getHost();
        }
        return null;
    }

    public String getURL() {
        Object llink = this.link;
        if (llink != null) {
            if (llink instanceof DownloadLink) {
                return ((DownloadLink)llink).getPluginPatternMatcher();
            }
            if (llink instanceof CryptedLink) {
                return ((CryptedLink)llink).getCryptedUrl();
            }
            if (llink instanceof CharSequence) {
                return llink.toString();
            }
            return null;
        }
        return null;
    }

    protected void linkToString(StringBuilder sb, Object link) {
        if (link != null) {
            if (link instanceof DownloadLink) {
                DownloadLink downloadLink = (DownloadLink)link;
                PluginForHost plugin = downloadLink.getDefaultPlugin();
                if (plugin != null) {
                    sb.append("DLink(" + plugin.getLazyP().getDisplayName() + "):" + downloadLink.getPluginPatternMatcher());
                } else {
                    sb.append("DLink:" + downloadLink.getPluginPatternMatcher());
                }
            } else if (link instanceof CryptedLink) {
                CryptedLink cryptedLink = (CryptedLink)link;
                LazyCrawlerPlugin plugin = cryptedLink.getLazyC();
                if (plugin != null) {
                    sb.append("CLink(" + plugin.getDisplayName() + "):" + cryptedLink.getCryptedUrl());
                } else {
                    sb.append("CLink:" + cryptedLink.getCryptedUrl());
                }
            } else if (link instanceof CharSequence) {
                sb.append("URL:" + link.toString());
            }
        }
    }

    public String toString() {
        CrawledLink parentL = this.getSourceLink();
        StringBuilder sb = new StringBuilder();
        if (this.isNameSet()) {
            sb.append("NAME:");
            sb.append(this.getName());
        }
        this.linkToString(sb, this.link);
        if (parentL != null) {
            sb.append("<--");
            sb.append(parentL.toString());
        }
        return sb.toString();
    }

    @Override
    public CrawledPackage getParentNode() {
        return this.parent;
    }

    @Override
    public synchronized void setParentNode(CrawledPackage parent) {
        if (this.parent == parent) {
            this.previousParent = null;
            return;
        }
        if (this.parent != null) {
            this.previousParent = this.parent.getUniqueID();
        }
        this.parent = parent;
    }

    @Override
    public boolean isEnabled() {
        return this.getProperty(PROPERTY.ENABLED);
    }

    public void setArchiveID(String id) {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            dlLink.setArchiveID(id);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.setProperty(b, PROPERTY.ENABLED) && this.hasNotificationListener()) {
            this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, CrawledLinkProperty.Property.ENABLED, b));
        }
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    @Override
    public long getFinishedDate() {
        return 0L;
    }

    public CrawledLink getSourceLink() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            CrawledLink ret = crawling.getSourceLink();
            if (ret != null) {
                return ret;
            }
            return null;
        }
        return null;
    }

    public CrawledLink getOriginLink() {
        CrawledLink lsourceLink = this.getSourceLink();
        if (lsourceLink == null) {
            return this;
        }
        return lsourceLink.getOriginLink();
    }

    public void setSourceLink(CrawledLink parent) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, parent != null);
        if (crawling != null) {
            crawling.setSourceLink(parent);
        }
    }

    public void setMatchingFilter(FilterRule matchedFilter) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, matchedFilter != null);
        if (crawling != null) {
            crawling.setMatchingFilter(matchedFilter);
        }
    }

    public FilterRule getMatchingFilter() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getMatchingFilter();
        }
        return null;
    }

    public AvailableLinkState getLinkState() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            switch (dlLink.getAvailableStatus()) {
                case FALSE: {
                    return AvailableLinkState.OFFLINE;
                }
                case TRUE: {
                    return AvailableLinkState.ONLINE;
                }
                case UNCHECKABLE: {
                    return AvailableLinkState.TEMP_UNKNOWN;
                }
                case UNCHECKED: {
                    return AvailableLinkState.UNKNOWN;
                }
            }
            return AvailableLinkState.UNKNOWN;
        }
        return AvailableLinkState.UNKNOWN;
    }

    public Priority getPriorityEnum() {
        return this.getPriority();
    }

    @Deprecated
    public Priority getPriority() {
        try {
            DownloadLink dlLink = this.getDownloadLink();
            if (dlLink == null) {
                return Priority.DEFAULT;
            }
            return dlLink.getPriorityEnum();
        }
        catch (Throwable e) {
            return Priority.DEFAULT;
        }
    }

    public void setPriority(Priority priority) {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            dlLink.setPriorityEnum(priority);
        }
    }

    public boolean hasAutoCaptcha() {
        PluginForHost plugin = this.gethPlugin();
        return plugin != null && plugin.hasAutoCaptcha();
    }

    public boolean hasCaptcha(Account acc) {
        PluginForHost plugin = this.gethPlugin();
        DownloadLink dlLink = this.getDownloadLink();
        return plugin != null && dlLink != null && Boolean.TRUE.equals(plugin.expectCaptcha(dlLink, acc));
    }

    public boolean isDirectHTTP() {
        PluginForHost plugin = this.gethPlugin();
        return plugin != null && plugin.getClass().getName().endsWith("r.DirectHTTP");
    }

    public boolean isFTP() {
        PluginForHost plugin = this.gethPlugin();
        return plugin != null && plugin.getClass().getName().endsWith("r.Ftp");
    }

    @Override
    public DomainInfo getDomainInfo() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getDomainInfo();
        }
        return DomainInfo.getInstance(Browser.getHost((String)this.getURL(), (boolean)true));
    }

    public CrawledLinkModifier getCustomCrawledLinkModifier() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getModifyHandler();
        }
        return null;
    }

    public void setCustomCrawledLinkModifier(CrawledLinkModifier modifier) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, modifier != null);
        if (crawling != null) {
            crawling.setModifyHandler(modifier);
        }
    }

    public void setBrokenCrawlerHandler(BrokenCrawlerHandler brokenCrawlerHandler) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, brokenCrawlerHandler != null);
        if (crawling != null) {
            crawling.setBrokenCrawlerHandler(brokenCrawlerHandler);
        }
    }

    public BrokenCrawlerHandler getBrokenCrawlerHandler() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getBrokenCrawlerHandler();
        }
        return null;
    }

    @Override
    public boolean hasVariantSupport() {
        DownloadLink dlLink = this.getDownloadLink();
        return dlLink != null && dlLink.hasVariantSupport();
    }

    @Override
    public UniqueAlltimeID getUniqueID() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getUniqueID();
        }
        return null;
    }

    public void setCollectingInfo(LinkCollectingInformation collectingInfo) {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, collectingInfo != null);
        if (crawling != null) {
            crawling.setCollectingInfo(collectingInfo);
        }
    }

    public boolean hasCollectingInfo() {
        return this.getCollectingInfo() != null;
    }

    private LinkCollectingInformation _getCollectingInfo() {
        CrawlingCrawledLink crawling = CrawlingCrawledLink.get(this, false);
        if (crawling != null) {
            return crawling.getCollectingInfo();
        }
        return null;
    }

    public LinkCollectingInformation getCollectingInfo() {
        LinkCollectingInformation lcollectingInfo = this._getCollectingInfo();
        CrawledLink lsourceLink = this.getSourceLink();
        if (lcollectingInfo != null || lsourceLink == null) {
            return lcollectingInfo;
        }
        return lsourceLink.getCollectingInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveInfo getArchiveInfo() {
        if (this.archiveInfo != null) {
            return this.archiveInfo;
        }
        CrawledLink crawledLink = this;
        synchronized (crawledLink) {
            if (this.archiveInfo != null) {
                return this.archiveInfo;
            }
            this.archiveInfo = new ArchiveInfo();
            return this.archiveInfo;
        }
    }

    public boolean hasArchiveInfo() {
        ArchiveInfo larchiveInfo = this.archiveInfo;
        if (larchiveInfo != null) {
            if (!BooleanStatus.UNSET.equals((Object)larchiveInfo.getAutoExtract())) {
                return true;
            }
            return larchiveInfo.getExtractionPasswords() != null && larchiveInfo.getExtractionPasswords().size() > 0;
        }
        return false;
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    public LinkInfo getLinkInfo() {
        DownloadLink dlLink = this.getDownloadLink();
        if (!this.isNameSet() && dlLink != null) {
            return dlLink.getLinkInfo();
        }
        LinkInfo linkInfo = this.linkInfo;
        if (linkInfo == null) {
            LinkInfo newLinkInfo;
            this.linkInfo = newLinkInfo = LinkInfo.getLinkInfo(this);
            return newLinkInfo;
        }
        return linkInfo;
    }

    private void setLinkInfo(LinkInfo linkInfo) {
        this.linkInfo = linkInfo;
    }

    @Override
    public void nodeUpdated(AbstractNode source, AbstractNodeNotifier.NOTIFY notify, Object param) {
        CrawledPackage lparent = this.parent;
        if (lparent == null || !lparent.hasNotificationListener()) {
            return;
        }
        AbstractNode lsource = source;
        if (lsource != null && lsource instanceof DownloadLink && param instanceof DownloadLinkProperty) {
            DownloadLinkProperty propertyEvent = (DownloadLinkProperty)param;
            switch (propertyEvent.getProperty()) {
                case AVAILABILITY: {
                    this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, CrawledLinkProperty.Property.AVAILABILITY, propertyEvent.getValue()));
                    return;
                }
                case ENABLED: {
                    return;
                }
                case NAME: {
                    if (!this.isNameSet()) {
                        this.setLinkInfo(null);
                        this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, CrawledLinkProperty.Property.NAME, propertyEvent.getValue()));
                    }
                    return;
                }
                case PRIORITY: {
                    this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, CrawledLinkProperty.Property.PRIORITY, propertyEvent.getValue()));
                    return;
                }
                case COMMENT: {
                    this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, CrawledLinkProperty.Property.NAME, this.getName()));
                    return;
                }
            }
        }
        if (lsource == null) {
            lsource = this;
        }
        lparent.nodeUpdated(lsource, notify, param);
    }

    @Override
    public boolean hasNotificationListener() {
        CrawledPackage lparent = this.parent;
        return lparent != null && lparent.hasNotificationListener();
    }

    @Override
    public UniqueAlltimeID getPreviousParentNodeID() {
        return this.previousParent;
    }

    public String getArchiveID() {
        DownloadLink dlLink = this.getDownloadLink();
        if (dlLink != null) {
            return dlLink.getArchiveID();
        }
        return null;
    }

    public void firePropertyChanged(CrawledLinkProperty.Property property, Object value) {
        if (this.hasNotificationListener()) {
            this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, property, value));
        }
    }

    public void setSourceUrls(String[] sourceUrls) {
        this.sourceUrls = sourceUrls;
    }

    public String[] getSourceUrls() {
        return this.sourceUrls;
    }

    public void setComment(String comment) {
        DownloadLink link = this.getDownloadLink();
        if (link != null) {
            link.setComment(comment);
            if (this.hasNotificationListener()) {
                this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledLinkProperty(this, CrawledLinkProperty.Property.NAME, this.getName()));
            }
        }
    }

    public String getComment() {
        DownloadLink link = this.getDownloadLink();
        if (link != null) {
            return link.getComment();
        }
        return null;
    }

    @Override
    public Iterator<CrawledLink> iterator() {
        return new Iterator<CrawledLink>(){
            private CrawledLink current;
            {
                this.current = CrawledLink.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public CrawledLink next() {
                CrawledLink ret = this.current;
                if (this.current != null) {
                    this.current = this.current.getSourceLink();
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static enum PROPERTY {
        ENABLED,
        CRAWL_DEEP,
        AUTO_CONFIRM,
        AUTO_START,
        FORCED_AUTO_START;

    }
}

