/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.ArchiveInfo;
import jd.controlling.linkcrawler.BrokenCrawlerHandler;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.CrawledLinkModifiers;
import jd.controlling.linkcrawler.LinkCrawlerConfig;
import jd.controlling.linkcrawler.LinkCrawlerDeepHelperInterface;
import jd.controlling.linkcrawler.LinkCrawlerDeepInspector;
import jd.controlling.linkcrawler.LinkCrawlerDistributer;
import jd.controlling.linkcrawler.LinkCrawlerEvent;
import jd.controlling.linkcrawler.LinkCrawlerEventSender;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import jd.controlling.linkcrawler.LinkCrawlerHandler;
import jd.controlling.linkcrawler.LinkCrawlerLock;
import jd.controlling.linkcrawler.LinkCrawlerRule;
import jd.controlling.linkcrawler.LinkCrawlerRuleStorable;
import jd.controlling.linkcrawler.LinkCrawlerRunnable;
import jd.controlling.linkcrawler.LinkCrawlerThread;
import jd.controlling.linkcrawler.PackageInfo;
import jd.controlling.linkcrawler.UnknownCrawledLinkHandler;
import jd.http.AuthenticationFactory;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.PostRequest;
import jd.nutils.encoding.Encoding;
import jd.parser.html.Form;
import jd.parser.html.HTMLParser;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.ClearableLogInterface;
import org.appwork.utils.logging2.ClosableLogInterface;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.PublicSuffixList;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.auth.AuthenticationController;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.UrlProtection;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.plugins.components.abstractGenericHTTPDirectoryIndexCrawler;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.GeneralSettings;

public class LinkCrawler {
    private static final String DIRECT_HTTP = "directhttp";
    private static final String HTTP_LINKS = "http links";
    private static final int MAX_THREADS;
    private List<CrawledLink> crawledLinks = new ArrayList<CrawledLink>();
    private AtomicInteger crawledLinksCounter = new AtomicInteger(0);
    private List<CrawledLink> filteredLinks = new ArrayList<CrawledLink>();
    private AtomicInteger filteredLinksCounter = new AtomicInteger(0);
    private List<CrawledLink> brokenLinks = new ArrayList<CrawledLink>();
    private AtomicInteger brokenLinksCounter = new AtomicInteger(0);
    private List<CrawledLink> unhandledLinks = new ArrayList<CrawledLink>();
    private final AtomicInteger unhandledLinksCounter = new AtomicInteger(0);
    private final AtomicInteger processedLinksCounter = new AtomicInteger(0);
    private final List<LinkCrawlerTask> tasks = new ArrayList<LinkCrawlerTask>();
    private static final Set<LinkCrawler> CRAWLER;
    private final Map<String, Object> duplicateFinderContainer;
    private final Map<LazyCrawlerPlugin, Set<String>> duplicateFinderCrawler;
    private final Map<String, CrawledLink> duplicateFinderFinal;
    private final Map<String, Object> duplicateFinderDeep;
    private final Map<CrawledLink, Object> loopPreventionEmbedded;
    private LinkCrawlerHandler handler = null;
    protected static final ThreadPoolExecutor threadPool;
    private LinkCrawlerFilter filter = null;
    private final LinkCrawler parentCrawler;
    private final long created;
    public static final String PACKAGE_ALLOW_MERGE = "ALLOW_MERGE";
    public static final String PACKAGE_ALLOW_INHERITANCE = "ALLOW_INHERITANCE";
    public static final String PACKAGE_CLEANUP_NAME = "CLEANUP_NAME";
    public static final String PACKAGE_IGNORE_VARIOUS = "PACKAGE_IGNORE_VARIOUS";
    public static final String PROPERTY_AUTO_REFERER = "autoReferer";
    public static final UniqueAlltimeID PERMANENT_OFFLINE_ID;
    private boolean doDuplicateFinderFinalCheck = true;
    private List<LazyCrawlerPlugin> unsortedLazyCrawlerPlugins;
    protected final PluginClassLoader.PluginClassLoaderChild classLoader;
    private final String defaultDownloadFolder;
    private final AtomicReference<List<LazyCrawlerPlugin>> sortedLazyCrawlerPlugins = new AtomicReference();
    private final AtomicReference<List<LazyHostPlugin>> sortedLazyHostPlugins = new AtomicReference();
    private final AtomicReference<List<LinkCrawlerRule>> linkCrawlerRules = new AtomicReference();
    private LinkCrawlerDeepInspector deepInspector = null;
    private LinkCrawlerConfig.DirectHTTPPermission directHTTPPermission = LinkCrawlerConfig.DirectHTTPPermission.ALWAYS;
    protected final UniqueAlltimeID uniqueAlltimeID = new UniqueAlltimeID();
    protected final WeakHashMap<LinkCrawler, Object> children = new WeakHashMap();
    protected static final WeakHashMap<LinkCrawler, Set<LinkCrawlerLock>> LOCKS;
    protected final AtomicReference<LinkCrawlerGeneration> linkCrawlerGeneration = new AtomicReference<Object>(null);
    protected static final WeakHashMap<LinkCrawler, Map<String, Object>> CRAWLER_CACHE;
    private static final LinkCrawlerConfig CONFIG;
    protected static final ScheduledExecutorService TIMINGQUEUE;
    private static final LinkCrawlerEventSender EVENTSENDER;
    private static final Object LINKCRAWLERRULESLOCK;
    protected final AtomicReference<LazyHostPlugin> lazyDirect = new AtomicReference();
    protected final AtomicReference<LazyHostPlugin> lazyHttp = new AtomicReference();
    protected final AtomicReference<LazyHostPlugin> lazyFtp = new AtomicReference();
    protected final AtomicReference<LazyCrawlerPlugin> lazyDeepDecryptHelper = new AtomicReference();
    protected final AtomicReference<LazyCrawlerPlugin> lazyGenericHttpDirectoryCrawlerPlugin = new AtomicReference();
    private volatile Set<String> crawlerPluginBlacklist = new HashSet<String>();
    private volatile Set<String> hostPluginBlacklist = new HashSet<String>();
    private static final Object WAIT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCrawlerCache(String key) {
        WeakHashMap<LinkCrawler, Map<String, Object>> weakHashMap = CRAWLER_CACHE;
        synchronized (weakHashMap) {
            Map<String, Object> cache = CRAWLER_CACHE.get(this);
            return cache != null ? cache.get(key) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putCrawlerCache(String key, Object value) {
        WeakHashMap<LinkCrawler, Map<String, Object>> weakHashMap = CRAWLER_CACHE;
        synchronized (weakHashMap) {
            Map<String, Object> cache = CRAWLER_CACHE.get(this);
            if (cache == null) {
                cache = new HashMap<String, Object>();
                CRAWLER_CACHE.put(this, cache);
            }
            return cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkCrawlerGeneration getValidLinkCrawlerGeneration() {
        AtomicReference<LinkCrawlerGeneration> atomicReference = this.linkCrawlerGeneration;
        synchronized (atomicReference) {
            LinkCrawlerGeneration ret = this.linkCrawlerGeneration.get();
            if (ret == null || !ret.isValid()) {
                ret = new LinkCrawlerGeneration();
                this.linkCrawlerGeneration.set(ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkCrawlerGeneration getCurrentLinkCrawlerGeneration() {
        AtomicReference<LinkCrawlerGeneration> atomicReference = this.linkCrawlerGeneration;
        synchronized (atomicReference) {
            LinkCrawlerGeneration ret = this.linkCrawlerGeneration.get();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkCrawlerLock getLinkCrawlerLock(LazyCrawlerPlugin plugin, CrawledLink crawledLink) {
        WeakHashMap<LinkCrawler, Set<LinkCrawlerLock>> weakHashMap = LOCKS;
        synchronized (weakHashMap) {
            LinkCrawlerLock ret = null;
            for (Set<LinkCrawlerLock> locks : LOCKS.values()) {
                for (LinkCrawlerLock lock : locks) {
                    if (ret == lock || ret != null && (lock.getMaxConcurrency() >= ret.getMaxConcurrency() || !lock.matches(plugin, crawledLink))) continue;
                    ret = lock;
                }
            }
            if (ret == null && LinkCrawlerLock.requiresLocking(plugin)) {
                ret = new LinkCrawlerLock(plugin);
            }
            if (ret != null) {
                for (LinkCrawler linkCrawler : LOCKS.keySet()) {
                    this.addSequentialLockObject(linkCrawler.getRoot(), ret);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSequentialLockObject(LinkCrawler linkCrawler, LinkCrawlerLock lock) {
        if (lock == null) {
            return;
        }
        WeakHashMap<LinkCrawler, Set<LinkCrawlerLock>> weakHashMap = LOCKS;
        synchronized (weakHashMap) {
            LinkCrawler root = linkCrawler != null ? linkCrawler : this.getRoot();
            Set<LinkCrawlerLock> locks = LOCKS.get(root);
            if (locks == null) {
                locks = new HashSet<LinkCrawlerLock>();
                LOCKS.put(root, locks);
            }
            locks.add(lock);
        }
    }

    public void addSequentialLockObject(LinkCrawlerLock lock) {
        this.addSequentialLockObject(this.getRoot(), lock);
    }

    public UniqueAlltimeID getUniqueAlltimeID() {
        return this.uniqueAlltimeID;
    }

    public LinkCrawler getParent() {
        return this.parentCrawler;
    }

    public static LinkCrawlerConfig getConfig() {
        return CONFIG;
    }

    public void setDirectHTTPPermission(LinkCrawlerConfig.DirectHTTPPermission directHTTPPermission) {
        this.directHTTPPermission = directHTTPPermission == null ? LinkCrawlerConfig.DirectHTTPPermission.ALWAYS : directHTTPPermission;
    }

    public boolean isDoDuplicateFinderFinalCheck() {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.isDoDuplicateFinderFinalCheck();
        }
        return this.doDuplicateFinderFinalCheck;
    }

    protected Long getDefaultAverageRuntime() {
        return null;
    }

    public static int getMaxThreads() {
        return MAX_THREADS;
    }

    public static LinkCrawlerEventSender getGlobalEventSender() {
        return EVENTSENDER;
    }

    public static LinkCrawler newInstance() {
        return LinkCrawler.newInstance(null, null);
    }

    public static LinkCrawler newInstance(Boolean connectParent, Boolean avoidDuplicates) {
        LinkCrawler lc;
        if (Thread.currentThread() instanceof LinkCrawlerThread) {
            LinkCrawlerThread thread = (LinkCrawlerThread)((Object)Thread.currentThread());
            Object owner = thread.getCurrentOwner();
            final CrawledLink source = owner instanceof PluginForDecrypt ? ((PluginForDecrypt)owner).getCurrentLink() : (owner instanceof PluginsC ? ((PluginsC)owner).getCurrentLink() : null);
            final LinkCrawler parent = thread.getCurrentLinkCrawler();
            lc = new LinkCrawler(connectParent == null ? false : connectParent, avoidDuplicates == null ? false : avoidDuplicates){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void attachLinkCrawler(LinkCrawler linkCrawler) {
                    if (linkCrawler != null && linkCrawler != this) {
                        if (parent != null) {
                            parent.attachLinkCrawler(linkCrawler);
                        }
                        WeakHashMap weakHashMap = this.children;
                        synchronized (weakHashMap) {
                            this.children.put(linkCrawler, Boolean.TRUE);
                        }
                    }
                }

                @Override
                protected CrawledLink crawledLinkFactorybyURL(CharSequence url) {
                    CrawledLink ret = parent != null ? parent.crawledLinkFactorybyURL(url) : new CrawledLink(url);
                    if (source != null) {
                        ret.setSourceLink(source);
                    }
                    return ret;
                }

                @Override
                protected boolean distributeCrawledLink(CrawledLink crawledLink) {
                    return crawledLink != null && crawledLink.getSourceUrls() == null;
                }

                @Override
                protected void postprocessFinalCrawledLink(CrawledLink link) {
                }
            };
            parent.attachLinkCrawler(lc);
        } else {
            lc = new LinkCrawler(connectParent == null ? true : connectParent, avoidDuplicates == null ? true : avoidDuplicates);
        }
        return lc;
    }

    protected PluginClassLoader.PluginClassLoaderChild getPluginClassLoaderChild() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean addLinkCrawlerRule(LinkCrawlerRule newRule) {
        List<LinkCrawlerRuleStorable> existingRules;
        boolean refresh;
        block15: {
            boolean bl;
            if (newRule == null) {
                return false;
            }
            refresh = false;
            try {
                Object object = LINKCRAWLERRULESLOCK;
                // MONITORENTER : object
                existingRules = CONFIG.getLinkCrawlerRules();
                if (existingRules == null) {
                    existingRules = new ArrayList<LinkCrawlerRuleStorable>();
                    break block15;
                }
                for (LinkCrawlerRuleStorable existingRule : existingRules) {
                    if (existingRule.getId() != newRule.getId() && (existingRule.getRule() != newRule.getRule() || !StringUtils.equals((String)existingRule.getPattern(), (String)newRule.getPattern()))) continue;
                    bl = false;
                    // MONITOREXIT : object
                    if (!refresh) return bl;
                    AtomicReference<List<LinkCrawlerRule>> atomicReference = this.linkCrawlerRules;
                }
            }
            catch (Throwable throwable) {
                if (!refresh) throw throwable;
                AtomicReference<List<LinkCrawlerRule>> atomicReference = this.linkCrawlerRules;
                // MONITORENTER : atomicReference
                this.linkCrawlerRules.set(null);
                // MONITOREXIT : atomicReference
                throw throwable;
            }
            {
                // MONITORENTER : atomicReference
                this.linkCrawlerRules.set(null);
                // MONITOREXIT : atomicReference
                return bl;
            }
        }
        existingRules.add(new LinkCrawlerRuleStorable(newRule));
        CONFIG.setLinkCrawlerRules(existingRules);
        refresh = true;
        boolean bl = true;
        // MONITOREXIT : object
        if (!refresh) return bl;
        AtomicReference<List<LinkCrawlerRule>> atomicReference = this.linkCrawlerRules;
        // MONITORENTER : atomicReference
        this.linkCrawlerRules.set(null);
        // MONITOREXIT : atomicReference
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateLinkCrawlerRule(LinkCrawlerRule updateRule) {
        boolean refresh = false;
        try {
            AtomicReference<List<LinkCrawlerRule>> atomicReference = LINKCRAWLERRULESLOCK;
            synchronized (atomicReference) {
                List<LinkCrawlerRuleStorable> existingRules = CONFIG.getLinkCrawlerRules();
                if (existingRules == null) return;
                for (LinkCrawlerRuleStorable existingRule : existingRules) {
                    if (existingRule.getId() != updateRule.getId()) continue;
                    existingRule._set(updateRule);
                    CONFIG.setLinkCrawlerRules(new ArrayList<LinkCrawlerRuleStorable>(existingRules));
                    refresh = true;
                    return;
                }
                return;
            }
        }
        finally {
            if (refresh) {
                AtomicReference<List<LinkCrawlerRule>> atomicReference = this.linkCrawlerRules;
                synchronized (atomicReference) {
                    this.linkCrawlerRules.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkCrawlerRule getLinkCrawlerRule(long ruleID) {
        Object object = LINKCRAWLERRULESLOCK;
        synchronized (object) {
            List<LinkCrawlerRuleStorable> rules = CONFIG.getLinkCrawlerRules();
            if (rules == null || rules.size() == 0) {
                return null;
            }
            for (LinkCrawlerRuleStorable rule : rules) {
                if (rule.getId() != ruleID) continue;
                return rule;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LinkCrawlerRule> listLinkCrawlerRules() {
        ArrayList<LinkCrawlerRule> ret = new ArrayList<LinkCrawlerRule>();
        if (CONFIG.isLinkCrawlerRulesEnabled()) {
            Object object = LINKCRAWLERRULESLOCK;
            synchronized (object) {
                List<LinkCrawlerRuleStorable> rules = CONFIG.getLinkCrawlerRules();
                if (rules != null) {
                    for (LinkCrawlerRuleStorable rule : rules) {
                        try {
                            if (!rule.isEnabled()) continue;
                            ret.add(rule);
                        }
                        catch (Throwable e) {
                            LogController.CL().log(e);
                        }
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachLinkCrawler(LinkCrawler linkCrawler) {
        if (linkCrawler == null) {
            return;
        }
        if (linkCrawler == this) {
            return;
        }
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            parent.attachLinkCrawler(linkCrawler);
        }
        WeakHashMap<LinkCrawler, Object> weakHashMap = this.children;
        synchronized (weakHashMap) {
            this.children.put(linkCrawler, Boolean.TRUE);
        }
    }

    protected LazyHostPlugin getDirectHTTPPlugin() {
        if (this.parentCrawler != null) {
            return this.parentCrawler.getDirectHTTPPlugin();
        }
        LazyHostPlugin ret = this.lazyDirect.get();
        if (ret == null) {
            ret = HostPluginController.getInstance().get(DIRECT_HTTP);
            this.lazyDirect.set(ret);
        }
        return ret;
    }

    protected LazyHostPlugin getGenericHttpPlugin() {
        if (this.parentCrawler != null) {
            return this.parentCrawler.getGenericHttpPlugin();
        }
        LazyHostPlugin ret = this.lazyHttp.get();
        if (ret == null) {
            ret = HostPluginController.getInstance().get(HTTP_LINKS);
            this.lazyHttp.set(ret);
        }
        return ret;
    }

    protected LazyHostPlugin getGenericFtpPlugin() {
        if (this.parentCrawler != null) {
            return this.parentCrawler.getGenericFtpPlugin();
        }
        LazyHostPlugin ret = this.lazyFtp.get();
        if (ret == null) {
            ret = HostPluginController.getInstance().get("ftp");
            this.lazyFtp.set(ret);
        }
        return ret;
    }

    protected LazyCrawlerPlugin getDeepCrawlingPlugin() {
        if (this.parentCrawler != null) {
            return this.parentCrawler.getDeepCrawlingPlugin();
        }
        LazyCrawlerPlugin ret = this.lazyDeepDecryptHelper.get();
        if (ret == null) {
            List<LazyCrawlerPlugin> lazyCrawlerPlugins = this.getSortedLazyCrawlerPlugins();
            ListIterator<LazyCrawlerPlugin> it = lazyCrawlerPlugins.listIterator();
            while (it.hasNext()) {
                LazyCrawlerPlugin pDecrypt = it.next();
                if (!StringUtils.equals((String)"linkcrawlerdeephelper", (String)pDecrypt.getDisplayName())) continue;
                this.lazyDeepDecryptHelper.set(pDecrypt);
                return pDecrypt;
            }
        }
        return ret;
    }

    protected LazyCrawlerPlugin getLazyGenericHttpDirectoryCrawlerPlugin() {
        if (this.parentCrawler != null) {
            return this.parentCrawler.getLazyGenericHttpDirectoryCrawlerPlugin();
        }
        LazyCrawlerPlugin ret = this.lazyGenericHttpDirectoryCrawlerPlugin.get();
        if (ret == null) {
            List<LazyCrawlerPlugin> lazyCrawlerPlugins = this.getSortedLazyCrawlerPlugins();
            ListIterator<LazyCrawlerPlugin> it = lazyCrawlerPlugins.listIterator();
            while (it.hasNext()) {
                LazyCrawlerPlugin pDecrypt = it.next();
                if (!"httpdirectorycrawler".equals(pDecrypt.getDisplayName())) continue;
                this.lazyGenericHttpDirectoryCrawlerPlugin.set(pDecrypt);
                return pDecrypt;
            }
        }
        return ret;
    }

    public LinkCrawler(boolean connectParentCrawler, boolean avoidDuplicates) {
        this.setFilter(this.defaultFilterFactory());
        LinkCrawlerThread thread = this.getCurrentLinkCrawlerThread();
        if (connectParentCrawler && thread != null) {
            this.parentCrawler = thread.getCurrentLinkCrawler();
            this.parentCrawler.attachLinkCrawler(this);
            this.classLoader = this.parentCrawler.getPluginClassLoaderChild();
            this.directHTTPPermission = this.parentCrawler.directHTTPPermission;
            this.defaultDownloadFolder = this.parentCrawler.defaultDownloadFolder;
            this.duplicateFinderContainer = this.parentCrawler.duplicateFinderContainer;
            this.duplicateFinderCrawler = this.parentCrawler.duplicateFinderCrawler;
            this.duplicateFinderFinal = this.parentCrawler.duplicateFinderFinal;
            this.duplicateFinderDeep = this.parentCrawler.duplicateFinderDeep;
            this.loopPreventionEmbedded = this.parentCrawler.loopPreventionEmbedded;
            this.setHandler(this.parentCrawler.getHandler());
            this.setDeepInspector(this.parentCrawler.getDeepInspector());
        } else {
            this.duplicateFinderContainer = new HashMap<String, Object>();
            this.duplicateFinderCrawler = new HashMap<LazyCrawlerPlugin, Set<String>>();
            this.duplicateFinderFinal = new HashMap<String, CrawledLink>();
            this.duplicateFinderDeep = new HashMap<String, Object>();
            this.loopPreventionEmbedded = new HashMap<CrawledLink, Object>();
            this.setHandler(this.defaultHandlerFactory());
            this.setDeepInspector(this.defaultDeepInspector());
            this.defaultDownloadFolder = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder();
            this.parentCrawler = null;
            this.classLoader = PluginClassLoader.getInstance().getChild();
        }
        this.created = System.currentTimeMillis();
        this.doDuplicateFinderFinalCheck = avoidDuplicates;
    }

    public long getCreated() {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.getCreated();
        }
        return this.created;
    }

    protected CrawledLink crawledLinkFactorybyURL(CharSequence url) {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.crawledLinkFactorybyURL(url);
        }
        return new CrawledLink(url);
    }

    protected CrawledLink crawledLinkFactorybyDownloadLink(DownloadLink link) {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.crawledLinkFactorybyDownloadLink(link);
        }
        return new CrawledLink(link);
    }

    protected CrawledLink crawledLinkFactorybyCryptedLink(CryptedLink link) {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.crawledLinkFactorybyCryptedLink(link);
        }
        return new CrawledLink(link);
    }

    protected CrawledLink crawledLinkFactory(Object link) {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.crawledLinkFactory(link);
        }
        if (link instanceof DownloadLink) {
            return this.crawledLinkFactorybyDownloadLink((DownloadLink)link);
        }
        if (link instanceof CryptedLink) {
            return this.crawledLinkFactorybyCryptedLink((CryptedLink)link);
        }
        if (link instanceof CharSequence) {
            return this.crawledLinkFactorybyURL((CharSequence)link);
        }
        throw new IllegalArgumentException("Unsupported:" + link);
    }

    public void crawl(String text) {
        this.crawl(text, null, false);
    }

    public void setCrawlerPluginBlacklist(String[] list) {
        HashSet<String> lcrawlerPluginBlacklist = new HashSet<String>();
        if (list != null) {
            for (String s : list) {
                lcrawlerPluginBlacklist.add(s);
            }
        }
        this.crawlerPluginBlacklist = lcrawlerPluginBlacklist;
    }

    public boolean isBlacklisted(LazyCrawlerPlugin plugin) {
        LinkCrawler parent = this.getParent();
        if (parent != null && parent.isBlacklisted(plugin)) {
            return true;
        }
        return this.crawlerPluginBlacklist.contains(plugin.getDisplayName());
    }

    public boolean isBlacklisted(LazyHostPlugin plugin) {
        LinkCrawler parent = this.getParent();
        if (parent != null && parent.isBlacklisted(plugin)) {
            return true;
        }
        return this.hostPluginBlacklist.contains(plugin.getDisplayName());
    }

    public void setHostPluginBlacklist(String[] list) {
        HashSet<String> lhostPluginBlacklist = new HashSet<String>();
        if (list != null) {
            for (String s : list) {
                lhostPluginBlacklist.add(s);
            }
        }
        this.hostPluginBlacklist = lhostPluginBlacklist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crawl(final String text, final String url, final boolean allowDeep) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        final LinkCrawlerGeneration generation = this.getValidLinkCrawlerGeneration();
        LinkCrawlerTask task = this.checkStartNotify(generation, "crawlText");
        if (task == null) {
            return;
        }
        try {
            if (LinkCrawler.insideCrawlerPlugin()) {
                List<CrawledLink> links = this.find(generation, null, text, url, allowDeep, true);
                this.crawl(generation, links);
            } else {
                LinkCrawlerTask innerTask = this.checkStartNotify(generation, task.getTaskID() + "|crawlTextPool");
                if (innerTask != null) {
                    threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                        @Override
                        public long getAverageRuntime() {
                            Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                            if (ret != null) {
                                return ret;
                            }
                            return super.getAverageRuntime();
                        }

                        @Override
                        void crawling() {
                            List<CrawledLink> links = LinkCrawler.this.find(generation, null, text, url, allowDeep, true);
                            LinkCrawler.this.crawl(generation, links);
                        }
                    });
                }
            }
        }
        finally {
            LinkCrawler.checkFinishNotify(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CrawledLink> find(final LinkCrawlerGeneration generation, CrawledLink source, String text, String baseURL, final boolean allowDeep, boolean allowInstantCrawl) {
        final CrawledLink baseLink = StringUtils.isNotEmpty((String)baseURL) ? this.crawledLinkFactorybyURL(baseURL) : null;
        HTMLParser.HtmlParserResultSet resultSet = allowInstantCrawl && this.getCurrentLinkCrawlerThread() != null && generation != null ? new HTMLParser.HtmlParserResultSet(){
            private final HashSet<HTMLParser.HtmlParserCharSequence> fastResults = new HashSet();
            private LogSource logger = null;

            @Override
            public boolean add(HTMLParser.HtmlParserCharSequence e) {
                if (!generation.isValid()) {
                    throw new RuntimeException("Abort");
                }
                boolean ret = super.add(e);
                if (ret && !e.contains("...") && (this.getBaseURL() != null && !e.equals(this.getBaseURL()) || Boolean.TRUE.equals(this.isSkipBaseURL()))) {
                    this.fastResults.add(e);
                    CrawledLink crawledLink = LinkCrawler.this.crawledLinkFactorybyURL(e.toURL());
                    crawledLink.setCrawlDeep(allowDeep);
                    if (crawledLink.getSourceLink() == null) {
                        crawledLink.setSourceLink(baseLink);
                    }
                    ArrayList<CrawledLink> crawledLinks = new ArrayList<CrawledLink>(1);
                    crawledLinks.add(crawledLink);
                    LinkCrawler.this.crawl(generation, crawledLinks);
                }
                return ret;
            }

            @Override
            public LogInterface getLogger() {
                if (this.logger == null) {
                    this.logger = LogController.getInstance().getClassLogger(LinkCrawler.class);
                }
                return this.logger;
            }

            @Override
            protected Collection<String> exportResults() {
                ArrayList<String> ret = new ArrayList<String>();
                block0: for (HTMLParser.HtmlParserCharSequence result : this.getResults()) {
                    if (this.fastResults.contains(result)) continue;
                    int index = result.indexOf("...");
                    if (index > 0) {
                        HTMLParser.HtmlParserCharSequence check = result.subSequence(0, index);
                        for (HTMLParser.HtmlParserCharSequence fastResult : this.fastResults) {
                            if (!fastResult.startsWith(check) || result == fastResult || fastResult.contains("...")) continue;
                            continue block0;
                        }
                    }
                    ret.add(result.toURL());
                }
                return ret;
            }
        } : new HTMLParser.HtmlParserResultSet(){
            private LogSource logger = null;

            @Override
            public boolean add(HTMLParser.HtmlParserCharSequence e) {
                if (!generation.isValid()) {
                    throw new RuntimeException("Abort");
                }
                return super.add(e);
            }

            @Override
            public LogInterface getLogger() {
                if (this.logger == null) {
                    this.logger = LogController.getInstance().getClassLogger(LinkCrawler.class);
                }
                return this.logger;
            }
        };
        LinkCrawlerTask task = this.checkStartNotify(generation, "find");
        if (task == null) {
            return null;
        }
        try {
            String[] possibleLinks = HTMLParser.getHttpLinks(this.preprocessFind(text, baseURL, allowDeep), baseURL, resultSet);
            if (possibleLinks == null || possibleLinks.length == 0) {
                List<CrawledLink> list = null;
                return list;
            }
            ArrayList<CrawledLink> possibleCryptedLinks = new ArrayList<CrawledLink>(possibleLinks.length);
            for (String possibleLink : possibleLinks) {
                CrawledLink crawledLink = this.crawledLinkFactorybyURL(possibleLink);
                crawledLink.setCrawlDeep(allowDeep);
                if (crawledLink.getSourceLink() == null) {
                    crawledLink.setSourceLink(baseLink);
                }
                possibleCryptedLinks.add(crawledLink);
            }
            ArrayList<CrawledLink> arrayList = possibleCryptedLinks;
            return arrayList;
        }
        catch (RuntimeException e) {
            if (generation.isValid()) {
                resultSet.getLogger().log((Throwable)e);
            }
        }
        finally {
            LinkCrawler.checkFinishNotify(task);
        }
        return null;
    }

    public String preprocessFind(String in, String url, boolean allowDeep) {
        if (in == null) {
            return null;
        }
        String out = in.replaceAll("(?i)/\\s*Sharecode\\[\\?\\]:\\s*/", "/");
        out = out.replaceAll("(?i)\\s*Sharecode\\[\\?\\]:\\s*", "");
        out = out.replaceAll("(?i)/?\\s*Sharecode:\\s*/?", "/");
        return out;
    }

    public void crawl(List<CrawledLink> possibleCryptedLinks) {
        this.crawl(this.getValidLinkCrawlerGeneration(), possibleCryptedLinks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void crawl(final LinkCrawlerGeneration generation, final List<CrawledLink> possibleCryptedLinks) {
        if (possibleCryptedLinks == null || possibleCryptedLinks.size() == 0) {
            return;
        }
        LinkCrawlerTask task = this.checkStartNotify(generation, "crawlLinks");
        if (task == null) {
            return;
        }
        try {
            if (LinkCrawler.insideCrawlerPlugin()) {
                this.distribute(generation, possibleCryptedLinks);
            } else {
                LinkCrawlerTask innerTask = this.checkStartNotify(generation, task.getTaskID() + "|crawlLinksPool");
                if (innerTask != null) {
                    threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                        @Override
                        public long getAverageRuntime() {
                            Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                            if (ret != null) {
                                return ret;
                            }
                            return super.getAverageRuntime();
                        }

                        @Override
                        void crawling() {
                            LinkCrawler.this.distribute(generation, possibleCryptedLinks);
                        }
                    });
                }
            }
        }
        finally {
            LinkCrawler.checkFinishNotify(task);
        }
    }

    public static boolean insideCrawlerPlugin() {
        Object owner;
        return Thread.currentThread() instanceof LinkCrawlerThread && (owner = ((LinkCrawlerThread)((Object)Thread.currentThread())).getCurrentOwner()) != null && owner instanceof PluginForDecrypt;
    }

    public static boolean insideHosterPlugin() {
        Object owner;
        return Thread.currentThread() instanceof LinkCrawlerThread && (owner = ((LinkCrawlerThread)((Object)Thread.currentThread())).getCurrentOwner()) != null && owner instanceof PluginForHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkFinishNotify(LinkCrawlerTask task) {
        boolean finished;
        boolean stopped;
        if (task == null) {
            return;
        }
        if (!task.invalidate()) {
            return;
        }
        LinkCrawler linkCrawler = task.getCrawler();
        Object object = CRAWLER;
        synchronized (object) {
            boolean crawling;
            linkCrawler.tasks.remove(task);
            boolean bl = crawling = linkCrawler.tasks.size() > 0;
            if (crawling) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    System.out.println("LinkCrawler:checkFinishNotify:" + linkCrawler + "|Task:(" + task.getTaskID() + ")|Crawling:" + linkCrawler.tasks.size());
                }
                return;
            }
            stopped = CRAWLER.remove(linkCrawler);
            boolean bl2 = finished = CRAWLER.size() == 0;
            if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                System.out.println("LinkCrawler:checkFinishNotify:" + linkCrawler + "|Task:(" + task.getTaskID() + ")|Stopped:" + stopped + "|Finished:" + finished);
            }
        }
        if (stopped) {
            object = WAIT;
            synchronized (object) {
                WAIT.notifyAll();
            }
            if (linkCrawler.getParent() == null) {
                linkCrawler.cleanup();
            }
            EVENTSENDER.fireEvent((DefaultEvent)new LinkCrawlerEvent(linkCrawler, LinkCrawlerEvent.Type.STOPPED));
            linkCrawler.crawlerStopped();
        }
        if (finished) {
            object = WAIT;
            synchronized (object) {
                WAIT.notifyAll();
            }
            linkCrawler.cleanup();
            EVENTSENDER.fireEvent((DefaultEvent)new LinkCrawlerEvent(linkCrawler, LinkCrawlerEvent.Type.FINISHED));
            linkCrawler.crawlerFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Map<Object, Object> map = this.duplicateFinderContainer;
        synchronized (map) {
            this.duplicateFinderContainer.clear();
        }
        map = this.duplicateFinderCrawler;
        synchronized (map) {
            this.duplicateFinderCrawler.clear();
        }
        map = this.duplicateFinderFinal;
        synchronized (map) {
            this.duplicateFinderFinal.clear();
        }
        map = this.duplicateFinderDeep;
        synchronized (map) {
            this.duplicateFinderDeep.clear();
        }
        map = this.loopPreventionEmbedded;
        synchronized (map) {
            this.loopPreventionEmbedded.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void crawlerStopped() {
        WeakHashMap<LinkCrawler, Map<String, Object>> weakHashMap = CRAWLER_CACHE;
        synchronized (weakHashMap) {
            CRAWLER_CACHE.remove(this);
        }
    }

    protected void crawlerStarted() {
    }

    protected void crawlerFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkCrawlerTask checkStartNotify(LinkCrawlerGeneration generation, String taskID) {
        boolean event;
        if (generation == null) {
            return null;
        }
        if (!generation.isValid()) {
            return null;
        }
        LinkCrawlerTask task = new LinkCrawlerTask(this, generation, taskID);
        Set<LinkCrawler> set = CRAWLER;
        synchronized (set) {
            LinkCrawler linkCrawler = task.getCrawler();
            boolean start = linkCrawler.tasks.size() == 0;
            linkCrawler.tasks.add(task);
            boolean bl = event = CRAWLER.add(linkCrawler) && start;
            if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                System.out.println("LinkCrawler:checkStartNotify:" + linkCrawler + "|Task:(" + task.getTaskID() + ")|Start:" + start + "|Crawler:" + event + "|Crawling:" + linkCrawler.tasks.size());
            }
        }
        try {
            if (event) {
                EVENTSENDER.fireEvent((DefaultEvent)new LinkCrawlerEvent(task.getCrawler(), LinkCrawlerEvent.Type.STARTED));
                task.getCrawler().crawlerStarted();
            }
        }
        catch (RuntimeException e) {
            LinkCrawler.checkFinishNotify(task);
            throw e;
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected <T> T invokeLazyHosterPlugin(LinkCrawlerGeneration generation, LogInterface logger, LazyHostPlugin lazyH, LazyHosterPluginInvokation<T> invoker) throws Exception {
        LinkCrawlerTask task = this.checkStartNotify(generation, "invokeLazyHosterPlugin:" + lazyH);
        if (task == null) {
            return null;
        }
        try {
            T t;
            LinkCrawler previousCrawler;
            Object owner;
            LinkCrawlerThread lct;
            boolean oldDebug;
            boolean oldVerbose;
            LogInterface oldLogger;
            PluginForHost wplg;
            boolean newLogger;
            block15: {
                newLogger = logger == null;
                wplg = lazyH.newInstance(this.getPluginClassLoaderChild());
                if (logger != null) {
                    logger = LogController.getFastPluginLogger(wplg.getCrawlerLoggerID(null));
                }
                wplg.setLogger(logger);
                wplg.setBrowser(wplg.createNewBrowserInstance());
                wplg.init();
                oldLogger = null;
                oldVerbose = false;
                oldDebug = false;
                lct = this.getCurrentLinkCrawlerThread();
                owner = null;
                previousCrawler = null;
                if (lct != null) {
                    owner = lct.getCurrentOwner();
                    lct.setCurrentOwner(wplg);
                    previousCrawler = lct.getCurrentLinkCrawler();
                    lct.setCurrentLinkCrawler(this);
                    oldLogger = lct.getLogger();
                    oldDebug = lct.isDebug();
                    oldVerbose = lct.isVerbose();
                    lct.setLogger(logger);
                    lct.setVerbose(true);
                    lct.setDebug(true);
                }
                t = invoker.invoke(wplg);
                wplg.clean();
                if (lct == null) break block15;
                lct.setCurrentOwner(owner);
                lct.setCurrentLinkCrawler(previousCrawler);
                lct.setLogger(oldLogger);
                lct.setVerbose(oldVerbose);
                lct.setDebug(oldDebug);
            }
            if (newLogger && logger instanceof ClosableLogInterface) {
                ((ClosableLogInterface)logger).close();
            }
            return t;
            {
                catch (Throwable throwable) {
                    try {
                        wplg.clean();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (lct != null) {
                            lct.setCurrentOwner(owner);
                            lct.setCurrentLinkCrawler(previousCrawler);
                            lct.setLogger(oldLogger);
                            lct.setVerbose(oldVerbose);
                            lct.setDebug(oldDebug);
                        }
                        if (newLogger && logger instanceof ClosableLogInterface) {
                            ((ClosableLogInterface)logger).close();
                        }
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            LinkCrawler.checkFinishNotify(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected <T> T invokeLazyCrawlerPlugin(LinkCrawlerGeneration generation, LogInterface logger, LazyCrawlerPlugin lazyC, CrawledLink link, LazyCrawlerPluginInvokation<T> invoker) throws Exception {
        LinkCrawlerTask task = this.checkStartNotify(generation, "invokeLazyCrawlerPlugin:" + lazyC + "|" + link.getURL());
        if (task == null) {
            return null;
        }
        try {
            T t;
            long startTime;
            LinkCrawler previousCrawler;
            Object owner;
            LinkCrawlerThread lct;
            boolean oldDebug;
            boolean oldVerbose;
            LogInterface oldLogger;
            PluginForDecrypt wplg;
            boolean newLogger;
            block16: {
                newLogger = logger == null;
                wplg = lazyC.newInstance(this.getPluginClassLoaderChild());
                AtomicReference<LinkCrawler> nextLinkCrawler = new AtomicReference<LinkCrawler>(this);
                if (logger != null) {
                    logger = LogController.getFastPluginLogger(wplg.getCrawlerLoggerID(link));
                }
                wplg.setLogger(logger);
                wplg.setBrowser(wplg.createNewBrowserInstance());
                wplg.init();
                oldLogger = null;
                oldVerbose = false;
                oldDebug = false;
                lct = this.getCurrentLinkCrawlerThread();
                owner = null;
                previousCrawler = null;
                if (lct != null) {
                    owner = lct.getCurrentOwner();
                    lct.setCurrentOwner(wplg);
                    previousCrawler = lct.getCurrentLinkCrawler();
                    lct.setCurrentLinkCrawler(this);
                    oldLogger = lct.getLogger();
                    oldDebug = lct.isDebug();
                    oldVerbose = lct.isVerbose();
                    lct.setLogger(logger);
                    lct.setVerbose(true);
                    lct.setDebug(true);
                }
                startTime = System.currentTimeMillis();
                wplg.setCrawler(this);
                wplg.setLinkCrawlerGeneration(generation);
                wplg.setCurrentLink(link);
                LinkCrawler pluginNextLinkCrawler = wplg.getCustomNextCrawler();
                if (pluginNextLinkCrawler != null) {
                    nextLinkCrawler.set(pluginNextLinkCrawler);
                }
                t = invoker.invoke(wplg);
                wplg.clean();
                wplg.setLinkCrawlerGeneration(null);
                wplg.setCurrentLink(null);
                long endTime = System.currentTimeMillis() - startTime;
                lazyC.updateCrawlRuntime(endTime);
                if (lct == null) break block16;
                lct.setCurrentOwner(owner);
                lct.setCurrentLinkCrawler(previousCrawler);
                lct.setLogger(oldLogger);
                lct.setVerbose(oldVerbose);
                lct.setDebug(oldDebug);
            }
            if (newLogger && logger instanceof ClosableLogInterface) {
                ((ClosableLogInterface)logger).close();
            }
            return t;
            {
                catch (Throwable throwable) {
                    try {
                        wplg.clean();
                        wplg.setLinkCrawlerGeneration(null);
                        wplg.setCurrentLink(null);
                        long endTime = System.currentTimeMillis() - startTime;
                        lazyC.updateCrawlRuntime(endTime);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (lct != null) {
                            lct.setCurrentOwner(owner);
                            lct.setCurrentLinkCrawler(previousCrawler);
                            lct.setLogger(oldLogger);
                            lct.setVerbose(oldVerbose);
                            lct.setDebug(oldDebug);
                        }
                        if (newLogger && logger instanceof ClosableLogInterface) {
                            ((ClosableLogInterface)logger).close();
                        }
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            LinkCrawler.checkFinishNotify(task);
        }
    }

    protected URLConnectionAdapter openCrawlDeeperConnection(LinkCrawlerGeneration generation, LogInterface logger, final LinkCrawlerRule matchingRule, final Browser br, final CrawledLink link) throws Exception {
        LazyCrawlerPlugin lazyC = this.getDeepCrawlingPlugin();
        if (lazyC == null) {
            throw new UpdateRequiredClassNotFoundException("could not find 'LinkCrawlerDeepHelper' crawler plugin");
        }
        return this.invokeLazyCrawlerPlugin(generation, logger, lazyC, link, new LazyCrawlerPluginInvokation<URLConnectionAdapter>(){

            @Override
            public URLConnectionAdapter invoke(PluginForDecrypt plugin) throws Exception {
                plugin.setBrowser(br);
                return ((LinkCrawlerDeepHelperInterface)((Object)plugin)).openConnection(matchingRule, br, link);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCrawledLinkDuplicated(Map<String, Object> map, CrawledLink link) {
        String urlDecodedURL;
        if (link instanceof BrowserCrawledLink) {
            return false;
        }
        String url = link.getURL();
        String value = StringUtils.equals((String)url, (String)(urlDecodedURL = Encoding.urlDecode((String)url, (boolean)false))) ? url : urlDecodedURL;
        Map<String, Object> map2 = map;
        synchronized (map2) {
            if (map.containsKey(value)) {
                return true;
            }
            map.put(value, this);
            return false;
        }
    }

    public DownloadLink createDirectHTTPDownloadLink(Request sourceRequest, final URLConnectionAdapter con) {
        LazyHostPlugin directHttpPlugin;
        String postString;
        long contentLength;
        Request nextRedirectOrigin;
        Request request = con.getRequest();
        Request redirectOrigin = request.getRedirectOrigin();
        while (redirectOrigin != null && (nextRedirectOrigin = redirectOrigin.getRedirectOrigin()) != null) {
            redirectOrigin = nextRedirectOrigin;
        }
        String startURL = request instanceof PostRequest ? request.getURL().toExternalForm() : (sourceRequest != null ? sourceRequest.getURL().toExternalForm() : (redirectOrigin != null ? redirectOrigin.getURL().toExternalForm() : request.getURL().toExternalForm()));
        final DownloadLink link = new DownloadLink(null, null, "DirectHTTP", "directhttp://" + startURL, true);
        String cookie = con.getRequestProperty("Cookie");
        if (StringUtils.isNotEmpty((String)cookie)) {
            link.setProperty("COOKIES", cookie);
        }
        if ((contentLength = con.getCompleteContentLength()) > 0L) {
            if (con.isContentDecoded()) {
                link.setDownloadSize(contentLength);
            } else {
                link.setVerifiedFileSize(contentLength);
            }
        }
        link.setAvailable(true);
        String requestRef = request.getHeaders().getValue("Referer");
        if (requestRef != null && !StringUtils.equals((String)requestRef, (String)request.getURL().toExternalForm())) {
            link.setProperty(PROPERTY_AUTO_REFERER, requestRef);
        }
        if (request instanceof PostRequest && (postString = ((PostRequest)request).getPostDataString()) != null) {
            link.setProperty("post", postString);
        }
        if ((directHttpPlugin = this.getDirectHTTPPlugin()) != null) {
            try {
                this.invokeLazyHosterPlugin(this.getCurrentLinkCrawlerGeneration(), null, directHttpPlugin, new LazyHosterPluginInvokation<Void>(){

                    @Override
                    public Void invoke(PluginForHost plugin) throws Exception {
                        ReflectionUtils.invoke(plugin.getClass(), (String)"updateFilename", (Object)plugin, String.class, (Object[])new Object[]{link, con});
                        return null;
                    }
                });
            }
            catch (InterruptedException e) {
                LogController.CL().log((Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LogController.CL().log((Throwable)e);
            }
        }
        return link;
    }

    public CrawledLink createDirectHTTPCrawledLink(CrawledLink source, Request sourceRequest, URLConnectionAdapter con) {
        DownloadLink link = this.createDirectHTTPDownloadLink(sourceRequest, con);
        CrawledLink directHTTP = this.crawledLinkFactorybyDownloadLink(link);
        LinkCrawlerRule rule = source.getMatchingRule();
        if (rule != null) {
            link.setProperty("lcrID", rule.getId());
            directHTTP.setMatchingRule(rule);
        }
        return directHTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void crawlDeeperOrMatchingRule(final LinkCrawlerGeneration generation, final CrawledLink source) {
        block114: {
            if (source.getCustomCrawledLinkModifier() instanceof DeeperOrMatchingRuleModifier) {
                modifier = source.getCustomCrawledLinkModifier();
                while (modifier instanceof DeeperOrMatchingRuleModifier) {
                    modifier = ((DeeperOrMatchingRuleModifier)modifier).getSourceCrawledLinkModifier();
                }
                sourceLinkModifier = modifier;
            } else {
                sourceLinkModifier = source.getCustomCrawledLinkModifier();
            }
            source.setCustomCrawledLinkModifier(null);
            source.setBrokenCrawlerHandler(null);
            if (source == null || source.getURL() == null) {
                return;
            }
            if (this.isCrawledLinkDuplicated(this.duplicateFinderDeep, source)) {
                this.onCrawledLinkDuplicate(source, DUPLICATE.DEEP);
                return;
            }
            if (this.isCrawledLinkFiltered(source)) {
                return;
            }
            task = this.checkStartNotify(generation, "crawlDeeperOrMatchingRule:" + source.getURL());
            if (task == null) {
                return;
            }
            matchingRule = source.getMatchingRule();
            additionalModifier = new ArrayList<11>();
            lm = new DeeperOrMatchingRuleModifier(){

                @Override
                public CrawledLinkModifier getSourceCrawledLinkModifier() {
                    return sourceLinkModifier;
                }

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    boolean setContainerURL = link.getDownloadLink() != null && link.getDownloadLink().getContainerUrl() == null;
                    boolean ret = false;
                    if (sourceLinkModifier != null && sourceLinkModifier.modifyCrawledLink(link)) {
                        ret = true;
                    }
                    if (setContainerURL) {
                        link.getDownloadLink().setContainerUrl(source.getURL());
                        ret = true;
                    }
                    for (CrawledLinkModifier modifier : additionalModifier) {
                        if (!modifier.modifyCrawledLink(link)) continue;
                        ret = true;
                    }
                    return ret;
                }
            };
            try {
                block93: {
                    block112: {
                        block113: {
                            block115: {
                                block110: {
                                    block111: {
                                        block108: {
                                            block109: {
                                                block106: {
                                                    block107: {
                                                        block98: {
                                                            block105: {
                                                                block103: {
                                                                    block104: {
                                                                        block101: {
                                                                            block102: {
                                                                                block99: {
                                                                                    block100: {
                                                                                        block96: {
                                                                                            block97: {
                                                                                                block94: {
                                                                                                    block95: {
                                                                                                        block91: {
                                                                                                            block92: {
                                                                                                                block89: {
                                                                                                                    block90: {
                                                                                                                        block87: {
                                                                                                                            block88: {
                                                                                                                                br = null;
                                                                                                                                logger = matchingRule != null && matchingRule.isLogging() != false ? LogController.getFastPluginLogger("LinkCrawlerRule." + matchingRule.getId()) : LogController.getFastPluginLogger("LinkCrawlerDeep." + CrossSystem.alleviatePathParts((String)source.getHost()));
                                                                                                                                this.processedLinksCounter.incrementAndGet();
                                                                                                                                if (!StringUtils.startsWithCaseInsensitive((String)source.getURL(), (String)"file:/")) ** GOTO lbl74
                                                                                                                                currentURI = source.getURL().replaceFirst("file:///?", "file:///");
                                                                                                                                file = new File(new URI(currentURI));
                                                                                                                                if (file.exists()) break block87;
                                                                                                                                logger.info("FILE: Invalid file path: File does not exist");
                                                                                                                                if (br == null) break block88;
                                                                                                                                br.disconnect();
                                                                                                                            }
                                                                                                                            if (logger != null && logger instanceof ClosableLogInterface) {
                                                                                                                                ((ClosableLogInterface)logger).close();
                                                                                                                            }
                                                                                                                            return;
                                                                                                                        }
                                                                                                                        if (file.isFile()) break block89;
                                                                                                                        logger.info("FILE: Invalid file path: File is not a file");
                                                                                                                        if (br == null) break block90;
                                                                                                                        br.disconnect();
                                                                                                                    }
                                                                                                                    if (logger != null && logger instanceof ClosableLogInterface) {
                                                                                                                        ((ClosableLogInterface)logger).close();
                                                                                                                    }
                                                                                                                    return;
                                                                                                                }
                                                                                                                limit = LinkCrawler.CONFIG.getDeepDecryptFileSizeLimit();
                                                                                                                readLimit = limit == -1 ? -1 : Math.max(0x100000, limit);
                                                                                                                fileContent = new String(IO.readFile((File)file, (int)readLimit), "UTF-8");
                                                                                                                fileContentLinks = this.find(generation, source, fileContent, null, false, false);
                                                                                                                if (fileContentLinks != null && !fileContentLinks.isEmpty()) break block91;
                                                                                                                logger.info("FILE: Failed to find any results in file: " + file.getAbsolutePath());
                                                                                                                if (br == null) break block92;
                                                                                                                br.disconnect();
                                                                                                            }
                                                                                                            if (logger != null && logger instanceof ClosableLogInterface) {
                                                                                                                ((ClosableLogInterface)logger).close();
                                                                                                            }
                                                                                                            return;
                                                                                                        }
                                                                                                        sourceURLs = this.getAndClearSourceURLs(source);
                                                                                                        singleDest = fileContentLinks.size() == 1;
                                                                                                        for (CrawledLink fileContentLink : fileContentLinks) {
                                                                                                            this.forwardCrawledLinkInfos(source, fileContentLink, lm, sourceURLs, singleDest);
                                                                                                        }
                                                                                                        this.crawl(generation, fileContentLinks);
                                                                                                        break block93;
lbl74:
                                                                                                        // 1 sources

                                                                                                        nextRequest = null;
                                                                                                        if (source instanceof BrowserCrawledLink) {
                                                                                                            brc = (BrowserCrawledLink)source;
                                                                                                            br = brc.getBrowser().cloneBrowser();
                                                                                                            nextRequest = brc.getNextRequest();
                                                                                                        } else {
                                                                                                            br = new Browser();
                                                                                                            nextRequest = br.createGetRequest(source.getURL());
                                                                                                        }
                                                                                                        br.setLogger((LogInterface)logger);
                                                                                                        if (matchingRule != null && matchingRule.isLogging()) {
                                                                                                            br.setVerbose(true);
                                                                                                            br.setDebug(true);
                                                                                                        }
                                                                                                        if ((next = this.openCrawlDeeperConnectionV2(source, matchingRule, br, (Request)nextRequest)) == null) break block94;
                                                                                                        this.forwardCrawledLinkInfos(source, next, lm, this.getAndClearSourceURLs(source), true);
                                                                                                        this.crawl(generation, Arrays.asList(new CrawledLink[]{next}));
                                                                                                        if (br == null) break block95;
                                                                                                        br.disconnect();
                                                                                                    }
                                                                                                    if (logger != null && logger instanceof ClosableLogInterface) {
                                                                                                        ((ClosableLogInterface)logger).close();
                                                                                                    }
                                                                                                    return;
                                                                                                }
                                                                                                current_url = br._getURL().toExternalForm();
                                                                                                source_url = source.getURL();
                                                                                                if (StringUtils.equals((String)current_url, (String)source_url) || source instanceof BrowserCrawledLink) {
                                                                                                    deeperSource = source;
                                                                                                    sourceURLs = this.getAndClearSourceURLs(source);
                                                                                                } else {
                                                                                                    deeperSource = this.crawledLinkFactorybyURL(current_url);
                                                                                                    this.forwardCrawledLinkInfos(source, deeperSource, lm, this.getAndClearSourceURLs(source), true);
                                                                                                    sourceURLs = this.getAndClearSourceURLs(deeperSource);
                                                                                                }
                                                                                                lDeepInspector = this.getDeepInspector();
                                                                                                inspectedLinks = lDeepInspector.deepInspect(this, generation, br, br.getHttpConnection(), deeperSource);
                                                                                                if (inspectedLinks == null) break block96;
                                                                                                if (inspectedLinks.size() >= 0) {
                                                                                                    singleDest = inspectedLinks.size() == 1;
                                                                                                    for (CrawledLink possibleCryptedLink : inspectedLinks) {
                                                                                                        this.forwardCrawledLinkInfos(deeperSource, possibleCryptedLink, lm, sourceURLs, singleDest);
                                                                                                    }
                                                                                                    this.crawl(generation, inspectedLinks);
                                                                                                }
                                                                                                if (br == null) break block97;
                                                                                                br.disconnect();
                                                                                            }
                                                                                            if (logger != null && logger instanceof ClosableLogInterface) {
                                                                                                ((ClosableLogInterface)logger).close();
                                                                                            }
                                                                                            return;
                                                                                        }
                                                                                        finalPackageName = null;
                                                                                        if (matchingRule != null) {
                                                                                            if (matchingRule._getPackageNamePattern() != null && StringUtils.isNotEmpty((String)(packageName = br.getRegex(matchingRule._getPackageNamePattern()).getMatch(0)))) {
                                                                                                finalPackageName = Encoding.htmlDecode((String)packageName).trim();
                                                                                            }
                                                                                            if (matchingRule._getPasswordPattern() != null && (matches = br.getRegex(matchingRule._getPasswordPattern()).getMatches()) != null && matches.length > 0) {
                                                                                                passwords = new HashSet<Object>();
                                                                                                for (String[] matcharray : matches) {
                                                                                                    for (String match : matcharray) {
                                                                                                        if (!StringUtils.isNotEmpty((String)match)) continue;
                                                                                                        passwords.add(match);
                                                                                                    }
                                                                                                }
                                                                                                if (passwords.size() > 0) {
                                                                                                    additionalModifier.add(new CrawledLinkModifier(){

                                                                                                        @Override
                                                                                                        public boolean modifyCrawledLink(CrawledLink link) {
                                                                                                            for (String password : passwords) {
                                                                                                                link.getArchiveInfo().addExtractionPassword(password);
                                                                                                            }
                                                                                                            return true;
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (matchingRule == null || !LinkCrawlerRule.RULE.SUBMITFORM.equals((Object)matchingRule.getRule())) break block98;
                                                                                        formPattern = matchingRule._getFormPattern();
                                                                                        if (formPattern != null) break block99;
                                                                                        logger.info("SUBMITFORM: Cannot process Form handling because: Form Pattern is null");
                                                                                        if (br == null) break block100;
                                                                                        br.disconnect();
                                                                                    }
                                                                                    if (logger != null && logger instanceof ClosableLogInterface) {
                                                                                        ((ClosableLogInterface)logger).close();
                                                                                    }
                                                                                    return;
                                                                                }
                                                                                allForms = br.getForms();
                                                                                if (allForms != null && allForms.length != 0) break block101;
                                                                                logger.info("SUBMITFORM: Cannot process Form handling because: There are no forms available");
                                                                                if (br == null) break block102;
                                                                                br.disconnect();
                                                                            }
                                                                            if (logger != null && logger instanceof ClosableLogInterface) {
                                                                                ((ClosableLogInterface)logger).close();
                                                                            }
                                                                            return;
                                                                        }
                                                                        targetform = null;
                                                                        index = 0;
                                                                        for (Form form : allForms) {
                                                                            if (StringUtils.isNotEmpty((String)form.getAction()) && formPattern.matcher(form.getAction()).matches() || form.containsHTML(formPattern.pattern())) {
                                                                                targetform = form;
                                                                                break;
                                                                            }
                                                                            ++index;
                                                                        }
                                                                        if (targetform != null) break block103;
                                                                        logger.info("Failed to find any form matching given Pattern");
                                                                        if (br == null) break block104;
                                                                        br.disconnect();
                                                                    }
                                                                    if (logger != null && logger instanceof ClosableLogInterface) {
                                                                        ((ClosableLogInterface)logger).close();
                                                                    }
                                                                    return;
                                                                }
                                                                logger.info("SUBMITFORM: Submitting form from index [" + index + "]");
                                                                nextRequest = br.createFormRequest(targetform);
                                                                next = new BrowserCrawledLink(br, (Request)nextRequest);
                                                                this.forwardCrawledLinkInfos(source, next, lm, this.getAndClearSourceURLs(source), true);
                                                                if (finalPackageName != null) {
                                                                    PackageInfo.setName(next, finalPackageName);
                                                                }
                                                                this.crawl(generation, Arrays.asList(new CrawledLink[]{next}));
                                                                if (br == null) break block105;
                                                                br.disconnect();
                                                            }
                                                            if (logger != null && logger instanceof ClosableLogInterface) {
                                                                ((ClosableLogInterface)logger).close();
                                                            }
                                                            return;
                                                        }
                                                        request = br.getRequest();
                                                        brURL = request.getURL().toExternalForm();
                                                        possibleCryptedLinks = this.find(generation, source, brURL, null, false, false);
                                                        if (possibleCryptedLinks != null) break block106;
                                                        if (br == null) break block107;
                                                        br.disconnect();
                                                    }
                                                    if (logger != null && logger instanceof ClosableLogInterface) {
                                                        ((ClosableLogInterface)logger).close();
                                                    }
                                                    return;
                                                }
                                                singleDest = possibleCryptedLinks.size() == 1;
                                                for (CrawledLink possibleCryptedLink : possibleCryptedLinks) {
                                                    this.forwardCrawledLinkInfos(deeperSource, possibleCryptedLink, lm, sourceURLs, singleDest);
                                                    if (finalPackageName == null) continue;
                                                    PackageInfo.setName(possibleCryptedLink, finalPackageName);
                                                }
                                                if (singleDest) {
                                                    deepLink = possibleCryptedLinks.get(0);
                                                } else {
                                                    deep = null;
                                                    for (CrawledLink possibleCryptedLink : possibleCryptedLinks) {
                                                        if (!StringUtils.equalsIgnoreCase((String)possibleCryptedLink.getURL(), (String)source.getURL())) continue;
                                                        deep = possibleCryptedLink;
                                                        break;
                                                    }
                                                    deepLink = deep;
                                                }
                                                if (deepLink != null) break block108;
                                                if (br == null) break block109;
                                                br.disconnect();
                                            }
                                            if (logger != null && logger instanceof ClosableLogInterface) {
                                                ((ClosableLogInterface)logger).close();
                                            }
                                            return;
                                        }
                                        finalBaseUrl = new Regex(brURL, "(https?://.*?)(\\?|$)").getMatch(0);
                                        if (matchingRule == null || matchingRule._getDeepPattern() == null) ** GOTO lbl271
                                        matches = new Regex(request.getHtmlCode(), matchingRule._getDeepPattern()).getMatches();
                                        if (matches != null && matches.length != 0) break block110;
                                        if (matchingRule.isLogging()) {
                                            logger.info("Got no matches based on user defined DeepPattern");
                                        }
                                        if (br == null) break block111;
                                        br.disconnect();
                                    }
                                    if (logger != null && logger instanceof ClosableLogInterface) {
                                        ((ClosableLogInterface)logger).close();
                                    }
                                    return;
                                }
                                dups = new HashSet<String>();
                                sb = new StringBuilder();
                                var30_54 = matches;
                                var31_55 = var30_54.length;
                                for (var32_56 = 0; var32_56 < var31_55; ++var32_56) {
                                    for (String match : matcharray = var30_54[var32_56]) {
                                        if (!StringUtils.isNotEmpty((String)match) || brURL.equals(match) || !dups.add(match)) continue;
                                        if (sb.length() > 0) {
                                            sb.append("\r\n");
                                        }
                                        sb.append(match);
                                        if (!match.matches("^[^<>\"]+$")) continue;
                                        try {
                                            url = br.getURL(match).toExternalForm();
                                            if (!dups.add(url)) continue;
                                            sb.append("\r\n").append(url);
                                        }
                                        catch (Throwable var38_63) {
                                            // empty catch block
                                        }
                                    }
                                }
                                deepPatternContent = true;
                                possibleDeepCryptedLinks = this.find(generation, source, sb.toString(), finalBaseUrl, false, false);
                                break block115;
lbl271:
                                // 1 sources

                                deepPatternContent = false;
                                possibleDeepCryptedLinks = this.find(generation, source, request.getHtmlCode(), finalBaseUrl, false, false);
                            }
                            if (possibleDeepCryptedLinks != null && possibleDeepCryptedLinks.size() != 0) break block112;
                            if (br == null) break block113;
                            br.disconnect();
                        }
                        if (logger != null && logger instanceof ClosableLogInterface) {
                            ((ClosableLogInterface)logger).close();
                        }
                        return;
                    }
                    try {
                        singleDeepCryptedDest = possibleDeepCryptedLinks.size() == 1;
                        for (CrawledLink possibleDeepCryptedLink : possibleDeepCryptedLinks) {
                            this.forwardCrawledLinkInfos(deeperSource, possibleDeepCryptedLink, lm, sourceURLs, singleDeepCryptedDest);
                            if (finalPackageName == null) continue;
                            PackageInfo.setName(possibleDeepCryptedLink, finalPackageName);
                        }
                        if (deepPatternContent && StringUtils.startsWithCaseInsensitive((String)source.getURL(), (String)deepLink.getURL())) {
                            this.crawl(generation, possibleDeepCryptedLinks);
                            break block93;
                        }
                        deepLink.setUnknownHandler(new UnknownCrawledLinkHandler(){

                            @Override
                            public void unhandledCrawledLink(CrawledLink link, LinkCrawler lc) {
                                lc.crawl(generation, possibleDeepCryptedLinks);
                            }
                        });
                        this.crawl(generation, possibleCryptedLinks);
                    }
                    catch (Throwable e) {
                        try {
                            LogController.CL().log(e);
                            logger.log(e);
                            break block114;
                        }
                        catch (Throwable var39_64) {
                            throw var39_64;
                        }
                        finally {
                            if (br != null) {
                                br.disconnect();
                            }
                            if (logger != null && logger instanceof ClosableLogInterface) {
                                ((ClosableLogInterface)logger).close();
                            }
                        }
                    }
                }
                if (br != null) {
                    br.disconnect();
                }
                if (logger != null && logger instanceof ClosableLogInterface) {
                    ((ClosableLogInterface)logger).close();
                }
            }
            finally {
                LinkCrawler.checkFinishNotify(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BrowserCrawledLink openCrawlDeeperConnectionV2(CrawledLink source, LinkCrawlerRule matchingRule, Browser br, Request req) throws Exception {
        if (req == null) {
            return null;
        }
        if (req.isRequested()) {
            return null;
        }
        br.setFollowRedirects(false);
        ArrayList<Request> previousRequests = new ArrayList<Request>();
        if (!(source instanceof BrowserCrawledLink)) {
            CrawledLink sourceLink;
            CrawledLink crawledLink = sourceLink = source != null ? source.getSourceLink() : null;
            if (sourceLink != null && StringUtils.startsWithCaseInsensitive((String)sourceLink.getURL(), (String)"http")) {
                br.setCurrentURL(sourceLink.getURL());
            }
        } else if (source instanceof BrowserCrawledLink) {
            previousRequests.addAll(((BrowserCrawledLink)source).getPreviousRequests());
        }
        if (previousRequests.size() == 0 && matchingRule != null) {
            matchingRule.applyCookiesAndHeaders(br, req.getUrl(), false);
        }
        previousRequests.add(req);
        URLConnectionAdapter con = null;
        try {
            BrowserCrawledLink next;
            List<AuthenticationFactory> authenticationFactories = AuthenticationController.getInstance().buildAuthenticationFactories(req.getURL(), null);
            for (AuthenticationFactory authenticationFactory : authenticationFactories) {
                br.setCustomAuthenticationFactory(authenticationFactory);
                con = br.openRequestConnection(req);
                if (con.getResponseCode() != 401 && con.getResponseCode() != 403 || con.getHeaderField("WWW-Authenticate") == null) break;
                br.followConnection(true);
                req.resetConnection();
                con = null;
            }
            if (con == null) {
                throw new IOException("could not open connection due to missing/wrong authentication");
            }
            if (req.getLocation() != null) {
                br.followConnection(true);
                Request nextRequest = br.createRedirectFollowingRequest(br.getRequest());
                next = new BrowserCrawledLink(br, previousRequests, nextRequest);
            } else {
                if (HTTPConnection.RequestMethod.HEAD.equals((Object)con.getRequestMethod()) || !this.getDeepInspector().looksLikeDownloadableContent(con)) {
                    br.followConnection(true);
                } else {
                    con.disconnect();
                }
                next = new BrowserCrawledLink(br, previousRequests);
            }
            if (matchingRule != null) {
                if (matchingRule.updateCookies(br, req.getUrl(), false, false)) {
                    this.updateLinkCrawlerRule(matchingRule);
                }
                next.setMatchingRule(matchingRule);
            }
            BrowserCrawledLink browserCrawledLink = next;
            return browserCrawledLink;
        }
        finally {
            con.disconnect();
        }
    }

    protected boolean distributeCrawledLink(CrawledLink crawledLink) {
        return crawledLink != null && crawledLink.gethPlugin() == null;
    }

    public boolean canHandle(LazyPlugin<? extends Plugin> lazyPlugin, String url, CrawledLink link) {
        try {
            if (lazyPlugin.canHandle(url)) {
                Plugin plugin = lazyPlugin.getPrototype(this.getPluginClassLoaderChild(), false);
                return plugin != null && plugin.canHandle(url);
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        return false;
    }

    protected DISTRIBUTE distributePluginForHost(final LazyHostPlugin pluginForHost, final LinkCrawlerGeneration generation, String url, final CrawledLink link) {
        try {
            if (this.canHandle(pluginForHost, url, link)) {
                if (this.isBlacklisted(pluginForHost)) {
                    if (LogController.getInstance().isDebugMode()) {
                        LogController.CL().info("blacklisted! " + pluginForHost);
                    }
                    return DISTRIBUTE.BLACKLISTED;
                }
                if (LinkCrawler.insideCrawlerPlugin()) {
                    if (!generation.isValid()) {
                        return DISTRIBUTE.STOP;
                    }
                    this.processHostPlugin(generation, pluginForHost, link);
                } else {
                    LinkCrawlerTask innerTask = this.checkStartNotify(generation, "distributePluginForHost:" + pluginForHost + "|" + link.getURL());
                    if (innerTask == null) {
                        return DISTRIBUTE.STOP;
                    }
                    threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                        @Override
                        public long getAverageRuntime() {
                            Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                            if (ret != null) {
                                return ret;
                            }
                            return pluginForHost.getAverageParseRuntime();
                        }

                        @Override
                        void crawling() {
                            LinkCrawler.this.processHostPlugin(generation, pluginForHost, link);
                        }
                    });
                }
                return DISTRIBUTE.NEXT;
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        return DISTRIBUTE.CONTINUE;
    }

    public boolean breakPluginForDecryptLoop(LazyCrawlerPlugin pDecrypt, CrawledLink link) {
        boolean canHandle = this.canHandle(pDecrypt, link.getURL(), link.getSourceLink());
        if (!canHandle) {
            return false;
        }
        if (!AvailableLinkState.UNKNOWN.equals((Object)link.getLinkState())) {
            return true;
        }
        HashSet<String> dontRetry = new HashSet<String>();
        for (CrawledLink source = link.getSourceLink(); source != null; source = source.getSourceLink()) {
            if (source.getCryptedLink() == null || !StringUtils.equals((String)link.getURL(), (String)source.getURL())) continue;
            LazyCrawlerPlugin lazyC = source.getCryptedLink().getLazyC();
            dontRetry.add(lazyC.getDisplayName() + lazyC.getClassName());
        }
        boolean ret = dontRetry.contains(pDecrypt.getDisplayName() + pDecrypt.getClassName());
        return ret;
    }

    protected DISTRIBUTE distributePluginForDecrypt(final LazyCrawlerPlugin pDecrypt, final LinkCrawlerGeneration generation, String url, CrawledLink link) {
        block12: {
            try {
                if (!this.canHandle(pDecrypt, url, link)) break block12;
                if (this.isBlacklisted(pDecrypt)) {
                    if (LogController.getInstance().isDebugMode()) {
                        LogController.CL().info("blacklisted! " + pDecrypt);
                    }
                    return DISTRIBUTE.BLACKLISTED;
                }
                if (this.breakPluginForDecryptLoop(pDecrypt, link)) {
                    return DISTRIBUTE.CONTINUE;
                }
                ArrayList<CrawledLink> cryptedLinks = new ArrayList<CrawledLink>();
                DISTRIBUTE result = this.getCryptedLinks(cryptedLinks, pDecrypt, link, link.getCustomCrawledLinkModifier());
                if (cryptedLinks == null || cryptedLinks.size() == 0) {
                    return result;
                }
                if (LinkCrawler.insideCrawlerPlugin()) {
                    for (CrawledLink decryptThis : cryptedLinks) {
                        if (!generation.isValid()) {
                            return DISTRIBUTE.STOP;
                        }
                        this.crawl(generation, pDecrypt, decryptThis);
                    }
                } else {
                    for (final CrawledLink decryptThis : cryptedLinks) {
                        LinkCrawlerTask innerTask = this.checkStartNotify(generation, "distributePluginForDecrypt:" + pDecrypt + "|" + link.getURL() + "|" + decryptThis.getURL());
                        if (innerTask == null) {
                            return DISTRIBUTE.STOP;
                        }
                        threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                            @Override
                            public long getAverageRuntime() {
                                Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                                if (ret != null) {
                                    return ret;
                                }
                                return pDecrypt.getAverageCrawlRuntime();
                            }

                            @Override
                            protected LinkCrawlerLock getLinkCrawlerLock() {
                                return LinkCrawler.this.getLinkCrawlerLock(pDecrypt, decryptThis);
                            }

                            @Override
                            void crawling() {
                                LinkCrawler.this.crawl(generation, pDecrypt, decryptThis);
                            }
                        });
                    }
                }
                return result;
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
        return DISTRIBUTE.CONTINUE;
    }

    protected Boolean distributePluginC(final PluginsC pluginC, final LinkCrawlerGeneration generation, String url, CrawledLink link) {
        try {
            CrawledLinkModifier lm;
            if (!pluginC.canHandle(url)) {
                return null;
            }
            CrawledLinkModifier originalModifier = link.getCustomCrawledLinkModifier();
            if (pluginC.hideLinks()) {
                final ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
                if (originalModifier != null) {
                    modifiers.add(originalModifier);
                }
                modifiers.add(new CrawledLinkModifier(){

                    @Override
                    public boolean modifyCrawledLink(CrawledLink link) {
                        DownloadLink dl = link.getDownloadLink();
                        if (dl != null) {
                            dl.setUrlProtection(UrlProtection.PROTECTED_CONTAINER);
                            return true;
                        }
                        return false;
                    }
                });
                lm = new CrawledLinkModifier(){

                    @Override
                    public boolean modifyCrawledLink(CrawledLink link) {
                        boolean ret = false;
                        for (CrawledLinkModifier mod : modifiers) {
                            if (!mod.modifyCrawledLink(link)) continue;
                            ret = true;
                        }
                        return ret;
                    }
                };
            } else {
                lm = originalModifier;
            }
            List<CrawledLink> allPossibleCryptedLinks = this.getCrawledLinks(pluginC.getSupportedLinks(), link, lm);
            if (allPossibleCryptedLinks == null) {
                return true;
            }
            if (LinkCrawler.insideCrawlerPlugin()) {
                for (CrawledLink decryptThis : allPossibleCryptedLinks) {
                    if (!generation.isValid()) {
                        return false;
                    }
                    this.container(generation, pluginC, decryptThis);
                }
            } else {
                for (final CrawledLink decryptThis : allPossibleCryptedLinks) {
                    LinkCrawlerTask innerTask = this.checkStartNotify(generation, "distributePluginC:" + pluginC.getName() + "|" + link.getURL() + "|" + decryptThis.getURL());
                    if (innerTask == null) {
                        return false;
                    }
                    threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                        @Override
                        public long getAverageRuntime() {
                            Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                            if (ret != null) {
                                return ret;
                            }
                            return super.getAverageRuntime();
                        }

                        @Override
                        void crawling() {
                            LinkCrawler.this.container(generation, pluginC, decryptThis);
                        }
                    });
                }
            }
            return true;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return null;
        }
    }

    protected DISTRIBUTE rewrite(final LinkCrawlerGeneration generation, String url, CrawledLink source) {
        try {
            LinkCrawlerRule rule = this.getFirstMatchingRule(source, url, LinkCrawlerRule.RULE.REWRITE);
            if (rule != null && rule.getRewriteReplaceWith() != null) {
                source.setMatchingRule(rule);
                String newURL = url.replaceAll(rule.getPattern(), rule.getRewriteReplaceWith());
                if (!url.equals(newURL)) {
                    CrawledLinkModifier lm = source.getCustomCrawledLinkModifier();
                    source.setCustomCrawledLinkModifier(null);
                    source.setBrokenCrawlerHandler(null);
                    final CrawledLink rewritten = this.crawledLinkFactorybyURL(newURL);
                    this.forwardCrawledLinkInfos(source, rewritten, lm, this.getAndClearSourceURLs(source), true);
                    if (LinkCrawler.insideCrawlerPlugin()) {
                        if (!generation.isValid()) {
                            return DISTRIBUTE.STOP;
                        }
                        this.distribute(generation, rewritten);
                        return DISTRIBUTE.NEXT;
                    }
                    LinkCrawlerTask innerTask = this.checkStartNotify(generation, "rewritePool:" + source.getURL() + "|" + rewritten.getURL());
                    if (innerTask != null) {
                        threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                            @Override
                            public long getAverageRuntime() {
                                Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                                if (ret != null) {
                                    return ret;
                                }
                                return super.getAverageRuntime();
                            }

                            @Override
                            void crawling() {
                                LinkCrawler.this.distribute(generation, rewritten);
                            }
                        });
                        return DISTRIBUTE.NEXT;
                    }
                    return DISTRIBUTE.STOP;
                }
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        return DISTRIBUTE.CONTINUE;
    }

    protected Boolean distributeDeeperOrMatchingRule(final LinkCrawlerGeneration generation, String url, final CrawledLink link) {
        try {
            LinkCrawlerRule rule = null;
            rule = this.getFirstMatchingRule(link, url, LinkCrawlerRule.RULE.SUBMITFORM, LinkCrawlerRule.RULE.FOLLOWREDIRECT, LinkCrawlerRule.RULE.DEEPDECRYPT);
            if (rule != null || link.isCrawlDeep()) {
                if (rule != null) {
                    link.setMatchingRule(rule);
                }
                if (LinkCrawler.insideCrawlerPlugin()) {
                    if (!generation.isValid()) {
                        return false;
                    }
                    this.crawlDeeperOrMatchingRule(generation, link);
                } else {
                    LinkCrawlerTask innerTask = this.checkStartNotify(generation, "distributeDeeperOrMatchingRulePool:" + link.getURL());
                    if (innerTask == null) {
                        return false;
                    }
                    threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                        @Override
                        public long getAverageRuntime() {
                            Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                            if (ret != null) {
                                return ret;
                            }
                            return super.getAverageRuntime();
                        }

                        @Override
                        void crawling() {
                            LinkCrawler.this.crawlDeeperOrMatchingRule(generation, link);
                        }
                    });
                }
                return true;
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        return null;
    }

    protected void distribute(LinkCrawlerGeneration generation, CrawledLink ... possibleCryptedLinks) {
        if (possibleCryptedLinks == null || possibleCryptedLinks.length == 0) {
            return;
        }
        this.distribute(generation, Arrays.asList(possibleCryptedLinks));
    }

    protected CrawledLink createCopyOf(CrawledLink source) {
        CrawledLink ret = source.getDownloadLink() != null ? new CrawledLink(source.getDownloadLink()) : (source.getCryptedLink() != null ? new CrawledLink(source.getCryptedLink()) : new CrawledLink(source.getURL()));
        ret.setSourceLink(source);
        if (source.hasCollectingInfo()) {
            ret.setCollectingInfo(source.getCollectingInfo());
        }
        ret.setSourceJob(source.getSourceJob());
        ret.setSourceUrls(source.getSourceUrls());
        ret.setOrigin(source.getOrigin());
        ret.setCrawlDeep(source.isCrawlDeep());
        if (source.hasArchiveInfo()) {
            ret.setArchiveInfo(source.getArchiveInfo());
        }
        ret.setCustomCrawledLinkModifier(source.getCustomCrawledLinkModifier());
        ret.setBrokenCrawlerHandler(source.getBrokenCrawlerHandler());
        ret.setUnknownHandler(source.getUnknownHandler());
        ret.setMatchingFilter(source.getMatchingFilter());
        ret.setMatchingRule(source.getMatchingRule());
        ret.setEnabled(source.isEnabled());
        ret.setForcedAutoStartEnabled(source.isForcedAutoStartEnabled());
        ret.setAutoConfirmEnabled(source.isAutoConfirmEnabled());
        ret.setAutoStartEnabled(source.isAutoStartEnabled());
        if (source.isNameSet()) {
            ret.setName(source._getName());
        }
        ret.setDesiredPackageInfo(source.getDesiredPackageInfo());
        ret.setParentNode(source.getParentNode());
        return ret;
    }

    protected boolean distributeFinalCrawledLink(LinkCrawlerGeneration generation, CrawledLink crawledLink) {
        if (generation != null && generation.isValid() && crawledLink != null) {
            this.handleFinalCrawledLink(generation, crawledLink);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected void distribute(LinkCrawlerGeneration generation, List<CrawledLink> possibleCryptedLinks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected DISTRIBUTE distributeEmbeddedLink(LinkCrawlerGeneration generation, String url, CrawledLink source, UnknownCrawledLinkHandler unknownCrawledLinkHandler) {
        LinkedHashSet<String> possibleEmbeddedLinks = new LinkedHashSet<String>();
        try {
            String sourceURL = source.getURL();
            String queryString = new Regex(sourceURL, "\\?(.+)$").getMatch(0);
            if (StringUtils.isNotEmpty((String)queryString)) {
                String[] parameters;
                for (String parameter : parameters = queryString.split("\\&(?!#)", -1)) {
                    try {
                        String[] params = parameter.split("=", 2);
                        String checkParam = params.length == 1 ? URLDecoder.decode(params[0], "UTF-8") : URLDecoder.decode(params[1], "UTF-8");
                        if (checkParam.startsWith("aHR0c") || checkParam.startsWith("ZnRwOi")) {
                            String base64 = checkParam;
                            while (base64.length() % 4 != 0) {
                                base64 = base64 + "=";
                            }
                            byte[] decoded = Base64.decode((String)base64);
                            if (decoded == null) continue;
                            String possibleURLs = new String(decoded, "UTF-8");
                            if (HTMLParser.getProtocol(possibleURLs) == null) {
                                possibleURLs = URLDecoder.decode(possibleURLs, "UTF-8");
                            }
                            if (HTMLParser.getProtocol(possibleURLs) == null) continue;
                            possibleEmbeddedLinks.add(possibleURLs);
                            continue;
                        }
                        try {
                            boolean validPublicSuffix;
                            URL dummyURL;
                            boolean guessProtocol;
                            String maybeURL = checkParam.contains("%3") ? URLDecoder.decode(checkParam, "UTF-8").replaceFirst("^:?/?/?", "") : checkParam.replaceFirst("^:?/?/?", "");
                            if (HTMLParser.getProtocol(maybeURL) == null) {
                                guessProtocol = true;
                                dummyURL = new URL("http://" + maybeURL.replaceFirst("^(.+?://)", ""));
                            } else {
                                guessProtocol = false;
                                dummyURL = new URL(maybeURL);
                            }
                            boolean bl = validPublicSuffix = PublicSuffixList.getInstance().getDomain(dummyURL.getHost()) != null;
                            if (!validPublicSuffix || dummyURL.getHost() == null || !dummyURL.getHost().contains(".") || !StringUtils.isNotEmpty((String)dummyURL.getFile()) && (guessProtocol || !StringUtils.isNotEmpty((String)dummyURL.getRef()))) continue;
                            possibleEmbeddedLinks.add(dummyURL.toString());
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    catch (Throwable e) {
                        LogController.CL().log(e);
                    }
                }
            }
            if (StringUtils.contains((String)sourceURL, (String)"aHR0c") || StringUtils.contains((String)sourceURL, (String)"ZnRwOi")) {
                String base64 = new Regex(sourceURL, "(aHR0c[0-9a-zA-Z\\+\\/]+(%3D|=){0,2})").getMatch(0);
                if (base64 == null) {
                    base64 = new Regex(sourceURL, "(ZnRwOi[0-9a-zA-Z\\+\\/]+(%3D|=){0,2})").getMatch(0);
                }
                if (base64 != null) {
                    if (base64.contains("%3D")) {
                        base64 = URLDecoder.decode(base64, "UTF-8");
                    }
                    while (base64.length() % 4 != 0) {
                        base64 = base64 + "=";
                    }
                    byte[] decoded = Base64.decode((String)base64);
                    if (decoded != null) {
                        String possibleURLs = new String(decoded, "UTF-8");
                        if (HTMLParser.getProtocol(possibleURLs) == null) {
                            possibleURLs = URLDecoder.decode(possibleURLs, "UTF-8");
                        }
                        if (HTMLParser.getProtocol(possibleURLs) != null) {
                            possibleEmbeddedLinks.add(possibleURLs);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        if (possibleEmbeddedLinks.size() > 0) {
            ArrayList<CrawledLink> embeddedLinks = new ArrayList<CrawledLink>();
            for (String possibleURL : possibleEmbeddedLinks) {
                List<CrawledLink> links = this.find(generation, source, possibleURL, null, source.isCrawlDeep(), false);
                if (links == null) continue;
                embeddedLinks.addAll(links);
            }
            if (embeddedLinks.size() > 0) {
                boolean singleDest = embeddedLinks.size() == 1;
                String[] sourceURLs = this.getAndClearSourceURLs(source);
                CrawledLinkModifier sourceLinkModifier = source.getCustomCrawledLinkModifier();
                source.setCustomCrawledLinkModifier(null);
                source.setBrokenCrawlerHandler(null);
                for (CrawledLink embeddedLink : embeddedLinks) {
                    embeddedLink.setUnknownHandler(unknownCrawledLinkHandler);
                    this.forwardCrawledLinkInfos(source, embeddedLink, sourceLinkModifier, sourceURLs, singleDest);
                }
                this.crawl(generation, embeddedLinks);
                return DISTRIBUTE.NEXT;
            }
        }
        return DISTRIBUTE.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkCrawlerRule> getLinkCrawlerRules() {
        List<LinkCrawlerRule> ret = this.linkCrawlerRules.get();
        if (ret == null) {
            Object object = LINKCRAWLERRULESLOCK;
            synchronized (object) {
                ret = this.linkCrawlerRules.get();
                if (ret == null) {
                    this.linkCrawlerRules.set(this.listLinkCrawlerRules());
                    return this.getLinkCrawlerRules();
                }
            }
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    protected LinkCrawlerRule getFirstMatchingRule(CrawledLink link, String url, LinkCrawlerRule.RULE ... ruleTypes) {
        List<LinkCrawlerRule> rules = this.getLinkCrawlerRules();
        if (rules == null) {
            return null;
        }
        if (StringUtils.startsWithCaseInsensitive((String)url, (String)"file:/") || StringUtils.startsWithCaseInsensitive((String)url, (String)"http://") || StringUtils.startsWithCaseInsensitive((String)url, (String)"https://")) {
            LinkCrawlerRule matchedRule;
            for (LinkCrawlerRule.RULE ruleType : ruleTypes) {
                for (LinkCrawlerRule rule : rules) {
                    if (!ruleType.equals((Object)rule.getRule()) || !rule.matches(url)) continue;
                    if (rule.getMaxDecryptDepth() == -1) {
                        return rule;
                    }
                    Iterator<CrawledLink> it = link.iterator();
                    int depth = 0;
                    while (it.hasNext()) {
                        CrawledLink next = it.next();
                        LinkCrawlerRule matchingRule = next.getMatchingRule();
                        if (matchingRule == null || matchingRule.getId() != rule.getId()) continue;
                        ++depth;
                    }
                    if (depth > rule.getMaxDecryptDepth()) continue;
                    return rule;
                }
            }
            if (link instanceof BrowserCrawledLink && (matchedRule = link.getMatchingRule()) != null) {
                for (LinkCrawlerRule.RULE ruleType : ruleTypes) {
                    if (matchedRule == null || !ruleType.equals((Object)matchedRule.getRule())) continue;
                    return matchedRule;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LazyCrawlerPlugin> getSortedLazyCrawlerPlugins() {
        List<LazyCrawlerPlugin> ret;
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.getSortedLazyCrawlerPlugins();
        }
        if (this.unsortedLazyCrawlerPlugins == null) {
            this.unsortedLazyCrawlerPlugins = CrawlerPluginController.getInstance().list();
        }
        if ((ret = this.sortedLazyCrawlerPlugins.get()) == null) {
            AtomicReference<List<LazyCrawlerPlugin>> atomicReference = this.sortedLazyCrawlerPlugins;
            synchronized (atomicReference) {
                ret = this.sortedLazyCrawlerPlugins.get();
                if (ret == null) {
                    ret = new ArrayList<LazyCrawlerPlugin>(this.unsortedLazyCrawlerPlugins.size());
                    ArrayList<LazyCrawlerPlugin> allPlugins = new ArrayList<LazyCrawlerPlugin>(this.unsortedLazyCrawlerPlugins);
                    try {
                        ArrayList<LazyCrawlerPlugin> list;
                        Object entry;
                        HashMap<String, Object> pluginMap = new HashMap<String, Object>();
                        for (LazyCrawlerPlugin plugin : allPlugins) {
                            entry = pluginMap.get(plugin.getDisplayName());
                            if (entry == null) {
                                pluginMap.put(plugin.getDisplayName(), plugin);
                                continue;
                            }
                            if (entry instanceof List) {
                                ((List)entry).add(plugin);
                                continue;
                            }
                            list = new ArrayList<LazyCrawlerPlugin>();
                            list.add((LazyCrawlerPlugin)entry);
                            list.add(plugin);
                            pluginMap.put(plugin.getDisplayName(), list);
                        }
                        Collections.sort(allPlugins, new Comparator<LazyCrawlerPlugin>(){

                            @Override
                            public final int compare(long x, long y) {
                                return x < y ? 1 : (x == y ? 0 : -1);
                            }

                            @Override
                            public final int compare(boolean x, boolean y) {
                                return x == y ? 0 : (x ? 1 : -1);
                            }

                            @Override
                            public int compare(LazyCrawlerPlugin o1, LazyCrawlerPlugin o2) {
                                int ret = this.compare(o1.getPluginUsage(), o2.getPluginUsage());
                                if (ret == 0) {
                                    return this.compare(o1.hasFeature(LazyPlugin.FEATURE.GENERIC), o2.hasFeature(LazyPlugin.FEATURE.GENERIC));
                                }
                                return ret;
                            }
                        });
                        for (LazyCrawlerPlugin plugin : allPlugins) {
                            entry = pluginMap.remove(plugin.getDisplayName());
                            if (entry == null) {
                                if (!pluginMap.isEmpty()) continue;
                                break;
                            }
                            if (entry instanceof LazyCrawlerPlugin) {
                                ret.add((LazyCrawlerPlugin)entry);
                                continue;
                            }
                            list = (List)entry;
                            this.sortLazyCrawlerPluginByInterfaceVersion(list);
                            ret.addAll(list);
                        }
                    }
                    catch (Throwable e) {
                        LogController.CL(true).log(e);
                    }
                    if (ret == null || ret.size() == 0) {
                        ret = allPlugins;
                    }
                    this.sortedLazyCrawlerPlugins.compareAndSet(null, ret);
                }
            }
        }
        return ret;
    }

    protected void sortLazyCrawlerPluginByInterfaceVersion(List<LazyCrawlerPlugin> plugins) {
        Collections.sort(plugins, new Comparator<LazyCrawlerPlugin>(){

            @Override
            public final int compare(LazyCrawlerPlugin lazyCrawlerPlugin1, LazyCrawlerPlugin lazyCrawlerPlugin2) {
                int i2;
                int i1 = lazyCrawlerPlugin1.getLazyPluginClass().getInterfaceVersion();
                if (i1 == (i2 = lazyCrawlerPlugin2.getLazyPluginClass().getInterfaceVersion())) {
                    return 0;
                }
                if (i1 > i2) {
                    return -1;
                }
                return 1;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LazyHostPlugin> getSortedLazyHostPlugins() {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.getSortedLazyHostPlugins();
        }
        List<LazyHostPlugin> ret = this.sortedLazyHostPlugins.get();
        if (ret == null) {
            AtomicReference<List<LazyHostPlugin>> atomicReference = this.sortedLazyHostPlugins;
            synchronized (atomicReference) {
                ret = this.sortedLazyHostPlugins.get();
                if (ret == null) {
                    ret = new ArrayList<LazyHostPlugin>();
                    for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
                        if (HTTP_LINKS.equals(lazyHostPlugin.getDisplayName()) || "ftp".equals(lazyHostPlugin.getDisplayName()) || DIRECT_HTTP.equals(lazyHostPlugin.getDisplayName())) continue;
                        ret.add(lazyHostPlugin);
                    }
                    try {
                        Collections.sort(ret, new Comparator<LazyHostPlugin>(){

                            @Override
                            public final int compare(long x, long y) {
                                return x < y ? 1 : (x == y ? 0 : -1);
                            }

                            @Override
                            public final int compare(LazyHostPlugin o1, LazyHostPlugin o2) {
                                return this.compare(o1.getPluginUsage(), o2.getPluginUsage());
                            }
                        });
                    }
                    catch (Throwable e) {
                        LogController.CL(true).log(e);
                    }
                    this.sortedLazyHostPlugins.compareAndSet(null, ret);
                }
            }
        }
        return ret;
    }

    protected boolean resetSortedLazyCrawlerPlugins(List<LazyCrawlerPlugin> resetSortedLazyCrawlerPlugins) {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.resetSortedLazyCrawlerPlugins(resetSortedLazyCrawlerPlugins);
        }
        return this.sortedLazyCrawlerPlugins.compareAndSet(resetSortedLazyCrawlerPlugins, null);
    }

    protected boolean resetSortedLazyHostPlugins(List<LazyHostPlugin> lazyHostPlugins) {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.resetSortedLazyHostPlugins(lazyHostPlugins);
        }
        return this.sortedLazyHostPlugins.compareAndSet(lazyHostPlugins, null);
    }

    protected LinkCrawlerConfig.DirectHTTPPermission getDirectHTTPPermission() {
        return this.directHTTPPermission;
    }

    public DISTRIBUTE getCryptedLinks(List<CrawledLink> results, LazyCrawlerPlugin lazyC, CrawledLink source, CrawledLinkModifier modifier) {
        String[] matches = this.getMatchingLinks(lazyC.getPattern(), source, modifier);
        if (matches == null || matches.length == 0) {
            return DISTRIBUTE.NEXT;
        }
        DISTRIBUTE result = null;
        String sourceURL = source.getURL();
        for (String match : matches) {
            CryptedLink cryptedLink = matches.length == 1 && match.equals(sourceURL) ? new CryptedLink(source) : new CryptedLink(match, source);
            if (result == null) {
                if (match.equals(source.getURL())) {
                    result = DISTRIBUTE.NEXT;
                } else {
                    Matcher firstHttp = Pattern.compile("https?://").matcher(sourceURL);
                    int firstHttpIndex = firstHttp.find() ? firstHttp.start() : -1;
                    result = firstHttpIndex == sourceURL.indexOf(match) ? DISTRIBUTE.NEXT : DISTRIBUTE.PARTIAL_MATCH;
                }
            }
            cryptedLink.setLazyC(lazyC);
            CrawledLink link = this.crawledLinkFactorybyCryptedLink(cryptedLink);
            this.forwardCrawledLinkInfos(source, link, modifier, null, null);
            if ((source.getUrlLink() == null || StringUtils.equals((String)source.getUrlLink(), (String)link.getURL())) && (source.getDownloadLink() == null || source.getDownloadLink().getProperties().isEmpty())) {
                link.setCrawlDeep(source.isCrawlDeep());
                link.setSourceLink(source.getSourceLink());
                if (!(cryptedLink.getSource() instanceof String)) {
                    cryptedLink.setCryptedUrl(match);
                }
                cryptedLink.setSourceLink(source.getSourceLink());
                LinkCrawlerRule sourceMatchingRule = source.getMatchingRule();
                if (sourceMatchingRule != null) {
                    link.setMatchingRule(sourceMatchingRule);
                }
            }
            results.add(link);
        }
        return result;
    }

    protected String[] getMatchingLinks(Pattern pattern, CrawledLink source, CrawledLinkModifier modifier) {
        String[] ret = new Regex(source.getURL(), pattern).getColumn(-1);
        if (ret == null || ret.length == 0) {
            return null;
        }
        for (int index = 0; index < ret.length; ++index) {
            String match = ret[index];
            match = match.trim();
            while (match.length() > 2 && match.charAt(0) == '<' && match.charAt(match.length() - 1) == '>') {
                match = match.substring(1, match.length() - 1);
            }
            while (match.length() > 2 && match.charAt(0) == '\"' && match.charAt(match.length() - 1) == '\"') {
                match = match.substring(1, match.length() - 1);
            }
            ret[index] = match.trim();
            if (!StringUtils.equals((String)source.getURL(), (String)ret[index])) continue;
            ret[index] = source.getURL();
        }
        return ret;
    }

    public List<CrawledLink> getCrawledLinks(Pattern pattern, CrawledLink source, CrawledLinkModifier modifier) {
        String[] matches = this.getMatchingLinks(pattern, source, modifier);
        if (matches == null || matches.length == 0) {
            return null;
        }
        ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
        for (String match : matches) {
            CrawledLink link = this.crawledLinkFactorybyURL(match);
            this.forwardCrawledLinkInfos(source, link, modifier, null, null);
            if ((source.getUrlLink() == null || StringUtils.equals((String)source.getUrlLink(), (String)link.getURL())) && (source.getDownloadLink() == null || source.getDownloadLink().getProperties().isEmpty())) {
                link.setSourceLink(source.getSourceLink());
                if (source.getMatchingRule() != null) {
                    link.setMatchingRule(source.getMatchingRule());
                }
            }
            ret.add(link);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHostPlugin(LinkCrawlerGeneration generation, LazyHostPlugin pHost, CrawledLink possibleCryptedLink) {
        block32: {
            CrawledLinkModifier parentLinkModifier = possibleCryptedLink.getCustomCrawledLinkModifier();
            possibleCryptedLink.setCustomCrawledLinkModifier(null);
            possibleCryptedLink.setBrokenCrawlerHandler(null);
            if (pHost == null) {
                return;
            }
            if (possibleCryptedLink.getURL() == null) {
                return;
            }
            if (this.isCrawledLinkFiltered(possibleCryptedLink)) {
                return;
            }
            LinkCrawlerTask task = this.checkStartNotify(generation, "processHostPlugin:" + pHost + "|" + possibleCryptedLink.getURL());
            if (task == null) {
                return;
            }
            try {
                String[] sourceURLs = this.getAndClearSourceURLs(possibleCryptedLink);
                PluginForHost wplg = pHost.newInstance(this.getPluginClassLoaderChild());
                if (wplg == null) {
                    LogController.CL().info("Hoster Plugin not available:" + pHost.getDisplayName());
                    return;
                }
                LinkCrawlerThread lct = this.getCurrentLinkCrawlerThread();
                Object owner = null;
                LinkCrawler previousCrawler = null;
                boolean oldDebug = false;
                boolean oldVerbose = false;
                LogInterface oldLogger = null;
                try {
                    LogSource logger = LogController.getFastPluginLogger(wplg.getCrawlerLoggerID(possibleCryptedLink));
                    logger.info("Processing: " + possibleCryptedLink.getURL());
                    if (lct != null) {
                        owner = lct.getCurrentOwner();
                        lct.setCurrentOwner(wplg);
                        previousCrawler = lct.getCurrentLinkCrawler();
                        lct.setCurrentLinkCrawler(this);
                        oldLogger = lct.getLogger();
                        oldDebug = lct.isDebug();
                        oldVerbose = lct.isVerbose();
                        lct.setLogger((LogInterface)logger);
                        lct.setVerbose(true);
                        lct.setDebug(true);
                    }
                    Browser br = wplg.createNewBrowserInstance();
                    wplg.setBrowser(br);
                    wplg.setLogger((LogInterface)logger);
                    wplg.init();
                    String url = possibleCryptedLink.getURL();
                    FilePackage sourcePackage = null;
                    if (possibleCryptedLink.getDownloadLink() != null && FilePackage.isDefaultFilePackage(sourcePackage = possibleCryptedLink.getDownloadLink().getFilePackage())) {
                        sourcePackage = null;
                    }
                    long startTime = Time.systemIndependentCurrentJVMTimeMillis();
                    ArrayList<CrawledLink> crawledLinks = new ArrayList<CrawledLink>();
                    try {
                        wplg.setCurrentLink(possibleCryptedLink);
                        ArrayList<DownloadLink> hosterLinks = wplg.getDownloadLinks(possibleCryptedLink, url, sourcePackage);
                        if (hosterLinks != null) {
                            UrlProtection protection = wplg.getUrlProtection(hosterLinks);
                            if (protection != null && protection != UrlProtection.UNSET) {
                                for (DownloadLink dl : hosterLinks) {
                                    if (dl.getUrlProtection() != UrlProtection.UNSET) continue;
                                    dl.setUrlProtection(protection);
                                }
                            }
                            for (DownloadLink hosterLink : hosterLinks) {
                                try {
                                    wplg.correctDownloadLink(hosterLink);
                                }
                                catch (Throwable e) {
                                    LogController.CL().log(e);
                                }
                                crawledLinks.add(wplg.convert(hosterLink));
                            }
                        }
                        if (logger instanceof ClearableLogInterface) {
                            ((ClearableLogInterface)logger).clear();
                        }
                    }
                    finally {
                        wplg.clean();
                        wplg.setCurrentLink(null);
                        long endTime = Time.systemIndependentCurrentJVMTimeMillis() - startTime;
                        pHost.updateParseRuntime(endTime);
                        if (logger instanceof ClosableLogInterface) {
                            ((ClosableLogInterface)logger).close();
                        }
                    }
                    if (crawledLinks.size() > 0) {
                        boolean singleDest = crawledLinks.size() == 1;
                        for (CrawledLink crawledLink : crawledLinks) {
                            this.forwardCrawledLinkInfos(possibleCryptedLink, crawledLink, parentLinkModifier, sourceURLs, singleDest);
                            if (possibleCryptedLink.getUrlLink() == null || StringUtils.equals((String)possibleCryptedLink.getUrlLink(), (String)crawledLink.getURL())) {
                                crawledLink.setSourceLink(possibleCryptedLink.getSourceLink());
                                LinkCrawlerRule matchingRule = possibleCryptedLink.getMatchingRule();
                                if (matchingRule != null) {
                                    crawledLink.setMatchingRule(matchingRule);
                                }
                            }
                            this.distributeFinalCrawledLink(generation, crawledLink);
                        }
                    }
                    if (lct == null) break block32;
                    lct.setCurrentOwner(owner);
                    lct.setCurrentLinkCrawler(previousCrawler);
                }
                catch (Throwable throwable) {
                    if (lct != null) {
                        lct.setCurrentOwner(owner);
                        lct.setCurrentLinkCrawler(previousCrawler);
                        lct.setLogger(oldLogger);
                        lct.setVerbose(oldVerbose);
                        lct.setDebug(oldDebug);
                    }
                    throw throwable;
                }
                lct.setLogger(oldLogger);
                lct.setVerbose(oldVerbose);
                lct.setDebug(oldDebug);
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
            finally {
                LinkCrawler.checkFinishNotify(task);
            }
        }
    }

    public String[] getAndClearSourceURLs(CrawledLink link) {
        ArrayList<String> sources = new ArrayList<String>();
        CrawledLink next = link;
        CrawledLink previous = link;
        while (next != null) {
            CrawledLink current = next;
            next = current.getSourceLink();
            String currentURL = LinkCrawler.cleanURL(current.getURL());
            if (currentURL != null) {
                String previousURL;
                if (sources.size() == 0) {
                    sources.add(currentURL);
                } else if (!(current.getMatchingRule() != null && current.getMatchingRule() == previous.getMatchingRule() || StringUtils.equals((String)currentURL, (String)(previousURL = (String)sources.get(sources.size() - 1))))) {
                    sources.add(currentURL);
                }
            }
            previous = current;
        }
        link.setSourceUrls(null);
        String customSourceUrl = this.getReferrerUrl(link);
        if (customSourceUrl != null) {
            sources.add(customSourceUrl);
        }
        if (sources.size() == 0) {
            return null;
        }
        return sources.toArray(new String[0]);
    }

    public String getReferrerUrl(CrawledLink link) {
        String customSourceUrl;
        LinkCollectingJob job;
        if (link != null && (job = link.getSourceJob()) != null && (customSourceUrl = job.getCustomSourceUrl()) != null) {
            return customSourceUrl;
        }
        if (this instanceof LinkCollector.JobLinkCrawler && (job = ((LinkCollector.JobLinkCrawler)this).getJob()) != null) {
            return job.getCustomSourceUrl();
        }
        return null;
    }

    public static String getUnsafeName(String unsafeName, String currentName) {
        if (unsafeName == null) {
            return null;
        }
        String extension = Files.getExtension((String)unsafeName);
        if (extension == null && unsafeName.indexOf(46) < 0) {
            String unsafeSourceModified = null;
            if (unsafeName.indexOf(95) > 0) {
                unsafeSourceModified = unsafeName.replaceAll("_", ".");
                extension = Files.getExtension((String)unsafeSourceModified);
            }
            if (extension == null && unsafeName.indexOf(45) > 0) {
                unsafeSourceModified = unsafeName.replaceAll("-", ".");
                extension = Files.getExtension((String)unsafeSourceModified);
            }
            if (extension != null) {
                unsafeName = unsafeSourceModified;
            }
        }
        if (extension != null && !StringUtils.equals((String)currentName, (String)unsafeName)) {
            return unsafeName;
        }
        return null;
    }

    private DownloadLink getLatestDownloadLink(CrawledLink link) {
        DownloadLink ret = link.getDownloadLink();
        if (ret == null && link.getSourceLink() != null) {
            return link.getSourceLink().getDownloadLink();
        }
        return ret;
    }

    private CryptedLink getLatestCryptedLink(CrawledLink link) {
        CryptedLink ret = link.getCryptedLink();
        if (ret == null && link.getSourceLink() != null) {
            return link.getSourceLink().getCryptedLink();
        }
        return ret;
    }

    private void forwardCryptedLinkInfos(CrawledLink sourceCrawledLink, CryptedLink destCryptedLink) {
        CryptedLink latestCryptedLink;
        if (sourceCrawledLink == null) {
            return;
        }
        if (destCryptedLink == null) {
            return;
        }
        String pw = null;
        DownloadLink latestDownloadLink = this.getLatestDownloadLink(sourceCrawledLink);
        if (latestDownloadLink != null) {
            pw = latestDownloadLink.getDownloadPassword();
        }
        if (StringUtils.isEmpty(pw) && (latestCryptedLink = this.getLatestCryptedLink(sourceCrawledLink)) != null) {
            pw = latestCryptedLink.getDecrypterPassword();
        }
        if (StringUtils.isEmpty((String)pw) && this instanceof LinkCollector.JobLinkCrawler && ((LinkCollector.JobLinkCrawler)this).getJob() != null) {
            pw = ((LinkCollector.JobLinkCrawler)this).getJob().getCrawlerPassword();
        }
        destCryptedLink.setDecrypterPassword(pw);
    }

    protected void forwardCrawledLinkInfos(CrawledLink sourceCrawledLink, CrawledLink destCrawledLink, CrawledLinkModifier sourceLinkModifier, String[] sourceURLs, Boolean singleDestCrawledLink) {
        CrawledLinkModifier destCustomModifier;
        if (sourceCrawledLink == null || destCrawledLink == null || sourceCrawledLink == destCrawledLink) {
            return;
        }
        destCrawledLink.setSourceLink(sourceCrawledLink);
        destCrawledLink.setOrigin(sourceCrawledLink.getOrigin());
        destCrawledLink.setSourceUrls(sourceURLs);
        destCrawledLink.setMatchingFilter(sourceCrawledLink.getMatchingFilter());
        this.forwardCryptedLinkInfos(sourceCrawledLink, destCrawledLink.getCryptedLink());
        this.forwardDownloadLinkInfos(this.getLatestDownloadLink(sourceCrawledLink), destCrawledLink.getDownloadLink(), singleDestCrawledLink);
        if (Boolean.TRUE.equals(singleDestCrawledLink) && sourceCrawledLink.isNameSet()) {
            destCrawledLink.setName(sourceCrawledLink.getName());
        }
        if ((destCustomModifier = destCrawledLink.getCustomCrawledLinkModifier()) == null) {
            destCrawledLink.setCustomCrawledLinkModifier(sourceLinkModifier);
        } else if (sourceLinkModifier != null) {
            ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
            modifiers.add(sourceLinkModifier);
            modifiers.add(destCustomModifier);
            destCrawledLink.setCustomCrawledLinkModifier(new CrawledLinkModifiers(modifiers));
        }
        PackageInfo dpi = sourceCrawledLink.getDesiredPackageInfo();
        if (dpi != null) {
            destCrawledLink.setDesiredPackageInfo(dpi.getCopy());
        }
        ArchiveInfo destArchiveInfo = destCrawledLink.hasArchiveInfo() ? destCrawledLink.getArchiveInfo() : null;
        if (sourceCrawledLink.hasArchiveInfo()) {
            if (destArchiveInfo == null) {
                destCrawledLink.setArchiveInfo(new ArchiveInfo().migrate(sourceCrawledLink.getArchiveInfo()));
            } else {
                destArchiveInfo.migrate(sourceCrawledLink.getArchiveInfo());
            }
        }
        this.convertFilePackageInfos(destCrawledLink);
        this.permanentOffline(destCrawledLink);
    }

    private PackageInfo convertFilePackageInfos(CrawledLink link) {
        Boolean allowInheritance;
        Boolean ignoreVarious;
        String packageKey;
        Boolean allowMerge;
        String name;
        Boolean allowInheritance2;
        if (link.getDownloadLink() == null) {
            return null;
        }
        FilePackage fp = link.getDownloadLink().getFilePackage();
        if (FilePackage.isDefaultFilePackage(fp)) {
            return null;
        }
        fp.remove(link.getDownloadLink());
        if (link.getDesiredPackageInfo() != null && Boolean.TRUE.equals(link.getDesiredPackageInfo().isAllowInheritance()) && ((allowInheritance2 = fp.isAllowInheritance()) == null || allowInheritance2 == Boolean.FALSE)) {
            return link.getDesiredPackageInfo();
        }
        PackageInfo fpi = null;
        if (StringUtils.isNotEmpty((String)fp.getDownloadDirectory()) && !fp.getDownloadDirectory().equals(this.defaultDownloadFolder)) {
            if (fpi == null && (fpi = link.getDesiredPackageInfo()) == null) {
                fpi = new PackageInfo();
            }
            fpi.setDestinationFolder(CrossSystem.fixPathSeparators((String)(fp.getDownloadDirectory() + File.separator)));
        }
        if (StringUtils.isNotEmpty((String)(name = fp.getName()))) {
            if (fpi == null && (fpi = link.getDesiredPackageInfo()) == null) {
                fpi = new PackageInfo();
            }
            fpi.setName(name);
        }
        if ((allowMerge = fp.isAllowMerge()) != null) {
            if (allowMerge == Boolean.TRUE) {
                if (fpi != null || (fpi = link.getDesiredPackageInfo()) != null) {
                    fpi.setUniqueId(null);
                }
            } else {
                if (fpi == null && (fpi = link.getDesiredPackageInfo()) == null) {
                    fpi = new PackageInfo();
                }
                fpi.setUniqueId(fp.getUniqueID());
            }
        }
        if ((packageKey = fp.getPackageKey()) != null) {
            if (fpi == null && (fpi = link.getDesiredPackageInfo()) == null) {
                fpi = new PackageInfo();
            }
            fpi.setPackageKey(packageKey);
        }
        if ((ignoreVarious = fp.isIgnoreVarious()) != null) {
            if (fpi == null && (fpi = link.getDesiredPackageInfo()) == null) {
                fpi = new PackageInfo();
            }
            fpi.setIgnoreVarious(ignoreVarious);
        }
        if ((allowInheritance = fp.isAllowInheritance()) != null) {
            if (fpi == null && (fpi = link.getDesiredPackageInfo()) == null) {
                fpi = new PackageInfo();
            }
            fpi.setAllowInheritance(allowInheritance);
        }
        if (StringUtils.isNotEmpty((String)fp.getComment())) {
            if (fpi == null && (fpi = link.getDesiredPackageInfo()) == null) {
                fpi = new PackageInfo();
            }
            fpi.setComment(fp.getComment());
        }
        if (fpi != null) {
            link.setDesiredPackageInfo(fpi);
        }
        return fpi;
    }

    private void permanentOffline(CrawledLink link) {
        DownloadLink dl = link.getDownloadLink();
        if (dl == null) {
            return;
        }
        try {
            if (dl.getDefaultPlugin().getLazyP().isOfflinePlugin()) {
                PackageInfo dpi = link.getDesiredPackageInfo() == null ? new PackageInfo() : link.getDesiredPackageInfo();
                dpi.setUniqueId(PERMANENT_OFFLINE_ID);
                link.setDesiredPackageInfo(dpi);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void forwardDownloadLinkInfos(DownloadLink sourceDownloadLink, DownloadLink destDownloadLink, Boolean singleDestDownloadLink) {
        if (sourceDownloadLink == null || destDownloadLink == null || sourceDownloadLink == destDownloadLink) {
            return;
        }
        List<String> srcPWs = sourceDownloadLink.getSourcePluginPasswordList();
        if (srcPWs != null && srcPWs.size() > 0) {
            destDownloadLink.setSourcePluginPasswordList(new ArrayList<String>(srcPWs));
        }
        if (sourceDownloadLink.getComment() != null && destDownloadLink.getComment() == null) {
            destDownloadLink.setComment(sourceDownloadLink.getComment());
        }
        if (sourceDownloadLink.getContainerUrl() != null && destDownloadLink.getContainerUrl() == null) {
            destDownloadLink.setContainerUrl(sourceDownloadLink.getContainerUrl());
        }
        if (destDownloadLink.getUrlProtection() == UrlProtection.UNSET && sourceDownloadLink.getUrlProtection() != UrlProtection.UNSET) {
            destDownloadLink.setUrlProtection(sourceDownloadLink.getUrlProtection());
        }
        if (Boolean.TRUE.equals(singleDestDownloadLink)) {
            Map<String, Object> sourceProperties;
            if (!destDownloadLink.isNameSet()) {
                if (sourceDownloadLink.isNameSet()) {
                    destDownloadLink.setName(sourceDownloadLink.getName());
                } else {
                    String name = LinkCrawler.getUnsafeName(sourceDownloadLink.getName(), destDownloadLink.getName());
                    if (name != null) {
                        destDownloadLink.setName(name);
                    }
                }
            }
            if (sourceDownloadLink.getForcedFileName() != null && destDownloadLink.getForcedFileName() == null) {
                destDownloadLink.setForcedFileName(sourceDownloadLink.getForcedFileName());
            }
            if (sourceDownloadLink.getFinalFileName() != null && destDownloadLink.getFinalFileName() == null) {
                destDownloadLink.setFinalFileName(sourceDownloadLink.getFinalFileName());
            }
            if (sourceDownloadLink.isAvailabilityStatusChecked() && sourceDownloadLink.getAvailableStatus() != destDownloadLink.getAvailableStatus() && !destDownloadLink.isAvailabilityStatusChecked()) {
                destDownloadLink.setAvailableStatus(sourceDownloadLink.getAvailableStatus());
            }
            if (sourceDownloadLink.getContentUrl() != null && destDownloadLink.getContentUrl() == null) {
                destDownloadLink.setContentUrl(sourceDownloadLink.getContentUrl());
            }
            if (sourceDownloadLink.getVerifiedFileSize() >= 0L && destDownloadLink.getVerifiedFileSize() < 0L) {
                destDownloadLink.setVerifiedFileSize(sourceDownloadLink.getVerifiedFileSize());
            }
            if (sourceDownloadLink.hasTempProperties()) {
                destDownloadLink.getTempProperties().setProperties(sourceDownloadLink.getTempProperties().getProperties());
            }
            if ((sourceProperties = sourceDownloadLink.getProperties()) != null && !sourceProperties.isEmpty()) {
                Map<String, Object> destProperties = destDownloadLink.getProperties();
                if (destProperties == null || destProperties.isEmpty()) {
                    destDownloadLink.setProperties(sourceProperties);
                } else {
                    for (Map.Entry<String, Object> property : sourceProperties.entrySet()) {
                        if (destDownloadLink.hasProperty(property.getKey())) continue;
                        destDownloadLink.setProperty(property.getKey(), property.getValue());
                    }
                }
            }
            if (sourceDownloadLink.getView().getBytesTotal() >= 0L && destDownloadLink.getKnownDownloadSize() < 0L) {
                destDownloadLink.setDownloadSize(sourceDownloadLink.getView().getBytesTotal());
            }
        }
    }

    public void stopCrawling() {
        this.stopCrawling(true);
    }

    public void stopCrawling(boolean stopChildren) {
        LinkCrawlerGeneration generation = this.linkCrawlerGeneration.getAndSet(null);
        if (generation != null) {
            generation.invalidate();
        }
        if (stopChildren) {
            for (LinkCrawler child : this.getChildren()) {
                child.stopCrawling(true);
            }
        }
    }

    public boolean waitForCrawling() {
        return this.waitForCrawling(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCrawling(boolean waitForChildren) {
        while (this.isRunning(waitForChildren)) {
            Object object = WAIT;
            synchronized (object) {
                if (this.isRunning(waitForChildren)) {
                    try {
                        WAIT.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
        return !this.isRunning(waitForChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkCrawler> getChildren() {
        WeakHashMap<LinkCrawler, Object> weakHashMap = this.children;
        synchronized (weakHashMap) {
            return new ArrayList<LinkCrawler>(this.children.keySet());
        }
    }

    public LinkCrawler getRoot() {
        LinkCrawler parent = this.getParent();
        if (parent != null) {
            return parent.getRoot();
        }
        return this;
    }

    public boolean isRunning() {
        return this.isRunning(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning(boolean checkChildren) {
        Set<LinkCrawler> set = CRAWLER;
        synchronized (set) {
            if (this.tasks.size() > 0) {
                return true;
            }
        }
        if (checkChildren) {
            for (LinkCrawler child : this.getChildren()) {
                if (!child.isRunning(true)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCrawling() {
        Set<LinkCrawler> set = CRAWLER;
        synchronized (set) {
            return CRAWLER.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void container(final LinkCrawlerGeneration generation, PluginsC oplg, CrawledLink cryptedLink) {
        parentLinkModifier = cryptedLink.getCustomCrawledLinkModifier();
        cryptedLink.setCustomCrawledLinkModifier(null);
        cryptedLink.setBrokenCrawlerHandler(null);
        if (oplg == null) return;
        if (cryptedLink.getURL() == null) {
            return;
        }
        if (this.isCrawledLinkDuplicated(this.duplicateFinderContainer, cryptedLink)) {
            this.onCrawledLinkDuplicate(cryptedLink, DUPLICATE.CONTAINER);
            return;
        }
        if (this.isCrawledLinkFiltered(cryptedLink)) {
            return;
        }
        task = this.checkStartNotify(generation, "containerPlugin:" + oplg.getName() + "|" + cryptedLink.getURL());
        if (task == null) {
            return;
        }
        try {
            block32: {
                block33: {
                    sourceURLs = this.getAndClearSourceURLs(cryptedLink);
                    this.processedLinksCounter.incrementAndGet();
                    try {
                        plg = oplg.newPluginInstance();
                    }
                    catch (Throwable e) {
                        LogController.CL().log(e);
                        LinkCrawler.checkFinishNotify(task);
                        return;
                    }
                    lct = this.getCurrentLinkCrawlerThread();
                    owner = null;
                    previousCrawler = null;
                    oldDebug = false;
                    oldVerbose = false;
                    oldLogger = null;
                    try {
                        logger = LogController.getFastPluginLogger(plg.getName());
                        if (lct != null) {
                            owner = lct.getCurrentOwner();
                            lct.setCurrentOwner(plg);
                            previousCrawler = lct.getCurrentLinkCrawler();
                            lct.setCurrentLinkCrawler(this);
                            oldLogger = lct.getLogger();
                            oldDebug = lct.isDebug();
                            oldVerbose = lct.isVerbose();
                            lct.setLogger((LogInterface)logger);
                            lct.setVerbose(true);
                            lct.setDebug(true);
                        }
                        plg.setLogger((LogInterface)logger);
                        decryptedPossibleLinks = plg.decryptContainer(cryptedLink);
                        if (logger instanceof ClearableLogInterface) {
                            ((ClearableLogInterface)logger).clear();
                        }
                        if (decryptedPossibleLinks == null || decryptedPossibleLinks.size() == 0) {
                        }
                        ** GOTO lbl-1000
                        if (logger instanceof ClosableLogInterface) {
                            ((ClosableLogInterface)logger).close();
                        }
                        if (lct == null) return;
                        lct.setCurrentOwner(owner);
                        lct.setCurrentLinkCrawler(previousCrawler);
                    }
                    catch (Throwable var20_21) {
                        if (lct == null) throw var20_21;
                        lct.setCurrentOwner(owner);
                        lct.setCurrentLinkCrawler(previousCrawler);
                        lct.setLogger(oldLogger);
                        lct.setVerbose(oldVerbose);
                        lct.setDebug(oldDebug);
                        throw var20_21;
                    }
                    lct.setLogger(oldLogger);
                    lct.setVerbose(oldVerbose);
                    lct.setDebug(oldDebug);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        singleDest = decryptedPossibleLinks.size() == 1;
                        for (CrawledLink decryptedPossibleLink : decryptedPossibleLinks) {
                            this.forwardCrawledLinkInfos(cryptedLink, decryptedPossibleLink, parentLinkModifier, sourceURLs, singleDest);
                        }
                        if (!LinkCrawler.insideCrawlerPlugin()) ** GOTO lbl90
                        if (generation.isValid()) ** GOTO lbl-1000
                    }
                    if (logger instanceof ClosableLogInterface) {
                        ((ClosableLogInterface)logger).close();
                    }
                    if (lct == null) return;
                    lct.setCurrentOwner(owner);
                    lct.setCurrentLinkCrawler(previousCrawler);
                    lct.setLogger(oldLogger);
                    lct.setVerbose(oldVerbose);
                    lct.setDebug(oldDebug);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        this.distribute(generation, decryptedPossibleLinks);
                        break block32;
lbl90:
                        // 1 sources

                        innerTask = this.checkStartNotify(generation, task.getTaskID() + "|containerPool");
                        if (innerTask != null) break block33;
                    }
                    if (logger instanceof ClosableLogInterface) {
                        ((ClosableLogInterface)logger).close();
                    }
                    if (lct == null) return;
                    lct.setCurrentOwner(owner);
                    lct.setCurrentLinkCrawler(previousCrawler);
                    lct.setLogger(oldLogger);
                    lct.setVerbose(oldVerbose);
                    lct.setDebug(oldDebug);
                    return;
                }
                ** try [egrp 13[TRYBLOCK] [4 : 616->637)] { 
lbl103:
                // 1 sources

                LinkCrawler.threadPool.execute(new LinkCrawlerRunnable(this, generation, innerTask){

                    @Override
                    public long getAverageRuntime() {
                        Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                        if (ret != null) {
                            return ret;
                        }
                        return super.getAverageRuntime();
                    }

                    @Override
                    void crawling() {
                        LinkCrawler.this.distribute(generation, decryptedPossibleLinks);
                    }
                });
                break block32;
lbl105:
                // 1 sources

                finally {
                    if (logger instanceof ClosableLogInterface) {
                        ((ClosableLogInterface)logger).close();
                    }
                }
            }
            if (lct == null) return;
            lct.setCurrentOwner(owner);
            lct.setCurrentLinkCrawler(previousCrawler);
            lct.setLogger(oldLogger);
            lct.setVerbose(oldVerbose);
            lct.setDebug(oldDebug);
            return;
        }
        finally {
            LinkCrawler.checkFinishNotify(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDuplicatedCrawling(LazyCrawlerPlugin lazyC, CrawledLink cryptedLink) {
        String url = cryptedLink.getURL();
        try {
            URL tmp = URLHelper.createURL((String)url);
            String urlDecodedPath = URLDecoder.decode(tmp.getPath(), "UTF-8");
            if (!StringUtils.equals((String)tmp.getPath(), (String)urlDecodedPath)) {
                url = URLHelper.createURL((String)tmp.getProtocol(), (String)tmp.getUserInfo(), (String)tmp.getHost(), (int)tmp.getPort(), (String)urlDecodedPath, (String)tmp.getQuery(), (String)tmp.getRef());
            } else if (!StringUtils.contains((String)url, (String)tmp.getHost())) {
                url = tmp.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<LazyCrawlerPlugin, Set<String>> map = this.duplicateFinderCrawler;
        synchronized (map) {
            Set<String> set = this.duplicateFinderCrawler.get(lazyC);
            if (set == null) {
                set = new HashSet<String>();
                this.duplicateFinderCrawler.put(lazyC, set);
            }
            boolean ret = !set.add(url);
            return ret;
        }
    }

    protected LinkCrawlerThread getCurrentLinkCrawlerThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof LinkCrawlerThread) {
            return (LinkCrawlerThread)((Object)currentThread);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void crawl(final LinkCrawlerGeneration generation, LazyCrawlerPlugin lazyC, final CrawledLink cryptedLink) {
        final CrawledLinkModifier parentLinkModifier = cryptedLink.getCustomCrawledLinkModifier();
        cryptedLink.setCustomCrawledLinkModifier(null);
        BrokenCrawlerHandler brokenCrawler = cryptedLink.getBrokenCrawlerHandler();
        cryptedLink.setBrokenCrawlerHandler(null);
        if (lazyC == null) {
            return;
        }
        if (cryptedLink.getCryptedLink() == null) {
            return;
        }
        if (this.isDuplicatedCrawling(lazyC, cryptedLink)) {
            this.onCrawledLinkDuplicate(cryptedLink, DUPLICATE.CRAWLER);
            return;
        }
        if (this.isCrawledLinkFiltered(cryptedLink)) {
            return;
        }
        final LinkCrawlerTask task = this.checkStartNotify(generation, "crawlPlugin:" + lazyC + "|" + cryptedLink.getURL());
        if (task == null) {
            return;
        }
        try {
            ArrayList<DownloadLink> decryptedPossibleLinks;
            block31: {
                PluginForDecrypt wplg;
                final String[] sourceURLs = this.getAndClearSourceURLs(cryptedLink);
                this.processedLinksCounter.incrementAndGet();
                try {
                    wplg = lazyC.newInstance(this.getPluginClassLoaderChild());
                }
                catch (UpdateRequiredClassNotFoundException e1) {
                    LogController.CL().log((Throwable)e1);
                    LinkCrawler.checkFinishNotify(task);
                    return;
                }
                final AtomicReference<LinkCrawler> nextLinkCrawler = new AtomicReference<LinkCrawler>(this);
                Browser br = wplg.createNewBrowserInstance();
                wplg.setBrowser(br);
                LogInterface oldLogger = null;
                boolean oldVerbose = false;
                boolean oldDebug = false;
                LogSource logger = LogController.getFastPluginLogger(wplg.getCrawlerLoggerID(cryptedLink));
                logger.info("Crawling: " + cryptedLink.getURL());
                wplg.setLogger((LogInterface)logger);
                wplg.init();
                LinkCrawlerThread lct = this.getCurrentLinkCrawlerThread();
                Object owner = null;
                LinkCrawlerDistributer dist = null;
                LinkCrawler previousCrawler = null;
                decryptedPossibleLinks = null;
                try {
                    DelayedRunnable finalLinkCrawlerDistributerDelayer;
                    ArrayList distributedLinks;
                    boolean useDelay;
                    boolean bl = useDelay = wplg.getDistributeDelayerMinimum() > 0;
                    if (useDelay) {
                        distributedLinks = new ArrayList();
                        int minimumDelay = Math.max(10, wplg.getDistributeDelayerMinimum());
                        int maximumDelay = wplg.getDistributeDelayerMaximum();
                        if (maximumDelay == 0) {
                            maximumDelay = -1;
                        }
                        finalLinkCrawlerDistributerDelayer = new DelayedRunnable(TIMINGQUEUE, minimumDelay, maximumDelay){

                            public String getID() {
                                return "LinkCrawler";
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void delayedrun() {
                                ArrayList linksToDistribute;
                                List list = distributedLinks;
                                synchronized (list) {
                                    if (distributedLinks.size() == 0) {
                                        return;
                                    }
                                    linksToDistribute = new ArrayList(distributedLinks);
                                    distributedLinks.clear();
                                }
                                LinkCrawlerTask innerTask = LinkCrawler.this.checkStartNotify(generation, task.getTaskID() + "|crawlPool(1)");
                                if (innerTask != null) {
                                    threadPool.execute(new LinkCrawlerRunnable(LinkCrawler.this, generation, innerTask){

                                        @Override
                                        public long getAverageRuntime() {
                                            Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                                            if (ret != null) {
                                                return ret;
                                            }
                                            return super.getAverageRuntime();
                                        }

                                        @Override
                                        void crawling() {
                                            ((LinkCrawler)nextLinkCrawler.get()).distribute(generation, linksToDistribute);
                                        }
                                    });
                                }
                            }
                        };
                    } else {
                        finalLinkCrawlerDistributerDelayer = null;
                        distributedLinks = null;
                    }
                    dist = new LinkCrawlerDistributer(){
                        final HashSet<DownloadLink> fastDuplicateDetector = new HashSet();
                        final AtomicInteger distributed = new AtomicInteger(0);
                        final HashSet<DownloadLink> distribute = new HashSet();

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public synchronized void distribute(DownloadLink ... links) {
                            LinkCrawlerTask linkCrawlerTask;
                            if (links == null || links.length == 0 && wplg.getDistributer() != null) {
                                return;
                            }
                            for (DownloadLink downloadLink : links) {
                                if (downloadLink == null || downloadLink.getPluginPatternMatcher() == null || this.fastDuplicateDetector.contains(downloadLink)) continue;
                                this.distribute.add(downloadLink);
                            }
                            if (wplg.getDistributer() != null && this.distribute.size() + this.distributed.get() <= 1) {
                                return;
                            }
                            final ArrayList<CrawledLink> possibleCryptedLinks = new ArrayList<CrawledLink>(this.distribute.size());
                            boolean distributeMultipleLinks = this.distribute.size() + this.distributed.get() > 1;
                            String cleanURL = LinkCrawler.cleanURL(cryptedLink.getCryptedLink().getCryptedUrl());
                            for (DownloadLink link : this.distribute) {
                                if (link.getPluginPatternMatcher() == null || !this.fastDuplicateDetector.add(link)) continue;
                                this.distributed.incrementAndGet();
                                if (cleanURL != null) {
                                    if (LinkCrawler.isTempDecryptedURL(link.getPluginPatternMatcher())) {
                                        if (distributeMultipleLinks) {
                                            if (link.getContainerUrl() == null) {
                                                link.setContainerUrl(cleanURL);
                                            }
                                        } else if (link.getContentUrl() == null) {
                                            link.setContentUrl(cleanURL);
                                        }
                                    } else if (distributeMultipleLinks && link.getContainerUrl() == null) {
                                        link.setContainerUrl(cleanURL);
                                    }
                                }
                                CrawledLink crawledLink = wplg.convert(link);
                                LinkCrawler.this.forwardCrawledLinkInfos(cryptedLink, crawledLink, parentLinkModifier, sourceURLs, !distributeMultipleLinks);
                                possibleCryptedLinks.add(crawledLink);
                            }
                            this.distribute.clear();
                            if (useDelay && wplg.getDistributer() != null) {
                                List list = distributedLinks;
                                synchronized (list) {
                                    distributedLinks.addAll(possibleCryptedLinks);
                                }
                                finalLinkCrawlerDistributerDelayer.run();
                            } else if (possibleCryptedLinks.size() > 0 && (linkCrawlerTask = LinkCrawler.this.checkStartNotify(generation, task.getTaskID() + "|crawlPool(2)")) != null) {
                                threadPool.execute(new LinkCrawlerRunnable(LinkCrawler.this, generation, linkCrawlerTask){

                                    @Override
                                    public long getAverageRuntime() {
                                        Long ret = LinkCrawler.this.getDefaultAverageRuntime();
                                        if (ret != null) {
                                            return ret;
                                        }
                                        return super.getAverageRuntime();
                                    }

                                    @Override
                                    void crawling() {
                                        ((LinkCrawler)nextLinkCrawler.get()).distribute(generation, possibleCryptedLinks);
                                    }
                                });
                            }
                        }
                    };
                    wplg.setDistributer(dist);
                    if (lct != null) {
                        owner = lct.getCurrentOwner();
                        lct.setCurrentOwner(wplg);
                        previousCrawler = lct.getCurrentLinkCrawler();
                        lct.setCurrentLinkCrawler(this);
                        oldLogger = lct.getLogger();
                        oldDebug = lct.isDebug();
                        oldVerbose = lct.isVerbose();
                        lct.setLogger((LogInterface)logger);
                        lct.setVerbose(true);
                        lct.setDebug(true);
                    }
                    long startTime = Time.systemIndependentCurrentJVMTimeMillis();
                    try {
                        wplg.setCrawler(this);
                        wplg.setLinkCrawlerGeneration(generation);
                        LinkCrawler pluginNextLinkCrawler = wplg.getCustomNextCrawler();
                        if (pluginNextLinkCrawler != null) {
                            nextLinkCrawler.set(pluginNextLinkCrawler);
                        }
                        decryptedPossibleLinks = wplg.decryptLink(cryptedLink);
                        wplg.setDistributer(null);
                        if (finalLinkCrawlerDistributerDelayer != null) {
                            finalLinkCrawlerDistributerDelayer.setDelayerEnabled(false);
                            finalLinkCrawlerDistributerDelayer.delayedrun();
                        }
                        if (decryptedPossibleLinks != null) {
                            dist.distribute(decryptedPossibleLinks.toArray(new DownloadLink[decryptedPossibleLinks.size()]));
                        }
                        if (logger instanceof ClearableLogInterface) {
                            ((ClearableLogInterface)logger).clear();
                        }
                    }
                    finally {
                        wplg.setLinkCrawlerGeneration(null);
                        wplg.setCurrentLink(null);
                        long endTime = Time.systemIndependentCurrentJVMTimeMillis() - startTime;
                        lazyC.updateCrawlRuntime(endTime);
                        if (logger instanceof ClosableLogInterface) {
                            ((ClosableLogInterface)logger).close();
                        }
                    }
                    if (lct == null) break block31;
                    lct.setCurrentOwner(owner);
                    lct.setCurrentLinkCrawler(previousCrawler);
                }
                catch (Throwable throwable) {
                    if (lct != null) {
                        lct.setCurrentOwner(owner);
                        lct.setCurrentLinkCrawler(previousCrawler);
                        lct.setLogger(oldLogger);
                        lct.setVerbose(oldVerbose);
                        lct.setDebug(oldDebug);
                    }
                    throw throwable;
                }
                lct.setLogger(oldLogger);
                lct.setVerbose(oldVerbose);
                lct.setDebug(oldDebug);
            }
            if (decryptedPossibleLinks == null) {
                this.handleBrokenCrawledLink(cryptedLink);
            }
            if (brokenCrawler != null) {
                try {
                    brokenCrawler.brokenCrawler(cryptedLink, this);
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                }
            }
        }
        finally {
            LinkCrawler.checkFinishNotify(task);
        }
    }

    public List<CrawledLink> getCrawledLinks() {
        return this.crawledLinks;
    }

    public List<CrawledLink> getFilteredLinks() {
        return this.filteredLinks;
    }

    public List<CrawledLink> getBrokenLinks() {
        return this.brokenLinks;
    }

    public List<CrawledLink> getUnhandledLinks() {
        return this.unhandledLinks;
    }

    protected void handleBrokenCrawledLink(CrawledLink link) {
        this.brokenLinksCounter.incrementAndGet();
        this.getHandler().handleBrokenLink(link);
    }

    protected void handleUnhandledCryptedLink(CrawledLink link) {
        this.unhandledLinksCounter.incrementAndGet();
        this.getHandler().handleUnHandledLink(link);
    }

    private String getContentURL(CrawledLink link) {
        DownloadLink downloadLink = link.getDownloadLink();
        PluginForHost plugin = downloadLink.getDefaultPlugin();
        if (downloadLink == null || plugin == null) {
            return null;
        }
        String pluginURL = downloadLink.getPluginPatternMatcher();
        for (CrawledLink next : link) {
            String[] hits;
            if (next == link) continue;
            if (next.getDownloadLink() == null && next.getCryptedLink() != null) break;
            String nextURL = LinkCrawler.cleanURL(next.getURL());
            if (nextURL != null && !StringUtils.equals((String)pluginURL, (String)nextURL) && (hits = new Regex(nextURL, plugin.getSupportedLinks()).getColumn(-1)) != null) {
                try {
                    if (hits.length == 1 && hits[0] != null && plugin.isValidURL(hits[0]) && !StringUtils.equals((String)pluginURL, (String)hits[0]) && new URL(hits[0]).getPath().length() > 1) {
                        return hits[0];
                    }
                    return null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (next.getDownloadLink() != null) continue;
        }
        return null;
    }

    private String getOriginURL(CrawledLink link) {
        DownloadLink downloadLink = link.getDownloadLink();
        if (downloadLink == null) {
            return null;
        }
        String pluginURL = downloadLink.getPluginPatternMatcher();
        Iterator<CrawledLink> it = link.iterator();
        String originURL = null;
        while (it.hasNext()) {
            CrawledLink next = it.next();
            if (next == link || next.getDownloadLink() != null && next.getDownloadLink().getUrlProtection() != UrlProtection.UNSET) {
                originURL = null;
                continue;
            }
            String nextURL = LinkCrawler.cleanURL(next.getURL());
            if (nextURL == null || StringUtils.equals((String)pluginURL, (String)nextURL)) continue;
            originURL = nextURL;
        }
        return originURL;
    }

    protected void postprocessFinalCrawledLink(CrawledLink link) {
        String referrerURL;
        DownloadLink downloadLink = link.getDownloadLink();
        if (downloadLink == null) {
            return;
        }
        HashSet<String> knownURLs = new HashSet<String>();
        knownURLs.add(downloadLink.getPluginPatternMatcher());
        if (downloadLink.getContentUrl() != null) {
            if (StringUtils.equals((String)downloadLink.getPluginPatternMatcher(), (String)downloadLink.getContentUrl())) {
                downloadLink.setContentUrl(null);
            }
            knownURLs.add(downloadLink.getContentUrl());
        } else {
            String contentURL = this.getContentURL(link);
            if (contentURL != null && knownURLs.add(contentURL)) {
                downloadLink.setContentUrl(contentURL);
            }
        }
        if (downloadLink.getContainerUrl() != null) {
            knownURLs.add(downloadLink.getContainerUrl());
        }
        if (downloadLink.getOriginUrl() != null) {
            knownURLs.add(downloadLink.getOriginUrl());
        } else {
            String originURL = this.getOriginURL(link);
            if (originURL != null && knownURLs.add(originURL)) {
                downloadLink.setOriginUrl(originURL);
            }
        }
        if (StringUtils.equals((String)downloadLink.getOriginUrl(), (String)downloadLink.getContainerUrl())) {
            downloadLink.setContainerUrl(null);
        }
        if (downloadLink.getReferrerUrl() == null && (referrerURL = this.getReferrerUrl(link)) != null && knownURLs.add(referrerURL)) {
            downloadLink.setReferrerUrl(referrerURL);
        }
    }

    public static boolean isTempDecryptedURL(String url) {
        if (url == null) {
            return false;
        }
        String host = Browser.getHost((String)url, (boolean)true);
        return StringUtils.containsIgnoreCase((String)host, (String)"decrypted") || StringUtils.containsIgnoreCase((String)host, (String)"yt.not.allowed");
    }

    public static String cleanURL(String cUrl) {
        boolean isSupportedProtocol = HTMLParser.isSupportedProtocol(cUrl);
        if (!isSupportedProtocol) {
            return null;
        }
        String host = Browser.getHost((String)cUrl, (boolean)true);
        if (!(StringUtils.containsIgnoreCase((String)host, (String)"decrypted") || StringUtils.containsIgnoreCase((String)host, (String)"dummydirect.jdownloader.org") || StringUtils.containsIgnoreCase((String)host, (String)"dummycnl.jdownloader.org") || StringUtils.containsIgnoreCase((String)host, (String)"yt.not.allowed"))) {
            if (cUrl.startsWith("http://") || cUrl.startsWith("https://") || cUrl.startsWith("ftp://") || cUrl.startsWith("file:/")) {
                return cUrl;
            }
            if (cUrl.startsWith("m3u8://")) {
                return cUrl.substring("m3u8://".length());
            }
            if (cUrl.startsWith("directhttp://")) {
                return cUrl.substring("directhttp://".length());
            }
            if (cUrl.startsWith("httpviajd://")) {
                return "http://".concat(cUrl.substring("httpviajd://".length()));
            }
            if (cUrl.startsWith("httpsviajd://")) {
                return "https://".concat(cUrl.substring("httpsviajd://".length()));
            }
            if (cUrl.startsWith("ftpviajd://")) {
                return "ftp://".concat(cUrl.substring("ftpviajd://".length()));
            }
            if (cUrl.startsWith("jd://")) {
                return cUrl.replaceFirst("(?i)^jd://[^/:]+://", "");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFinalCrawledLink(LinkCrawlerGeneration generation, CrawledLink link) {
        LinkCrawlerRule rule;
        if (link == null) {
            return;
        }
        if (link.getDownloadLink() != null && (rule = link.getMatchingRule()) != null) {
            link.getDownloadLink().setProperty("lcrID", rule.getId());
        }
        CrawledLink origin = link.getOriginLink();
        if (link.getCreated() == -1L) {
            link.setCreated(this.getCreated());
            CrawledLinkModifier customModifier = link.getCustomCrawledLinkModifier();
            if (customModifier != null) {
                link.setCustomCrawledLinkModifier(null);
                try {
                    customModifier.modifyCrawledLink(link);
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                }
            }
            this.postprocessFinalCrawledLink(link);
            link.setBrokenCrawlerHandler(null);
            link.setUnknownHandler(null);
        }
        if (this.isDoDuplicateFinderFinalCheck()) {
            boolean specialHandling;
            boolean bl = specialHandling = origin != null && origin != link && StringUtils.equals((String)origin.getLinkID(), (String)link.getLinkID());
            if (!specialHandling) {
                PluginForHost hPlugin;
                CrawledLink existing = null;
                Map<String, CrawledLink> map = this.duplicateFinderFinal;
                synchronized (map) {
                    String key = Encoding.urlDecode((String)link.getLinkID(), (boolean)false);
                    existing = this.duplicateFinderFinal.get(key);
                    if (existing == null) {
                        this.duplicateFinderFinal.put(key, link);
                    }
                }
                if (existing != null && ((hPlugin = link.gethPlugin()) == null || hPlugin.onLinkCrawlerDupeFilterEnabled(existing, link))) {
                    this.onCrawledLinkDuplicate(link, DUPLICATE.FINAL);
                    return;
                }
            }
        }
        this.enqueueFinalCrawledLink(generation, link);
    }

    protected void enqueueFinalCrawledLink(LinkCrawlerGeneration generation, CrawledLink link) {
        if (!this.isCrawledLinkFiltered(link)) {
            this.crawledLinksCounter.incrementAndGet();
            this.getHandler().handleFinalLink(link);
        }
    }

    protected boolean isCrawledLinkFiltered(CrawledLink link) {
        LinkCrawler parent = this.getParent();
        if (parent != null && this.getFilter() != parent.getFilter() && parent.isCrawledLinkFiltered(link)) {
            return true;
        }
        if (this.getFilter().dropByUrl(link)) {
            this.filteredLinksCounter.incrementAndGet();
            this.getHandler().handleFilteredLink(link);
            return true;
        }
        return false;
    }

    protected void onCrawledLinkDuplicate(CrawledLink link, DUPLICATE duplicate) {
    }

    public int getCrawledLinksFoundCounter() {
        return this.crawledLinksCounter.get();
    }

    public int getFilteredLinksFoundCounter() {
        return this.filteredLinksCounter.get();
    }

    public int getBrokenLinksFoundCounter() {
        return this.brokenLinksCounter.get();
    }

    public int getUnhandledLinksFoundCounter() {
        return this.unhandledLinksCounter.get();
    }

    public int getProcessedLinksCounter() {
        return this.crawledLinksCounter.get() + this.filteredLinksCounter.get() + this.brokenLinksCounter.get() + this.processedLinksCounter.get();
    }

    public LinkCrawlerDeepInspector defaultDeepInspector() {
        return new LinkCrawlerDeepInspector(){

            @Override
            public List<CrawledLink> deepInspect(LinkCrawler lc, LinkCrawlerGeneration generation, final Browser br, URLConnectionAdapter urlConnection, final CrawledLink link) throws Exception {
                LinkCrawlerRule rule;
                int limit = Math.max(0x100000, CONFIG.getDeepDecryptLoadLimit());
                if (br != null) {
                    br.setLoadLimit(limit);
                }
                if ((rule = link.getMatchingRule()) == null && !urlConnection.isContentDisposition()) {
                    boolean hasContentType;
                    boolean bl = hasContentType = urlConnection.getHeaderField("Content-Type") != null;
                    if (urlConnection.getRequest().getLocation() == null && urlConnection.getResponseCode() == 200 && !this.isTextContent(urlConnection) || urlConnection.getCompleteContentLength() > (long)limit) {
                        block18: {
                            if (!hasContentType) {
                                try {
                                    br.followConnection();
                                    if (br.containsHTML("<!DOCTYPE html>") || br.containsHTML("</html") && br.containsHTML("<html")) {
                                        return null;
                                    }
                                }
                                catch (IOException e) {
                                    LogInterface log = br.getLogger();
                                    if (log == null) break block18;
                                    log.log((Throwable)e);
                                }
                            }
                        }
                        urlConnection.disconnect();
                        ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
                        CrawledLink direct = LinkCrawler.this.createDirectHTTPCrawledLink(link, null, urlConnection);
                        if (direct != null) {
                            ret.add(direct);
                        }
                        return ret;
                    }
                }
                if (this.looksLikeDownloadableContent(urlConnection)) {
                    if (rule != null && LinkCrawlerRule.RULE.DEEPDECRYPT.equals((Object)rule.getRule()) && this.isTextContent(urlConnection)) {
                        br.followConnection();
                        return null;
                    }
                    urlConnection.disconnect();
                    ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
                    CrawledLink direct = lc.createDirectHTTPCrawledLink(link, null, urlConnection);
                    if (direct != null) {
                        ret.add(direct);
                    }
                    return ret;
                }
                br.followConnection();
                if (br.containsHTML("^#EXTM3U")) {
                    ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
                    ret.add(lc.crawledLinkFactorybyURL("m3u8://" + br._getURL().toExternalForm()));
                    return ret;
                }
                if (rule != null && LinkCrawlerRule.RULE.DEEPDECRYPT.equals((Object)rule.getRule())) {
                    return null;
                }
                try {
                    LazyCrawlerPlugin lazyC = lc.getLazyGenericHttpDirectoryCrawlerPlugin();
                    if (lazyC == null) {
                        throw new UpdateRequiredClassNotFoundException("could not find 'GenericHttpDirectoryCrawlerPlugin' crawler plugin");
                    }
                    ArrayList<DownloadLink> directoryContent = lc.invokeLazyCrawlerPlugin(generation, null, lazyC, link, new LazyCrawlerPluginInvokation<ArrayList<DownloadLink>>(){

                        @Override
                        public ArrayList<DownloadLink> invoke(PluginForDecrypt plugin) throws Exception {
                            plugin.setBrowser(br);
                            return ((abstractGenericHTTPDirectoryIndexCrawler)plugin).parseHTTPDirectory(new CryptedLink(br.getURL(), link), br);
                        }
                    });
                    if (directoryContent != null && directoryContent.size() > 0) {
                        ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
                        ret.add(lc.crawledLinkFactorybyURL("jd://directoryindex://" + br._getURL(true).toExternalForm()));
                        return ret;
                    }
                }
                catch (InterruptedException e) {
                    LogController.CL().log((Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                }
                return null;
            }
        };
    }

    public LinkCrawlerHandler defaultHandlerFactory() {
        return new LinkCrawlerHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFinalLink(CrawledLink link) {
                List list = LinkCrawler.this.crawledLinks;
                synchronized (list) {
                    LinkCrawler.this.crawledLinks.add(link);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFilteredLink(CrawledLink link) {
                List list = LinkCrawler.this.filteredLinks;
                synchronized (list) {
                    LinkCrawler.this.filteredLinks.add(link);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleBrokenLink(CrawledLink link) {
                List list = LinkCrawler.this.brokenLinks;
                synchronized (list) {
                    LinkCrawler.this.brokenLinks.add(link);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleUnHandledLink(CrawledLink link) {
                List list = LinkCrawler.this.unhandledLinks;
                synchronized (list) {
                    LinkCrawler.this.unhandledLinks.add(link);
                }
            }
        };
    }

    public LinkCrawlerFilter defaultFilterFactory() {
        return new LinkCrawlerFilter(){

            @Override
            public boolean dropByUrl(CrawledLink link) {
                return false;
            }

            @Override
            public boolean dropByFileProperties(CrawledLink link) {
                return false;
            }
        };
    }

    public void setFilter(LinkCrawlerFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.filter = filter;
    }

    public void setHandler(LinkCrawlerHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        this.handler = handler;
    }

    public void setDeepInspector(LinkCrawlerDeepInspector deepInspector) {
        if (deepInspector == null) {
            throw new IllegalArgumentException("deepInspector is null");
        }
        this.deepInspector = deepInspector;
    }

    public LinkCrawlerFilter getFilter() {
        return this.filter;
    }

    public LinkCrawlerHandler getHandler() {
        return this.handler;
    }

    public LinkCrawlerDeepInspector getDeepInspector() {
        return this.deepInspector;
    }

    static {
        CRAWLER = new HashSet<LinkCrawler>();
        PERMANENT_OFFLINE_ID = new UniqueAlltimeID();
        LOCKS = new WeakHashMap();
        CRAWLER_CACHE = new WeakHashMap();
        CONFIG = (LinkCrawlerConfig)JsonConfig.create(LinkCrawlerConfig.class);
        TIMINGQUEUE = DelayedRunnable.getNewScheduledExecutorService();
        MAX_THREADS = Math.max(CONFIG.getMaxThreads(), 1);
        int keepAlive = Math.max(CONFIG.getThreadKeepAlive(), 100);
        threadPool = new ThreadPoolExecutor(MAX_THREADS, MAX_THREADS, keepAlive, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(100, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                long l2;
                if (o1 == o2) {
                    return 0;
                }
                long l1 = ((LinkCrawlerRunnable)o1).getAverageRuntime();
                return l1 < (l2 = ((LinkCrawlerRunnable)o2).getAverageRuntime()) ? -1 : (l1 == l2 ? 0 : 1);
            }
        }), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new LinkCrawlerThread(r);
            }
        }, new ThreadPoolExecutor.AbortPolicy());
        threadPool.allowCoreThreadTimeOut(true);
        EVENTSENDER = new LinkCrawlerEventSender();
        LINKCRAWLERRULESLOCK = new Object();
        WAIT = new Object();
    }

    public static class BrowserCrawledLink
    extends CrawledLink {
        private final Browser br;
        private final Request next;
        private final Request last;
        private final List<Request> previousRequests = new ArrayList<Request>();

        protected List<Request> getPreviousRequests() {
            return this.previousRequests;
        }

        protected BrowserCrawledLink(Browser br, Request nextRequest) {
            this(br, null, nextRequest);
        }

        protected BrowserCrawledLink(Browser br, List<Request> previousRequests) {
            this(br, previousRequests, null);
        }

        protected BrowserCrawledLink(Browser br, List<Request> previousRequests, Request nextRequest) {
            this.br = br;
            this.last = br.getRequest();
            this.next = nextRequest;
            if (previousRequests != null) {
                this.previousRequests.addAll(previousRequests);
            }
        }

        @Override
        public boolean isCrawlDeep() {
            return true;
        }

        protected Browser getBrowser() {
            return this.br;
        }

        public Browser cloneBrowser() {
            return this.br.cloneBrowser();
        }

        @Override
        protected void linkToString(StringBuilder sb, Object link) {
            if (link == null) {
                if (this.next != null) {
                    sb.append("NextRequest:" + this.next.getUrl());
                } else if (this.last != null) {
                    sb.append("|Request:" + this.last.getUrl());
                }
            }
        }

        protected Request getLastRequest() {
            return this.last;
        }

        protected Request getNextRequest() {
            return this.next;
        }

        @Override
        public String getURL() {
            if (this.next != null) {
                return this.next.getURL().toExternalForm();
            }
            return this.last.getURL().toExternalForm();
        }

        private Map<String, String> findPropertyPatternMatches(LinkCrawlerRule rule) {
            Map<String, List<Pattern>> patternmap = rule._getPropertyPatterns();
            if (patternmap == null) {
                return null;
            }
            HashMap<String, String> results = new HashMap<String, String>();
            block0: for (Map.Entry<String, List<Pattern>> entry : patternmap.entrySet()) {
                String key = entry.getKey();
                for (Pattern pattern : entry.getValue()) {
                    Regex regex = new Regex((Object)this.br, pattern);
                    if (!regex.patternFind()) continue;
                    String match = new Regex((Object)this.br, pattern).getMatch(0);
                    if (match == null) {
                        match = regex.getMatch(-1);
                    }
                    results.put(key, match);
                    continue block0;
                }
            }
            return results;
        }
    }

    protected static interface DeeperOrMatchingRuleModifier
    extends CrawledLinkModifier {
        public CrawledLinkModifier getSourceCrawledLinkModifier();
    }

    protected static interface LazyCrawlerPluginInvokation<T> {
        public T invoke(PluginForDecrypt var1) throws Exception;
    }

    protected static interface LazyHosterPluginInvokation<T> {
        public T invoke(PluginForHost var1) throws Exception;
    }

    public class LinkCrawlerGeneration {
        private final AtomicBoolean validFlag = new AtomicBoolean(true);

        public final boolean isValid() {
            return this.validFlag.get() && LinkCrawler.this.linkCrawlerGeneration.get() == this;
        }

        protected final void invalidate() {
            this.validFlag.set(false);
        }
    }

    public class LinkCrawlerTask {
        private final AtomicBoolean runningFlag = new AtomicBoolean(true);
        private final LinkCrawlerGeneration generation;
        private final LinkCrawler crawler;
        private final String taskID;

        public final LinkCrawler getCrawler() {
            return this.crawler;
        }

        protected LinkCrawlerTask(LinkCrawler linkCrawler, LinkCrawlerGeneration generation, String taskID) {
            this.generation = generation;
            this.crawler = linkCrawler;
            this.taskID = taskID + ":" + UniqueAlltimeID.next();
        }

        public String getTaskID() {
            return this.taskID;
        }

        public LinkCrawlerGeneration getLinkCrawlerGeneration() {
            return this.generation;
        }

        public final boolean isRunning() {
            return this.runningFlag.get();
        }

        protected final boolean invalidate() {
            return this.runningFlag.compareAndSet(true, false);
        }
    }

    protected static enum DUPLICATE {
        CONTAINER,
        CRAWLER,
        FINAL,
        DEEP;

    }

    private static enum DISTRIBUTE {
        STOP,
        BLACKLISTED,
        NEXT,
        CONTINUE,
        PARTIAL_MATCH;

    }
}

