/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadConnectionVerifier;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;

public abstract class LinkCrawlerDeepInspector {
    public boolean looksLikeDownloadableContent(URLConnectionAdapter urlConnection) {
        Boolean verified = null;
        boolean looksLike = false;
        if (urlConnection.getResponseCode() == 200 || urlConnection.getResponseCode() == 206) {
            long completeContentLength = urlConnection.getCompleteContentLength();
            String contentType = urlConnection.getHeaderField("Content-Type");
            boolean hasContentType = StringUtils.isNotEmpty((String)contentType);
            boolean hasContentLength = StringUtils.isNotEmpty((String)urlConnection.getHeaderField("Content-Length"));
            boolean allowsByteRanges = StringUtils.contains((String)urlConnection.getHeaderField("Accept-Ranges"), (String)"bytes");
            String eTag = urlConnection.getHeaderField("ETag");
            boolean hasEtag = StringUtils.isNotEmpty((String)eTag);
            boolean hasStrongEtag = hasEtag && !eTag.matches("(?i)^\\s*W/.*");
            String filePathName = new Regex(urlConnection.getURL().getPath(), ".*?/([^/]+)$").getMatch(0);
            long sizeDownloadableContent = StringUtils.endsWithCaseInsensitive((String)filePathName, (String)".epub") ? 0x100000L : 0x200000L;
            if (urlConnection.isContentDisposition()) {
                String contentDispositionHeader = urlConnection.getHeaderField("Content-Disposition");
                String contentDispositionFileName = HTTPConnectionUtils.getFileNameFromDispositionHeader((String)contentDispositionHeader);
                boolean inlineFlag = contentDispositionHeader.matches("(?i)^\\s*inline\\s*;?.*");
                looksLike = !(inlineFlag && (contentDispositionFileName != null && contentDispositionFileName.matches("(?i)^.*\\.html?$") || hasContentType && this.isHtmlContent(urlConnection)));
            } else {
                if (completeContentLength == 0L) {
                    return false;
                }
                if (hasContentType && !this.isTextContent(urlConnection) && contentType.matches("(?i)^(application|audio|video|image)/.+")) {
                    looksLike = this.isOtherTextContent(urlConnection) ? false : !LinkCrawlerDeepInspector.looksLikeMpegURL(urlConnection);
                } else if (hasContentType && !this.isTextContent(urlConnection) && contentType.matches("(?i)^binary/octet-stream")) {
                    looksLike = true;
                } else if (hasContentType && !this.isTextContent(urlConnection) && completeContentLength > 0L) {
                    looksLike = true;
                } else if (!hasContentType && completeContentLength > 0L && hasStrongEtag) {
                    looksLike = true;
                } else if (!hasContentType && completeContentLength > 0L && allowsByteRanges) {
                    looksLike = true;
                } else if (!(completeContentLength <= sizeDownloadableContent || hasContentType && this.isTextContent(urlConnection))) {
                    looksLike = true;
                } else if (completeContentLength > sizeDownloadableContent && (allowsByteRanges || urlConnection.getResponseCode() == 206 && urlConnection.getRange() != null)) {
                    looksLike = true;
                } else if (filePathName != null && filePathName.matches("(?i).+\\.epub") && this.isPlainTextContent(urlConnection) && (!hasContentLength || completeContentLength > sizeDownloadableContent)) {
                    looksLike = true;
                } else if (filePathName != null && filePathName.matches("(?i).+\\.srt") && this.isPlainTextContent(urlConnection) && (!hasContentLength || completeContentLength > 512L || hasEtag)) {
                    looksLike = true;
                }
            }
        }
        if (looksLike) {
            try {
                PluginClassLoader.PluginClassLoaderChild pluginClassLoaderChild;
                PluginForHost plugin;
                String host;
                LazyHostPlugin lazyHostPlugin;
                HashSet<LazyHostPlugin> plugins = new HashSet<LazyHostPlugin>();
                Plugin currentActivePlugin = Plugin.getCurrentActivePlugin();
                if (currentActivePlugin instanceof DownloadConnectionVerifier) {
                    verified = ((DownloadConnectionVerifier)((Object)currentActivePlugin)).verifyDownloadableContent(plugins, urlConnection);
                }
                if (verified == null && (lazyHostPlugin = new PluginFinder()._assignHost(host = Browser.getHost((URL)urlConnection.getURL()))) != null && plugins.add(lazyHostPlugin) && (plugin = (PluginForHost)Plugin.getNewPluginInstance(currentActivePlugin, lazyHostPlugin, pluginClassLoaderChild = PluginClassLoader.getThreadPluginClassLoaderChild())) instanceof DownloadConnectionVerifier) {
                    verified = ((DownloadConnectionVerifier)((Object)plugin)).verifyDownloadableContent(plugins, urlConnection);
                }
            }
            catch (Exception e) {
                LogController.CL().log((Throwable)e);
            }
        }
        if (verified != null) {
            return verified;
        }
        return looksLike;
    }

    public static boolean looksLikeMpegURL(URLConnectionAdapter urlConnection) {
        String contentType = urlConnection != null ? urlConnection.getContentType() : null;
        return StringUtils.isNotEmpty((String)contentType) && (StringUtils.equalsIgnoreCase((String)contentType, (String)"application/vnd.apple.mpegurl") || StringUtils.equalsIgnoreCase((String)contentType, (String)"application/x-mpegurl"));
    }

    public static boolean looksLikeDashURL(URLConnectionAdapter urlConnection) {
        String contentType = urlConnection != null ? urlConnection.getContentType() : null;
        return StringUtils.isNotEmpty((String)contentType) && StringUtils.equalsIgnoreCase((String)contentType, (String)"application/dash+xml");
    }

    public boolean isTextContent(URLConnectionAdapter urlConnection) {
        if (this.isOtherTextContent(urlConnection)) {
            return true;
        }
        if (this.isPlainTextContent(urlConnection)) {
            return true;
        }
        return this.isHtmlContent(urlConnection);
    }

    public boolean isOtherTextContent(URLConnectionAdapter urlConnection) {
        if (this.isHtmlContent(urlConnection)) {
            return false;
        }
        String contentType = urlConnection.getContentType();
        return StringUtils.isNotEmpty((String)contentType) && (contentType.matches("(?i)application/(?!vnd)[^ ;]*(json|xml).*") || contentType.matches("(?i)text/xml.*"));
    }

    public boolean isPlainTextContent(URLConnectionAdapter urlConnection) {
        String contentType = urlConnection != null ? urlConnection.getContentType() : null;
        return StringUtils.isNotEmpty((String)contentType) && (StringUtils.containsIgnoreCase((String)contentType, (String)"text/plain") || StringUtils.containsIgnoreCase((String)contentType, (String)"plain/text"));
    }

    public boolean isHtmlContent(URLConnectionAdapter urlConnection) {
        String contentType = urlConnection != null ? urlConnection.getContentType() : null;
        return StringUtils.isNotEmpty((String)contentType) && (StringUtils.containsIgnoreCase((String)contentType, (String)"text/html") || StringUtils.containsIgnoreCase((String)contentType, (String)"application/xhtml+xml"));
    }

    public abstract List<CrawledLink> deepInspect(LinkCrawler var1, LinkCrawler.LinkCrawlerGeneration var2, Browser var3, URLConnectionAdapter var4, CrawledLink var5) throws Exception;
}

