/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.LinkCrawlerLock;

public abstract class LinkCrawlerRunnable
implements Runnable {
    private final LinkCrawler.LinkCrawlerGeneration generation;
    private final LinkCrawler crawler;
    private final LinkCrawler.LinkCrawlerTask task;
    static final HashMap<Object, List<LinkCrawlerRunnable>> SEQ_RUNNABLES = new HashMap();
    static final HashMap<Object, AtomicInteger> SEQ_COUNTER = new HashMap();

    public LinkCrawler.LinkCrawlerGeneration getGeneration() {
        return this.generation;
    }

    protected LinkCrawlerRunnable(LinkCrawler crawler, LinkCrawler.LinkCrawlerGeneration generation, LinkCrawler.LinkCrawlerTask task) {
        if (crawler == null) {
            throw new IllegalArgumentException("crawler==null?");
        }
        if (generation == null) {
            throw new IllegalArgumentException("generation==null?");
        }
        if (task == null) {
            throw new IllegalArgumentException("task==null?");
        }
        this.crawler = crawler;
        this.generation = generation;
        this.task = task;
    }

    public LinkCrawler.LinkCrawlerTask getTask() {
        return this.task;
    }

    public LinkCrawler getLinkCrawler() {
        return this.crawler;
    }

    @Override
    public void run() {
        LinkCrawlerLock lock = this.getLinkCrawlerLock();
        if (lock == null || !lock.requiresLocking()) {
            this.run_now();
        } else {
            this.run_delayed(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run_delayed(LinkCrawlerLock lock) {
        LinkCrawlerRunnable startRunnable;
        AtomicInteger counter;
        List<LinkCrawlerRunnable> seqs;
        int maxConcurrency = lock.getMaxConcurrency();
        HashMap<Object, List<LinkCrawlerRunnable>> hashMap = SEQ_RUNNABLES;
        synchronized (hashMap) {
            seqs = SEQ_RUNNABLES.get(lock);
            if (seqs == null) {
                seqs = new ArrayList<LinkCrawlerRunnable>();
                SEQ_RUNNABLES.put(lock, seqs);
            }
            if ((counter = SEQ_COUNTER.get(lock)) == null) {
                counter = new AtomicInteger(0);
                SEQ_COUNTER.put(lock, counter);
            }
            if (counter.get() < maxConcurrency) {
                if (seqs.size() > 0) {
                    startRunnable = seqs.remove(0);
                    seqs.add(this);
                } else {
                    startRunnable = this;
                }
                counter.incrementAndGet();
            } else {
                startRunnable = null;
                seqs.add(this);
            }
        }
        if (startRunnable == null) {
            return;
        }
        try {
            startRunnable.run_now();
        }
        finally {
            hashMap = SEQ_RUNNABLES;
            synchronized (hashMap) {
                seqs = SEQ_RUNNABLES.get(lock);
                counter = SEQ_COUNTER.get(lock);
                if (seqs != null) {
                    counter.decrementAndGet();
                    if (seqs.size() == 0) {
                        if (counter.get() == 0) {
                            SEQ_RUNNABLES.remove(lock);
                            SEQ_COUNTER.remove(lock);
                        }
                    } else {
                        LinkCrawlerRunnable next = seqs.remove(0);
                        LinkCrawler.threadPool.execute(next);
                    }
                }
            }
        }
    }

    protected void run_now() {
        try {
            if (this.getGeneration().isValid()) {
                this.crawling();
            }
        }
        finally {
            LinkCrawler.checkFinishNotify(this.getTask());
        }
    }

    abstract void crawling();

    public long getAverageRuntime() {
        return 0L;
    }

    protected LinkCrawlerLock getLinkCrawlerLock() {
        return null;
    }
}

