/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler.modifier;

import java.io.File;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.PackageInfo;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;

public class DownloadFolderModifier
implements CrawledLinkModifier {
    protected final String folder;
    protected final boolean overwriteFlag;

    public String getFolder() {
        return this.folder;
    }

    public boolean isOverwriteFlag() {
        return this.overwriteFlag;
    }

    public DownloadFolderModifier(String folder, boolean overwriteFlag) {
        this.folder = StringUtils.isNotEmpty((String)folder) ? CrossSystem.fixPathSeparators((String)(folder + File.separator)) : null;
        this.overwriteFlag = overwriteFlag;
    }

    @Override
    public boolean modifyCrawledLink(CrawledLink link) {
        PackageInfo existing = link.getDesiredPackageInfo();
        if (this.overwriteFlag || existing == null || StringUtils.isEmpty((String)existing.getDestinationFolderRoot())) {
            if (existing == null) {
                existing = new PackageInfo();
            }
            if (this.overwriteFlag) {
                existing.setIgnoreVarious(true);
                existing.setDestinationFolder(this.folder);
            } else {
                existing.setDestinationFolderRoot(this.folder);
            }
            existing.setUniqueId(null);
            link.setDesiredPackageInfo(existing);
            return true;
        }
        return false;
    }
}

