/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler.modifier;

import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.PackageInfo;
import org.appwork.utils.StringUtils;

public class PackageNameModifier
implements CrawledLinkModifier {
    protected final String name;
    protected final boolean overwriteFlag;

    public String getName() {
        return this.name;
    }

    public boolean isOverwriteFlag() {
        return this.overwriteFlag;
    }

    public PackageNameModifier(String name, boolean overwriteFlag) {
        this.name = name;
        this.overwriteFlag = overwriteFlag;
    }

    @Override
    public boolean modifyCrawledLink(CrawledLink link) {
        PackageInfo existing = link.getDesiredPackageInfo();
        if (this.overwriteFlag || existing == null || StringUtils.isEmpty((String)existing.getName())) {
            if (existing == null) {
                existing = new PackageInfo();
            }
            existing.setName(this.name);
            if (this.overwriteFlag) {
                existing.setIgnoreVarious(true);
            }
            existing.setUniqueId(null);
            link.setDesiredPackageInfo(existing);
            return true;
        }
        return false;
    }
}

