/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.packagecontroller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractNodeVisitor;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageControllerComparator;
import jd.controlling.packagecontroller.PackageControllerModifyVetoListener;
import jd.controlling.packagecontroller.PackageControllerQueue;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.components.packagetable.PackageControllerSelectionInfo;
import org.jdownloader.gui.views.components.packagetable.dragdrop.MergePosition;
import org.jdownloader.logging.LogController;

public abstract class PackageController<PackageType extends AbstractPackageNode<ChildType, PackageType>, ChildType extends AbstractPackageChildrenNode<PackageType>>
implements AbstractNodeNotifier {
    protected final AtomicLong structureChanged = new AtomicLong(System.currentTimeMillis());
    protected final AtomicLong childrenChanged = new AtomicLong(System.currentTimeMillis());
    protected final AtomicLong backendChanged = new AtomicLong(System.currentTimeMillis());
    protected final AtomicLong contentChanged = new AtomicLong(System.currentTimeMillis());
    protected final LogSource logger = LogController.CL();
    protected final WeakHashMap<UniqueAlltimeID, PackageType> uniqueAlltimeIDPackageMap = new WeakHashMap();
    protected final WeakHashMap<UniqueAlltimeID, ChildType> uniqueAlltimeIDChildrenMap = new WeakHashMap();
    protected final ArrayList<PackageType> packages = new ArrayList();
    protected final ModifyLock lock = new ModifyLock();
    protected final ModifyLock mapLock = new ModifyLock();
    protected final PackageControllerQueue QUEUE = new PackageControllerQueue(this.getClass().getName());
    private List<PackageControllerModifyVetoListener<PackageType, ChildType>> vetoListener = new CopyOnWriteArrayList<PackageControllerModifyVetoListener<PackageType, ChildType>>();
    private volatile PackageControllerComparator<AbstractNode> sorter;
    protected volatile PackageControllerSelectionInfo<PackageType, ChildType> selectionInfo = null;

    public long getBackendChanged() {
        return this.backendChanged.get();
    }

    public long getPackageControllerChanges() {
        return this.structureChanged.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChildType> getAllChildren() {
        ArrayList ret = new ArrayList();
        boolean readL = this.readLock();
        try {
            for (AbstractPackageNode fp : this.getPackages()) {
                boolean readL2 = fp.getModifyLock().readLock();
                try {
                    ret.addAll(fp.getChildren());
                }
                finally {
                    fp.getModifyLock().readUnlock(readL2);
                }
            }
        }
        finally {
            this.readUnlock(readL);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractNode> getCopy() {
        ArrayList<AbstractNode> ret = new ArrayList<AbstractNode>();
        boolean readL = this.readLock();
        try {
            for (AbstractPackageNode fp : this.getPackages()) {
                ret.add(fp);
                boolean readL2 = fp.getModifyLock().readLock();
                try {
                    ret.addAll(fp.getChildren());
                }
                finally {
                    fp.getModifyLock().readUnlock(readL2);
                }
            }
        }
        finally {
            this.readUnlock(readL);
        }
        return ret;
    }

    public long getChildrenChanges() {
        return this.childrenChanged.get();
    }

    public long getContentChanges() {
        return this.contentChanged.get();
    }

    protected ModifyLock getMapLock() {
        return this.mapLock;
    }

    protected void addmovePackageAt(PackageType pkg, int index) {
        this.addmovePackageAt(pkg, index, false);
    }

    public PackageControllerQueue getQueue() {
        return this.QUEUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUniqueAlltimeIDMaps(List<PackageType> packages) {
        if (packages == null) {
            return;
        }
        if (packages.size() == 0) {
            return;
        }
        this.getMapLock().writeLock();
        try {
            for (AbstractPackageNode pkg : packages) {
                this.uniqueAlltimeIDPackageMap.put(pkg.getUniqueID(), pkg);
                boolean readL = pkg.getModifyLock().readLock();
                try {
                    for (AbstractPackageChildrenNode child : pkg.getChildren()) {
                        this.uniqueAlltimeIDChildrenMap.put(child.getUniqueID(), child);
                    }
                }
                finally {
                    pkg.getModifyLock().readUnlock(readL);
                }
            }
        }
        finally {
            this.getMapLock().writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildrenCount() {
        int ret = 0;
        boolean readL = this.readLock();
        try {
            for (AbstractPackageNode fp : this.getPackages()) {
                boolean readL2 = fp.getModifyLock().readLock();
                try {
                    ret += fp.getChildren().size();
                }
                finally {
                    fp.getModifyLock().readUnlock(readL2);
                }
            }
        }
        finally {
            this.readUnlock(readL);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _sortPackageChildren(PackageType pkg, PackageControllerComparator<AbstractNode> comparator) {
        boolean sort;
        boolean bl = sort = pkg.size() > 1 && comparator != null && !comparator.equals(pkg.getCurrentSorter());
        if (sort) {
            ArrayList<ChildType> children = this.getChildrenCopy(pkg);
            try {
                Collections.sort(children, comparator);
            }
            catch (Throwable e) {
                LogController.CL(true).log(e);
            }
            pkg.getModifyLock().writeLock();
            try {
                pkg.setCurrentSorter(comparator);
                for (AbstractPackageChildrenNode child : children) {
                    child.setParentNode(pkg);
                }
                pkg.getChildren().clear();
                pkg.getChildren().addAll(children);
            }
            finally {
                pkg.getModifyLock().writeUnlock();
                pkg.nodeUpdated((AbstractNode)pkg, AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE, null);
            }
            return true;
        }
        pkg.getModifyLock().writeLock();
        try {
            pkg.setCurrentSorter(comparator);
            for (AbstractPackageChildrenNode child : pkg.getChildren()) {
                child.setParentNode(pkg);
            }
        }
        finally {
            pkg.getModifyLock().writeUnlock();
        }
        return false;
    }

    public void sortPackageChildren(final PackageType pkg, final PackageControllerComparator<AbstractNode> comparator) {
        if (pkg == null) {
            return;
        }
        if (comparator == null) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (PackageController.this._sortPackageChildren(pkg, comparator)) {
                    PackageController.this.structureChanged.set(PackageController.this.backendChanged.incrementAndGet());
                    PackageController.this._controllerPackageNodeStructureChanged(pkg, this.getQueuePrio());
                }
                return null;
            }
        });
    }

    protected void addmovePackageAt(final PackageType pkg, final int index, final boolean allowEmpty) {
        if (pkg == null) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                if (!allowEmpty && pkg.getChildren().size() == 0) {
                    return null;
                }
                boolean isNew = true;
                PackageController controller = pkg.getControlledBy();
                boolean need2Remove = false;
                if (PackageController.this == controller) {
                    need2Remove = true;
                } else if (controller != null) {
                    controller.removePackage(pkg);
                }
                PackageController.this.writeLock();
                try {
                    ListIterator li = PackageController.this.getPackages().listIterator();
                    int currentIndex = 0;
                    boolean done = false;
                    boolean addLast = false;
                    if (index < 0 || index > PackageController.this.getPackages().size() - 1) {
                        done = true;
                        addLast = true;
                    }
                    while (li.hasNext() && (!done || need2Remove)) {
                        AbstractPackageNode c = (AbstractPackageNode)li.next();
                        if (c == pkg && currentIndex == index) {
                            Void void_ = null;
                            return void_;
                        }
                        if (currentIndex == index) {
                            AbstractPackageNode replaced = c;
                            li.set(pkg);
                            li.add(replaced);
                            done = true;
                        } else if (c == pkg) {
                            li.remove();
                            isNew = false;
                            need2Remove = false;
                        }
                        ++currentIndex;
                    }
                    if (!done || addLast) {
                        PackageController.this.getPackages().add(pkg);
                    }
                    pkg.setControlledBy(PackageController.this);
                }
                finally {
                    PackageController.this.writeUnlock();
                }
                PackageController.this.getMapLock().writeLock();
                try {
                    PackageController.this.uniqueAlltimeIDPackageMap.put(pkg.getUniqueID(), pkg);
                    boolean readL = pkg.getModifyLock().readLock();
                    try {
                        for (AbstractPackageChildrenNode child : pkg.getChildren()) {
                            PackageController.this.uniqueAlltimeIDChildrenMap.put(child.getUniqueID(), child);
                        }
                    }
                    finally {
                        pkg.getModifyLock().readUnlock(readL);
                    }
                }
                finally {
                    PackageController.this.getMapLock().writeUnlock();
                }
                long version = PackageController.this.backendChanged.incrementAndGet();
                PackageController.this.structureChanged.set(version);
                if (isNew) {
                    if (pkg.getChildren().size() > 0) {
                        PackageController.this.childrenChanged.set(version);
                    }
                    PackageController.this._controllerPackageNodeAdded(pkg, this.getQueuePrio());
                } else {
                    PackageController.this._controllerPackageNodeStructureChanged(pkg, this.getQueuePrio());
                }
                PackageController.this._controllerStructureChanged(this.getQueuePrio());
                return null;
            }
        });
    }

    public int size() {
        boolean readL = this.readLock();
        try {
            int n = this.packages.size();
            return n;
        }
        finally {
            this.readUnlock(readL);
        }
    }

    public void removeVetoListener(PackageControllerModifyVetoListener<PackageType, ChildType> list) {
        this.vetoListener.remove(list);
    }

    public void addVetoListener(PackageControllerModifyVetoListener<PackageType, ChildType> list) {
        this.vetoListener.add(list);
    }

    public List<ChildType> askForRemoveVetos(Object asker, PackageType pkg) {
        ArrayList<ChildType> noVetos = this.getChildrenCopy(pkg);
        for (PackageControllerModifyVetoListener<PackageType, ChildType> listener : this.vetoListener) {
            List<ChildType> response = listener.onAskToRemovePackage(asker, pkg, noVetos);
            if (response != null) {
                noVetos.retainAll(response);
            } else if (response == null) {
                noVetos.clear();
            }
            if (noVetos.size() != 0) continue;
            return noVetos;
        }
        return noVetos;
    }

    public List<ChildType> askForRemoveVetos(Object asker, List<ChildType> children) {
        ArrayList<ChildType> noVetos = new ArrayList<ChildType>(children);
        for (PackageControllerModifyVetoListener<PackageType, ChildType> listener : this.vetoListener) {
            List<ChildType> response = listener.onAskToRemoveChildren(asker, noVetos);
            if (response != null) {
                noVetos.retainAll(response);
            } else if (response == null) {
                noVetos.clear();
            }
            if (noVetos.size() != 0) continue;
            return noVetos;
        }
        return noVetos;
    }

    public void removePackage(final PackageType pkg) {
        if (pkg == null) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                boolean removed = false;
                PackageController controller = pkg.getControlledBy();
                if (controller == null) {
                    PackageController.this.logger.log(new Throwable("NO CONTROLLER!!!"));
                    return null;
                }
                if (pkg.getControlledBy() != null) {
                    if (PackageController.this != pkg.getControlledBy()) {
                        PackageController.this.logger.log(new Throwable("removing a package which is not controlled by this controller?!?!?"));
                    }
                    pkg.setControlledBy(null);
                    PackageController.this.writeLock();
                    try {
                        removed = controller.getPackages().remove(pkg);
                    }
                    finally {
                        PackageController.this.writeUnlock();
                    }
                }
                if (removed) {
                    ArrayList remove = PackageController.this.getChildrenCopy(pkg);
                    PackageController.this.getMapLock().writeLock();
                    try {
                        PackageController.this.uniqueAlltimeIDPackageMap.remove((Object)pkg.getUniqueID());
                        for (AbstractPackageChildrenNode child : remove) {
                            PackageController.this.uniqueAlltimeIDChildrenMap.remove((Object)child.getUniqueID());
                        }
                    }
                    finally {
                        PackageController.this.getMapLock().writeUnlock();
                    }
                    long version = PackageController.this.backendChanged.incrementAndGet();
                    if (remove.size() > 0) {
                        PackageController.this.childrenChanged.set(version);
                        controller._controllerParentlessLinks(pkg, remove, this.getQueuePrio());
                    }
                    controller.structureChanged.set(version);
                    controller._controllerPackageNodeRemoved(pkg, this.getQueuePrio());
                    PackageController.this._controllerStructureChanged(this.getQueuePrio());
                }
                return null;
            }
        });
    }

    public void removeChildren(final List<ChildType> removechildren) {
        if (removechildren == null) {
            return;
        }
        if (removechildren.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                PackageController.this.internalRemoveChildren(removechildren);
                PackageController.this._controllerStructureChanged(this.getQueuePrio());
                return null;
            }
        });
    }

    protected void internalRemoveChildren(List<ChildType> removechildren) {
        ArrayList<ChildType> children = new ArrayList<ChildType>(removechildren);
        boolean childrenRemoved = false;
        HashMap<AbstractPackageNode, ArrayList<AbstractPackageChildrenNode>> removeaddMap = new HashMap<AbstractPackageNode, ArrayList<AbstractPackageChildrenNode>>();
        for (AbstractPackageChildrenNode child : children) {
            AbstractPackageNode parent = (AbstractPackageNode)child.getParentNode();
            if (parent == null) continue;
            ArrayList<AbstractPackageChildrenNode> pmap = (ArrayList<AbstractPackageChildrenNode>)removeaddMap.get(parent);
            if (pmap == null) {
                childrenRemoved = true;
                pmap = new ArrayList<AbstractPackageChildrenNode>();
                removeaddMap.put(parent, pmap);
            }
            pmap.add(child);
        }
        Set eset = removeaddMap.entrySet();
        for (Map.Entry next : eset) {
            AbstractPackageNode cpkg = (AbstractPackageNode)next.getKey();
            PackageController controller = cpkg.getControlledBy();
            if (controller == null) {
                this.logger.log(new Throwable("NO CONTROLLER!!!"));
                continue;
            }
            controller.removeChildren(cpkg, (List)next.getValue(), true);
        }
        long version = this.backendChanged.incrementAndGet();
        this.structureChanged.set(version);
        if (childrenRemoved) {
            this.childrenChanged.set(version);
        }
    }

    public List<ChildType> getChildrenByFilter(AbstractPackageChildrenNodeFilter<ChildType> filter) {
        ArrayList<AbstractPackageChildrenNode> ret = new ArrayList<AbstractPackageChildrenNode>();
        for (AbstractPackageNode pkg : this.getPackagesCopy()) {
            for (AbstractPackageChildrenNode child : this.getChildrenCopy(pkg)) {
                if (filter != null && filter.returnMaxResults() > 0 && ret.size() == filter.returnMaxResults()) {
                    return ret;
                }
                if (filter != null && !filter.acceptNode(child)) continue;
                ret.add(child);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitNodes(AbstractNodeVisitor<ChildType, PackageType> visitor, boolean liveWalk) {
        if (visitor == null) {
            return;
        }
        if (liveWalk) {
            boolean pkgLock = this.readLock();
            try {
                block9: for (AbstractPackageNode pkg : this.getPackages()) {
                    Boolean visitNode = visitor.visitPackageNode(pkg);
                    if (visitNode == null) {
                        return;
                    }
                    if (!Boolean.TRUE.equals(visitNode)) continue;
                    boolean childLock = pkg.getModifyLock().readLock();
                    try {
                        for (AbstractPackageChildrenNode child : pkg.getChildren()) {
                            visitNode = visitor.visitChildrenNode(child);
                            if (visitNode == null) {
                                return;
                            }
                            if (!Boolean.FALSE.equals(visitNode)) continue;
                            continue block9;
                        }
                    }
                    finally {
                        pkg.getModifyLock().readUnlock(childLock);
                    }
                }
            }
            finally {
                this.readUnlock(pkgLock);
            }
        } else {
            block11: for (AbstractPackageNode pkg : this.getPackagesCopy()) {
                Boolean visitNode = visitor.visitPackageNode(pkg);
                if (visitNode == null) {
                    return;
                }
                if (!Boolean.TRUE.equals(visitNode)) continue;
                for (AbstractPackageChildrenNode child : this.getChildrenCopy(pkg)) {
                    visitNode = visitor.visitChildrenNode(child);
                    if (visitNode == null) {
                        return;
                    }
                    if (!Boolean.FALSE.equals(visitNode)) continue;
                    continue block11;
                }
            }
        }
    }

    public void merge(PackageType dest, List<PackageType> srcPkgs, MergePackageSettings mergesettings) {
        this.merge(dest, null, srcPkgs, mergesettings);
    }

    public void merge(final PackageType dest, final List<ChildType> srcLinks, final List<PackageType> srcPkgs, final MergePackageSettings mergesettings) {
        if (dest == null) {
            return;
        }
        if (srcLinks == null && srcPkgs == null) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                int positionMerge = 0;
                switch (mergesettings.getMergePosition()) {
                    case BOTTOM: {
                        positionMerge = dest.getChildren().size();
                        break;
                    }
                    case TOP: {
                        positionMerge = 0;
                        break;
                    }
                    default: {
                        positionMerge = -1;
                    }
                }
                if (srcLinks != null) {
                    PackageController.this.moveOrAddAt(dest, srcLinks, positionMerge);
                    if (positionMerge != -1) {
                        positionMerge += srcLinks.size();
                    }
                }
                if (srcPkgs != null) {
                    for (AbstractPackageNode pkg : srcPkgs) {
                        int size = pkg.getChildren().size();
                        PackageController.this.moveOrAddAt(dest, pkg.getChildren(), positionMerge);
                        if (positionMerge == -1) continue;
                        positionMerge += size;
                    }
                    if (Boolean.TRUE.equals(mergesettings.getMergePackageComments())) {
                        HashSet<String> commentDups = new HashSet<String>();
                        StringBuilder sb = new StringBuilder();
                        srcPkgs.add(0, dest);
                        for (AbstractPackageNode pkg : srcPkgs) {
                            String[] commentLines;
                            String comment = pkg.getComment();
                            if (StringUtils.isEmpty((String)comment)) continue;
                            for (String commentLine : commentLines = Regex.getLines((String)comment)) {
                                if (StringUtils.isEmpty((String)commentLine) || !commentDups.add(commentLine)) continue;
                                if (sb.length() > 0) {
                                    sb.append("\r\n");
                                }
                                sb.append(commentLine);
                            }
                        }
                        String mergedComments = sb.toString();
                        if (!StringUtils.isEmpty((String)mergedComments)) {
                            dest.setComment(mergedComments);
                        }
                    }
                }
                return null;
            }
        });
    }

    public void moveOrAddAt(PackageType pkg, List<ChildType> movechildren, int moveChildrenindex) {
        this.moveOrAddAt(pkg, movechildren, moveChildrenindex, -1);
    }

    public void moveOrAddAt(final PackageType pkg, final List<ChildType> moveChildren, final int moveChildrenindex, final int pkgIndex) {
        if (pkg == null) {
            return;
        }
        if (moveChildren == null) {
            return;
        }
        if (moveChildren.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected final int search(List<ChildType> pkgchildren, ChildType elementToMove, PackageControllerComparator<AbstractNode> sorter) {
                int min = 0;
                int max = pkgchildren.size() - 1;
                int mid = 0;
                while (min <= max) {
                    mid = (max + min) / 2;
                    AbstractPackageChildrenNode midValue = (AbstractPackageChildrenNode)pkgchildren.get(mid);
                    int comp = sorter.compare((AbstractNode)elementToMove, midValue);
                    if (min == max) {
                        return comp > 0 ? min + 1 : min;
                    }
                    if (comp < 0) {
                        max = mid;
                        continue;
                    }
                    if (comp > 0) {
                        min = mid + 1;
                        continue;
                    }
                    return mid;
                }
                return mid;
            }

            private final boolean containsOnlyNewChildren(List<ChildType> children) {
                for (AbstractPackageChildrenNode child : children) {
                    AbstractPackageNode parent = (AbstractPackageNode)child.getParentNode();
                    if (parent == null) continue;
                    return false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                if (PackageController.this != pkg.getControlledBy()) {
                    PackageController.this.addmovePackageAt(pkg, pkgIndex, true);
                }
                boolean newChildren = false;
                if (pkgIndex == -1 && moveChildrenindex == -1 && this.containsOnlyNewChildren(moveChildren)) {
                    try {
                        AbstractPackageChildrenNode moveChild;
                        int index;
                        newChildren = true;
                        pkg.getModifyLock().writeLock();
                        PackageControllerComparator<AbstractNode> sorter = pkg.getCurrentSorter();
                        List pkgChildren = pkg.getChildren();
                        int maxIndex = moveChildren.size();
                        if (sorter != null) {
                            for (index = 0; index < maxIndex; ++index) {
                                moveChild = (AbstractPackageChildrenNode)moveChildren.get(index);
                                pkgChildren.add(this.search(pkgChildren, moveChild, sorter), moveChild);
                                moveChild.setParentNode(pkg);
                            }
                        } else {
                            pkgChildren.addAll(moveChildren);
                            for (index = 0; index < maxIndex; ++index) {
                                moveChild = (AbstractPackageChildrenNode)moveChildren.get(index);
                                moveChild.setParentNode(pkg);
                            }
                        }
                    }
                    finally {
                        pkg.getModifyLock().writeUnlock();
                        pkg.nodeUpdated(pkg, AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE, null);
                    }
                    boolean readL = pkg.getModifyLock().readLock();
                    try {
                        PackageController.this.autoFileNameCorrection(pkg.getChildren(), pkg);
                    }
                    catch (Throwable e) {
                        PackageController.this.logger.log(e);
                    }
                    finally {
                        pkg.getModifyLock().readUnlock(readL);
                    }
                    PackageController.this.getMapLock().writeLock();
                    try {
                        for (AbstractPackageChildrenNode moveChild : moveChildren) {
                            PackageController.this.uniqueAlltimeIDChildrenMap.put(moveChild.getUniqueID(), moveChild);
                        }
                    }
                    finally {
                        PackageController.this.getMapLock().writeUnlock();
                    }
                }
                ArrayList elementsToMove = new ArrayList(moveChildren);
                HashMap<AbstractPackageNode, ArrayList<AbstractPackageChildrenNode>> removeaddMap = new HashMap<AbstractPackageNode, ArrayList<AbstractPackageChildrenNode>>();
                for (AbstractPackageChildrenNode child : elementsToMove) {
                    AbstractPackageNode parent = (AbstractPackageNode)child.getParentNode();
                    if (parent == null || pkg == parent) {
                        if (parent != null) continue;
                        newChildren = true;
                        continue;
                    }
                    ArrayList<AbstractPackageChildrenNode> pmap = (ArrayList<AbstractPackageChildrenNode>)removeaddMap.get(parent);
                    if (pmap == null) {
                        pmap = new ArrayList<AbstractPackageChildrenNode>();
                        removeaddMap.put(parent, pmap);
                    }
                    pmap.add(child);
                    newChildren = true;
                }
                Set eset = removeaddMap.entrySet();
                for (Map.Entry next : eset) {
                    AbstractPackageNode cpkg = (AbstractPackageNode)next.getKey();
                    PackageController controller = cpkg.getControlledBy();
                    if (controller == null) {
                        PackageController.this.logger.log(new Throwable("NO CONTROLLER!!!"));
                        continue;
                    }
                    controller.removeChildren(cpkg, (List)next.getValue(), false);
                }
                ArrayList children = PackageController.this.getChildrenCopy(pkg);
                int destIndex = moveChildrenindex;
                for (Object child : elementsToMove) {
                    int childI = children.indexOf(child);
                    if (childI < 0) continue;
                    if (childI < destIndex) {
                        --destIndex;
                    }
                    children.remove(childI);
                }
                if (destIndex < 0 || destIndex > children.size()) {
                    PackageControllerComparator<AbstractNode> sorter = pkg.getCurrentSorter();
                    if (sorter != null) {
                        for (AbstractPackageChildrenNode c : elementsToMove) {
                            children.add(this.search(children, c, sorter), c);
                        }
                    } else {
                        children.addAll(elementsToMove);
                    }
                } else {
                    pkg.setCurrentSorter(null);
                    children.addAll(destIndex, elementsToMove);
                }
                if (newChildren) {
                    try {
                        PackageController.this.autoFileNameCorrection(children, pkg);
                    }
                    catch (Throwable e) {
                        PackageController.this.logger.log(e);
                    }
                }
                try {
                    pkg.getModifyLock().writeLock();
                    for (Object child : elementsToMove) {
                        child.setParentNode(pkg);
                    }
                    for (Object child : children) {
                        child.setParentNode(pkg);
                    }
                    pkg.getChildren().clear();
                    pkg.getChildren().addAll(children);
                }
                finally {
                    pkg.getModifyLock().writeUnlock();
                    pkg.nodeUpdated(pkg, AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE, null);
                }
                PackageController.this.getMapLock().writeLock();
                try {
                    for (Object child : elementsToMove) {
                        PackageController.this.uniqueAlltimeIDChildrenMap.put(child.getUniqueID(), child);
                    }
                }
                finally {
                    PackageController.this.getMapLock().writeUnlock();
                }
                long version = PackageController.this.backendChanged.incrementAndGet();
                PackageController.this.structureChanged.set(version);
                if (newChildren) {
                    PackageController.this.childrenChanged.set(version);
                }
                PackageController.this._controllerPackageNodeStructureChanged(pkg, this.getQueuePrio());
                PackageController.this._controllerStructureChanged(this.getQueuePrio());
                return null;
            }
        });
    }

    protected void autoFileNameCorrection(List<ChildType> pkgchildren, PackageType pkg) {
    }

    public void removeChildren(final PackageType pkg, final List<ChildType> children, final boolean doNotifyParentlessLinks) {
        if (pkg == null) {
            return;
        }
        if (children == null) {
            return;
        }
        if (children.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                ArrayList links = new ArrayList(children);
                PackageController controller = pkg.getControlledBy();
                if (controller == null) {
                    PackageController.this.logger.log(new Throwable("NO CONTROLLER!!!"));
                    return null;
                }
                boolean notifyStructureChanges = false;
                try {
                    pkg.getModifyLock().writeLock();
                    List pkgchildren = pkg.getChildren();
                    for (AbstractPackageChildrenNode child : pkgchildren) {
                        child.setParentNode(pkg);
                    }
                    ListIterator it = links.listIterator(links.size());
                    while (it.hasPrevious()) {
                        AbstractPackageChildrenNode dl = (AbstractPackageChildrenNode)it.previous();
                        if (pkgchildren.remove(dl)) {
                            notifyStructureChanges = true;
                            if (dl.getParentNode() == pkg) {
                                dl.setParentNode(null);
                                continue;
                            }
                            PackageController.this.logger.log(new Throwable("removing children from wrong parent?!?!?"));
                            continue;
                        }
                        it.remove();
                    }
                }
                finally {
                    pkg.getModifyLock().writeUnlock();
                    if (notifyStructureChanges) {
                        pkg.nodeUpdated(pkg, AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE, null);
                    }
                }
                if (links.size() > 0) {
                    long version = PackageController.this.backendChanged.incrementAndGet();
                    controller.structureChanged.set(version);
                    if (doNotifyParentlessLinks) {
                        PackageController.this.getMapLock().writeLock();
                        PackageController.this.childrenChanged.set(version);
                        try {
                            for (AbstractPackageChildrenNode child : links) {
                                PackageController.this.uniqueAlltimeIDChildrenMap.remove((Object)child.getUniqueID());
                            }
                        }
                        finally {
                            PackageController.this.getMapLock().writeUnlock();
                        }
                        controller._controllerParentlessLinks(pkg, links, this.getQueuePrio());
                    }
                    if (pkg.getChildren().size() == 0) {
                        controller.removePackage(pkg);
                    }
                }
                return null;
            }
        });
    }

    public void clear() {
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                for (AbstractPackageNode pkg : PackageController.this.getPackagesCopy()) {
                    PackageController.this.removePackage(pkg);
                }
                return null;
            }
        });
    }

    public void move(final List<PackageType> srcPkgs, final PackageType afterDest) {
        if (srcPkgs == null || srcPkgs.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                AbstractPackageNode internalafterDest = afterDest;
                for (AbstractPackageNode srcPkg : srcPkgs) {
                    int destination = 0;
                    if (internalafterDest != null) {
                        int destI = PackageController.this.indexOf(internalafterDest);
                        destination = Math.max(destI, 0) + 1;
                    }
                    PackageController.this.addmovePackageAt(srcPkg, destination);
                    internalafterDest = srcPkg;
                }
                return null;
            }
        });
    }

    public void moveAfter(final List<ChildType> srcLinks, final PackageType dstPkg, final ChildType after) {
        if (dstPkg == null || srcLinks == null || srcLinks.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                int destination = 0;
                if (after != null) {
                    int destI = dstPkg.indexOf(after);
                    destination = Math.max(destI, 0) + 1;
                }
                PackageController.this.moveOrAddAt(dstPkg, srcLinks, destination);
                return null;
            }
        });
    }

    public void moveBefore(final List<ChildType> srcLinks, final PackageType dstPkg, final ChildType before) {
        if (dstPkg == null || srcLinks == null || srcLinks.size() == 0) {
            return;
        }
        this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                int destination = 0;
                if (before != null) {
                    int destI = dstPkg.indexOf(before);
                    destination = Math.max(destI - 1, 0);
                }
                PackageController.this.moveOrAddAt(dstPkg, srcLinks, destination);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, List<PackageType>> getPackagesWithSameName(boolean case_insensitive) {
        boolean readL = this.readLock();
        try {
            Map<String, List<PackageType>> map = this.getPackagesWithSameName(this.getPackages(), case_insensitive);
            return map;
        }
        finally {
            this.readUnlock(readL);
        }
    }

    public final Map<String, List<PackageType>> getPackagesWithSameName(List<PackageType> packages, boolean case_insensitive) {
        HashMap<String, List<PackageType>> dupes = new HashMap<String, List<PackageType>>();
        for (AbstractPackageNode packageNode : this.getPackages()) {
            String compareString;
            ArrayList<AbstractPackageNode> thisdupeslist;
            String downloaddestination;
            String packagename = packageNode.getName();
            if (case_insensitive) {
                packagename = packagename.toLowerCase(Locale.ENGLISH);
            }
            if ((downloaddestination = LinkTreeUtils.getDownloadDirectory(packageNode).getPath()) != null && CrossSystem.isWindows()) {
                downloaddestination = downloaddestination.toLowerCase(Locale.ENGLISH);
            }
            if ((thisdupeslist = (ArrayList<AbstractPackageNode>)dupes.get(compareString = packagename + downloaddestination)) == null) {
                thisdupeslist = new ArrayList<AbstractPackageNode>();
                dupes.put(compareString, thisdupeslist);
            }
            thisdupeslist.add(packageNode);
        }
        return dupes;
    }

    @Deprecated
    public void move(List<ChildType> srcLinks, PackageType dstPkg, ChildType afterLink) {
        this.moveAfter(srcLinks, dstPkg, afterLink);
    }

    protected abstract void _controllerParentlessLinks(PackageType var1, List<ChildType> var2, Queue.QueuePriority var3);

    protected abstract void _controllerStructureChanged(Queue.QueuePriority var1);

    protected abstract void _controllerPackageNodeAdded(PackageType var1, Queue.QueuePriority var2);

    protected abstract void _controllerPackageNodeRemoved(PackageType var1, Queue.QueuePriority var2);

    protected abstract void _controllerPackageNodeStructureChanged(PackageType var1, Queue.QueuePriority var2);

    public boolean readLock() {
        return this.lock.readLock();
    }

    public void readUnlock(boolean state) {
        this.lock.readUnlock(state);
    }

    public void writeLock() {
        this.lock.writeLock();
    }

    public void writeUnlock() {
        this.lock.writeUnlock();
    }

    public ArrayList<PackageType> getPackages() {
        return this.packages;
    }

    public ArrayList<PackageType> getPackagesCopy() {
        boolean readL = this.readLock();
        try {
            ArrayList<PackageType> arrayList = new ArrayList<PackageType>(this.getPackages());
            return arrayList;
        }
        finally {
            this.readUnlock(readL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ChildType> getChildrenCopy(PackageType pkg) {
        boolean readL2 = pkg.getModifyLock().readLock();
        try {
            ArrayList arrayList = new ArrayList(pkg.getChildren());
            return arrayList;
        }
        finally {
            pkg.getModifyLock().readUnlock(readL2);
        }
    }

    @Override
    public void nodeUpdated(AbstractNode source, AbstractNodeNotifier.NOTIFY notify, Object param) {
        this.contentChanged.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(PackageType pkg) {
        boolean readL = this.readLock();
        try {
            int n = this.getPackages().indexOf(pkg);
            return n;
        }
        finally {
            this.readUnlock(readL);
        }
    }

    public SelectionInfo<PackageType, ChildType> getSelectionInfo() {
        long version = this.getBackendChanged();
        PackageControllerSelectionInfo<PackageType, ChildType> lSelectionInfo = this.selectionInfo;
        if (lSelectionInfo != null && lSelectionInfo.getBackendVersion() == version) {
            return lSelectionInfo;
        }
        return (SelectionInfo)this.getQueue().addWait(new PackageControllerQueue.ReadOnlyQueueAction<SelectionInfo<PackageType, ChildType>, RuntimeException>(Queue.QueuePriority.HIGH){

            protected SelectionInfo<PackageType, ChildType> run() throws RuntimeException {
                long version = PackageController.this.getBackendChanged();
                PackageControllerSelectionInfo lSelectionInfo = PackageController.this.selectionInfo;
                if (lSelectionInfo != null && lSelectionInfo.getBackendVersion() == version) {
                    return lSelectionInfo;
                }
                lSelectionInfo = new PackageControllerSelectionInfo(PackageController.this);
                PackageController.this.selectionInfo = lSelectionInfo;
                return lSelectionInfo;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(PackageType pkg) {
        boolean readL = this.readLock();
        try {
            int n = this.getPackages().lastIndexOf(pkg);
            return n;
        }
        finally {
            this.readUnlock(readL);
        }
    }

    public void sort(final PackageControllerComparator<AbstractNode> comparator, final boolean sortChildren) {
        this.sorter = comparator;
        if (comparator != null) {
            this.QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void run() throws RuntimeException {
                    ArrayList lpackages = PackageController.this.getPackagesCopy();
                    try {
                        Collections.sort(lpackages, comparator);
                    }
                    catch (Throwable e) {
                        LogController.CL(true).log(e);
                    }
                    boolean sortChildrenChanged = sortChildren;
                    if (sortChildrenChanged) {
                        sortChildrenChanged = false;
                        try {
                            for (AbstractPackageNode pkg : lpackages) {
                                sortChildrenChanged |= PackageController.this._sortPackageChildren(pkg, comparator);
                            }
                        }
                        finally {
                            if (sortChildrenChanged) {
                                PackageController.this.structureChanged.set(PackageController.this.backendChanged.incrementAndGet());
                            }
                        }
                    }
                    PackageController.this.writeLock();
                    try {
                        PackageController.this.getPackages().clear();
                        PackageController.this.getPackages().addAll(lpackages);
                    }
                    finally {
                        PackageController.this.writeUnlock();
                    }
                    PackageController.this.structureChanged.set(PackageController.this.backendChanged.incrementAndGet());
                    if (sortChildrenChanged) {
                        for (AbstractPackageNode pkg : lpackages) {
                            PackageController.this._controllerPackageNodeStructureChanged(pkg, this.getQueuePrio());
                        }
                    }
                    PackageController.this._controllerStructureChanged(this.getQueuePrio());
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageType getPackageByID(long longID) {
        UniqueAlltimeID packageId = new UniqueAlltimeID(longID);
        boolean readL = this.getMapLock().readLock();
        try {
            AbstractPackageNode pkg = (AbstractPackageNode)this.uniqueAlltimeIDPackageMap.get((Object)packageId);
            if (pkg != null) {
                AbstractPackageNode abstractPackageNode = pkg;
                return (PackageType)abstractPackageNode;
            }
            PackageType PackageType = null;
            return PackageType;
        }
        finally {
            this.getMapLock().readUnlock(readL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PackageType> getPackagesByID(long[] packageUUIDs) {
        boolean readL = this.getMapLock().readLock();
        try {
            ArrayList<AbstractPackageNode> ret = new ArrayList<AbstractPackageNode>(packageUUIDs.length);
            for (long longID : packageUUIDs) {
                UniqueAlltimeID packageId = new UniqueAlltimeID(longID);
                AbstractPackageNode pkg = (AbstractPackageNode)this.uniqueAlltimeIDPackageMap.get((Object)packageId);
                if (pkg == null) continue;
                ret.add(pkg);
            }
            ArrayList<AbstractPackageNode> arrayList = ret;
            return arrayList;
        }
        finally {
            this.getMapLock().readUnlock(readL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildType getLinkByID(long longID) {
        UniqueAlltimeID childID = new UniqueAlltimeID(longID);
        boolean readL = this.getMapLock().readLock();
        try {
            AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)this.uniqueAlltimeIDChildrenMap.get((Object)childID);
            if (child != null) {
                AbstractPackageChildrenNode abstractPackageChildrenNode = child;
                return (ChildType)abstractPackageChildrenNode;
            }
            ChildType ChildType = null;
            return ChildType;
        }
        finally {
            this.getMapLock().readUnlock(readL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChildType> getLinksByID(long[] childUUIDs) {
        boolean readL = this.getMapLock().readLock();
        try {
            ArrayList<AbstractPackageChildrenNode> ret = new ArrayList<AbstractPackageChildrenNode>(childUUIDs.length);
            for (long longID : childUUIDs) {
                UniqueAlltimeID childID = new UniqueAlltimeID(longID);
                AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)this.uniqueAlltimeIDChildrenMap.get((Object)childID);
                if (child == null) continue;
                ret.add(child);
            }
            ArrayList<AbstractPackageChildrenNode> arrayList = ret;
            return arrayList;
        }
        finally {
            this.getMapLock().readUnlock(readL);
        }
    }

    public PackageControllerComparator<AbstractNode> getSorter() {
        return this.sorter;
    }

    public static final class MergePackageSettings {
        private MergePosition mergeposition = null;
        private Boolean mergePackageComments = null;

        public MergePackageSettings() {
            this.setMergePosition(null);
        }

        public MergePosition getMergePosition() {
            return this.mergeposition;
        }

        public MergePackageSettings setMergePosition(MergePosition mergeposition) {
            this.mergeposition = mergeposition == null ? MergePosition.BOTTOM : mergeposition;
            return this;
        }

        public Boolean getMergePackageComments() {
            return this.mergePackageComments;
        }

        public MergePackageSettings setMergePackageComments(Boolean mergePackageComments) {
            this.mergePackageComments = mergePackageComments;
            return this;
        }
    }
}

