/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.packagecontroller;

import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import jd.controlling.packagecontroller.AbstractNode;
import jd.nutils.NaturalOrderComparator;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;
import org.jdownloader.logging.LogController;

public abstract class PackageControllerComparator<T extends AbstractNode>
implements Comparator<T> {
    public static final PackageControllerComparator<AbstractNode> SORTER_ASC = new PackageControllerComparator<AbstractNode>(){
        private final Comparator<String> comp = new NaturalOrderComparator();

        @Override
        public int compare(AbstractNode o1, AbstractNode o2) {
            String o1s = o1.getName();
            String o2s = o2.getName();
            if (o1s == null) {
                o1s = "";
            }
            if (o2s == null) {
                o2s = "";
            }
            return this.comp.compare(o1s, o2s);
        }

        @Override
        public String getID() {
            return "jd.generic.Name";
        }

        @Override
        public boolean isAsc() {
            return true;
        }
    };
    public static final PackageControllerComparator<AbstractNode> SORTER_DESC = new PackageControllerComparator<AbstractNode>(){

        @Override
        public int compare(AbstractNode o1, AbstractNode o2) {
            return SORTER_ASC.compare(o2, o1);
        }

        @Override
        public String getID() {
            return SORTER_ASC.getID();
        }

        @Override
        public boolean isAsc() {
            return false;
        }
    };
    private static final WeakHashMap<PackageControllerComparator<AbstractNode>, String> CACHE = new WeakHashMap();

    public abstract String getID();

    public abstract boolean isAsc();

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof PackageControllerComparator) {
            PackageControllerComparator c = (PackageControllerComparator)obj;
            return c.isAsc() == this.isAsc() && StringUtils.equals((String)c.getID(), (String)this.getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageControllerComparator<AbstractNode> getComparator(String id) {
        if (id != null) {
            final boolean asc = id.startsWith("ASC.");
            if (id.endsWith("jd.generic.Name") || id.endsWith("jd.controlling.linkcrawler.CrawledPackage")) {
                return asc ? SORTER_ASC : SORTER_DESC;
            }
            try {
                WeakHashMap<PackageControllerComparator<AbstractNode>, String> weakHashMap = CACHE;
                synchronized (weakHashMap) {
                    for (Map.Entry<PackageControllerComparator<AbstractNode>, String> entry : CACHE.entrySet()) {
                        if (!id.equals(entry.getValue())) continue;
                        return entry.getKey();
                    }
                    PackageControllerComparator<AbstractNode> ret = null;
                    int columnIndex = id.indexOf("Column.");
                    if (columnIndex != -1) {
                        String colID = id.substring(columnIndex + 7);
                        if (id.contains(DownloadsTableModel.getInstance().getModelID())) {
                            for (final ExtColumn c : DownloadsTableModel.getInstance().getColumns()) {
                                if (!colID.equals(c.getID())) continue;
                                ret = new PackageControllerComparator<AbstractNode>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public int compare(AbstractNode o1, AbstractNode o2) {
                                        ExtDefaultRowSorter sorter = c.getRowSorter();
                                        sorter.setThreadSortOrderIdentifier("ASC");
                                        try {
                                            if (this.isAsc()) {
                                                int n = sorter.compare((Object)o1, (Object)o2);
                                                return n;
                                            }
                                            int n = sorter.compare((Object)o2, (Object)o1);
                                            return n;
                                        }
                                        finally {
                                            sorter.setThreadSortOrderIdentifier(null);
                                        }
                                    }

                                    @Override
                                    public String getID() {
                                        return c.getModel().getModelID() + ".Column." + c.getID();
                                    }

                                    @Override
                                    public boolean isAsc() {
                                        return asc;
                                    }
                                };
                                break;
                            }
                        }
                        if (ret == null && id.contains(LinkGrabberTableModel.getInstance().getModelID())) {
                            for (final ExtColumn c : LinkGrabberTableModel.getInstance().getColumns()) {
                                if (!colID.equals(c.getID())) continue;
                                ret = new PackageControllerComparator<AbstractNode>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public int compare(AbstractNode o1, AbstractNode o2) {
                                        ExtDefaultRowSorter sorter = c.getRowSorter();
                                        sorter.setThreadSortOrderIdentifier("ASC");
                                        try {
                                            if (this.isAsc()) {
                                                int n = sorter.compare((Object)o1, (Object)o2);
                                                return n;
                                            }
                                            int n = sorter.compare((Object)o2, (Object)o1);
                                            return n;
                                        }
                                        finally {
                                            sorter.setThreadSortOrderIdentifier(null);
                                        }
                                    }

                                    @Override
                                    public String getID() {
                                        return c.getModel().getModelID() + ".Column." + c.getID();
                                    }

                                    @Override
                                    public boolean isAsc() {
                                        return asc;
                                    }
                                };
                                break;
                            }
                        }
                    }
                    CACHE.put(ret, id);
                    return ret;
                }
            }
            catch (Throwable t) {
                LogController.CL(true).log(t);
            }
        }
        return null;
    }
}

