/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.proxy.ProxyController;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.IPCheckProvider;
import jd.controlling.reconnect.ipcheck.OfflineException;
import jd.http.Browser;
import jd.http.NoGateWayException;
import jd.http.ProxySelectorInterface;
import jd.http.StaticProxySelector;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;

public class BalancedWebIPCheck
implements IPCheckProvider {
    private static final List<String> SERVICES = new ArrayList<String>();
    protected final Browser br;
    private final Pattern pattern;
    private final Object LOCK = new Object();

    public BalancedWebIPCheck() {
        this(CFG_RECONNECT.CFG.isIPCheckUsesProxyEnabled() ? ProxyController.getInstance() : new StaticProxySelector(HTTPProxy.NONE));
    }

    public BalancedWebIPCheck(ProxySelectorInterface proxySelector) {
        this.pattern = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)");
        this.br = this.initBrowser(proxySelector);
    }

    protected Browser initBrowser(ProxySelectorInterface proxySelector) {
        Browser br = new Browser();
        br.setDebug(true);
        br.setVerbose(true);
        if (proxySelector != null) {
            br.setProxySelector(proxySelector);
        }
        br.setConnectTimeout(((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getIPCheckConnectTimeout());
        br.setReadTimeout(((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getIPCheckReadTimeout());
        return br;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IP getExternalIP() throws IPCheckException {
        Object object = this.LOCK;
        synchronized (object) {
            LogSource logger = LogController.getFastPluginLogger("BalancedWebIPCheck");
            logger.setAllowTimeoutFlush(false);
            this.br.setLogger((LogInterface)logger);
            NoGateWayException noGateWayException = null;
            UnknownHostException unknownHostException = null;
            for (String service : SERVICES) {
                IP iP;
                try {
                    Matcher matcher = this.pattern.matcher(this.br.getPage(service));
                    if (!matcher.find() || matcher.groupCount() <= 0) continue;
                    logger.clear();
                    logger.close();
                    iP = IP.getInstance(matcher.group(1));
                }
                catch (UnknownHostException e) {
                    unknownHostException = e;
                    continue;
                }
                catch (NoGateWayException e) {
                    noGateWayException = e;
                    continue;
                }
                catch (Throwable e) {
                    logger.log(e);
                    continue;
                }
                return iP;
                finally {
                    try {
                        this.br.disconnect();
                    }
                    catch (Throwable e) {}
                }
            }
            if (noGateWayException != null) {
                logger.log(noGateWayException);
            }
            if (unknownHostException != null) {
                logger.log(unknownHostException);
            }
            logger.severe("All balanced Services failed");
            logger.close();
            throw new OfflineException("All balanced Services failed");
        }
    }

    @Override
    public int getIpCheckInterval() {
        return 5;
    }

    static {
        SERVICES.add("http://ipcheck4.jdownloader.org");
        SERVICES.add("http://ipcheck3.jdownloader.org");
        SERVICES.add("http://ipcheck2.jdownloader.org");
        SERVICES.add("http://ipcheck1.jdownloader.org");
        SERVICES.add("http://ipcheck0.jdownloader.org");
        Collections.shuffle(SERVICES);
    }
}

