/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.controlling.reconnect.ProcessCallBack;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.ReconnectPluginController;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.pluginsinc.liveheader.EditScriptAction;
import jd.controlling.reconnect.pluginsinc.liveheader.GetIPAction;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderDetectionWizard;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderInvoker;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectResult;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectSettings;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderScriptConfirmDialog;
import jd.controlling.reconnect.pluginsinc.liveheader.ReconnectRecorderAction;
import jd.controlling.reconnect.pluginsinc.liveheader.RouterSendAction;
import jd.controlling.reconnect.pluginsinc.liveheader.SearchScriptAction;
import jd.controlling.reconnect.pluginsinc.liveheader.recorder.Gui;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.gui.UserIO;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.ConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.components.ExtTextField;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.OKCancelCloseUserIODefinition;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.advanced.AdvancedConfigManager;

public class LiveHeaderReconnect
extends RouterPlugin
implements ConfigEventListener {
    private ExtTextField txtUser;
    private ExtPasswordField txtPassword;
    private ExtTextField txtIP;
    private ExtTextField txtName;
    private Icon icon = new AbstractIcon("modem", 16);
    private LiveHeaderReconnectSettings settings;
    public static final String ID = "httpliveheader";

    @Override
    public Icon getIcon16() {
        return this.icon;
    }

    public LiveHeaderReconnect() {
        ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class))._getStorageHandler().getEventSender().addListener((EventListener)((Object)this));
        this.settings = (LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class);
        this.settings._getStorageHandler().getEventSender().addListener((EventListener)((Object)this));
        AdvancedConfigManager.getInstance().register(JsonConfig.create(LiveHeaderReconnectSettings.class));
    }

    void editScript(final boolean wait) {
        RouterData editing = this.settings.getRouterData();
        if (editing == null) {
            editing = new RouterData();
        }
        final RouterData rd = editing;
        editing.setScript(this.settings.getScript());
        editing.setRouterIP(this.settings.getRouterIP());
        final LiveHeaderScriptConfirmDialog d = new LiveHeaderScriptConfirmDialog(256, T.T.script(this.getRouterName(editing.getRouterName())), new AbstractIcon("reconnect", 32), _GUI.T.lit_save(), _GUI.T.lit_close(), editing, null, editing.getRouterName()){

            @Override
            public String getMessage() {
                return T.T.edit_script();
            }

            public Dialog.ModalityType getModalityType() {
                if (wait) {
                    return super.getModalityType();
                }
                return Dialog.ModalityType.MODELESS;
            }
        };
        new Thread(){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    ((OKCancelCloseUserIODefinition)UIOManager.I().show(OKCancelCloseUserIODefinition.class, (UserIODefinition)d)).throwCloseExceptions();
                    LiveHeaderReconnect.this.validateAndSet(rd);
                }
                catch (DialogClosedException e) {
                    e.printStackTrace();
                }
                catch (DialogCanceledException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getRouterName(String routerName) {
        if (StringUtils.isEmpty((String)routerName)) {
            return _GUI.T.unknown_router_name();
        }
        return routerName;
    }

    protected void validateAndSet(RouterData rd) {
        if (!StringUtils.equals((String)this.settings.getScript(), (String)rd.getScript())) {
            this.settings.setScript(rd.getScript());
            rd.setScriptID(null);
            this.settings.setRouterData(rd);
        }
    }

    @Override
    public JComponent getGUI() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0 0 0 0,wrap 3", "[][][grow,fill]", ""));
        p.setOpaque(false);
        this.txtUser = new ExtTextField();
        this.txtUser.setHelpText(T.T.LiveHeaderReconnect_getGUI_help_user());
        this.txtUser.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                LiveHeaderReconnect.this.settings.setUserName(LiveHeaderReconnect.this.txtUser.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.txtPassword = new ExtPasswordField(){

            public void onChanged() {
                LiveHeaderReconnect.this.settings.setPassword(new String(LiveHeaderReconnect.this.txtPassword.getPassword()));
            }
        };
        this.txtPassword.setHelpText(T.T.LiveHeaderReconnect_getGUI_help_password());
        this.txtIP = new ExtTextField();
        this.txtIP.setHelpText(T.T.LiveHeaderReconnect_getGUI_help_ip());
        this.txtIP.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                LiveHeaderReconnect.this.settings.setRouterIP(LiveHeaderReconnect.this.txtIP.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.txtName = new ExtTextField();
        this.txtName.setEditable(false);
        this.txtName.setBorder(null);
        SwingUtils.setOpaque((JComponent)this.txtName, (boolean)false);
        p.add((Component)this.createButton((AbstractAction)((Object)new RouterSendAction(this))), "sg buttons,aligny top,newline");
        p.add((Component)new JLabel(T.T.literally_router_model()), "");
        p.add((Component)this.txtName, "spanx");
        p.add((Component)this.createButton((AbstractAction)((Object)new GetIPAction(this))), "sg buttons,aligny top,newline");
        p.add((Component)new JLabel(T.T.literally_router_ip()), "");
        p.add((Component)this.txtIP, "spanx");
        p.add((Component)this.createButton((AbstractAction)((Object)new ReconnectRecorderAction(this))), "sg buttons,aligny top,newline");
        p.add((Component)new JLabel(T.T.literally_username()), "");
        p.add((Component)this.txtUser, "spanx");
        p.add((Component)this.createButton((AbstractAction)((Object)new EditScriptAction(this))), "sg buttons,aligny top,newline");
        p.add((Component)new JLabel(T.T.literally_password()), "");
        p.add((Component)this.txtPassword, "spanx");
        p.add((Component)this.createButton((AbstractAction)((Object)new SearchScriptAction(this))), "sg buttons,aligny top,newline");
        this.updateGUI();
        return p;
    }

    private JButton createButton(AbstractAction autoDetectAction) {
        ExtButton ret = new ExtButton(autoDetectAction);
        ret.setHorizontalAlignment(2);
        ret.setTooltipsEnabled(true);
        return ret;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return "LiveHeader";
    }

    public void routerRecord() {
        if (((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).isIPCheckGloballyDisabled()) {
            UserIO.getInstance().requestMessageDialog(1, T.T.jd_gui_swing_jdgui_settings_panels_downloadandnetwork_advanced_ipcheckdisable_warning_title(), T.T.jd_gui_swing_jdgui_settings_panels_downloadandnetwork_advanced_ipcheckdisable_warning_message());
        } else {
            new Thread(){

                @Override
                public void run() {
                    String text = LiveHeaderReconnect.this.txtIP.getText().toString();
                    if (StringUtils.isEmpty((String)text) || !IP.isValidRouterIP(text)) {
                        new GetIPAction(LiveHeaderReconnect.this).actionPerformed(null);
                    }
                    new EDTHelper<Object>(){

                        public Object edtRun() {
                            Gui jd = new Gui(LiveHeaderReconnect.this.settings.getRouterIP());
                            try {
                                ((Gui)UIOManager.I().show(null, (UserIODefinition)jd)).throwCloseExceptions();
                                if (jd.saved) {
                                    LiveHeaderReconnect.this.settings.setRouterIP(jd.ip);
                                    if (jd.user != null) {
                                        LiveHeaderReconnect.this.settings.setUserName(jd.user);
                                    }
                                    if (jd.pass != null) {
                                        LiveHeaderReconnect.this.settings.setPassword(jd.pass);
                                    }
                                    if (jd.methode != null && jd.methode.equals(LiveHeaderReconnect.this.settings.getScript())) {
                                        LiveHeaderReconnect.this.settings.setAlreadySendToCollectServer3(false);
                                    }
                                    LiveHeaderReconnect.this.settings.setScript(jd.methode);
                                    this.setName("Router Recorder Custom Script");
                                }
                            }
                            catch (DialogClosedException e) {
                                e.printStackTrace();
                            }
                            catch (DialogCanceledException e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    }.start();
                }
            }.start();
        }
    }

    @Override
    public List<ReconnectResult> runDetectionWizard(ProcessCallBack processCallBack) throws InterruptedException {
        LiveHeaderDetectionWizard wizard = new LiveHeaderDetectionWizard();
        try {
            return wizard.runOnlineScan(processCallBack);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
            return null;
        }
    }

    void updateGUI() {
        if (!Application.isHeadless()) {
            new EDTRunner(){

                protected void runInEDT() {
                    try {
                        String str = LiveHeaderReconnect.this.getRouterName();
                        if (LiveHeaderReconnect.this.settings.getRouterData().getManufactor() != null && LiveHeaderReconnect.this.settings.getRouterData().getManufactor().length() > 0) {
                            if (str.length() > 0) {
                                str = str + " - ";
                            }
                            str = str + LiveHeaderReconnect.this.settings.getRouterData().getManufactor();
                        }
                        LiveHeaderReconnect.this.txtName.setText(str);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        LiveHeaderReconnect.this.txtIP.setText(LiveHeaderReconnect.this.settings.getRouterIP());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        LiveHeaderReconnect.this.txtPassword.setPassword(LiveHeaderReconnect.this.settings.getPassword().toCharArray());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        LiveHeaderReconnect.this.txtUser.setText(LiveHeaderReconnect.this.settings.getUserName());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        if (keyHandler.isChildOf((ConfigInterface)this.settings)) {
            this.updateGUI();
            if (!keyHandler.getKey().equalsIgnoreCase("AlreadySendToCollectServer2")) {
                this.settings.setAlreadySendToCollectServer3(false);
            }
        } else if (!Application.isHeadless() && this.settings.isAutoReplaceIPEnabled()) {
            RouterSendAction action = new RouterSendAction(this);
            if (!action.isEnabled()) {
                return;
            }
            LogController.CL().info("Successful reonnects in a row: " + ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getSuccessCounter());
            LiveHeaderReconnect liveHeaderReconnect = this;
            synchronized (liveHeaderReconnect) {
                if (!this.settings.isAlreadySendToCollectServer3() && ReconnectPluginController.getInstance().getActivePlugin() == this && ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getSuccessCounter() > 3) {
                    if (CloseReason.OK == ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)new ConfirmDialog(1060, T.T.LiveHeaderReconnect_onConfigValueModified_ask_title(), T.T.LiveHeaderReconnect_onConfigValueModified_ask_msg(), this.icon, null, null){
                        {
                            this.setTimeout(300000);
                        }
                    })).getCloseReason()) {
                        action.actionPerformed(null);
                    }
                    this.settings.setAlreadySendToCollectServer3(true);
                }
            }
        }
    }

    @Override
    public void setSetup(ReconnectResult reconnectResult) {
        if (reconnectResult.getInvoker() instanceof LiveHeaderInvoker) {
            LiveHeaderInvoker i = (LiveHeaderInvoker)reconnectResult.getInvoker();
            RouterData rd = ((LiveHeaderReconnectResult)reconnectResult).getRouterData();
            rd.setRouterName(i.getName());
            this.settings.setRouterData(rd);
            this.settings.setPassword(i.getPass());
            this.settings.setUserName(i.getUser());
            this.settings.setRouterIP(i.getRouter());
            LiveHeaderReconnectSettings liveHeaderReconnectSettings = (LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class);
            if (i.getScript() != null && i.getScript().equals(liveHeaderReconnectSettings.getScript())) {
                liveHeaderReconnectSettings.setAlreadySendToCollectServer3(false);
            }
            this.settings.setScript(i.getScript());
            ReconnectConfig reconnectConfig = (ReconnectConfig)JsonConfig.create(ReconnectConfig.class);
            reconnectConfig.setSecondsBeforeFirstIPCheck((int)reconnectResult.getOfflineDuration() / 1000);
            reconnectConfig.setSecondsToWaitForIPChange((int)(reconnectResult.getMaxSuccessDuration() / 1000L));
            reconnectConfig.setSecondsToWaitForOffline((int)reconnectResult.getMaxOfflineDuration() / 1000);
            this.updateGUI();
        }
    }

    @Override
    public ReconnectInvoker getReconnectInvoker() {
        String script = this.settings.getScript();
        if (script == null) {
            return null;
        }
        String user = this.settings.getUserName();
        String pass = this.settings.getPassword();
        String ip = this.settings.getRouterIP();
        RouterData rd = this.settings.getRouterData();
        LiveHeaderInvoker ret = new LiveHeaderInvoker(this, script, user, pass, ip, this.getRouterName());
        if (rd != null && StringUtils.equals((String)rd.getScript(), (String)script)) {
            ret.setRouterData(rd);
        }
        return ret;
    }

    protected String getRouterName() {
        String ret;
        RouterData routerData = this.settings.getRouterData();
        if (routerData != null && StringUtils.isNotEmpty((String)(ret = routerData.getRouterName()))) {
            return ret;
        }
        return "<unknown router>";
    }
}

