/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectSettings;
import jd.controlling.reconnect.pluginsinc.liveheader.ReconnectFailedException;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.controlling.reconnect.pluginsinc.liveheader.validate.RetryWithReplacedScript;
import jd.controlling.reconnect.pluginsinc.liveheader.validate.Scriptvalidator;
import jd.gui.swing.laf.LookAndFeelController;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.ExceptionDialogInterface;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiveHeaderScriptConfirmDialog
extends AbstractDialog<Object> {
    protected RouterData routerData;
    private String gateway;
    private String name;
    private JTextPane textpane;
    private LogSource logger;
    private HashSet<String> confirmed = new HashSet();
    private AppAction editAction;
    private Map<String, String> internalVariables = null;
    private Map<String, String> parsedVariables = null;

    public static void main(String[] args) {
        Application.setApplication((String)".jd_home");
        LookAndFeelController.getInstance().init();
        RouterData rd = new RouterData();
        rd.setScript(((InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)new InputDialog(64, "", "", ""))).getText());
        UIOManager.I().show(null, (UserIODefinition)new LiveHeaderScriptConfirmDialog(rd, "myip.ne", "My Router"));
    }

    protected int getPreferredHeight() {
        int pr = super.getPreferredHeight();
        if (pr > 0) {
            return Math.min(750, pr);
        }
        return Math.min(this.getRawPreferredSize().height + 20, 750);
    }

    protected int getPreferredWidth() {
        int pr = super.getPreferredHeight();
        if (pr > 0) {
            return Math.min(1000, pr);
        }
        return Math.min(this.getRawPreferredSize().width + 20, 1000);
    }

    public LiveHeaderScriptConfirmDialog(RouterData test, String gatewayAdressHost, String name) {
        this(288, _GUI.T.runDetectionWizard_confirm_title(), new AbstractIcon("reconnect", 32), _GUI.T.lit_continue(), _GUI.T.lit_skip(), test, gatewayAdressHost, name);
    }

    public LiveHeaderScriptConfirmDialog(int flag, String title, Icon icon, String okOption, String cancelOption, RouterData test, String gatewayAdressHost, String name) {
        super(flag, title, icon, okOption, cancelOption);
        this.routerData = test;
        this.logger = LogController.getInstance().getLogger("LiveHeaderScriptConfirmDialog");
        this.gateway = gatewayAdressHost;
        this.name = name;
        this.addEditAction();
    }

    public void addEditAction() {
        AbstractAction[] abstractActionArray = new AbstractAction[1];
        this.editAction = new AppAction(){
            {
                this.setName(_GUI.T.LiveHeaderScriptConfirmDialog_LiveHeaderScriptConfirmDialog_edit());
            }

            public void actionPerformed(ActionEvent e) {
                InputDialog dialog = new InputDialog(320, T.T.script(LiveHeaderScriptConfirmDialog.this.routerData.getRouterName()), T.T.script_check_modify(), LiveHeaderScriptConfirmDialog.this.routerData.getScript(), new AbstractIcon("edit", 32), T.T.jd_controlling_reconnect_plugins_liveheader_LiveHeaderReconnect_actionPerformed_save(), null){

                    public boolean isRemoteAPIEnabled() {
                        return super.isRemoteAPIEnabled();
                    }
                };
                dialog.setPreferredSize(new Dimension(700, 400));
                InputDialogInterface d = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)dialog);
                try {
                    d.throwCloseExceptions();
                    LiveHeaderScriptConfirmDialog.this.routerData.setScript(d.getText());
                    LiveHeaderScriptConfirmDialog.this.routerData.setScriptID(null);
                    try {
                        final LiveHeaderReconnectSettings settings = (LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class);
                        RouterData rd = LiveHeaderScriptConfirmDialog.this.routerData;
                        new Scriptvalidator(rd){

                            @Override
                            protected void replaceAuthHeader(String authorization, String lUsername, String lPassword) throws RetryWithReplacedScript, Exception {
                                if (this.defaultPasswords.contains(lPassword.toLowerCase(Locale.ENGLISH)) && this.defaultUsernames.contains(lUsername.toLowerCase(Locale.ENGLISH))) {
                                    return;
                                }
                                if (StringUtils.isEmpty((String)settings.getPassword())) {
                                    settings.setPassword(lPassword);
                                }
                                if (StringUtils.isEmpty((String)settings.getUserName())) {
                                    settings.setUserName(lPassword);
                                }
                                if (StringUtils.isNotEmpty((String)settings.getPassword()) && !StringUtils.equals((String)settings.getPassword(), (String)lPassword)) {
                                    if (UIOManager.I().showConfirmDialog(0, T.T.please_check(), T.T.please_confirm_password_change(authorization, lPassword), null, _GUI.T.lit_yes(), _GUI.T.lit_no())) {
                                        settings.setPassword(lPassword);
                                    } else {
                                        return;
                                    }
                                }
                                if (StringUtils.isNotEmpty((String)settings.getUserName()) && !StringUtils.equals((String)settings.getUserName(), (String)lUsername)) {
                                    if (UIOManager.I().showConfirmDialog(0, T.T.please_check(), T.T.please_confirm_username_change(authorization, lUsername), null, _GUI.T.lit_yes(), _GUI.T.lit_no())) {
                                        settings.setUserName(lUsername);
                                    } else {
                                        return;
                                    }
                                }
                                throw new RetryWithReplacedScript(this.rd.getScript(), authorization.substring("Basic ".length()), "%%%basicauth%%%");
                            }

                            @Override
                            protected void replacePasswordParameter(String key, String value) throws RetryWithReplacedScript, Exception {
                                if (this.defaultPasswords.contains(value.toLowerCase(Locale.ENGLISH))) {
                                    return;
                                }
                                if (LiveHeaderScriptConfirmDialog.this.confirmed.contains(key + "=" + value)) {
                                    return;
                                }
                                if (StringUtils.equals((String)value, (String)settings.getPassword())) {
                                    super.replacePasswordParameter(key, value);
                                } else if (this.confirm(key, value)) {
                                    if (StringUtils.isNotEmpty((String)settings.getPassword()) && !StringUtils.equals((String)settings.getPassword(), (String)value)) {
                                        return;
                                    }
                                    if (StringUtils.isEmpty((String)settings.getPassword())) {
                                        settings.setPassword(value);
                                    }
                                    super.replacePasswordParameter(key, value);
                                } else {
                                    LiveHeaderScriptConfirmDialog.this.confirmed.add(key + "=" + value);
                                }
                            }

                            @Override
                            protected void replaceUsernameParameter(String key, String value) throws RetryWithReplacedScript, Exception {
                                if (this.defaultUsernames.contains(value.toLowerCase(Locale.ENGLISH))) {
                                    return;
                                }
                                if (LiveHeaderScriptConfirmDialog.this.confirmed.contains(key + "=" + value)) {
                                    return;
                                }
                                if (StringUtils.equals((String)value, (String)settings.getUserName())) {
                                    super.replaceUsernameParameter(key, value);
                                } else if (this.confirm(key, value)) {
                                    if (StringUtils.isNotEmpty((String)settings.getUserName()) && !StringUtils.equals((String)settings.getUserName(), (String)value)) {
                                        return;
                                    }
                                    if (StringUtils.isEmpty((String)settings.getUserName())) {
                                        settings.setUserName(value);
                                    }
                                    super.replaceUsernameParameter(key, value);
                                } else {
                                    LiveHeaderScriptConfirmDialog.this.confirmed.add(key + "=" + value);
                                }
                            }

                            protected boolean confirm(String key, String value) {
                                ConfirmDialog d = new ConfirmDialog(0, T.T.please_check(), T.T.please_check_sensitive_data_after_edit(key + "=" + value), (Icon)new AbstractIcon("question", 32), T.T.yes_replace(), T.T.no_keep());
                                d.setPreferredWidth(500);
                                try {
                                    ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                                    return true;
                                }
                                catch (DialogClosedException e) {
                                    e.printStackTrace();
                                }
                                catch (DialogCanceledException e) {
                                    e.printStackTrace();
                                }
                                return false;
                            }
                        }.run();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)new ConfirmDialog(16, _GUI.T.lit_warning(), _GUI.T.LiveHeaderReconnect_validateAndSet_object_(), null, null, null));
                    }
                    LiveHeaderScriptConfirmDialog.this.updateScriptInfo();
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
            }
        };
        abstractActionArray[0] = this.editAction;
        this.setLeftActions(abstractActionArray);
    }

    protected Object createReturnValue() {
        return null;
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 2", "[align right][grow,fill]", "[]");
        this.addMessage(p);
        p.add(this.getLabel(_GUI.T.LiveHeaderScriptConfirmDialog_layoutDialogContent_routername()));
        p.add((Component)new JLabel(StringUtils.isEmpty((String)this.name) ? T.T.unknown() : this.name));
        if (StringUtils.isNotEmpty((String)this.routerData.getManufactor())) {
            p.add(this.getLabel(_GUI.T.LiveHeaderScriptConfirmDialog_layoutDialogContent_Manufactor()));
            p.add((Component)new JLabel(this.routerData.getManufactor()));
        }
        if (this.routerData.getAvgScD() > 0L) {
            p.add(this.getLabel(_GUI.T.LiveHeaderScriptConfirmDialog_layoutDialogContent_time()));
            p.add((Component)new JLabel(TimeFormatter.formatMilliSeconds((long)this.routerData.getAvgScD(), (int)0)));
        }
        if (StringUtils.isNotEmpty((String)this.gateway)) {
            p.add(this.getLabel(_GUI.T.LiveHeaderScriptConfirmDialog_layoutDialogContent_routerip()));
            p.add((Component)new JLabel(this.gateway));
        }
        p.add(this.getLabel(_GUI.T.LiveHeaderScriptConfirmDialog_layoutDialogContent_script_overview()));
        p.add(Box.createHorizontalGlue());
        this.textpane = this.addMessageComponent();
        p.add((Component)new JScrollPane(this.textpane), (Object)"pushx,growx,spanx,pushy,growy");
        this.updateScriptInfo();
        if (StringUtils.isEmpty((String)this.textpane.toString())) {
            this.editAction.actionPerformed(null);
        }
        return p;
    }

    protected void addMessage(MigPanel p) {
        JTextPane textField = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return true;
            }
        };
        Font font = textField.getFont();
        textField.setContentType("text/plain");
        textField.setFont(font);
        textField.setText(this.getMessage());
        textField.setEditable(false);
        textField.setBackground(null);
        textField.setOpaque(false);
        textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        textField.setCaretPosition(0);
        p.add((Component)textField, (Object)"spanx,alignx left");
    }

    public String getMessage() {
        return T.T.confirm_script();
    }

    public void updateScriptInfo() {
        try {
            this.textpane.setText(this.toOverView(this.routerData.getScript()));
        }
        catch (Throwable e) {
            this.textpane.setText(_GUI.T.LiveHeaderScriptConfirmDialog_layoutDialogContent_invalidscript());
            UIOManager.I().show(ExceptionDialogInterface.class, (UserIODefinition)new ExceptionDialog(8, e.getMessage(), e.getMessage(), e, null, _GUI.T.lit_close()));
        }
    }

    private static String[] splitLines(String source) {
        return source.split("\r\n|\r|\n");
    }

    private String toOverView(String script) throws Exception {
        if (StringUtils.isEmpty((String)script)) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", URLEncode.encodeRFC2396((String)"<Username required>"));
        map.put("pass", URLEncode.encodeRFC2396((String)"<Password required>"));
        map.put("username", URLEncode.encodeRFC2396((String)"<Username required>"));
        map.put("password", URLEncode.encodeRFC2396((String)"<Password required>"));
        map.put("basicauth", URLEncode.encodeRFC2396((String)"<Basic Authentication. Username and Password required>"));
        map.put("auth", URLEncode.encodeRFC2396((String)"<Basic Authentication. Username and Password required>"));
        if (StringUtils.isEmpty((String)this.gateway)) {
            map.put("ip", "your.router.ip");
            map.put("routerip", "your.router.ip");
            map.put("host", "your.router.ip");
        } else {
            map.put("ip", this.gateway);
            map.put("routerip", this.gateway);
            map.put("host", this.gateway);
        }
        this.internalVariables = Collections.unmodifiableMap(map);
        this.logger.info("Internal Variables: " + this.internalVariables);
        this.parsedVariables = new HashMap<String, String>();
        if (script != null) {
            script = script.replaceAll("\\[\\[\\[", "<");
            script = script.replaceAll("\\]\\]\\]", ">");
            script = script.replaceAll("<REQUEST(.*?)>", "<REQUEST$1><![CDATA[");
            script = script.replaceAll("</REQUEST>", "]]></REQUEST>");
            script = script.replaceAll("<RESPONSE(.*?)>", "<RESPONSE$1><![CDATA[");
            script = script.replaceAll("</RESPONSE.*>", "]]></RESPONSE>");
        }
        StringBuilder sb = new StringBuilder();
        Document xmlScript = JDUtilities.parseXmlString(script);
        if (xmlScript == null) {
            this.logger.severe("Error while parsing the xml string: " + script);
            throw new ReconnectException("Error while parsing the xml string");
        }
        Node root = xmlScript.getChildNodes().item(0);
        if (root == null || !root.getNodeName().equalsIgnoreCase("HSRC")) {
            this.logger.severe("Root Node must be [[[HSRC]]]*[/HSRC]");
            throw new ReconnectException("Error while parsing the xml string. Root Node must be [[[HSRC]]]*[/HSRC]");
        }
        NodeList steps = root.getChildNodes();
        for (int step = 0; step < steps.getLength(); ++step) {
            Node current = steps.item(step);
            if (current.getNodeType() == 3) continue;
            if (!current.getNodeName().equalsIgnoreCase("STEP")) {
                this.logger.severe("Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + current.getNodeName());
                throw new ReconnectException("Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + current.getNodeName());
            }
            NodeList toDos = current.getChildNodes();
            int toDosLength = toDos.getLength();
            for (int toDoStep = 0; toDoStep < toDosLength; ++toDoStep) {
                NamedNodeMap attributes;
                Node toDo = toDos.item(toDoStep);
                if (toDo.getNodeName().equalsIgnoreCase("DEFINE")) {
                    attributes = toDo.getAttributes();
                    for (int attribute = 0; attribute < attributes.getLength(); ++attribute) {
                        String key = attributes.item(attribute).getNodeName();
                        String value = attributes.item(attribute).getNodeValue();
                        String[] tmp = value.split("\\%\\%\\%(.*?)\\%\\%\\%", -1);
                        String[] params = new Regex(value, "%%%(.*?)%%%").getColumn(0);
                        if (params.length > 0) {
                            StringBuilder newValue = new StringBuilder(tmp[0]);
                            int tmpLength = tmp.length;
                            for (int i = 1; i <= tmpLength; ++i) {
                                if (i > params.length) continue;
                                this.logger.finer("Replace variable: *********(" + params[i - 1] + ")");
                                newValue.append(this.getModifiedVariable(params[i - 1]));
                                if (i >= tmpLength) continue;
                                newValue.append(tmp[i]);
                            }
                            value = newValue.toString();
                        }
                        this.append(sb, "Define Variable " + key + "\t=\t" + value);
                        this.putVariable(key, value);
                    }
                }
                if (toDo.getNodeName().equalsIgnoreCase("PARSE")) {
                    String[] parseLines;
                    for (String parseLine : parseLines = LiveHeaderScriptConfirmDialog.splitLines(toDo.getChildNodes().item(0).getNodeValue().trim())) {
                        String varname = new Regex(parseLine, "(.*?):").getMatch(0);
                        String pattern = new Regex(parseLine, ".*?:(.+)").getMatch(0);
                        if (varname == null || pattern == null) continue;
                        varname = varname.trim();
                        pattern = pattern.trim();
                        this.putVariable(varname, URLEncode.encodeRFC2396((String)("<Variable " + varname + ">")));
                        this.append(sb, "\t-> Search in HTML Response:  " + varname + " = Regex:" + pattern);
                    }
                }
                if (toDo.getNodeName().equalsIgnoreCase("REQUEST")) {
                    if (toDo.getChildNodes().getLength() != 1) {
                        this.logger.severe("A REQUEST Tag is not allowed to have childTags.");
                        throw new ReconnectException("A REQUEST Tag is not allowed to have childTags.");
                    }
                    attributes = toDo.getAttributes();
                    Object retbr = null;
                    try {
                        this.doRequest(toDo.getChildNodes().item(0).getNodeValue().trim(), sb, attributes.getNamedItem("https") != null, attributes.getNamedItem("raw") != null);
                    }
                    catch (Exception e) {
                        if (e instanceof ReconnectException) {
                            throw e;
                        }
                        retbr = null;
                    }
                }
                if (StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"RESPONSE")) {
                    String[] keys;
                    this.logger.finer("get Response");
                    if (toDo.getChildNodes().getLength() != 1) {
                        this.logger.severe("A RESPONSE Tag is not allowed to have childTags.");
                        throw new ReconnectException("A RESPONSE Tag is not allowed to have childTags.");
                    }
                    attributes = toDo.getAttributes();
                    if (attributes.getNamedItem("keys") == null) {
                        this.logger.severe("A RESPONSE Node needs a Keys Attribute: " + toDo);
                        throw new ReconnectException("A RESPONSE Node needs a Keys Attribute: " + toDo);
                    }
                    for (String s : keys = attributes.getNamedItem("keys").getNodeValue().split("\\;")) {
                        this.append(sb, "\t-> Search Variable in HTML Response:  " + s);
                    }
                }
                if (StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"WAIT")) {
                    attributes = toDo.getAttributes();
                    Node item = attributes.getNamedItem("seconds");
                    if (item == null) {
                        this.logger.severe("A Wait Step needs a Waittimeattribute: e.g.: <WAIT seconds=\"15\"/>");
                        throw new ReconnectException("A Wait Step needs a Waittimeattribute: e.g.: <WAIT seconds=\"15\"/>");
                    }
                    int seconds = Formatter.filterInt((String)item.getNodeValue());
                    if (seconds > 0) {
                        this.append(sb, "Wait " + TimeFormatter.formatMilliSeconds((long)(seconds * 1000), (int)0));
                    }
                }
                if (!StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"TIMEOUT")) continue;
                attributes = toDo.getAttributes();
                Node item = attributes.getNamedItem("seconds");
                if (item == null) {
                    this.logger.severe("A valid timeout must be set: e.g.: <TIMEOUT seconds=\"15\"/>");
                    throw new ReconnectException("A valid timeout must be set: e.g.: <TIMEOUT seconds=\"15\"/>");
                }
                int seconds = Formatter.filterInt((String)item.getNodeValue());
                if (seconds <= 0) continue;
                this.logger.finer("Timeout set to " + seconds + " seconds");
                this.append(sb, "Set HTTP Timeout to " + TimeFormatter.formatMilliSeconds((long)(seconds * 1000), (int)0));
            }
        }
        return sb.toString();
    }

    private void doRequest(String request, StringBuilder sb, boolean ishttps, boolean israw) throws ReconnectException, IOException {
        String protocoll;
        String[] requestLines;
        StringBuilder post = new StringBuilder();
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        if (israw) {
            // empty if block
        }
        String[] tmp = request.split("\\%\\%\\%(.*?)\\%\\%\\%");
        String[] params = new Regex(request, "%%%(.*?)%%%").getColumn(0);
        if (params.length > 0) {
            String modifiedVariable;
            String key;
            int i;
            int tmpLength;
            StringBuilder req;
            if (request.startsWith(params[0])) {
                req = new StringBuilder();
                tmpLength = tmp.length;
                for (i = 0; i <= tmpLength; ++i) {
                    key = params[i - 1];
                    modifiedVariable = this.getModifiedVariable(key);
                    this.logger.finer("Replace variable: " + modifiedVariable + "(" + key + ")");
                    req.append(URLEncode.encodeRFC2396((String)modifiedVariable));
                    if (i >= tmpLength) continue;
                    req.append(tmp[i]);
                }
            } else {
                req = new StringBuilder(tmp[0]);
                tmpLength = tmp.length;
                for (i = 1; i <= tmpLength; ++i) {
                    if (i > params.length) continue;
                    key = params[i - 1];
                    modifiedVariable = this.getModifiedVariable(key);
                    this.logger.finer("Replace variable: " + modifiedVariable + "(" + key + ")");
                    req.append(URLEncode.encodeRFC2396((String)modifiedVariable));
                    if (i >= tmpLength) continue;
                    req.append(tmp[i]);
                }
            }
            request = req.toString();
        }
        if ((requestLines = LiveHeaderScriptConfirmDialog.splitLines(request)).length == 0) {
            throw new ReconnectException("Parse Fehler:" + request);
        }
        tmp = requestLines[0].split(" ");
        if (tmp.length < 2) {
            throw new ReconnectException("Konnte Requesttyp nicht finden: " + requestLines[0]);
        }
        String requestType = tmp[0];
        String path = tmp[1];
        boolean headersEnd = false;
        String host = null;
        int requestLinesLength = requestLines.length;
        for (int li = 1; li < requestLinesLength; ++li) {
            if (headersEnd) {
                post.append(requestLines[li]);
                post.append(new char[]{'\r', '\n'});
                continue;
            }
            if (requestLines[li].trim().length() == 0) {
                headersEnd = true;
                continue;
            }
            String[] p = requestLines[li].split("\\:");
            if (p.length < 2) {
                this.logger.warning("Syntax Fehler in: " + requestLines[li] + "\r\n Vermute Post Parameter");
                headersEnd = true;
                --li;
                continue;
            }
            requestProperties.put(p[0].trim().toLowerCase(Locale.ENGLISH), requestLines[li].substring(p[0].length() + 1).trim());
            if (!p[0].trim().equalsIgnoreCase("HOST")) continue;
            host = requestLines[li].substring(p[0].length() + 1).trim();
        }
        if (host == null) {
            throw new ReconnectException("Host not available: " + request);
        }
        if (requestProperties != null) {
            // empty if block
        }
        String string = protocoll = ishttps ? "https://" : "http://";
        if (StringUtils.equalsIgnoreCase((String)requestType, (String)"AUTH")) {
            this.logger.finer("Convert AUTH->GET");
        }
        if (StringUtils.equalsIgnoreCase((String)requestType, (String)"GET") || StringUtils.equalsIgnoreCase((String)requestType, (String)"AUTH")) {
            String authorization;
            URL url = new URL(protocoll + host + path);
            this.append(sb, "\r\nHTTP Request " + requestType + " " + protocoll + host + url.getPath());
            String cookie = (String)requestProperties.get("cookie");
            if (StringUtils.isNotEmpty((String)cookie)) {
                this.append(sb, "\tCookie:\t" + this.decode(cookie));
            }
            if (StringUtils.isNotEmpty((String)(authorization = (String)requestProperties.get("authorization")))) {
                this.append(sb, "\tAuthorization:\t" + this.decode(authorization));
            }
            int i = 1;
            for (KeyValuePair pa : HttpConnection.parseParameterList((String)url.getQuery())) {
                this.append(sb, "\tParameter #" + i++ + ": \t" + this.decode(pa.key) + "\t=\t" + this.decode(pa.value));
            }
        } else if (StringUtils.equalsIgnoreCase((String)requestType, (String)"POST") || StringUtils.equalsIgnoreCase((String)requestType, (String)"PUT")) {
            String authorization;
            String poster = post.toString().trim();
            URL url = new URL(protocoll + host + path);
            this.append(sb, "\r\nHTTP Request " + requestType + " " + protocoll + host + path);
            String cookie = (String)requestProperties.get("cookie");
            if (StringUtils.isNotEmpty((String)cookie)) {
                this.append(sb, "\tCookie:\t" + this.decode(cookie));
            }
            if (StringUtils.isNotEmpty((String)(authorization = (String)requestProperties.get("authorization")))) {
                this.append(sb, "\tAuthorization:\t" + this.decode(authorization));
            }
            int i = 1;
            for (KeyValuePair pa : HttpConnection.parseParameterList((String)url.getQuery())) {
                this.append(sb, "\tParameter #" + i++ + ": \t" + this.decode(pa.key) + "\t=\t" + this.decode(pa.value));
            }
            for (KeyValuePair pa : HttpConnection.parseParameterList((String)poster)) {
                this.append(sb, "\tParameter #" + i++ + ": \t" + this.decode(pa.key) + "\t=\t" + this.decode(pa.value));
            }
        } else {
            this.logger.severe("Unknown/Unsupported requestType: " + requestType);
            throw new ReconnectException("Host not available: " + request);
        }
    }

    private String decode(String key) {
        try {
            String newKey;
            while (StringUtils.isNotEmpty((String)(newKey = Encoding.htmlDecode((String)key))) && !StringUtils.equals((String)newKey, (String)key)) {
                key = newKey;
            }
        }
        catch (Throwable e) {
        }
        return key;
    }

    private void append(StringBuilder sb, String string) {
        if (sb.length() > 0) {
            sb.append("\r\n");
        }
        sb.append(string);
    }

    private void putVariable(String key, String value) throws ReconnectFailedException {
        if (key != null) {
            String lowerKey = key.toLowerCase(Locale.ENGLISH);
            if (this.internalVariables.containsKey(lowerKey)) {
                throw new ReconnectFailedException("Cannot change internal varbiable:" + lowerKey);
            }
            if (value == null) {
                this.logger.info("Remove Variable:" + lowerKey + "=" + this.parsedVariables.remove(lowerKey));
            } else {
                this.parsedVariables.put(lowerKey, value);
                this.logger.info("Set Variable:" + lowerKey + "->" + value);
            }
        }
    }

    private String getVariable(String key) throws ReconnectFailedException {
        if (key != null) {
            String lowerKey = key.toLowerCase(Locale.ENGLISH);
            if (this.internalVariables.containsKey(lowerKey)) {
                return this.internalVariables.get(lowerKey);
            }
            if (this.parsedVariables.containsKey(lowerKey)) {
                return this.parsedVariables.get(lowerKey);
            }
            this.logger.info("Variable not set:" + lowerKey);
        }
        return null;
    }

    private String getModifiedVariable(String key) throws ReconnectException {
        if (StringUtils.equalsIgnoreCase((String)"timestamp", (String)key)) {
            return Long.toString(System.currentTimeMillis());
        }
        if (StringUtils.containsIgnoreCase((String)key, (String)"random:")) {
            try {
                String[] params = new Regex(key, "random\\:(\\d+):(.+)").getRow(0);
                String possiblechars = params[1];
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Integer.parseInt(params[0]); ++i) {
                    sb.append(possiblechars.charAt((int)(Math.random() * (double)possiblechars.length())));
                }
                return sb.toString();
            }
            catch (Exception e) {
                throw new ReconnectException(e);
            }
        }
        int index = key.indexOf(":::");
        String value = null;
        if (index == -1) {
            value = this.getVariable(key);
            return value == null ? "" : value;
        }
        String keyValue = key.substring(key.lastIndexOf(":::") + 3);
        value = this.getVariable(keyValue);
        if (value == null) {
            return "";
        }
        while ((index = key.indexOf(":::")) >= 0) {
            if (value == null) {
                this.logger.info("Modified Variable broken: " + key);
                return "";
            }
            String method = key.substring(0, index);
            key = key.substring(index + 3);
            if (StringUtils.equalsIgnoreCase((String)method, (String)"URLENCODE")) {
                value = "<Variable: UrlEncode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"URLDECODE")) {
                value = "<Variable: UrlDecode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"UTF8DECODE")) {
                value = "<Variable: UTF8Decode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"UTF8ENCODE")) {
                value = "<Variable: UTF8Encode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"MD5")) {
                value = "<Variable: MD5(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"SHA256")) {
                value = "<Variable: SHA256(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"BASE64_SHA256")) {
                value = "<Variable: Base64(SHA256(\"" + key + "\"))>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"BASE64")) {
                value = "<Variable: Base64(\"" + key + "\")>";
                continue;
            }
            throw new ReconnectException("Unsupported Type: " + method);
        }
        return value;
    }

    protected JTextPane addMessageComponent() {
        JTextPane textField = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        Font font = textField.getFont();
        textField.setContentType("text/plain");
        textField.setFont(font);
        textField.setText(this.getMessage());
        textField.setEditable(false);
        textField.setBackground(null);
        textField.setOpaque(false);
        textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        textField.setCaretPosition(0);
        TabStop[] tabs = new TabStop[]{new TabStop(20.0f, 0, 0), new TabStop(120.0f, 0, 0), new TabStop(300.0f, 0, 0), new TabStop(320.0f, 0, 0)};
        TabSet tabset = new TabSet(tabs);
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.TabSet, tabset);
        textField.setParagraphAttributes(aset, false);
        return textField;
    }

    private Component getLabel(String str) {
        JLabel ret = new JLabel(str);
        ret.setEnabled(false);
        return ret;
    }
}

