/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader.recorder;

import java.net.Socket;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import jd.controlling.reconnect.pluginsinc.liveheader.recorder.ProxyThread;

public class Proxy
extends Thread {
    public static final int FORWARD = 2;
    public static final int RECORD_HEADER = 4;
    public static final int CHANGE_HEADER = 8;
    private Socket socket;
    private Vector<String> steps = null;
    private String serverip;
    private int port;
    private boolean ishttps = false;
    private boolean israw = false;

    public Proxy(Socket socket, Vector<String> steps, String serverip, int port, boolean ishttps, boolean israw) {
        super("JDProxy");
        this.socket = socket;
        this.steps = steps;
        this.serverip = serverip;
        this.port = port;
        this.ishttps = ishttps;
        this.israw = israw;
    }

    @Override
    public void run() {
        Socket incoming = this.socket;
        Socket outgoing = null;
        try {
            if (!this.ishttps) {
                outgoing = new Socket(this.serverip, this.port);
            } else {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                outgoing = socketFactory.createSocket(this.serverip, this.port);
            }
            ProxyThread thread1 = new ProxyThread(incoming, outgoing, 12, this.steps, this.ishttps, this.israw);
            thread1.setHost(this.serverip);
            thread1.setName("Client2Router");
            thread1.start();
            ProxyThread thread2 = new ProxyThread(outgoing, incoming, 8, this.steps, this.ishttps, this.israw);
            thread2.setHost(this.serverip);
            thread2.setName("Router2Client");
            thread2.start();
            thread2.join();
            try {
                outgoing.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                incoming.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                outgoing.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                incoming.shutdownOutput();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

