/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.speedporthybrid;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.controlling.proxy.NoProxySelector;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.IPCheckProvider;
import jd.controlling.reconnect.ipcheck.InvalidIPException;
import jd.controlling.reconnect.pluginsinc.speedporthybrid.SessionInvalidException;
import jd.controlling.reconnect.pluginsinc.speedporthybrid.SpeedPortHybridReconnectConfig;
import jd.http.Browser;
import jd.http.ProxySelectorInterface;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.StorageException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.components.ExtTextField;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.extmanager.Log;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.parser.UrlQuery;
import org.appwork.utils.swing.SwingUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class SpeedPortHybrid
extends RouterPlugin
implements IPCheckProvider {
    public static final String ID = "SpeedPortHybrid";
    private Icon icon;
    private ReconnectInvoker invoker;
    private ExtPasswordField txtPassword;
    private SpeedPortHybridReconnectConfig config = (SpeedPortHybridReconnectConfig)JsonConfig.create(SpeedPortHybridReconnectConfig.class);
    private ExtTextField txtIP;
    private Browser br;
    private String derivedk;
    private String csrf;
    private String challengev;
    private String lte_tunnel;
    private String dsl_tunnel;
    private String bonding;
    private String ipv4;

    public static void main(String[] args) throws StorageException, IOException {
        File file = new File("C:\\Users\\Thomas\\Desktop\\interfaces.json");
        Application.setApplication((String)".appwork");
        String[] lte_tunnel = new Regex(IO.readFileToString((File)file), "\\'IPv4_address\\'\\s*\\:\\s*\\'([^']*)").getColumn(0);
        System.out.println(lte_tunnel);
    }

    private String PBKDF2Key(String password, String salt) throws Exception {
        PBEKeySpec spec = new PBEKeySpec(Hash.getSHA256((String)password).toCharArray(), salt.getBytes("UTF-8"), 1000, 128);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        byte[] hash = skf.generateSecret(spec).getEncoded();
        return HexFormatter.byteArrayToHex((byte[])hash);
    }

    public String encrypt(String pt) throws UnsupportedEncodingException, IllegalStateException, InvalidCipherTextException {
        Log.info((String)("Encrypt " + pt));
        byte[] iv = HexFormatter.hexToByteArray((String)this.challengev.substring(16, 32));
        byte[] adata = HexFormatter.hexToByteArray((String)this.challengev.substring(32, 48));
        CCMBlockCipher chipher = new CCMBlockCipher((BlockCipher)new AESFastEngine());
        AEADParameters params = new AEADParameters(new KeyParameter(HexFormatter.hexToByteArray((String)this.derivedk)), 64, iv);
        chipher.init(true, (CipherParameters)params);
        byte[] enc = pt.getBytes("UTF-8");
        byte[] tmp = new byte[enc.length + adata.length];
        chipher.processAADBytes(adata, 0, adata.length);
        int len = chipher.processBytes(enc, 0, enc.length, tmp, 0);
        len += chipher.doFinal(tmp, len);
        return HexFormatter.byteArrayToHex((byte[])tmp);
    }

    public String decrypt(String hex) throws IllegalStateException, InvalidCipherTextException, UnsupportedEncodingException, SessionInvalidException {
        String ret;
        if (hex == null) {
            return null;
        }
        if (!hex.trim().matches("[a-fA-f0-9]+")) {
            ret = hex;
        } else {
            byte[] iv = HexFormatter.hexToByteArray((String)this.challengev.substring(16, 32));
            String ads = this.challengev.substring(32, 48);
            byte[] adata = HexFormatter.hexToByteArray((String)ads);
            AEADParameters params = new AEADParameters(new KeyParameter(HexFormatter.hexToByteArray((String)this.derivedk)), 64, iv);
            CCMBlockCipher dc = new CCMBlockCipher((BlockCipher)new AESFastEngine());
            dc.init(false, (CipherParameters)params);
            byte[] enc = HexFormatter.hexToByteArray((String)hex);
            byte[] tmp = new byte[enc.length + adata.length];
            dc.processAADBytes(adata, 0, adata.length);
            int len = dc.processBytes(enc, 0, enc.length, tmp, 0);
            len += dc.doFinal(tmp, len);
            ret = new String(tmp, 0, len, "UTF-8");
            Log.info((String)ret);
        }
        return ret;
    }

    @Override
    public int getIpCheckInterval() {
        return 1000;
    }

    @Override
    public IP getExternalIP() throws IPCheckException {
        SpeedPortHybrid speedPortHybrid = this;
        synchronized (speedPortHybrid) {
            try {
                try {
                    return this.getExternalIPOnce();
                }
                catch (SessionInvalidException e) {
                    Log.info((String)"Try again ip check");
                    return this.getExternalIPOnce();
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
                throw new InvalidIPException("Unknown");
            }
        }
    }

    private IP getExternalIPOnce() throws Exception, InvalidCipherTextException, UnsupportedEncodingException, SessionInvalidException, IOException, IPCheckException {
        this.ensureSession();
        this.updateBonding();
        Log.info((String)("IP: " + this.ipv4));
        if (this.ipv4 != null) {
            return IP.getInstance(this.ipv4);
        }
        throw new IPCheckException("Offline");
    }

    private String extractVariable(String crypted, String key) {
        return new Regex(crypted, "\"varid\"\\s*:\\s*\"" + key + "\",\\s*\"varvalue\"\\s*:\\s*\"([^\"]+)").getMatch(0);
    }

    public SpeedPortHybrid() {
        this.icon = new AbstractIcon("reconnect", 16);
        this.invoker = new ReconnectInvoker(this){

            @Override
            protected void testRun() throws ReconnectException, InterruptedException {
                this.run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws ReconnectException {
                SpeedPortHybrid speedPortHybrid = SpeedPortHybrid.this;
                synchronized (speedPortHybrid) {
                    try {
                        try {
                            this.runOnce();
                        }
                        catch (SessionInvalidException e) {
                            Log.info((String)"Try again");
                            this.runOnce();
                        }
                        Log.info((String)("dsl_tunnel " + SpeedPortHybrid.this.dsl_tunnel));
                        Log.info((String)("lte_tunnel " + SpeedPortHybrid.this.lte_tunnel));
                        Log.info((String)("bonding " + SpeedPortHybrid.this.bonding));
                    }
                    catch (Throwable e) {
                        throw new ReconnectException(e);
                    }
                }
            }

            private void runOnce() throws Exception, InvalidCipherTextException, UnsupportedEncodingException, SessionInvalidException, IOException, InterruptedException {
                SpeedPortHybrid.this.ensureSession();
                SpeedPortHybrid.this.loadFrame("/html/content/config/problem_handling.html?lang=de");
                SpeedPortHybrid.this.getXHR("/data/Reboot.json", 2);
                Thread.sleep(2000L);
                SpeedPortHybrid.this.postXHR("/data/Reboot.json", "reboot_device=true&csrf_token=" + SpeedPortHybrid.this.csrf, true);
                Thread.sleep(60000L);
            }

            private void estabilishConnection() throws Exception {
                this.logger.info("Estabilish Connection");
                for (int i = 0; i < 5; ++i) {
                    this.logger.info("Estabilish Connection Try " + i);
                    SpeedPortHybrid.this.postXHR("/data/Connect.json?lang=de", "req_connect=online&csrf_token=" + SpeedPortHybrid.this.csrf, true);
                    Thread.sleep(10000L);
                    long started = System.currentTimeMillis();
                    while (System.currentTimeMillis() - started < 60000L) {
                        this.logger.info("Wait for onlinestatus==online");
                        String crypted = SpeedPortHybrid.this.getXHR("/data/Connect.json", 1);
                        String onlineStatus = SpeedPortHybrid.this.extractVariable(crypted, "onlinestatus");
                        if ("online".equalsIgnoreCase(onlineStatus)) {
                            this.setStatusString("Connect #" + i + " os " + onlineStatus + " bonding_ok");
                            this.logger.info("We are online");
                            SpeedPortHybrid.this.updateBonding();
                            if (StringUtils.equalsIgnoreCase((String)"Up", (String)SpeedPortHybrid.this.dsl_tunnel) && StringUtils.equalsIgnoreCase((String)"Up", (String)SpeedPortHybrid.this.bonding)) {
                                return;
                            }
                            this.logger.info("Wait for Bonding");
                        } else {
                            this.setStatusString("Connect #" + i + " os " + onlineStatus);
                            this.logger.info("Not online yet");
                        }
                        Thread.sleep(6000L);
                    }
                }
            }
        };
    }

    protected String getXHR(String rel, int timeext) throws Exception {
        for (int ii = 0; ii < 2; ++ii) {
            this.ensureSession();
            String url = this.createAbsoluteUrl(rel, timeext);
            Browser clone = this.br.cloneBrowser();
            String json = this.decrypt(clone.getPage(url));
            String newCsrf = this.extractVariable(json, "csrf_token");
            if (StringUtils.isNotEmpty((String)newCsrf) && !StringUtils.equals((String)this.csrf, (String)newCsrf)) {
                Log.info((String)("New CSRF: " + newCsrf));
                this.csrf = newCsrf;
            }
            try {
                this.checkXHRError(clone, json);
            }
            catch (SessionInvalidException e) {
                if (ii <= 0) continue;
                throw e;
            }
            return json;
        }
        throw new WTFException();
    }

    private String createAbsoluteUrl(String rel, int timeext) {
        String url = "http://" + this.config.getRouterIP() + rel;
        for (int i = 0; i < timeext; ++i) {
            if (i > 0) {
                if (timeext > 0) {
                    url = url + "&";
                }
            } else if (timeext > 0) {
                url = url + "?";
            }
            url = url + "_time=" + System.currentTimeMillis() + "&_rand=" + (int)(Math.random() * 1000.0);
        }
        return url;
    }

    private void checkXHRError(Browser clone, String json) throws SessionInvalidException {
        if (clone.getRequest().getHttpConnection().getResponseCode() == 302) {
            this.br = null;
            throw new SessionInvalidException("Invalid ResponseCode");
        }
        String loginstate = this.extractVariable(json, "loginstate");
        if (loginstate != null && !"1".equals(loginstate)) {
            this.br = null;
            throw new SessionInvalidException("LoginState=" + loginstate);
        }
    }

    private String postXHR(String rel, String postData, boolean encrypt) throws Exception {
        for (int ii = 0; ii < 2; ++ii) {
            this.ensureSession();
            String url = "http://" + this.config.getRouterIP() + rel;
            Browser clone = this.br.cloneBrowser();
            String json = this.decrypt(clone.postPageRaw(url, encrypt ? this.encrypt(postData) : postData));
            String newCsrf = this.extractVariable(json, "csrf_token");
            if (StringUtils.isNotEmpty((String)newCsrf) && !StringUtils.equals((String)this.csrf, (String)newCsrf)) {
                Log.info((String)("New CSRF: " + newCsrf));
                this.csrf = newCsrf;
            }
            try {
                this.checkXHRError(clone, json);
            }
            catch (SessionInvalidException e) {
                if (ii <= 0) continue;
                throw e;
            }
            String status = this.extractVariable(json, "status");
            if ("fail".equals(status) && ii == 0) {
                this.br = null;
                continue;
            }
            return json;
        }
        throw new WTFException();
    }

    private void updateBonding() throws Exception {
        Log.info((String)"bonding_tunnel.json");
        String json = this.getXHR("/data/bonding_tunnel.json", 0);
        this.lte_tunnel = new Regex(json, "\\'lte_tunnel\\'\\s*\\:\\s*\\'([^']*)").getMatch(0);
        this.dsl_tunnel = new Regex(json, "\\'dsl_tunnel\\'\\s*\\:\\s*\\'([^']*)").getMatch(0);
        this.bonding = new Regex(json, "\\'bonding\\'\\s*\\:\\s*\\'([^']*)").getMatch(0);
        this.ipv4 = new Regex(json, "\\'ipv4\\'\\s*\\:\\s*\\'([^']*)").getMatch(0);
        Log.info((String)("Public IP: " + this.ipv4));
        Log.info((String)("LTE: " + this.lte_tunnel));
        Log.info((String)("DSL: " + this.dsl_tunnel));
        Log.info((String)("Bonding: " + this.bonding));
    }

    protected synchronized void ensureSession() throws Exception {
        if (this.isLoggedIn()) {
            return;
        }
        this.br = new Browser();
        this.br.setVerbose(true);
        this.br.setDebug(true);
        this.br.setProxySelector((ProxySelectorInterface)new NoProxySelector());
        if (System.getProperty("fiddler") != null) {
            this.br.setProxy(new HTTPProxy(HTTPProxy.TYPE.HTTP, "localhost", 8888));
        }
        String json = null;
        for (int i = 5; i > 0; --i) {
            UrlQuery query = new UrlQuery().append("csrf_token", "nulltoken", true).append("showpw", "0", true).append("challengev", "null", true);
            json = this.br.postPage(this.createAbsoluteUrl("/data/Login.json?lang=de", 0), query);
            if ("2".equals(this.extractVariable(json, "loginstate"))) {
                this.br.getPage(this.createAbsoluteUrl("/data/Login.json", 2));
                json = this.br.postPage(this.createAbsoluteUrl("/data/Login.json?lang=de", 0), query);
            }
            this.challengev = this.extractVariable(json, "challengev");
            if (!StringUtils.isEmpty((String)this.challengev)) break;
            Thread.sleep(15000L);
        }
        if (StringUtils.isEmpty((String)this.challengev)) {
            UIOManager.I().showErrorMessage("Login to Speedport Failed (Challenge Missing)!");
            this.br = null;
            throw new SessionInvalidException("Login Failed (Challenge Missing)");
        }
        Log.info((String)("Challenge: " + this.challengev));
        long start = System.currentTimeMillis();
        do {
            json = this.br.postPage(this.createAbsoluteUrl("/data/Login.json?lang=de", 0), new UrlQuery().append("csrf_token", "nulltoken", true).append("showpw", "0", true).append("password", Hash.getSHA256((String)(this.challengev + ":" + this.config.getPassword())), true));
            Thread.sleep(15000L);
        } while ("69".equals(this.extractVariable(json, "login")) && System.currentTimeMillis() - start < 120000L);
        String session = this.br.getCookie("http://" + this.config.getRouterIP(), "SessionID_R3");
        if (StringUtils.isEmpty((String)session)) {
            UIOManager.I().showErrorMessage("Login to Speedport Failed!");
            this.br = null;
            throw new SessionInvalidException("Login Failed");
        }
        this.derivedk = this.PBKDF2Key(this.config.getPassword(), this.challengev.substring(0, 16));
        this.br.setCookie("http://" + this.config.getRouterIP(), "derivedk", this.derivedk);
        this.br.setCookie("http://" + this.config.getRouterIP(), "challengev", this.challengev);
        this.loadFrame("/html/content/internet/connection.html?lang=de");
    }

    private void loadFrame(String string) throws IllegalStateException, InvalidCipherTextException, UnsupportedEncodingException, SessionInvalidException, IOException {
        this.br.setVerbose(false);
        this.br.setDebug(false);
        this.br.getPage("http://" + this.config.getRouterIP() + string);
        String newcsrf = this.br.getRegex("csrf_token\\s*=\\s*\"([^\"]+)").getMatch(0);
        if (StringUtils.isNotEmpty((String)newcsrf) && !StringUtils.equals((String)this.csrf, (String)newcsrf)) {
            Log.info((String)("New CSRF: " + newcsrf));
            this.csrf = newcsrf;
        }
        this.br.setVerbose(true);
        this.br.setDebug(true);
        Log.info((String)(this.br.getRequest().getHttpConnection() + ""));
    }

    private boolean isLoggedIn() {
        return this.br != null && this.br.getCookie("http://" + this.config.getRouterIP(), "SessionID_R3") != null;
    }

    @Override
    public Icon getIcon16() {
        return this.icon;
    }

    @Override
    public JComponent getGUI() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 2", "[][grow,fill]", "[][][grow,fill][]"));
        p.setOpaque(false);
        this.txtPassword = new ExtPasswordField(){

            public void onChanged() {
                SpeedPortHybrid.this.config.setPassword(SpeedPortHybrid.this.txtPassword.getText());
            }
        };
        this.txtIP = new ExtTextField(){

            public void onChanged() {
                SpeedPortHybrid.this.config.setRouterIP(SpeedPortHybrid.this.txtIP.getText());
            }
        };
        this.txtPassword.setText(this.config.getPassword());
        this.txtIP.setText(this.config.getRouterIP());
        p.add(this.label(_GUI.T.lit_router_ip()));
        p.add((Component)this.txtIP);
        p.add(this.label(_GUI.T.lit_password()));
        p.add((Component)this.txtPassword);
        return p;
    }

    private Component label(String string) {
        JLabel ret = new JLabel(string);
        SwingUtils.toBold((JLabel)ret);
        ret.setEnabled(false);
        ret.setHorizontalAlignment(4);
        return ret;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return "Speed Port Hybrid Reconnect";
    }

    @Override
    public ReconnectInvoker getReconnectInvoker() {
        return this.invoker;
    }
}

