/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.upnp.cling;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.transport.impl.StreamClientConfigurationImpl;
import org.fourthline.cling.transport.spi.InitializationException;
import org.fourthline.cling.transport.spi.StreamClient;
import org.seamless.util.URIUtil;
import org.seamless.util.io.IO;

public class StreamClientImpl
implements StreamClient<StreamClientConfigurationImpl> {
    protected final StreamClientConfigurationImpl configuration;

    public StreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
    }

    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) throws InterruptedException {
        UpnpRequest requestOperation = (UpnpRequest)requestMessage.getOperation();
        URL url = URIUtil.toURL((URI)requestOperation.getURI());
        HTTPConnectionImpl urlConnection = null;
        try {
            final byte[] bodyBytes = requestMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING) ? (requestMessage.getBodyString() != null ? requestMessage.getBodyString().getBytes("UTF-8") : null) : (requestMessage.getBodyType().equals((Object)UpnpMessage.BodyType.BYTES) ? requestMessage.getBodyBytes() : null);
            urlConnection = new HTTPConnectionImpl(url){

                protected boolean isRequiresOutputStream() {
                    return super.isRequiresOutputStream() || bodyBytes != null;
                }
            };
            urlConnection.setRequestMethod(HTTPConnection.RequestMethod.valueOf((String)requestOperation.getHttpMethodName()));
            urlConnection.setReadTimeout(this.configuration.getTimeoutSeconds() * 1000);
            urlConnection.setConnectTimeout(this.configuration.getTimeoutSeconds() * 1000);
            if (!requestMessage.getHeaders().containsKey(UpnpHeader.Type.USER_AGENT)) {
                urlConnection.setRequestProperty(UpnpHeader.Type.USER_AGENT.getHttpName(), this.getConfiguration().getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
            }
            for (Map.Entry entry : requestMessage.getHeaders().entrySet()) {
                for (String v : (List)entry.getValue()) {
                    String headerName = (String)entry.getKey();
                    urlConnection.setRequestProperty(headerName, v);
                }
            }
            if (bodyBytes != null) {
                urlConnection.setRequestProperty("Content-Length", Integer.toString(bodyBytes.length));
                urlConnection.connect();
                urlConnection.getOutputStream().write(bodyBytes);
                urlConnection.finalizeConnect();
            }
            urlConnection.setAllowedResponseCodes(new int[]{urlConnection.getResponseCode()});
            InputStream inputStream = urlConnection.getInputStream();
            StreamResponseMessage streamResponseMessage = this.createResponse((HTTPConnection)urlConnection, inputStream);
            return streamResponseMessage;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StreamResponseMessage streamResponseMessage = null;
            return streamResponseMessage;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    protected StreamResponseMessage createResponse(HTTPConnection urlConnection, InputStream inputStream) throws Exception {
        if (urlConnection.getResponseCode() == -1) {
            return null;
        }
        UpnpResponse responseOperation = new UpnpResponse(urlConnection.getResponseCode(), urlConnection.getResponseMessage());
        StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
        responseMessage.setHeaders(new UpnpHeaders(urlConnection.getHeaderFields()));
        byte[] bodyBytes = null;
        if (inputStream != null) {
            bodyBytes = IO.readBytes((InputStream)inputStream);
        }
        if (bodyBytes != null && bodyBytes.length > 0 && responseMessage.isContentTypeMissingOrText()) {
            responseMessage.setBodyCharacters(bodyBytes);
        } else if (bodyBytes != null && bodyBytes.length > 0) {
            responseMessage.setBody(UpnpMessage.BodyType.BYTES, (Object)bodyBytes);
        }
        return responseMessage;
    }

    public void stop() {
    }
}

