/*
 * Decompiled with CFR 0.152.
 */
package jd.crypt;

import jd.crypt.AEStables;
import jd.crypt.Copy;

public class AESdecrypt {
    public final int Nb = 4;
    public int nk;
    public int nr;
    AEStables tab;
    byte[] w;
    private int wCount;

    public AESdecrypt(byte[] key, int NkIn) {
        this.nk = NkIn;
        this.nr = this.nk + 6;
        this.tab = new AEStables();
        this.w = new byte[16 * (this.nr + 1)];
        this.KeyExpansion(key, this.w);
    }

    private void InvAddRoundKey(byte[][] state) {
        for (int c = 3; c >= 0; --c) {
            for (int r = 3; r >= 0; --r) {
                state[r][c] = (byte)(state[r][c] ^ this.w[--this.wCount]);
            }
        }
    }

    public void InvCipher(byte[] in, byte[] out) {
        this.wCount = 16 * (this.nr + 1);
        byte[][] state = new byte[4][4];
        Copy.copy(state, in);
        this.InvAddRoundKey(state);
        for (int round = this.nr - 1; round >= 1; --round) {
            this.InvShiftRows(state);
            this.InvSubBytes(state);
            this.InvAddRoundKey(state);
            this.InvMixColumns(state);
        }
        this.InvShiftRows(state);
        this.InvSubBytes(state);
        this.InvAddRoundKey(state);
        Copy.copy(out, state);
    }

    private void InvMixColumns(byte[][] s) {
        int[] sp = new int[4];
        byte b0b = 11;
        byte b0d = 13;
        byte b09 = 9;
        byte b0e = 14;
        for (int c = 0; c < 4; ++c) {
            sp[0] = this.tab.FFMul(b0e, s[0][c]) ^ this.tab.FFMul(b0b, s[1][c]) ^ this.tab.FFMul(b0d, s[2][c]) ^ this.tab.FFMul(b09, s[3][c]);
            sp[1] = this.tab.FFMul(b09, s[0][c]) ^ this.tab.FFMul(b0e, s[1][c]) ^ this.tab.FFMul(b0b, s[2][c]) ^ this.tab.FFMul(b0d, s[3][c]);
            sp[2] = this.tab.FFMul(b0d, s[0][c]) ^ this.tab.FFMul(b09, s[1][c]) ^ this.tab.FFMul(b0e, s[2][c]) ^ this.tab.FFMul(b0b, s[3][c]);
            sp[3] = this.tab.FFMul(b0b, s[0][c]) ^ this.tab.FFMul(b0d, s[1][c]) ^ this.tab.FFMul(b09, s[2][c]) ^ this.tab.FFMul(b0e, s[3][c]);
            for (int i = 0; i < 4; ++i) {
                s[i][c] = (byte)sp[i];
            }
        }
    }

    private void InvShiftRows(byte[][] state) {
        byte[] t = new byte[4];
        for (int r = 1; r < 4; ++r) {
            int c;
            for (c = 0; c < 4; ++c) {
                t[(c + r) % 4] = state[r][c];
            }
            for (c = 0; c < 4; ++c) {
                state[r][c] = t[c];
            }
        }
    }

    private void InvSubBytes(byte[][] state) {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                state[row][col] = this.tab.invSBox(state[row][col]);
            }
        }
    }

    private void KeyExpansion(byte[] key, byte[] w) {
        byte[] temp = new byte[4];
        int j = 0;
        while (j < 4 * this.nk) {
            w[j] = key[j++];
        }
        while (j < 16 * (this.nr + 1)) {
            int iTemp;
            int i = j / 4;
            for (iTemp = 0; iTemp < 4; ++iTemp) {
                temp[iTemp] = w[j - 4 + iTemp];
            }
            if (i % this.nk == 0) {
                byte oldtemp0 = temp[0];
                for (int iTemp2 = 0; iTemp2 < 4; ++iTemp2) {
                    byte ttemp = iTemp2 == 3 ? oldtemp0 : temp[iTemp2 + 1];
                    byte tRcon = iTemp2 == 0 ? this.tab.Rcon(i / this.nk) : (byte)0;
                    temp[iTemp2] = (byte)(this.tab.SBox(ttemp) ^ tRcon);
                }
            } else if (this.nk > 6 && i % this.nk == 4) {
                for (iTemp = 0; iTemp < 4; ++iTemp) {
                    temp[iTemp] = this.tab.SBox(temp[iTemp]);
                }
            }
            for (iTemp = 0; iTemp < 4; ++iTemp) {
                w[j + iTemp] = (byte)(w[j - 4 * this.nk + iTemp] ^ temp[iTemp]);
            }
            j += 4;
        }
    }
}

