/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.config.Property;
import jd.controlling.AccountController;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.plugins.AccountInfo;
import jd.plugins.AccountProperty;
import jd.plugins.AccountTrafficView;
import jd.plugins.CookieStorable;
import jd.plugins.PluginForHost;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.translate._JDT;

public class Account
extends Property {
    private static final String VALID_UNTIL = "VALID_UNTIL";
    private static final String ACCOUNT_TYPE = "ACCOUNT_TYPE";
    private static final String LATEST_VALID_TIMESTAMP = "LATEST_VALID_TIMESTAMP";
    public static final String IS_MULTI_HOSTER_ACCOUNT = "IS_MULTI_HOSTER_ACCOUNT";
    private static final long serialVersionUID = -7578649066389032068L;
    private String user;
    private String pass;
    private boolean enabled = true;
    private boolean concurrentUsePossible = true;
    public static final String PROPERTY_REFRESH_TIMEOUT = "PROPERTY_REFRESH_TIMEOUT";
    private static final String COOKIE_STORAGE = "COOKIE_STORAGE";
    private static final String OBJECT_STORAGE = "OBJECT_STORAGE";
    private DomainInfo domainInfo;
    private final AtomicLong tmpDisabledTimeout = new AtomicLong(-1L);
    private transient UniqueAlltimeID id = new UniqueAlltimeID();
    private String hoster = null;
    private List<String> hosterHistory = null;
    private AccountInfo accinfo = null;
    private long updatetime = 0L;
    private int maxDownloads = 0;
    private transient AccountController ac = null;
    private transient PluginForHost plugin = null;
    private transient boolean isMulti = false;
    private transient boolean isMultiPlugin = false;
    private volatile transient AccountError error;
    private volatile transient String errorString;
    private final AtomicBoolean checking = new AtomicBoolean(false);
    private static final long DEFAULT_REFRESH_TIMEOUT = 1800000L;
    private static final long MIN_REFRESH_TIMEOUT = 300000L;
    private volatile transient AccountPropertyChangeHandler notifyHandler = null;
    private static final String REGTS = "regts";

    public boolean isConcurrentUsePossible() {
        return this.concurrentUsePossible;
    }

    public String getAccountFootprintString() {
        return Hash.getSHA256((String)(this.getUser() + ":" + this.getPass()));
    }

    public synchronized void storeObject(String storageID, Object object) {
        this.setProperty("OBJECT_STORAGE.validation." + storageID, this.getAccountFootprintString());
        this.setProperty("OBJECT_STORAGE.object." + storageID, JSonStorage.serializeToJson((Object)object));
        this.setProperty("OBJECT_STORAGE.ts." + storageID, System.currentTimeMillis());
    }

    public synchronized void clearObject(String storageID) {
        this.removeProperty("OBJECT_STORAGE.validation." + storageID);
        this.removeProperty("OBJECT_STORAGE.object." + storageID);
        this.removeProperty("OBJECT_STORAGE.ts." + storageID);
    }

    public synchronized <T> T restoreObject(String storageID, TypeRef<T> type) {
        boolean containsObject = this.hasProperty("OBJECT_STORAGE.object." + storageID);
        if (containsObject) {
            if (StringUtils.equals((String)this.getStringProperty("OBJECT_STORAGE.validation." + storageID), (String)this.getAccountFootprintString())) {
                return (T)JSonStorage.restoreFromString((String)this.getStringProperty("OBJECT_STORAGE.object." + storageID), type, null);
            }
            this.clearObject(storageID);
        }
        return null;
    }

    @Deprecated
    public void setTempDisabled(boolean tempDisabled) {
        if (tempDisabled) {
            this.setError(AccountError.TEMP_DISABLED, -1L, null);
        } else if (AccountError.TEMP_DISABLED.equals((Object)this.getError())) {
            this.setError(null, -1L, null);
        }
    }

    public DomainInfo getDomainInfo() {
        DomainInfo domainInfo = this.domainInfo;
        if (domainInfo == null) {
            this.domainInfo = domainInfo = DomainInfo.getInstance(this.getHosterByPlugin(true));
        }
        return domainInfo;
    }

    public final AccountTrafficView getAccountTrafficView() {
        PluginForHost plugin = this.getPlugin();
        if (plugin == null) {
            AccountInfo accountInfo = this.getAccountInfo();
            if (accountInfo != null) {
                return accountInfo;
            }
            return null;
        }
        return plugin.getAccountTrafficView(this);
    }

    public synchronized long getObjectTimeStamp(String storageID) {
        return this.getLongProperty("OBJECT_STORAGE.ts." + storageID, -1L);
    }

    public synchronized void saveCookies(Cookies cookies, String ID2) {
        String validation = this.getAccountFootprintString();
        List<CookieStorable> cookieStorables = Account.getListOfCookieStorablesWithoutAntiDdosCookies(cookies);
        this.setProperty(COOKIE_STORAGE, validation);
        String COOKIE_STORAGE_ID = "COOKIE_STORAGE:" + ID2;
        this.setProperty(COOKIE_STORAGE_ID, new SimpleMapper().setPrettyPrintEnabled(false).objectToString(cookieStorables));
        String COOKIE_STORAGE_TIMESTAMP_ID = "COOKIE_STORAGE:TS:" + ID2;
        long ret = System.currentTimeMillis();
        this.setProperty(COOKIE_STORAGE_TIMESTAMP_ID, ret);
    }

    public static List<CookieStorable> getListOfCookieStorables(Cookies cookies) {
        if (cookies == null) {
            return null;
        }
        ArrayList<CookieStorable> cookieStorables = new ArrayList<CookieStorable>();
        for (Cookie cookie : cookies.getCookies()) {
            if (cookie.getKey() == null || cookie.isExpired()) continue;
            cookieStorables.add(new CookieStorable(cookie));
        }
        return cookieStorables;
    }

    public static List<CookieStorable> getListOfCookieStorablesWithoutAntiDdosCookies(Cookies cookies) {
        if (cookies == null) {
            return null;
        }
        ArrayList<CookieStorable> cookieStorables = new ArrayList<CookieStorable>();
        String antiddosCookies = "__cfduid|cf_clearance|visid_incap_\\d+|incap_ses_\\d+_\\d+|sucuri_cloudproxy_uuid_[a-f0-9]+|rcksid|BLAZINGFAST-WEB-PROTECT|BlazingWebCookie|BlazingPuzzleCookie";
        for (Cookie cookie : cookies.getCookies()) {
            if (cookie.getKey() == null || cookie.getKey().matches("__cfduid|cf_clearance|visid_incap_\\d+|incap_ses_\\d+_\\d+|sucuri_cloudproxy_uuid_[a-f0-9]+|rcksid|BLAZINGFAST-WEB-PROTECT|BlazingWebCookie|BlazingPuzzleCookie") || cookie.isExpired()) continue;
            cookieStorables.add(new CookieStorable(cookie));
        }
        return cookieStorables;
    }

    public synchronized void clearCookies(String ID2) {
        String COOKIE_STORAGE_ID = "COOKIE_STORAGE:" + ID2;
        this.removeProperty(COOKIE_STORAGE_ID);
        String COOKIE_STORAGE_TIMESTAMP_ID = "COOKIE_STORAGE:TS:" + ID2;
        this.removeProperty(COOKIE_STORAGE_TIMESTAMP_ID);
    }

    public synchronized long getCookiesTimeStamp(String ID2) {
        String COOKIE_STORAGE_TIMESTAMP_ID = "COOKIE_STORAGE:TS:" + ID2;
        return this.getLongProperty(COOKIE_STORAGE_TIMESTAMP_ID, -1L);
    }

    public synchronized Cookies loadCookies(String ID2) {
        String COOKIE_STORAGE_ID;
        String cookieStorables;
        String validation = this.getAccountFootprintString();
        if (StringUtils.equals((String)this.getStringProperty(COOKIE_STORAGE), (String)validation) && StringUtils.isNotEmpty((String)(cookieStorables = this.getStringProperty(COOKIE_STORAGE_ID = "COOKIE_STORAGE:" + ID2)))) {
            try {
                List cookies = (List)JSonStorage.restoreFromString((String)cookieStorables, (TypeRef)new TypeRef<ArrayList<CookieStorable>>(){}, null);
                Cookies ret = new Cookies();
                for (CookieStorable storable : cookies) {
                    Cookie cookie = storable._restore();
                    if (cookie.isExpired()) continue;
                    ret.add(cookie);
                }
                return ret;
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
        this.clearCookies(ID2);
        return null;
    }

    public Cookies loadUserCookies() {
        return this.loadUserCookies(true);
    }

    public Cookies loadUserCookies(boolean loadUserAgent) {
        Cookies ret = Cookies.parseCookiesFromJsonString((String)this.getPass(), (LogInterface)LogController.getRebirthLogger());
        if (ret != null && !loadUserAgent) {
            ret.setUserAgent(null);
        }
        return ret;
    }

    public void setConcurrentUsePossible(boolean concurrentUsePossible) {
        this.concurrentUsePossible = concurrentUsePossible;
    }

    public long getTmpDisabledTimeout() {
        return Math.max(-1L, this.tmpDisabledTimeout.get());
    }

    public List<String> getHosterHistory() {
        return this.hosterHistory;
    }

    public void setHosterHistory(List<String> hosterHistory) {
        this.hosterHistory = hosterHistory != null && hosterHistory.size() > 0 ? new CopyOnWriteArrayList<String>(hosterHistory) : null;
    }

    public PluginForHost getPlugin() {
        return this.plugin;
    }

    public void setPlugin(PluginForHost plugin) {
        this.plugin = plugin;
        this.isMultiPlugin = plugin != null ? plugin.isHandlingMultipleHosts() : false;
    }

    public boolean isMultiPlugin() {
        return this.isMultiPlugin;
    }

    public void setAllowReconnectToResetLimits(boolean b) {
    }

    private static final String trim(String string) {
        return string == null ? null : StringUtils.removeBOM((String)string);
    }

    public void setAccountController(AccountController ac) {
        this.ac = ac;
    }

    public AccountController getAccountController() {
        return this.ac;
    }

    public Account(String user, String pass) {
        this.user = Account.trim(user);
        this.pass = Account.trim(pass);
    }

    public int getMaxSimultanDownloads() {
        return this.maxDownloads;
    }

    public void setMaxSimultanDownloads(int max) {
        this.maxDownloads = max < 0 ? -1 : max;
    }

    public String getPass() {
        this.pass = this.updateAccountPassword(this.pass);
        return this.pass;
    }

    protected String updateAccountPassword(String password) {
        PluginForHost plugin = this.getPlugin();
        if (plugin != null && password != null) {
            return plugin.updateAccountPassword(this, password);
        }
        return password;
    }

    public boolean isValid() {
        AccountError lerror = this.getError();
        return lerror == null || AccountError.TEMP_DISABLED.equals((Object)lerror);
    }

    public long getLastValidTimestamp() {
        return this.getLongProperty(LATEST_VALID_TIMESTAMP, -1L);
    }

    @Deprecated
    public void setValid(boolean b) {
        if (b) {
            if (this.getError() == AccountError.INVALID) {
                this.setError(null, -1L, null);
            }
        } else {
            this.setError(AccountError.INVALID, -1L, null);
        }
    }

    public long lastUpdateTime() {
        return this.updatetime;
    }

    public void setUpdateTime(long l) {
        this.updatetime = l;
    }

    public String getHoster() {
        return this.hoster;
    }

    public void setHoster(String h) {
        this.hoster = h;
    }

    public String getHosterByPlugin() {
        return this.getHosterByPlugin(false);
    }

    public String getHosterByPlugin(boolean includeSubdomain) {
        String ret;
        PluginForHost plugin = this.getPlugin();
        if (plugin != null && this.isMultiPlugin() && (ret = plugin.getHost(null, this, includeSubdomain)) != null) {
            return ret;
        }
        return this.hoster;
    }

    public void setChecking(boolean b) {
        this.checking.set(b);
    }

    public boolean isChecking() {
        return this.checking.get();
    }

    public AccountInfo getAccountInfo() {
        return this.accinfo;
    }

    public void setAccountInfo(AccountInfo info) {
        this.accinfo = info;
        if (info == null) {
            return;
        }
        info.setAccount(this);
        if (AccountType.PREMIUM.equals((Object)this.getType()) && !info.isExpired() && info.getValidUntil() > 0L) {
            this.setValidPremiumUntil(info.getValidUntil());
        }
        if (this.getType() != null && info.getStatus() == null) {
            String output = this.getType().toString();
            output = output.substring(0, 1) + output.substring(1).toLowerCase(Locale.ENGLISH) + " Account";
            info.setStatus(output);
        }
    }

    private void setValidPremiumUntil(long validUntil) {
        this.setProperty(VALID_UNTIL, validUntil);
    }

    public long getValidPremiumUntil() {
        AccountInfo info = this.getAccountInfo();
        long ret = -1L;
        if (info != null && AccountType.PREMIUM.equals((Object)this.getType()) && !info.isExpired()) {
            ret = info.getValidUntil();
        }
        if (ret <= 0L) {
            ret = this.getLongProperty(VALID_UNTIL, 0L);
        }
        return ret;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.setTmpDisabledTimeout(-1L);
        this.isMulti = false;
        this.id = new UniqueAlltimeID();
        this.isMultiPlugin = false;
    }

    public UniqueAlltimeID getId() {
        return this.id;
    }

    public void setId(long id) {
        if (id > 0L) {
            this.id = new UniqueAlltimeID(id);
        }
    }

    public boolean isTempDisabled() {
        return AccountError.TEMP_DISABLED.equals((Object)this.getError());
    }

    public void setError(AccountError error, long setTimeout, String errorString) {
        this.setError(error, setTimeout, errorString, true);
    }

    public void setError(AccountError error, long setTimeout, String errorString, boolean forceAccountCheckOnChange) {
        if (error == null) {
            errorString = null;
        }
        if (this.getError() != error || !StringUtils.equals((String)this.getErrorString(), (String)errorString)) {
            if (AccountError.TEMP_DISABLED.equals((Object)error)) {
                long timeout = setTimeout <= 0L ? System.currentTimeMillis() + CFG_GENERAL.CFG.getAccountTemporarilyDisabledDefaultTimeout() : System.currentTimeMillis() + setTimeout;
                this.setTmpDisabledTimeout(timeout);
            } else {
                this.setTmpDisabledTimeout(-1L);
            }
            this.error = error;
            this.errorString = errorString;
            if (forceAccountCheckOnChange) {
                this.notifyUpdate(AccountProperty.Property.ERROR, (Object)error);
            }
        }
    }

    public final void setNextDayAsTempTimeout(Browser br) {
        this.setNextDayAsTempTimeout(br, "EEE, dd MMM yyyy HH:mm:ss z", -1L, null);
    }

    public final void setNextDayAsTempTimeout(Browser br, String message) {
        this.setNextDayAsTempTimeout(br, "EEE, dd MMM yyyy HH:mm:ss z", -1L, message);
    }

    public final void setNextDayAsTempTimeout(Browser br, long failOverTime) {
        this.setNextDayAsTempTimeout(br, "EEE, dd MMM yyyy HH:mm:ss z", failOverTime, null);
    }

    public final void setNextDayAsTempTimeout(Browser br, String formatter, long failOverTime, String errorString) {
        long result = -1L;
        if (failOverTime <= 0L) {
            failOverTime = 3600000L;
        }
        if (br != null && br.getHttpConnection() != null) {
            long serverTime = -1L;
            String dateString = br.getHttpConnection().getHeaderField("Date");
            if (dateString != null) {
                if (StringUtils.isNotEmpty((String)formatter)) {
                    serverTime = TimeFormatter.getMilliSeconds((String)dateString, (String)formatter, (Locale)Locale.ENGLISH);
                } else {
                    Date date = TimeFormatter.parseDateString((String)dateString);
                    if (date != null) {
                        serverTime = date.getTime();
                    }
                }
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                c.setTime(new Date(serverTime));
                c.set(6, c.get(6) + 1);
                c.set(11, 0);
                c.set(12, 1);
                c.set(13, 0);
                long stTomorrow = c.getTimeInMillis();
                long stDifference = stTomorrow - serverTime;
                long ut = System.currentTimeMillis();
                result = ut + stDifference;
            }
        }
        long timeout = result > 0L ? result : failOverTime;
        this.setError(AccountError.TEMP_DISABLED, timeout, errorString);
    }

    public void setTmpDisabledTimeout(long tmpDisabledTimeout) {
        this.tmpDisabledTimeout.set(tmpDisabledTimeout);
    }

    public AccountError getError() {
        AccountError error = this.error;
        if (AccountError.TEMP_DISABLED.equals((Object)error)) {
            Long disabledTimeStamp = this.getTmpDisabledTimeout();
            if (disabledTimeStamp < 0L) {
                return null;
            }
            if (System.currentTimeMillis() >= disabledTimeStamp) {
                if (this.tmpDisabledTimeout.compareAndSet(disabledTimeStamp, -1L)) {
                    new Thread("notifyUpdate:" + this.getUser()){
                        {
                            this.setDaemon(true);
                        }

                        @Override
                        public void run() {
                            Account.this.notifyUpdate(AccountProperty.Property.ERROR, null);
                        }
                    }.start();
                }
                return null;
            }
        }
        return error;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, true);
    }

    public void setEnabled(boolean enabled, boolean forceAccountCheckOnChange) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (forceAccountCheckOnChange) {
                this.notifyUpdate(AccountProperty.Property.ENABLED, enabled);
            }
        }
    }

    public long getRefreshTimeout() {
        long timeout = this.getLongProperty(PROPERTY_REFRESH_TIMEOUT, 1800000L);
        timeout = Math.max(300000L, timeout <= 0L ? 1800000L : timeout);
        AccountInfo ai = this.getAccountInfo();
        if (ai == null) {
            return timeout;
        }
        if (ai.isExpired()) {
            return timeout;
        }
        long validUntil = ai.getValidUntil();
        if (validUntil < 0L) {
            return timeout;
        }
        long timeValid = validUntil - System.currentTimeMillis();
        return Math.min(timeout, Math.max(timeValid, 0L));
    }

    public void setRefreshTimeout(long refresh_timeout) {
        this.setProperty(PROPERTY_REFRESH_TIMEOUT, refresh_timeout);
    }

    public boolean refreshTimeoutReached() {
        if (this.updatetime <= 0L) {
            return true;
        }
        return System.currentTimeMillis() - this.updatetime >= this.getRefreshTimeout();
    }

    public void setNotifyHandler(AccountPropertyChangeHandler notifyHandler) {
        this.notifyHandler = notifyHandler;
    }

    private void notifyUpdate(AccountProperty.Property property, Object value) {
        AccountPropertyChangeHandler notify = this.notifyHandler;
        boolean notifyController = true;
        AccountProperty event = null;
        if (notify != null) {
            event = new AccountProperty(this, property, value);
            notifyController = notify.fireAccountPropertyChange(event);
        }
        if ((notify = this.getAccountController()) != null && notifyController) {
            if (event == null) {
                event = new AccountProperty(this, property, value);
            }
            notifyController = notify.fireAccountPropertyChange(event);
        }
    }

    public void setPass(String newPass) {
        this.setPass(newPass, true);
    }

    public void setPass(String newPass, boolean forceAccountCheckOnChange) {
        if (!StringUtils.equals((String)this.pass, (String)(newPass = this.updateAccountPassword(Account.trim(newPass))))) {
            this.pass = newPass;
            if (forceAccountCheckOnChange) {
                this.notifyUpdate(AccountProperty.Property.PASSWORD, newPass);
            }
        }
    }

    public void setUser(String newUser) {
        if (!StringUtils.equals((String)this.user, (String)(newUser = Account.trim(newUser)))) {
            this.user = newUser;
            this.notifyUpdate(AccountProperty.Property.USERNAME, newUser);
        }
    }

    @Override
    public String toString() {
        AccountInfo ai = this.accinfo;
        if (ai != null) {
            return this.user + ":" + this.pass + "@" + this.hoster + "=" + this.enabled + " " + super.toString() + " AccInfo: " + ai.toString();
        }
        return this.user + ":" + this.pass + "@" + this.hoster + "=" + this.enabled + " " + super.toString();
    }

    public boolean equals(Account account) {
        if (account == null) {
            return false;
        }
        if (account == this) {
            return true;
        }
        if (!StringUtils.equals((String)this.getHoster(), (String)account.getHoster())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getUser(), (String)account.getUser())) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)this.getUser())) {
            return true;
        }
        return StringUtils.equals((String)this.getPass(), (String)account.getPass());
    }

    public boolean isMultiHost() {
        return this.isMulti;
    }

    public boolean hasEverBeenValid() {
        return this.getLastValidTimestamp() != -1L;
    }

    public void setLastValidTimestamp(long currentTimeMillis) {
        this.setProperty(LATEST_VALID_TIMESTAMP, currentTimeMillis);
    }

    public void setType(AccountType type) {
        if (type == null) {
            super.setProperty(ACCOUNT_TYPE, Property.NULL);
        } else {
            super.setProperty(ACCOUNT_TYPE, type.name());
        }
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (IS_MULTI_HOSTER_ACCOUNT.equalsIgnoreCase(key)) {
            this.isMulti = value != null && Boolean.TRUE.equals(value);
        }
        return super.setProperty(key, value);
    }

    public long getRegisterTimeStamp() {
        return this.getLongProperty(REGTS, -1L);
    }

    public void setRegisterTimeStamp(long ts) {
        if (ts < 0L) {
            this.removeProperty(REGTS);
        } else {
            this.setProperty(REGTS, ts);
        }
    }

    public AccountType getType() {
        String v = this.getStringProperty(ACCOUNT_TYPE, null);
        if (v != null) {
            try {
                return AccountType.valueOf(v);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return AccountType.PREMIUM;
    }

    public static String getExpireDateFormatString(Object requestor) {
        String custom = CFG_GUI.CFG.getDateTimeFormatAccountManagerExpireDateColumn();
        if (StringUtils.isNotEmpty((String)custom)) {
            return custom;
        }
        DateFormat sd = SimpleDateFormat.getDateTimeInstance();
        if (sd instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)sd).toPattern();
        }
        return _GUI.T.PremiumAccountTableModel_getDateFormatString_();
    }

    public static enum AccountType implements LabelInterface
    {
        FREE{

            public String getLabel() {
                return _JDT.T.AccountType_free();
            }
        }
        ,
        PREMIUM{

            public String getLabel() {
                return _JDT.T.AccountType_premium();
            }
        }
        ,
        LIFETIME{

            public String getLabel() {
                return _JDT.T.AccountType_lifetime();
            }
        }
        ,
        UNKNOWN{

            public String getLabel() {
                return _JDT.T.AccountType_unknown();
            }
        };

    }

    public static interface AccountPropertyChangeHandler {
        public boolean fireAccountPropertyChange(AccountProperty var1);
    }

    public static enum AccountError {
        TEMP_DISABLED,
        EXPIRED,
        INVALID,
        PLUGIN_ERROR;

    }
}

