/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import jd.config.Property;
import jd.http.Browser;
import jd.nutils.NaturalOrderComparator;
import jd.parser.Regex;
import jd.plugins.Account;
import jd.plugins.AccountTrafficView;
import jd.plugins.DownloadLink;
import jd.plugins.MultiHostHost;
import jd.plugins.PluginForHost;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;

public class AccountInfo
extends Property
implements AccountTrafficView {
    private static final long serialVersionUID = 1825140346023286206L;
    private volatile long account_validUntil = -1L;
    private volatile long account_LastValidUntil = -1L;
    private volatile long account_trafficLeft = -1L;
    private volatile long account_trafficMax = -1L;
    private long account_filesNum = -1L;
    private long account_premiumPoints = -1L;
    private double account_balance = -1.0;
    private long account_usedSpace = -1L;
    private volatile String account_status;
    private long account_createTime = 0L;
    private static final String PROPERTY_MULTIHOST_SUPPORT = "multiHostSupport";
    private Account account = null;
    private Currency currency = null;
    private volatile boolean specialTraffic = false;
    private volatile boolean account_trafficRefill = true;
    protected List<MultiHostHost> multihostSupportV2 = null;

    protected void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    public boolean isTrafficRefill() {
        return this.account_trafficRefill;
    }

    public void setTrafficRefill(boolean account_trafficRefill) {
        this.account_trafficRefill = account_trafficRefill;
    }

    public long getCreateTime() {
        return this.account_createTime;
    }

    public void setSpecialTraffic(boolean b) {
        this.specialTraffic = b;
    }

    @Override
    public boolean isSpecialTraffic() {
        return this.specialTraffic;
    }

    public void setCreateTime(long createTime) {
        this.account_createTime = createTime;
    }

    public double getAccountBalance() {
        return this.account_balance;
    }

    public String getAccountBalanceFormatted() {
        String balanceStr = String.format("%.3f", this.getAccountBalance());
        Currency currency = this.getCurrency();
        if (currency != null) {
            balanceStr = balanceStr + currency.getSymbol();
        }
        return balanceStr;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public long getFilesNum() {
        return this.account_filesNum;
    }

    public long getPremiumPoints() {
        return this.account_premiumPoints;
    }

    public String getStatus() {
        return this.account_status;
    }

    @Override
    public long getTrafficLeft() {
        return Math.max(0L, this.account_trafficLeft);
    }

    @Override
    public long getTrafficMax() {
        return Math.max(this.getTrafficLeft(), this.account_trafficMax);
    }

    public long getUsedSpace() {
        return this.account_usedSpace;
    }

    public long getValidUntil() {
        return this.account_validUntil;
    }

    public long getLastValidUntil() {
        return this.account_LastValidUntil;
    }

    public boolean isExpired() {
        long validUntil = this.getValidUntil();
        if (validUntil == -1L) {
            return false;
        }
        if (validUntil == 0L) {
            return true;
        }
        if (validUntil < 0L) {
            return true;
        }
        return validUntil < System.currentTimeMillis();
    }

    public void setAccountBalance(double num) {
        this.account_balance = Math.max(0.0, num);
    }

    public void setAccountBalance(double balance, Currency currency) {
        this.account_balance = balance;
        this.currency = currency;
    }

    public void setExpired(boolean b) {
        if (b) {
            this.setValidUntil(0L);
        } else {
            this.setValidUntil(-1L);
        }
    }

    public void setFilesNum(long parseInt) {
        this.account_filesNum = Math.max(0L, parseInt);
    }

    public void setPremiumPoints(long parseInt) {
        this.account_premiumPoints = Math.max(0L, parseInt);
    }

    public void setPremiumPoints(String string) {
        this.setPremiumPoints(Integer.parseInt(string.trim()));
    }

    public void setStatus(String string) {
        this.account_status = string;
    }

    public void setTrafficLeft(long size) {
        this.account_trafficLeft = Math.max(0L, size);
    }

    public void setUnlimitedTraffic() {
        this.account_trafficLeft = -1L;
    }

    @Override
    public boolean isUnlimitedTraffic() {
        return this.account_trafficLeft == -1L;
    }

    public void setTrafficLeft(String freeTraffic) {
        this.setTrafficLeft(SizeFormatter.getSize((String)freeTraffic, (boolean)true, (boolean)true));
    }

    public void setTrafficMax(String trafficMax) {
        this.setTrafficMax(SizeFormatter.getSize((String)trafficMax, (boolean)true, (boolean)true));
    }

    public void setTrafficMax(long trafficMax) {
        this.account_trafficMax = Math.max(0L, trafficMax);
    }

    public void setUsedSpace(long size) {
        this.account_usedSpace = Math.max(0L, size);
    }

    public void setUsedSpace(String string) {
        this.setUsedSpace(SizeFormatter.getSize((String)string, (boolean)true, (boolean)true));
    }

    public final boolean setValidUntil(long validuntil, Browser br) {
        return this.setValidUntil(validuntil, br, "EEE, dd MMM yyyy HH:mm:ss z");
    }

    public final boolean setValidUntil(long validuntil, Browser br, String formatter) {
        if (validuntil == -1L) {
            this.setValidUntil(-1L);
            return true;
        }
        long serverTime = br.getCurrentServerTime(-1L);
        if (serverTime > 0L) {
            long a1 = validuntil + (System.currentTimeMillis() - serverTime);
            this.setValidUntil(a1);
            return true;
        }
        this.setValidUntil(validuntil);
        return false;
    }

    public void setValidUntil(long validUntil) {
        this.account_validUntil = validUntil;
    }

    public void setLastValidUntil(long validUntil) {
        this.account_LastValidUntil = validUntil;
    }

    @Deprecated
    public List<String> setMultiHostSupport(PluginForHost multiHostPlugin, List<String> multiHostSupportListStr) {
        List<MultiHostHost> results;
        ArrayList<MultiHostHost> mhosts = new ArrayList<MultiHostHost>();
        if (multiHostSupportListStr != null) {
            for (String domain : multiHostSupportListStr) {
                if (domain == null) continue;
                mhosts.add(new MultiHostHost(domain));
            }
        }
        if ((results = this.setMultiHostSupportV2(multiHostPlugin, mhosts)) == null) {
            return null;
        }
        ArrayList<String> resultsStr = new ArrayList<String>();
        for (MultiHostHost mhost : results) {
            resultsStr.add(mhost.getDomain());
        }
        return resultsStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MultiHostHost> setMultiHostSupportV2(PluginForHost multiHostPlugin, List<MultiHostHost> multiHostSupportList) {
        if (multiHostPlugin != null && multiHostPlugin.getLogger() != null) {
            return this.setMultiHostSupportV2(multiHostPlugin, multiHostSupportList, new PluginFinder(multiHostPlugin.getLogger()));
        }
        LogSource logSource = LogController.getFastPluginLogger(Thread.currentThread().getName());
        try {
            List<MultiHostHost> list = this.setMultiHostSupportV2(multiHostPlugin, multiHostSupportList, new PluginFinder((LogInterface)logSource));
            return list;
        }
        finally {
            logSource.close();
        }
    }

    /*
     * Could not resolve type clashes
     */
    public List<MultiHostHost> setMultiHostSupportV2(PluginForHost multiHostPlugin, List<MultiHostHost> multiHostSupportList, PluginFinder pluginFinder) {
        if (multiHostSupportList == null || multiHostSupportList.size() == 0) {
            this.removeProperty(PROPERTY_MULTIHOST_SUPPORT);
            return null;
        }
        LogSource logger = multiHostPlugin != null && multiHostPlugin.getLogger() != null ? multiHostPlugin.getLogger() : LogController.CL();
        boolean debugLogging = logger != null && (LogController.getInstance().isDebugMode() || DebugMode.TRUE_IN_IDE_ELSE_FALSE);
        HostPluginController hpc = HostPluginController.getInstance();
        HashMap<String, MultiHostHost> cleanList = new HashMap<String, MultiHostHost>();
        HashMap<String, HashSet<LazyHostPlugin>> mapping = new HashMap<String, HashSet<LazyHostPlugin>>();
        HashSet<String> skippedOfflineEntries = new HashSet<String>();
        HashSet<String> skippedInvalidEntries = new HashSet<String>();
        HashSet<String> skippedByPluginAllowHandleEntries = new HashSet<String>();
        HashSet<Object> alternativeDomainsOfFoundHits = new HashSet<Object>();
        HashSet<String> otherIgnoreEntries = new HashSet<String>();
        Pattern patternInvalid = Pattern.compile("http|directhttp|https|file|up|upload|video|torrent|ftp", 2);
        block2: for (MultiHostHost mhost : multiHostSupportList) {
            String[] siteSupportedNames;
            Iterator domainCleaned;
            List<String> domains = mhost.getDomains();
            ArrayList<String> cleanedDomains = new ArrayList<String>();
            String maindomainCleaned = null;
            for (String domain : domains) {
                if (domain == null || StringUtils.isEmpty((String)((Object)(domainCleaned = domain.toLowerCase(Locale.ENGLISH).replaceAll("\\s+", ""))))) continue;
                if (new Regex((Object)domainCleaned, patternInvalid).patternMatches()) {
                    skippedInvalidEntries.add((String)((Object)domainCleaned));
                    continue;
                }
                if (maindomainCleaned == null) {
                    maindomainCleaned = domainCleaned;
                }
                if (cleanedDomains.contains(domainCleaned)) continue;
                cleanedDomains.add((String)((Object)domainCleaned));
            }
            if (maindomainCleaned == null) continue;
            for (String domain : cleanedDomains) {
                if (!alternativeDomainsOfFoundHits.contains(domain)) continue;
                logger.info("Skipping same domain duplicated in multiple MultiHostHost entries: " + mhost.getDomain());
                continue block2;
            }
            mhost.setDomains(cleanedDomains);
            cleanList.put(maindomainCleaned, mhost);
            LazyHostPlugin safeHit = null;
            ArrayList<LazyHostPlugin> hits = new ArrayList<LazyHostPlugin>();
            domainCleaned = hpc.list().iterator();
            block5: while (domainCleaned.hasNext()) {
                Object domain2;
                LazyHostPlugin lazyHostPlugin = (LazyHostPlugin)domainCleaned.next();
                for (Object domain2 : cleanedDomains) {
                    if (!((String)domain2).equals(lazyHostPlugin.getHost())) continue;
                    safeHit = lazyHostPlugin;
                    break block5;
                }
                siteSupportedNames = lazyHostPlugin.getSitesSupported();
                if (siteSupportedNames == null) continue;
                for (Object siteSupportedName : siteSupportedNames) {
                    if (!cleanedDomains.contains(siteSupportedName)) continue;
                    safeHit = lazyHostPlugin;
                    break block5;
                }
                domain2 = cleanedDomains.iterator();
                while (domain2.hasNext()) {
                    String domain3 = (String)domain2.next();
                    for (String siteSupportedName : siteSupportedNames) {
                        if (!siteSupportedName.startsWith(domain3)) continue;
                        hits.add(lazyHostPlugin);
                        continue block5;
                    }
                }
            }
            if (safeHit != null) {
                hits.clear();
                hits.add(safeHit);
            }
            if (hits.isEmpty()) continue;
            domainCleaned = hits.iterator();
            while (domainCleaned.hasNext()) {
                HashSet<LazyHostPlugin> plugins;
                LazyHostPlugin hit = (LazyHostPlugin)domainCleaned.next();
                siteSupportedNames = hit.getSitesSupported();
                if (siteSupportedNames != null) {
                    for (Object siteSupportedName : siteSupportedNames) {
                        alternativeDomainsOfFoundHits.add(siteSupportedName);
                    }
                }
                if ((plugins = (HashSet<LazyHostPlugin>)mapping.get(maindomainCleaned)) == null) {
                    plugins = new HashSet<LazyHostPlugin>();
                    mapping.put(maindomainCleaned, plugins);
                }
                plugins.add(hit);
            }
        }
        boolean skipOfflineEntries = !DebugMode.TRUE_IN_IDE_ELSE_FALSE;
        ArrayList<String> final_dupes = new ArrayList<String>();
        ArrayList<MultiHostHost> final_results = new ArrayList<MultiHostHost>();
        HashSet<String> unassignedMultiHostSupport = new HashSet<String>();
        for (Map.Entry entry : cleanList.entrySet()) {
            LazyHostPlugin finalplugin;
            String maindomainCleaned = (String)entry.getKey();
            MultiHostHost mhost = (MultiHostHost)entry.getValue();
            Set plugins = (Set)mapping.get(maindomainCleaned);
            if (plugins == null) {
                mhost.setStatus(MultiHostHost.MultihosterHostStatus.DEACTIVATED_JDOWNLOADER_UNSUPPORTED);
                unassignedMultiHostSupport.add(maindomainCleaned);
                final_results.add(mhost);
                continue;
            }
            if (mhost.getStatus() == MultiHostHost.MultihosterHostStatus.DEACTIVATED_JDOWNLOADER_UNSUPPORTED) {
                mhost.setStatus(MultiHostHost.MultihosterHostStatus.WORKING);
            }
            Iterator iterator = plugins.iterator();
            while (iterator.hasNext()) {
                LazyHostPlugin plugin = (LazyHostPlugin)iterator.next();
                if (!final_dupes.contains(plugin.getHost())) continue;
                iterator.remove();
            }
            if (plugins.size() == 0) continue;
            ArrayList<LazyHostPlugin> best = new ArrayList<LazyHostPlugin>();
            HashSet<LazyHostPlugin> thisSkippedByPluginAllowHandleEntries = new HashSet<LazyHostPlugin>();
            HashSet<LazyHostPlugin> thisSkippedByOfflinePluginEntries = new HashSet<LazyHostPlugin>();
            for (LazyHostPlugin plugin : plugins) {
                block53: {
                    if (plugin.isOfflinePlugin()) {
                        thisSkippedByOfflinePluginEntries.add(plugin);
                        skippedOfflineEntries.add(maindomainCleaned);
                        continue;
                    }
                    if (plugin.isFallbackPlugin()) {
                        otherIgnoreEntries.add(maindomainCleaned);
                        continue;
                    }
                    if (multiHostPlugin != null && plugin.isHasAllowHandle()) {
                        try {
                            DownloadLink link = new DownloadLink(null, "", plugin.getHost(), "", false);
                            PluginForHost plg = pluginFinder.getPlugin(plugin);
                            if (!plg.allowHandle(link, multiHostPlugin)) {
                                thisSkippedByPluginAllowHandleEntries.add(plugin);
                                skippedByPluginAllowHandleEntries.add(plugin.getHost());
                            }
                            break block53;
                        }
                        catch (Throwable e) {
                            if (debugLogging) {
                                logger.log(e);
                            }
                            otherIgnoreEntries.add(maindomainCleaned);
                        }
                        continue;
                    }
                }
                best.add(plugin);
            }
            if (best.size() == 1) {
                finalplugin = (LazyHostPlugin)best.get(0);
            } else if (thisSkippedByPluginAllowHandleEntries.size() == plugins.size()) {
                finalplugin = (LazyHostPlugin)plugins.iterator().next();
                mhost.setStatus(MultiHostHost.MultihosterHostStatus.DEACTIVATED_JDOWNLOADER_NOT_ALLOWED_BY_ORIGINAL_PLUGIN);
            } else if (thisSkippedByOfflinePluginEntries.size() == plugins.size()) {
                finalplugin = (LazyHostPlugin)plugins.iterator().next();
                mhost.setStatus(MultiHostHost.MultihosterHostStatus.DEACTIVATED_JDOWNLOADER);
                mhost.setStatusText("Permanently offline");
                if (skipOfflineEntries) {
                    continue;
                }
            } else {
                unassignedMultiHostSupport.add(maindomainCleaned);
                if (!debugLogging || best.size() <= 1) continue;
                logger.warning("Found more than one possible plugins for one domain: " + maindomainCleaned);
                logger.log((Throwable)new Exception("DEBUG: " + maindomainCleaned));
                continue;
            }
            boolean hostIsWorkingAccordingToMultihost = mhost.getStatus() == MultiHostHost.MultihosterHostStatus.WORKING || mhost.getStatus() == MultiHostHost.MultihosterHostStatus.WORKING_UNSTABLE;
            boolean printNonWorkingHosts = true;
            if (debugLogging && !hostIsWorkingAccordingToMultihost) {
                logger.info("Non working host: " + mhost);
            }
            String pluginHost = finalplugin.getHost();
            if (multiHostPlugin != null && pluginHost.equals(multiHostPlugin.getHost()) || final_dupes.contains(pluginHost)) continue;
            final_dupes.add(pluginHost);
            String[] siteSupportedNames = finalplugin.getSitesSupported();
            if (siteSupportedNames != null && siteSupportedNames.length > 0) {
                for (String siteSupportedName : siteSupportedNames) {
                    alternativeDomainsOfFoundHits.add(siteSupportedName);
                }
                mhost.addDomains(Arrays.asList(siteSupportedNames));
            }
            mhost.getDomains().remove(pluginHost);
            mhost.getDomains().add(0, pluginHost);
            final_results.add(mhost);
        }
        for (String item : alternativeDomainsOfFoundHits) {
            unassignedMultiHostSupport.remove(item);
        }
        if (debugLogging) {
            if (skipOfflineEntries && skippedOfflineEntries.size() > 0) {
                logger.info("Found " + skippedOfflineEntries.size() + " offline entries");
                for (String host : skippedOfflineEntries) {
                    logger.info("Skipped offline entry: " + host);
                }
            }
            if (skippedByPluginAllowHandleEntries.size() > 0) {
                logger.info("Found " + skippedByPluginAllowHandleEntries.size() + " skippedbyPluginAllowHandle entries");
                for (String host : skippedByPluginAllowHandleEntries) {
                    logger.info("Skipped by allowHandle entry: " + host);
                }
            }
            if (skippedInvalidEntries.size() > 0) {
                logger.info("Found " + skippedInvalidEntries.size() + " skippedInvalid entries");
                for (String host : skippedInvalidEntries) {
                    logger.info("Skipped invalid entry: " + host);
                }
            }
            if (unassignedMultiHostSupport.size() > 0) {
                logger.info("Found " + unassignedMultiHostSupport.size() + " unassigned entries");
                for (String host : unassignedMultiHostSupport) {
                    logger.info("Could not assign any host for: " + host);
                }
            }
            if (otherIgnoreEntries.size() > 0) {
                logger.info("Found " + otherIgnoreEntries.size() + " other skipped entries");
                for (String item : otherIgnoreEntries) {
                    if (logger == null) continue;
                    logger.info("Skipped _other_ entry: " + item);
                }
            }
        }
        if (final_results.isEmpty()) {
            if (logger != null) {
                logger.info("Failed to find ANY usable results");
            }
            this.removeProperty(PROPERTY_MULTIHOST_SUPPORT);
            return null;
        }
        if (debugLogging) {
            // empty if block
        }
        Collections.sort(final_dupes, new NaturalOrderComparator());
        this.setProperty(PROPERTY_MULTIHOST_SUPPORT, new CopyOnWriteArrayList(final_dupes));
        this.setMultiHostSupportV2(final_results);
        return final_results;
    }

    @Deprecated
    public List<String> getMultiHostSupport() {
        Object ret = this.getProperty(PROPERTY_MULTIHOST_SUPPORT, null);
        if (ret == null) {
            return null;
        }
        if (!(ret instanceof List)) {
            return null;
        }
        List list = (List)ret;
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    @Override
    public boolean removeProperty(String key) {
        if (PROPERTY_MULTIHOST_SUPPORT.equals(key)) {
            this.setMultiHostSupportV2(null);
        }
        return super.removeProperty(key);
    }

    public List<MultiHostHost> getMultiHostSupportV2() {
        return this.multihostSupportV2;
    }

    public void setMultiHostSupportV2(List<MultiHostHost> mhosts) {
        if (mhosts == null || mhosts.size() == 0) {
            this.multihostSupportV2 = null;
            return;
        }
        for (MultiHostHost mhost : mhosts) {
            mhost.setAccountInfo(this);
        }
        try {
            Collections.sort(mhosts, new Comparator<MultiHostHost>(){

                @Override
                public int compare(MultiHostHost o1, MultiHostHost o2) {
                    return StringUtils.valueOrEmpty((String)o1.getDomain()).compareToIgnoreCase(StringUtils.valueOrEmpty((String)o2.getDomain()));
                }
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.multihostSupportV2 = new CopyOnWriteArrayList<MultiHostHost>(mhosts);
    }

    public MultiHostHost getMultihostSupportedHost(String domain) {
        List<MultiHostHost> mhosts = this.getMultiHostSupportV2();
        if (mhosts == null || mhosts.size() == 0) {
            return null;
        }
        for (MultiHostHost mhost : mhosts) {
            if (!mhost.supportsDomain(domain)) continue;
            return mhost;
        }
        return null;
    }

    public void updateMultihostSupportedHost(MultiHostHost mhost) {
        List<MultiHostHost> mhosts = this.getMultiHostSupportV2();
        if (mhosts == null || mhosts.size() == 0) {
            return;
        }
        if (!mhosts.contains(mhost)) {
            mhosts.add(mhost);
        }
    }

    public static long getTimestampInServerContext(Browser br, long timestamp) {
        long serverTime = br.getCurrentServerTime(-1L);
        if (serverTime > 0L) {
            return timestamp + (System.currentTimeMillis() - serverTime);
        }
        return timestamp;
    }
}

