/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.util.ArrayList;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcollector.LinkOriginDetails;
import jd.controlling.linkcrawler.ArchiveInfoStorable;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkStorable;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.TypeRef;
import org.jdownloader.extensions.extraction.BooleanStatus;

public class CrawledLinkStorable
implements Storable {
    public static final TypeRef<CrawledLinkStorable> TYPEREF = new TypeRef<CrawledLinkStorable>(){};
    private CrawledLink link;
    private String id = null;
    private long UID = -1L;

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.link._getName();
    }

    public void setName(String name) {
        this.link.setName(name);
    }

    public boolean isEnabled() {
        return this.link.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.link.setEnabled(enabled);
    }

    @StorableAllowPrivateAccessModifier
    private CrawledLinkStorable() {
        this.link = new CrawledLink((CharSequence)null);
    }

    public CrawledLinkStorable(CrawledLink link) {
        this.link = link;
    }

    public void setSourceUrls(String[] urls) {
        if (urls != null) {
            ArrayList<String> deDuplicatedURLs = new ArrayList<String>();
            for (String url : urls) {
                String deDuplicatedURL = DownloadLink.dedupeString(LinkCrawler.cleanURL(url));
                if (deDuplicatedURL == null) continue;
                deDuplicatedURLs.add(deDuplicatedURL);
            }
            urls = deDuplicatedURLs.toArray(new String[deDuplicatedURLs.size()]);
        }
        this.link.setSourceUrls(urls);
    }

    public String[] getSourceUrls() {
        return this.link.getSourceUrls();
    }

    public LinkOriginStorable getOriginDetails() {
        LinkOriginDetails origin = this.link.getOrigin();
        if (origin == null) {
            return null;
        }
        return new LinkOriginStorable(origin);
    }

    public void setOriginDetails(LinkOriginStorable origin) {
        if (origin != null) {
            try {
                LinkOrigin enu = LinkOrigin.valueOf(origin.id);
                this.link.setOrigin(LinkOriginDetails.getInstance(enu, origin.details));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public long getUID() {
        DownloadLink dll = this._getDownloadLink();
        if (dll != null) {
            return dll.getUniqueID().getID();
        }
        return this.link.getUniqueID().getID();
    }

    public void setUID(long id) {
        this.UID = id;
    }

    public DownloadLinkStorable getDownloadLink() {
        return new DownloadLinkStorable(this._getDownloadLink());
    }

    public void setDownloadLink(DownloadLinkStorable link) {
        this.link.setDownloadLink(link._getDownloadLink());
    }

    public DownloadLink _getDownloadLink() {
        return this.link.getDownloadLink();
    }

    public void setCreated(long created) {
        this.link.setCreated(created);
    }

    public long getCreated() {
        return this.link.getCreated();
    }

    public CrawledLink _getCrawledLink() {
        DownloadLink dll = this._getDownloadLink();
        if (dll != null && this.UID != -1L) {
            dll.getUniqueID().setID(this.UID);
        }
        if (this.UID != -1L) {
            this.link.getUniqueID().setID(this.UID);
        }
        this._finalizeDeserialization(this.link, dll);
        return this.link;
    }

    public void _finalizeDeserialization(CrawledLink crawledLink, DownloadLink downloadLink) {
        if (crawledLink != null && crawledLink.getSourceUrls() != null && downloadLink != null) {
            String[] sourceURLs;
            for (String sourceURL : sourceURLs = crawledLink.getSourceUrls()) {
                if (sourceURL == null || !sourceURL.equals(downloadLink.getPluginPatternMatcher())) continue;
                downloadLink.setPluginPatternMatcherUnsafe(sourceURL);
            }
        }
    }

    public ArchiveInfoStorable getArchiveInfo() {
        if (this.link.hasArchiveInfo()) {
            return new ArchiveInfoStorable(this.link.getArchiveInfo());
        }
        return null;
    }

    public void setArchiveInfo(ArchiveInfoStorable info) {
        if (info != null) {
            boolean setArchiveInfo;
            boolean bl = setArchiveInfo = !BooleanStatus.UNSET.equals((Object)info.getAutoExtract());
            if (!setArchiveInfo) {
                boolean bl2 = setArchiveInfo = info.getExtractionPasswords() != null && info.getExtractionPasswords().size() > 0;
            }
            if (setArchiveInfo) {
                this.link.setArchiveInfo(info._getArchiveInfo());
            }
        }
    }

    public static class LinkOriginStorable
    implements Storable {
        private String id;
        private String details;

        public LinkOriginStorable() {
        }

        public LinkOriginStorable(LinkOriginDetails origin) {
            this.id = origin.getOrigin().name();
            this.details = origin.getDetails();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }
}

