/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.util.ArrayList;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.PackageControllerComparator;
import jd.plugins.CrawledLinkStorable;
import jd.plugins.DownloadLink;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.TypeRef;
import org.jdownloader.controlling.Priority;

public class CrawledPackageStorable
implements Storable {
    public static final TypeRef<CrawledPackageStorable> TYPEREF = new TypeRef<CrawledPackageStorable>(){};
    private TYPE type = TYPE.NORMAL;
    private String packageID = null;
    private CrawledPackage pkg;
    private List<CrawledLinkStorable> links;

    public TYPE getType() {
        switch (this.pkg.getType()) {
            case NORMAL: {
                return TYPE.NORMAL;
            }
            case OFFLINE: {
                return TYPE.OFFLINE;
            }
            case POFFLINE: {
                return TYPE.POFFLINE;
            }
            case VARIOUS: {
                return TYPE.VARIOUS;
            }
        }
        return TYPE.NORMAL;
    }

    public void setType(TYPE type) {
        if (type == null) {
            type = TYPE.NORMAL;
        }
        this.type = type;
    }

    public long getUID() {
        return this.pkg.getUniqueID().getID();
    }

    public void setUID(long id) {
        this.pkg.getUniqueID().setID(id);
    }

    public String getComment() {
        return this.pkg.getComment();
    }

    public String getSorterId() {
        PackageControllerComparator<AbstractNode> lSorter = this.pkg.getCurrentSorter();
        if (lSorter == null) {
            return null;
        }
        boolean asc = lSorter.isAsc();
        return (asc ? "ASC" : "DESC") + "." + lSorter.getID();
    }

    public void setSorterId(String id) {
        if (id == null) {
            this.pkg.setCurrentSorter(null);
        } else {
            this.pkg.setCurrentSorter(PackageControllerComparator.getComparator(id));
        }
    }

    public void setComment(String comment) {
        this.pkg.setComment(comment);
    }

    @StorableAllowPrivateAccessModifier
    private CrawledPackageStorable() {
        this(new CrawledPackage(), false);
    }

    public CrawledPackageStorable(CrawledPackage pkg) {
        this(pkg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawledPackageStorable(CrawledPackage pkg, boolean includeChildren) {
        this.pkg = pkg;
        if (!includeChildren) {
            this.links = new ArrayList<CrawledLinkStorable>();
        } else {
            boolean readL = pkg.getModifyLock().readLock();
            try {
                this.links = new ArrayList<CrawledLinkStorable>(pkg.getChildren().size());
                for (CrawledLink link : pkg.getChildren()) {
                    this.links.add(new CrawledLinkStorable(link));
                }
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        }
    }

    public CrawledPackage _getCrawledPackage() {
        switch (this.type) {
            case NORMAL: {
                this.pkg.setType(CrawledPackage.TYPE.NORMAL);
                break;
            }
            case OFFLINE: {
                this.pkg.setType(CrawledPackage.TYPE.OFFLINE);
                break;
            }
            case POFFLINE: {
                this.pkg.setType(CrawledPackage.TYPE.POFFLINE);
                break;
            }
            case VARIOUS: {
                this.pkg.setType(CrawledPackage.TYPE.VARIOUS);
            }
        }
        return this.pkg;
    }

    public long getCreated() {
        return this.pkg.getCreated();
    }

    public long getModified() {
        return this.pkg.getModified();
    }

    public String getDownloadFolder() {
        return this.pkg.getRawDownloadFolder();
    }

    public List<CrawledLinkStorable> getLinks() {
        return this.links;
    }

    public boolean isExpanded() {
        return this.pkg.isExpanded();
    }

    public void setCreated(long created) {
        this.pkg.setCreated(created);
    }

    public void setModified(long modified) {
        this.pkg.setModified(modified);
    }

    public void setDownloadFolder(String downloadFolder) {
        this.pkg.setDownloadFolder(downloadFolder);
    }

    public void setExpanded(boolean expanded) {
        this.pkg.setExpanded(expanded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinks(List<CrawledLinkStorable> links) {
        if (links != null) {
            this.links = links;
            try {
                this.pkg.getModifyLock().writeLock();
                List<CrawledLink> children = this.pkg.getChildren();
                for (CrawledLinkStorable link : links) {
                    if (link == null) continue;
                    CrawledLink crawledLink = link._getCrawledLink();
                    children.add(crawledLink);
                    crawledLink.setParentNode(this.pkg);
                    DownloadLink downloadLink = crawledLink.getDownloadLink();
                    downloadLink.setNodeChangeListener(crawledLink);
                }
            }
            finally {
                this.pkg.getModifyLock().writeUnlock();
            }
        }
    }

    public void setName(String name) {
        this.pkg.setName(name);
    }

    public String getName() {
        return this.pkg.getName();
    }

    public void setPackageID(String packageID) {
        this.packageID = packageID;
    }

    public String getPriority() {
        return this.pkg.getPriorityEnum().name();
    }

    public void setPriority(String priority) {
        try {
            if (priority != null) {
                this.pkg.setPriorityEnum(Priority.valueOf(priority));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPackageID() {
        return this.packageID;
    }

    public static enum TYPE {
        NORMAL,
        OFFLINE,
        POFFLINE,
        VARIOUS;

    }
}

