/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import jd.gui.swing.components.linkbutton.JLink;
import jd.plugins.Account;
import jd.plugins.PluginForHost;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.components.ExtTextHighlighter;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.InputChangedCallbackInterface;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.accounts.AccountBuilderInterface;

public class DefaultEditAccountPanelAPIKeyLogin
extends MigPanel
implements AccountBuilderInterface {
    private static final long serialVersionUID = 1L;
    private final ExtPasswordField pass;
    private final JLabel idLabel;
    private final PluginForHost plg;

    protected String getPassword() {
        if (this.pass == null) {
            return null;
        }
        return new String(this.pass.getPassword());
    }

    @Override
    public boolean updateAccount(Account input, Account output) {
        boolean changed = false;
        if (!StringUtils.equals((String)input.getUser(), (String)output.getUser())) {
            output.setUser(input.getUser());
            changed = true;
        }
        if (!StringUtils.equals((String)input.getPass(), (String)output.getPass())) {
            output.setPass(input.getPass());
            changed = true;
        }
        return changed;
    }

    public DefaultEditAccountPanelAPIKeyLogin(final InputChangedCallbackInterface callback, PluginForHost plg) {
        super("ins 0, wrap 2", "[][grow,fill]", "");
        this.plg = plg;
        this.add(new JLabel(_GUI.T.jd_gui_swing_components_AccountDialog_generic_instructions()));
        this.add((Component)new JLink(_GUI.T.jd_gui_swing_components_AccountDialog_generic_instructions_click_here_for_instructions(), plg.getAPILoginHelpURL()));
        this.idLabel = new JLink("<HTML><U>" + _GUI.T.jd_gui_swing_components_AccountDialog_api_key() + "</U></HTML>", plg.getAPILoginHelpURL());
        this.add(this.idLabel);
        this.pass = new ExtPasswordField(){
            {
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("^(\\s+)")));
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("(\\s+)$")));
                this.applyTextHighlighter(null);
            }

            public void onChanged() {
                callback.onChangedInput(DefaultEditAccountPanelAPIKeyLogin.this.pass);
            }
        };
        this.add((Component)this.pass, "");
        this.pass.setHelpText(_GUI.T.jd_gui_swing_components_AccountDialog_api_key_help());
    }

    @Override
    public void setAccount(Account defaultAccount) {
        if (defaultAccount != null) {
            this.pass.setText(defaultAccount.getPass());
        }
    }

    @Override
    public boolean validateInputs() {
        String password = this.getPassword();
        if (this.plg.looksLikeValidAPIKey(password)) {
            this.idLabel.setForeground(Color.BLACK);
            return true;
        }
        this.idLabel.setForeground(Color.RED);
        return false;
    }

    @Override
    public Account getAccount() {
        return new Account(null, this.getPassword());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

