/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import jd.gui.swing.components.linkbutton.JLink;
import jd.http.Cookies;
import jd.plugins.Account;
import jd.plugins.PluginForHost;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.ExtTextHighlighter;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.InputChangedCallbackInterface;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.accounts.AccountBuilderInterface;
import org.jdownloader.plugins.controller.LazyPlugin;

public class DefaultEditAccountPanelCookieLogin
extends MigPanel
implements AccountBuilderInterface {
    private static final long serialVersionUID = 1L;
    private final ExtTextField name;
    private final ExtPasswordField pass;
    private final InputChangedCallbackInterface callback;
    private JLabel usernameLabel = null;
    private final JLabel passwordOrCookiesLabel;
    private final PluginForHost plg;
    private final boolean usernameIsEmail;
    private final boolean cookieLoginOnly;
    private final boolean cookieLoginOptional;

    protected String getPassword() {
        if (this.pass == null) {
            return null;
        }
        return new String(this.pass.getPassword());
    }

    protected String getUsername() {
        if (this.name == null) {
            return "";
        }
        if (_GUI.T.jd_gui_swing_components_AccountDialog_help_username().equals(this.name.getText())) {
            return null;
        }
        return this.name.getText();
    }

    @Override
    public boolean updateAccount(Account input, Account output) {
        boolean changed = false;
        if (!StringUtils.equals((String)input.getUser(), (String)output.getUser())) {
            output.setUser(input.getUser());
            changed = true;
        }
        if (!StringUtils.equals((String)input.getPass(), (String)output.getPass())) {
            output.setPass(input.getPass());
            changed = true;
        }
        return changed;
    }

    public DefaultEditAccountPanelCookieLogin(final InputChangedCallbackInterface callback, PluginForHost plg) {
        super("ins 0, wrap 2", "[][grow,fill]", "");
        this.plg = plg;
        this.callback = callback;
        this.usernameIsEmail = this.plg.hasFeature(LazyPlugin.FEATURE.USERNAME_IS_EMAIL);
        this.cookieLoginOnly = this.plg.hasFeature(LazyPlugin.FEATURE.COOKIE_LOGIN_ONLY);
        this.cookieLoginOptional = this.plg.hasFeature(LazyPlugin.FEATURE.COOKIE_LOGIN_OPTIONAL);
        if (this.cookieLoginOnly) {
            this.add(new JLabel(_GUI.T.jd_gui_swing_components_AccountDialog_generic_instructions()));
            this.add((Component)new JLink(_GUI.T.jd_gui_swing_components_AccountDialog_generic_instructions_click_here_for_instructions(), "https://support.jdownloader.org/Knowledgebase/Article/View/account-cookie-login-instructions"));
        }
        if (this.usernameIsEmail) {
            this.usernameLabel = new JLabel(_GUI.T.jd_gui_swing_components_AccountDialog_email());
            this.add(this.usernameLabel);
        } else {
            this.usernameLabel = new JLabel(_GUI.T.jd_gui_swing_components_AccountDialog_name());
            this.add(this.usernameLabel);
        }
        this.name = new ExtTextField(){
            {
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("^(\\s+)")));
                this.addTextHighlighter(new ExtTextHighlighter((Highlighter.HighlightPainter)painter, Pattern.compile("(\\s+)$")));
                this.refreshTextHighlighter();
            }

            public void onChanged() {
                callback.onChangedInput(DefaultEditAccountPanelCookieLogin.this.name);
            }
        };
        this.add((Component)this.name);
        if (this.usernameIsEmail) {
            this.name.setHelpText(_GUI.T.jd_gui_swing_components_AccountDialog_help_email());
        } else {
            this.name.setHelpText(_GUI.T.jd_gui_swing_components_AccountDialog_help_username());
        }
        if (this.cookieLoginOnly) {
            this.passwordOrCookiesLabel = new JLink("<HTML><U>" + _GUI.T.jd_gui_swing_components_AccountDialog_cookies() + "</U></HTML>", "https://support.jdownloader.org/Knowledgebase/Article/View/account-cookie-login-instructions");
            this.add(this.passwordOrCookiesLabel);
        } else if (this.cookieLoginOptional) {
            String labelTxt = _GUI.T.jd_gui_swing_components_AccountDialog_pass_or_cookies();
            labelTxt = labelTxt.replaceFirst("(?i)" + Pattern.quote(_GUI.T.jd_gui_swing_components_AccountDialog_cookies()), "<U>" + _GUI.T.jd_gui_swing_components_AccountDialog_cookies() + "</U>");
            if (!_GUI.T.jd_gui_swing_components_AccountDialog_pass_or_cookies().matches(labelTxt)) {
                labelTxt = "<HTML>" + labelTxt + "</HTML>";
                this.passwordOrCookiesLabel = new JLink(labelTxt, "https://support.jdownloader.org/Knowledgebase/Article/View/account-cookie-login-instructions");
                this.add(this.passwordOrCookiesLabel);
            } else {
                this.passwordOrCookiesLabel = new JLabel(labelTxt);
                this.add(this.passwordOrCookiesLabel);
            }
        } else {
            this.passwordOrCookiesLabel = new JLabel(_GUI.T.jd_gui_swing_components_AccountDialog_pass());
            this.add(this.passwordOrCookiesLabel);
        }
        this.pass = new ExtPasswordField(){
            {
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                this.addTextHighlighter(new ExtTextHighlighter(painter, Pattern.compile("^(\\s+)")){

                    public boolean highlight(Highlighter highlighter, CharSequence charSequence) {
                        if (Cookies.parseCookiesFromString((String)charSequence.toString()) != null) {
                            return false;
                        }
                        return super.highlight(highlighter, charSequence);
                    }
                });
                this.addTextHighlighter(new ExtTextHighlighter(painter, Pattern.compile("(\\s+)$")){

                    public boolean highlight(Highlighter highlighter, CharSequence charSequence) {
                        if (Cookies.parseCookiesFromString((String)charSequence.toString()) != null) {
                            return false;
                        }
                        return super.highlight(highlighter, charSequence);
                    }
                });
                this.applyTextHighlighter(null);
            }

            public void onChanged() {
                callback.onChangedInput(DefaultEditAccountPanelCookieLogin.this.pass);
            }
        };
        this.add((Component)this.pass, "");
        if (this.cookieLoginOnly) {
            this.pass.setHelpText(_GUI.T.BuyAndAddPremiumAccount_layoutDialogContent_cookies());
        } else if (this.cookieLoginOptional) {
            this.pass.setHelpText(_GUI.T.BuyAndAddPremiumAccount_layoutDialogContent_pass_or_cookies());
        } else {
            this.pass.setHelpText(_GUI.T.BuyAndAddPremiumAccount_layoutDialogContent_pass());
        }
        ExtTextField dummy = new ExtTextField();
        dummy.paste();
        String clipboard = dummy.getText();
        if (StringUtils.isNotEmpty((String)clipboard)) {
            Cookies userCookies = Cookies.parseCookiesFromJsonString((String)clipboard, null);
            if ((this.cookieLoginOnly || this.cookieLoginOptional) && userCookies != null) {
                this.pass.setPassword(clipboard.toCharArray());
            } else if (userCookies == null && clipboard.trim().length() > 0) {
                this.name.setText(clipboard);
            }
        }
    }

    public InputChangedCallbackInterface getCallback() {
        return this.callback;
    }

    @Override
    public void setAccount(Account defaultAccount) {
        if (defaultAccount != null) {
            this.name.setText(defaultAccount.getUser());
            this.pass.setText(defaultAccount.getPass());
        }
    }

    @Override
    public boolean validateInputs() {
        boolean userok;
        if (StringUtils.isEmpty((String)this.getUsername())) {
            this.usernameLabel.setForeground(Color.RED);
            userok = false;
        } else if (this.usernameIsEmail && !this.plg.looksLikeValidEmailAddress(null, this.getUsername())) {
            this.usernameLabel.setForeground(Color.RED);
            userok = false;
        } else {
            this.usernameLabel.setForeground(Color.BLACK);
            userok = true;
        }
        String pw = this.getPassword();
        Cookies cookies = Cookies.parseCookiesFromString((String)pw);
        boolean passok = StringUtils.isEmpty((String)pw) ? false : (this.cookieLoginOnly && cookies == null ? false : this.cookieLoginOnly || this.cookieLoginOptional || cookies == null);
        if (!passok) {
            this.passwordOrCookiesLabel.setForeground(Color.RED);
        } else {
            this.passwordOrCookiesLabel.setForeground(Color.BLACK);
        }
        return userok && passok;
    }

    @Override
    public Account getAccount() {
        return new Account(this.getUsername(), this.getPassword());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

