/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import jd.config.Property;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.plugins.DownloadLinkDatabindingInterface;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.LinkInfo;
import jd.plugins.LinkStatus;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.UseSetLinkStatusThread;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.HashInfo;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.DefaultDownloadLinkViewImpl;
import org.jdownloader.controlling.DownloadLinkView;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.UrlProtection;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.controlling.linkcrawler.GenericVariants;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DownloadLink
extends Property
implements Serializable,
AbstractPackageChildrenNode<FilePackage>,
CheckableLink {
    private static final String PROPERTY_MD5 = "MD5";
    private static final String PROPERTY_HASHINFO = "HASHINFO";
    private static final String PROPERTY_MIRRORID = "MID";
    private static final String PROPERTY_SHA1 = "SHA1";
    private static final String PROPERTY_SHA256 = "SHA256";
    private static final String PROPERTY_PASS = "pass";
    private static final String PROPERTY_FINALFILENAME = "FINAL_FILENAME";
    private static final String PROPERTY_FORCEDFILENAME = "FORCED_FILENAME";
    public static final String PROPERTY_COMMENT = "COMMENT";
    private static final String PROPERTY_PASSWORD_PROTECTED = "PASSWORD_PROTECTED";
    private static final String PROPERTY_PRIORITY = "PRIORITY2";
    private static final String PROPERTY_FINISHTIME = "FINISHTIME";
    private static final String PROPERTY_PWLIST = "PWLIST";
    public static final String PROPERTY_LINKDUPEID = "LINKDUPEID";
    private static final String PROPERTY_SPEEDLIMIT = "SPEEDLIMIT";
    private static final String PROPERTY_VERIFIEDFILESIZE = "VERIFIEDFILESIZE";
    public static final String PROPERTY_RESUMEABLE = "PROPERTY_RESUMEABLE";
    public static final String PROPERTY_CUSTOM_LOCALFILENAME = "CUSTOM_LOCALFILENAME";
    public static final String PROPERTY_CUSTOM_LOCALFILENAMEAPPEND = "CUSTOM_LOCALFILENAMEAPPEND";
    public static final String PROPERTY_DOWNLOADTIME = "DOWNLOADTIME";
    public static final String PROPERTY_ARCHIVE_ID = "ARCHIVE_ID";
    public static final String PROPERTY_EXTRACTION_STATUS = "EXTRACTION_STATUS";
    public static final String PROPERTY_CUSTOM_MESSAGE = "CUSTOM_MESSAGE";
    public static final String PROPERTY_MIME_HINT = "MIME_HINT";
    public static final String PROPERTY_LAST_MODIFIED = "LAST_MODIFIED";
    private static final long serialVersionUID = 1981079856214268373L;
    private static final String UNKNOWN_FILE_NAME = "unknownFileName";
    private static final String PROPERTY_CHUNKS = "CHUNKS";
    private static final String URL_ORIGIN = "URL_ORIGIN";
    private static final String URL_REFERRER = "URL_REFERRER";
    public static final String URL_CONTAINER = "URL_CONTAINER";
    public static final String URL_CONTENT = "URL_CONTENT";
    public static final String URL_CUSTOM = "URL_CUSTOM";
    private static final String VARIANT_SUPPORT = "VARIANT_SUPPORT";
    public static final String PROPERTY_JOB_ID = "JOB_ID";
    private volatile AvailableStatus availableStatus = AvailableStatus.UNCHECKED;
    @Deprecated
    private long[] chunksProgress = null;
    private long downloadCurrent = 0L;
    private volatile SingleDownloadController downloadLinkController = null;
    private long downloadMax = -1L;
    private FilePackage filePackage;
    private String host;
    private boolean isEnabled;
    private String name;
    private PluginForHost defaultplugin;
    private PluginForHost liveplugin;
    private String urlDownload;
    private volatile List<PluginProgress> pluginProgress = null;
    private long created = -1L;
    private UniqueAlltimeID uniqueID = null;
    private AbstractNodeNotifier propertyListener;
    private DomainInfo domainInfo = null;
    private volatile SkipReason skipReason = null;
    private volatile ConditionalSkipReason conditionalSkipReason = null;
    private volatile FinalLinkState finalLinkState = null;
    private UniqueAlltimeID previousParent = null;
    private volatile ExtractionStatus extractionStatus = null;
    private Property tempProperties = null;
    private DownloadLinkView view = null;
    private LinkInfo linkInfo = null;
    private volatile long lastAvailableStatusChange = -1L;
    private volatile FilePackage lastValidFilePackage = null;
    private volatile String[] cachedName = null;
    private UrlProtection urlProtection = UrlProtection.UNSET;
    private List<HistoryEntry> history = null;
    private Boolean partOfAnArchive = null;
    public static final String RELATIVE_DOWNLOAD_FOLDER_PATH = "subfolderbyplugin";
    private static final String[] DEFAULT_DO_NOT_CHANGE_EXISTING_KEYS = new String[]{"COMMENT", "MID", "pass", "PRIORITY2", "LINKDUPEID", "SPEEDLIMIT", "ARCHIVE_ID", "URL_ORIGIN", "URL_REFERRER", "URL_CONTAINER", "URL_CONTENT", "URL_CUSTOM", "JOB_ID"};

    public Boolean isPartOfAnArchive() {
        return this.partOfAnArchive;
    }

    public void setPartOfAnArchive(Boolean archivePart) {
        if (!Boolean.FALSE.equals(archivePart) || Files.getExtension((String)this.getName()) != null) {
            this.partOfAnArchive = Boolean.FALSE.equals(archivePart) && this.getLinkInfo().getExtension().isSameExtensionGroup(CompiledFiletypeFilter.ArchiveExtensions.AA) ? null : archivePart;
        }
    }

    public void setRelativeDownloadFolderPath(String path) {
        this.setProperty(RELATIVE_DOWNLOAD_FOLDER_PATH, path);
    }

    public String getRelativeDownloadFolderPath() {
        return this.getStringProperty(RELATIVE_DOWNLOAD_FOLDER_PATH);
    }

    public long getJobID() {
        long jobID = this.getLongProperty(PROPERTY_JOB_ID, -1L);
        return jobID;
    }

    public FilePackage getLastValidFilePackage() {
        FilePackage lFilePackage = this.lastValidFilePackage;
        if (lFilePackage != null) {
            return lFilePackage;
        }
        return this.filePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property getTempProperties() {
        if (this.tempProperties != null) {
            return this.tempProperties;
        }
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            Property ltempProperties = this.tempProperties;
            if (ltempProperties == null) {
                this.tempProperties = ltempProperties = new Property();
            }
            return ltempProperties;
        }
    }

    public boolean hasTempProperties() {
        return this.tempProperties != null;
    }

    public DownloadLink(String pluginPatternMatcher) {
        this.init(null, null, null, pluginPatternMatcher, true);
    }

    public DownloadLink(String pluginPatternMatcher, boolean isEnabled) {
        this.init(null, null, null, pluginPatternMatcher, isEnabled);
    }

    public DownloadLink(PluginForHost plugin, String name, String host, String pluginPatternMatcher, boolean isEnabled) {
        this.init(plugin, name, host, pluginPatternMatcher, isEnabled);
    }

    public DownloadLink(PluginForHost plugin, String host, String pluginPatternMatcher, boolean isEnabled) {
        this.init(plugin, null, host, pluginPatternMatcher, isEnabled);
    }

    public DownloadLink(PluginForHost plugin, String host, String pluginPatternMatcher) {
        this.init(plugin, null, host, pluginPatternMatcher, true);
    }

    public void init(PluginForHost plugin, String name, String host, String pluginPatternMatcher, boolean isEnabled) {
        this.setDefaultPlugin(plugin);
        this.setView(this.getDefaultDowloadLinkView());
        if (name != null) {
            this.setName(name);
        }
        this.isEnabled = isEnabled;
        this.downloadMax = -1L;
        this.setHost(host);
        this.created = System.currentTimeMillis();
        this.setPluginPatternMatcher(pluginPatternMatcher);
    }

    protected DownloadLinkView getDefaultDowloadLinkView() {
        PluginForHost defaultPlugin = this.getDefaultPlugin();
        DownloadLinkView ret = null;
        if (defaultPlugin != null) {
            ret = defaultPlugin.getDownloadLinkView(this);
        }
        if (ret == null) {
            ret = new DefaultDownloadLinkViewImpl();
        }
        return ret;
    }

    @Override
    public long getFinishedDate() {
        return this.getLongProperty(PROPERTY_FINISHTIME, -1L);
    }

    public void setFinishedDate(long finishedDate) {
        if (finishedDate <= 0L) {
            this.removeProperty(PROPERTY_FINISHTIME);
        } else {
            this.setProperty(PROPERTY_FINISHTIME, finishedDate);
        }
    }

    public void addDownloadTime(long time) {
        if (time < 0L) {
            this.removeProperty(PROPERTY_DOWNLOADTIME);
        } else {
            this.setProperty(PROPERTY_DOWNLOADTIME, time + this.getDownloadTime());
        }
    }

    public long getDownloadTime() {
        return this.getLongProperty(PROPERTY_DOWNLOADTIME, 0L);
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniqueAlltimeID getUniqueID() {
        if (this.uniqueID == null) {
            DownloadLink downloadLink = this;
            synchronized (downloadLink) {
                if (this.uniqueID == null) {
                    this.uniqueID = new UniqueAlltimeID();
                }
            }
        }
        return this.uniqueID;
    }

    public Priority getPriorityEnum() {
        try {
            String priority = this.getStringProperty(PROPERTY_PRIORITY, null);
            if (priority == null) {
                return Priority.DEFAULT;
            }
            return Priority.valueOf(priority);
        }
        catch (Throwable e) {
            return Priority.DEFAULT;
        }
    }

    public int getChunks() {
        return this.getIntegerProperty(PROPERTY_CHUNKS, 0);
    }

    public void setChunks(int chunks) {
        if (chunks == this.getChunks()) {
            return;
        }
        if (chunks == 0) {
            this.removeProperty(PROPERTY_CHUNKS);
        } else {
            this.setProperty(PROPERTY_CHUNKS, chunks);
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.CHUNKS, chunks));
        }
    }

    public void setCustomSpeedLimit(int limit) {
        if (limit == this.getCustomSpeedLimit()) {
            return;
        }
        if (limit == 0) {
            this.removeProperty(PROPERTY_SPEEDLIMIT);
        } else {
            if (limit < 0) {
                limit = 1;
            }
            this.setProperty(PROPERTY_SPEEDLIMIT, limit);
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.SPEED_LIMIT, limit));
        }
    }

    public int getCustomSpeedLimit() {
        return this.getIntegerProperty(PROPERTY_SPEEDLIMIT, 0);
    }

    @Deprecated
    public long[] getChunksProgress() {
        return this.chunksProgress;
    }

    public long getDownloadCurrent() {
        SingleDownloadController dlc = this.getDownloadLinkController();
        DownloadInterface dli = null;
        long currentRaw = this.getDownloadCurrentRaw();
        if (dlc != null && (dli = dlc.getDownloadInstance()) != null) {
            if (dli.getTotalLinkBytesLoadedLive() == 0L && currentRaw != 0L) {
                return currentRaw;
            }
            return dli.getTotalLinkBytesLoadedLive();
        }
        return currentRaw;
    }

    public long getDownloadCurrentRaw() {
        return this.downloadCurrent;
    }

    public SingleDownloadController getDownloadLinkController() {
        return this.downloadLinkController;
    }

    public long getDownloadSize() {
        long verifiedFileSize = this.getVerifiedFileSize();
        if (verifiedFileSize >= 0L) {
            return verifiedFileSize;
        }
        return Math.max(this.getDownloadCurrent(), this.downloadMax);
    }

    public long getDownloadSpeed() {
        SingleDownloadController dlc = this.getDownloadLinkController();
        DownloadInterface dli = null;
        if (dlc != null && (dli = dlc.getDownloadInstance()) != null) {
            return dli.getManagedConnetionHandler().getSpeed();
        }
        return 0L;
    }

    public DownloadLinkView getView() {
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLinkView setView(DownloadLinkView status) {
        DownloadLinkView old;
        if (status == null) {
            throw new NullPointerException();
        }
        status.setLink(this);
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            old = this.view;
            this.view = status;
        }
        return old;
    }

    @Deprecated
    public String getDownloadURL() {
        return this.getPluginPatternMatcher();
    }

    public String getContentUrl() {
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            return plugin.getPluginContentURL(this);
        }
        return this.getStringProperty(URL_CONTENT);
    }

    public void setContentUrl(String url) {
        boolean changedFlag;
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            changedFlag = plugin.setPluginContentURL(url, this);
        } else if (!StringUtils.equals((String)url, (String)this.getContentUrl())) {
            changedFlag = StringUtils.isEmpty((String)url) ? this.removeProperty(URL_CONTENT) : this.setProperty(URL_CONTENT, url);
        } else {
            return;
        }
        if (changedFlag && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.URL_CONTENT, url));
        }
    }

    public String getCustomUrl() {
        PluginForHost plugin = this.getLivePlugin();
        if (plugin == null) {
            plugin = this.getDefaultPlugin();
        }
        if (plugin != null) {
            return plugin.getPluginCustomURL(this);
        }
        return this.getStringProperty(URL_CUSTOM);
    }

    public void setCustomURL(String url) {
        boolean changedFlag;
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            changedFlag = plugin.setPluginCustomURL(url, this);
        } else if (!StringUtils.equals((String)url, (String)this.getCustomUrl())) {
            changedFlag = StringUtils.isEmpty((String)url) ? this.removeProperty(URL_CUSTOM) : this.setProperty(URL_CUSTOM, url);
        } else {
            return;
        }
        if (changedFlag && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.URL_CUSTOM, url));
        }
    }

    public String getContainerUrl() {
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            return plugin.getPluginContainerURL(this);
        }
        return this.getStringProperty(URL_CONTAINER);
    }

    public void setContainerUrl(String url) {
        boolean changedFlag;
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            changedFlag = plugin.setPluginContainerURL(url, this);
        } else if (!StringUtils.equals((String)url, (String)this.getContainerUrl())) {
            changedFlag = StringUtils.isEmpty((String)url) ? this.removeProperty(URL_CONTAINER) : this.setProperty(URL_CONTAINER, url);
        } else {
            return;
        }
        if (changedFlag && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.URL_CONTAINER, url));
        }
    }

    public String getOriginUrl() {
        return this.getStringProperty(URL_ORIGIN);
    }

    public void setOriginUrl(String url) {
        if (!StringUtils.equals((String)url, (String)this.getOriginUrl())) {
            if (StringUtils.isEmpty((String)url)) {
                this.removeProperty(URL_ORIGIN);
            } else {
                this.setProperty(URL_ORIGIN, url);
            }
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.URL_ORIGIN, url));
            }
        }
    }

    public String getReferrerUrl() {
        return this.getStringProperty(URL_REFERRER);
    }

    public void setReferrerUrl(String url) {
        if (!StringUtils.equals((String)url, (String)this.getReferrerUrl())) {
            if (StringUtils.isEmpty((String)url)) {
                this.removeProperty(URL_REFERRER);
            } else {
                this.setProperty(URL_REFERRER, url);
            }
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.URL_REFERRER, url));
            }
        }
    }

    public String getPluginPatternMatcher() {
        return this.urlDownload;
    }

    public String getFileOutput() {
        return this.getFileOutput(false, false);
    }

    public String getFileOutputForPlugin(boolean ignoreUnsafe, boolean ignoreCustom) {
        SingleDownloadController con = this.getDownloadLinkController();
        if (con == null) {
            return this.getFileOutput(ignoreUnsafe, ignoreCustom);
        }
        return con.getFileOutput(ignoreUnsafe, ignoreCustom).getAbsolutePath();
    }

    public String getFileOutput(boolean ignoreUnsafe, boolean ignoreCustom) {
        return this.getFileOutput(this.getDownloadDirectory(), ignoreUnsafe, ignoreCustom);
    }

    public String getFileOutput(String downloadDirectory, boolean ignoreUnsafe, boolean ignoreCustom) {
        String fileName = this.getInternalTmpFilename();
        if (!StringUtils.isEmpty((String)fileName) && !ignoreCustom) {
            return new File(downloadDirectory, fileName).getAbsolutePath();
        }
        fileName = this.getName(ignoreUnsafe, false);
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        String customAppend = this.getInternalTmpFilenameAppend();
        if (!StringUtils.isEmpty((String)customAppend) && !ignoreCustom) {
            fileName = fileName + customAppend;
        }
        return new File(downloadDirectory, fileName).getAbsolutePath();
    }

    public String getDownloadDirectory() {
        if (Thread.currentThread() instanceof SingleDownloadController) {
            return ((SingleDownloadController)((Object)Thread.currentThread())).getSessionDownloadDirectory();
        }
        FilePackage fp = this.getLastValidFilePackage();
        if (fp != null) {
            String downloadDirectory = fp.getDownloadDirectory();
            if (StringUtils.isEmpty((String)downloadDirectory)) {
                throw new WTFException("what the fuck just happened here? defaultFilePackage: " + FilePackage.isDefaultFilePackage(fp));
            }
            return downloadDirectory;
        }
        throw new WTFException("what the fuck just happened here? no lastValidFilePackage");
    }

    public String getInternalTmpFilename() {
        String ret = this.getStringProperty(PROPERTY_CUSTOM_LOCALFILENAME, null);
        if (!StringUtils.isEmpty((String)ret)) {
            return ret;
        }
        return null;
    }

    public String getInternalTmpFilenameAppend() {
        String ret = this.getStringProperty(PROPERTY_CUSTOM_LOCALFILENAMEAPPEND, null);
        if (!StringUtils.isEmpty((String)ret)) {
            return ret;
        }
        return null;
    }

    public void setInternalTmpFilename(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            this.removeProperty(PROPERTY_CUSTOM_LOCALFILENAME);
        } else {
            fileName = this.fixFilename(fileName);
            this.setProperty(PROPERTY_CUSTOM_LOCALFILENAME, fileName);
        }
        this.cachedName = null;
    }

    public void setInternalTmpFilenameAppend(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            this.removeProperty(PROPERTY_CUSTOM_LOCALFILENAMEAPPEND);
        } else {
            fileName = this.fixFilename(fileName);
            this.setProperty(PROPERTY_CUSTOM_LOCALFILENAMEAPPEND, fileName);
        }
        this.cachedName = null;
    }

    public FilePackage getFilePackage() {
        FilePackage lFilePackage = this.filePackage;
        if (lFilePackage == null) {
            return FilePackage.getDefaultFilePackage();
        }
        return lFilePackage;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newHost) {
        if (newHost == null) {
            return;
        }
        this.host = DownloadLink.dedupeString(newHost.toLowerCase(Locale.ENGLISH));
    }

    public LinkStatus getLinkStatus() {
        Thread current = Thread.currentThread();
        if (current instanceof UseSetLinkStatusThread) {
            return ((UseSetLinkStatusThread)((Object)current)).getLinkStatus(this);
        }
        SingleDownloadController controller = this.getDownloadLinkController();
        if (controller != null) {
            return controller.getLinkStatus();
        }
        throw new WTFException("Cannot use getLinkStatus outside UseSetLinkStatusThread/SingleDownloadController");
    }

    public UrlProtection getUrlProtection() {
        return this.urlProtection;
    }

    @Override
    public String getName() {
        return this.getName(false, false);
    }

    public String getName(boolean ignoreUnsafe, boolean ignoreForcedFilename) {
        String ret = this.getCachedName(ignoreUnsafe, ignoreForcedFilename);
        if (StringUtils.isNotEmpty((String)ret)) {
            return ret;
        }
        String string = ret = ignoreForcedFilename ? null : this.getForcedFileName();
        if (StringUtils.isNotEmpty((String)ret)) {
            this.setCachedName(ignoreUnsafe, ignoreForcedFilename, ret);
            return ret;
        }
        ret = this.getFinalFileName();
        if (StringUtils.isNotEmpty((String)ret)) {
            ret = this.replaceCustomExtension(ret);
            this.setCachedName(ignoreUnsafe, ignoreForcedFilename, ret);
            return ret;
        }
        if (ignoreUnsafe) {
            this.setCachedName(ignoreUnsafe, ignoreForcedFilename, null);
            return null;
        }
        try {
            String name = this.getRawName();
            if (StringUtils.isNotEmpty((String)name)) {
                ret = this.replaceCustomExtension(name);
                this.setCachedName(ignoreUnsafe, ignoreForcedFilename, ret);
                return ret;
            }
            String defaultFilename = this.getDefaultFileName(this.getDefaultPlugin());
            if (defaultFilename != null) {
                this.setCachedName(ignoreUnsafe, ignoreForcedFilename, defaultFilename);
                return defaultFilename;
            }
            return UNKNOWN_FILE_NAME;
        }
        catch (Exception e) {
            return UNKNOWN_FILE_NAME;
        }
    }

    public String getDefaultFileName(PluginForHost plugin) {
        String urlName;
        String ret;
        if (plugin != null && StringUtils.isNotEmpty((String)(ret = plugin.getDefaultFileName(this)))) {
            return ret;
        }
        String url = this.getContentUrlOrPatternMatcher();
        if (StringUtils.isNotEmpty((String)url) && StringUtils.isNotEmpty((String)(urlName = Plugin.extractFileNameFromURL(url)))) {
            return this.replaceCustomExtension(urlName);
        }
        return null;
    }

    public String getRawName() {
        String lName = this.name;
        if (!UNKNOWN_FILE_NAME.equals(lName)) {
            return lName;
        }
        return null;
    }

    public boolean isNameSet() {
        return this.getRawName() != null || this.getForcedFileName() != null || this.getFinalFileName() != null;
    }

    public boolean isSizeSet() {
        return this.downloadMax != -1L || this.getVerifiedFileSize() != -1L;
    }

    public String replaceCustomExtension(String name) {
        if (name == null) {
            return null;
        }
        String cust = this.getCustomExtension();
        if (cust != null) {
            int index = name.lastIndexOf(".");
            if (index < 0) {
                return name + "." + cust;
            }
            return name.substring(0, index + 1) + cust;
        }
        return name;
    }

    private void setCachedName(boolean ignoreUnsafe, boolean ignoreForcedFilename, String ret) {
        String[] lCachedName = this.cachedName;
        if (lCachedName == null) {
            this.cachedName = lCachedName = new String[]{null, null, null, null};
        }
        String name = this.dedupeValueString(DownloadLinkProperty.Property.NAME.name(), ret);
        lCachedName[(ignoreUnsafe ? 1 : 0) * 2 + (ignoreForcedFilename ? 1 : 0)] = name;
    }

    private String getCachedName(boolean ignoreUnsafe, boolean ignoreForcedFilename) {
        String[] lCachedName = this.cachedName;
        if (lCachedName != null) {
            return lCachedName[(ignoreUnsafe ? 1 : 0) * 2 + (ignoreForcedFilename ? 1 : 0)];
        }
        return null;
    }

    public LinkInfo getSetLinkInfo() {
        return this.linkInfo;
    }

    public LinkInfo getLinkInfo() {
        LinkInfo lLinkInfo = this.linkInfo;
        if (lLinkInfo == null) {
            LinkInfo newLinkInfo;
            this.linkInfo = newLinkInfo = LinkInfo.getLinkInfo(this);
            return newLinkInfo;
        }
        return lLinkInfo;
    }

    private void setLinkInfo(LinkInfo linkInfo) {
        this.linkInfo = linkInfo;
    }

    public String getNameSetbyPlugin() {
        String ret = this.getFinalFileName();
        if (ret != null) {
            return ret;
        }
        return this.name;
    }

    public PluginForHost getDefaultPlugin() {
        return this.defaultplugin;
    }

    public PluginForHost getLivePlugin() {
        return this.liveplugin;
    }

    public String getComment() {
        return this.getStringProperty(PROPERTY_COMMENT, null);
    }

    public List<String> getSourcePluginPasswordList() {
        Object ret = this.getProperty(PROPERTY_PWLIST);
        if (ret != null) {
            if (ret instanceof String[]) {
                if (((String[])ret).length > 0) {
                    return Arrays.asList((String[])ret);
                }
                return null;
            }
            if (ret instanceof String) {
                if (StringUtils.isNotEmpty((String)((String)ret))) {
                    return Arrays.asList((String)ret);
                }
                return null;
            }
            if (ret instanceof List) {
                if (((List)ret).size() > 0) {
                    return (List)ret;
                }
                return null;
            }
        }
        return null;
    }

    public String getFinalFileName() {
        return this.getStringProperty(PROPERTY_FINALFILENAME, null);
    }

    public String getForcedFileName() {
        if (Thread.currentThread() instanceof SingleDownloadController) {
            return ((SingleDownloadController)((Object)Thread.currentThread())).getSessionDownloadFilename();
        }
        return this.getStringProperty(PROPERTY_FORCEDFILENAME, null);
    }

    public String getSetLinkID() {
        return this.getStringProperty(PROPERTY_LINKDUPEID, null);
    }

    public String getLinkID() {
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            return plugin.getLinkID(this);
        }
        String linkID = this.getSetLinkID();
        if (StringUtils.isEmpty((String)linkID)) {
            return this.getPluginPatternMatcher();
        }
        return linkID;
    }

    public void setLinkID(String id) {
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            plugin.setLinkID(this, id);
        } else if (StringUtils.isEmpty((String)id)) {
            this.removeProperty(PROPERTY_LINKDUPEID);
        } else {
            this.setProperty(PROPERTY_LINKDUPEID, id);
        }
    }

    public boolean isAvailabilityStatusChecked() {
        return this.availableStatus != AvailableStatus.UNCHECKED;
    }

    public boolean isAvailable() {
        return this.availableStatus != AvailableStatus.FALSE;
    }

    public AvailableStatus getAvailableStatus() {
        return this.availableStatus;
    }

    public void setAvailableStatus(AvailableStatus availableStatus) {
        if (availableStatus == null) {
            availableStatus = AvailableStatus.UNCHECKED;
        }
        this.lastAvailableStatusChange = AvailableStatus.UNCHECKED.equals((Object)availableStatus) ? -1L : System.currentTimeMillis();
        if (this.availableStatus != availableStatus) {
            this.availableStatus = availableStatus;
            switch (availableStatus) {
                case FALSE: {
                    if (this.getFinalLinkState() != null) break;
                    this.setFinalLinkState(FinalLinkState.OFFLINE);
                    break;
                }
                case TRUE: {
                    if (!FinalLinkState.OFFLINE.equals((Object)this.getFinalLinkState())) break;
                    this.setFinalLinkState(null);
                    break;
                }
            }
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.AVAILABILITY, (Object)availableStatus));
            }
        }
    }

    protected void setAvailableStatusUnsafe(AvailableStatus availableStatus) {
        this.availableStatus = availableStatus == null ? AvailableStatus.UNCHECKED : availableStatus;
    }

    public long getLastAvailableStatusChange() {
        return this.lastAvailableStatusChange;
    }

    public void notifyChanges(AbstractNodeNotifier.NOTIFY notify, Object param) {
        AbstractNodeNotifier pl = this.getNodeChangeListener();
        if (pl != null) {
            pl.nodeUpdated(this, notify, param);
            return;
        }
        FilePackage pl2 = this.filePackage;
        if (pl2 != null) {
            pl2.nodeUpdated(this, notify, param);
            return;
        }
    }

    public boolean hasNotificationListener() {
        AbstractNodeNotifier pl = this.getNodeChangeListener();
        FilePackage pl2 = this.filePackage;
        return pl != null && pl.hasNotificationListener() || pl2 != null && pl2.hasNotificationListener();
    }

    public void reset(List<PluginForHost> resetPlugins) {
        this.clearHistory();
        this.setInternalTmpFilenameAppend(null);
        this.setInternalTmpFilename(null);
        this.setFinalFileName(null);
        this.setFinalLinkState(null);
        long size = this.getView().getBytesTotal();
        this.setVerifiedFileSize(-1L);
        if (size >= 0L) {
            this.setDownloadSize(size);
        }
        this.setChunksProgress(null);
        this.setChunks(0);
        this.setCustomSpeedLimit(0);
        this.setDownloadCurrent(0L);
        this.setFinishedDate(-1L);
        this.addDownloadTime(-1L);
        this.setAvailableStatus(AvailableStatus.UNCHECKED);
        this.setSkipReason(null);
        this.setConditionalSkipReason(null);
        this.setEnabled(true);
        this.setLinkInfo(null);
        this.setExtractionStatus(null);
        if (resetPlugins != null) {
            for (PluginForHost resetPlugin : resetPlugins) {
                try {
                    resetPlugin.resetLink(this);
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                }
            }
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.RESET, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory() {
        Object object = NULL;
        synchronized (object) {
            if (this.history != null) {
                this.history.clear();
            }
        }
    }

    public void resume(List<PluginForHost> resetPlugins) {
        this.setAvailableStatus(AvailableStatus.UNCHECKED);
        this.setSkipReason(null);
        this.setConditionalSkipReason(null);
        this.setEnabled(true);
        if (resetPlugins != null) {
            for (PluginForHost resetPlugin : resetPlugins) {
                try {
                    resetPlugin.resumeDownloadlink(this);
                }
                catch (Throwable e) {
                    LogController.CL().log(e);
                }
            }
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.RESUME, null));
        }
    }

    public void setAvailable(boolean available) {
        this.setAvailableStatus(available ? AvailableStatus.TRUE : AvailableStatus.FALSE);
    }

    @Deprecated
    public void setChunksProgress(long[] is) {
        this.chunksProgress = is;
    }

    public void setDownloadCurrent(long downloadedCurrent) {
        if (this.getDownloadCurrentRaw() == downloadedCurrent) {
            return;
        }
        this.downloadCurrent = downloadedCurrent;
        if (this.hasNotificationListener() && this.getCurrentDownloadInterface() == null) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, null);
        }
    }

    private DownloadInterface getCurrentDownloadInterface() {
        SingleDownloadController dlc = this.getDownloadLinkController();
        DownloadInterface dli = null;
        if (dlc != null && (dli = dlc.getDownloadInstance()) != null) {
            return dli;
        }
        return null;
    }

    public void setDownloadLinkController(SingleDownloadController downloadLinkController) {
        SingleDownloadController old = this.downloadLinkController;
        this.downloadLinkController = downloadLinkController;
        if (old != null && old != downloadLinkController) {
            old.onDetach(this);
        }
        if (old != downloadLinkController && downloadLinkController != null) {
            downloadLinkController.onAttach(this);
        }
        if (old != downloadLinkController) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.DOWNLOAD_CONTROLLER, downloadLinkController));
        }
    }

    public void setDownloadSize(long downloadMax) {
        if (this.downloadMax == downloadMax) {
            return;
        }
        this.downloadMax = Math.max(-1L, downloadMax);
        if (this.hasNotificationListener() && this.getCurrentDownloadInterface() == null) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.DOWNLOADSIZE, downloadMax));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean isEnabled) {
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            if (this.isEnabled == isEnabled) {
                return;
            }
            this.isEnabled = isEnabled;
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.ENABLED, isEnabled));
        }
    }

    public boolean isSkipped() {
        return this.skipReason != null;
    }

    public String getCustomMessage(SkipReason skipReason) {
        HistoryEntry entry = this.getLatestHistoryEntry();
        if (entry != null) {
            return entry.getCustomMessage(skipReason);
        }
        return null;
    }

    public String getCustomMessage(FinalLinkState finalLinkState) {
        HistoryEntry entry = this.getLatestHistoryEntry();
        if (entry != null) {
            return entry.getCustomMessage(finalLinkState);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SkipReason setSkipReason(SkipReason skipReason) {
        SkipReason old;
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            old = this.skipReason;
            this.skipReason = skipReason;
        }
        if (old != skipReason && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.SKIPPED, (Object)skipReason));
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinalLinkState setFinalLinkState(FinalLinkState finalLinkState) {
        FinalLinkState old;
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            old = this.finalLinkState;
            this.finalLinkState = finalLinkState;
        }
        if (old == finalLinkState) {
            return old;
        }
        if (FinalLinkState.CheckFinished(finalLinkState)) {
            this.setResumeable(false);
            this.setChunksProgress(null);
        }
        if (finalLinkState == null || !FinalLinkState.CheckFinished(finalLinkState)) {
            this.setFinishedDate(-1L);
        }
        if (finalLinkState == FinalLinkState.OFFLINE) {
            this.setAvailable(false);
        }
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && finalLinkState != null && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isHashRetryEnabled() && finalLinkState.isFailedHash()) {
            List<DownloadLink> link = Arrays.asList(this);
            DownloadWatchDog.getInstance().reset(link);
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.FINAL_STATE, (Object)finalLinkState));
        }
        return old;
    }

    protected void setFinalLinkStateUnsafe(FinalLinkState finalLinkState) {
        if (FinalLinkState.CheckFinished(finalLinkState)) {
            this.setChunksProgress(null);
        }
        this.finalLinkState = finalLinkState;
    }

    public FinalLinkState getFinalLinkState() {
        return this.finalLinkState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalSkipReason setConditionalSkipReason(ConditionalSkipReason conditionalSkipReason) {
        ConditionalSkipReason old;
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            old = this.conditionalSkipReason;
            this.conditionalSkipReason = conditionalSkipReason;
        }
        if (old != conditionalSkipReason && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.CONDITIONAL_SKIPPED, conditionalSkipReason));
        }
        return old;
    }

    public ConditionalSkipReason getConditionalSkipReason() {
        return this.conditionalSkipReason;
    }

    public SkipReason getSkipReason() {
        return this.skipReason;
    }

    public void setUrlProtection(UrlProtection type) {
        if (type == null) {
            type = UrlProtection.UNSET;
        }
        if (type == this.getUrlProtection()) {
            return;
        }
        this.urlProtection = type;
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.URL_PROTECTION, (Object)type));
        }
    }

    public void setDefaultPlugin(PluginForHost plugin) {
        LazyHostPlugin lazy;
        if (plugin != null && (lazy = plugin.getLazyP()) != null && !lazy.isPrototype(plugin)) {
            try {
                plugin = lazy.getPrototype(null);
            }
            catch (UpdateRequiredClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.defaultplugin = plugin;
    }

    public void setLivePlugin(PluginForHost plugin) {
        PluginForHost oldLivePlugin = this.getLivePlugin();
        this.liveplugin = plugin;
        if (plugin != null) {
            plugin.setDownloadLink(this);
        }
        if (oldLivePlugin != null && oldLivePlugin != plugin) {
            oldLivePlugin.setDownloadLink(null);
        }
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = Plugin.extractFileNameFromURL(this.getContentUrlOrPatternMatcher());
        }
        if (!StringUtils.isEmpty((String)name)) {
            name = this.fixFilename(name);
        }
        if (StringUtils.isEmpty((String)name)) {
            name = UNKNOWN_FILE_NAME;
        }
        this.name = name;
        this.cachedName = null;
        String newName = this.getName();
        if (!StringUtils.equals((String)oldName, (String)newName)) {
            this.setLinkInfo(null);
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.NAME, newName));
            }
        }
    }

    protected void setNameUnsafe(String name) {
        this.name = name == null ? name : this.dedupeValueString(DownloadLinkProperty.Property.NAME.name(), name);
    }

    public void forceForcedFileName(String newForced) {
        String oldForced = this.getStringProperty(PROPERTY_FORCEDFILENAME);
        if (!StringUtils.equals((String)StringUtils.nullOrNonEmpty((String)newForced), (String)StringUtils.nullOrNonEmpty((String)oldForced))) {
            String oldName;
            if (StringUtils.isEmpty((String)newForced)) {
                oldName = this.getName();
                this.removeProperty(PROPERTY_FORCEDFILENAME);
            } else {
                oldName = this.getName(false, true);
                newForced = this.fixFilename(newForced);
                this.setProperty(PROPERTY_FORCEDFILENAME, newForced);
            }
            this.cachedName = null;
            String newName = this.getName();
            if (!StringUtils.equals((String)oldName, (String)newName)) {
                this.setLinkInfo(null);
                if (this.hasNotificationListener()) {
                    this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.NAME, newName));
                }
            }
        }
    }

    public void setForcedFileName(String name) {
        String curForced = this.getStringProperty(PROPERTY_FORCEDFILENAME);
        if (StringUtils.equals((String)name, (String)curForced)) {
            return;
        }
        String oldName = this.getName(false, true);
        if (StringUtils.isEmpty((String)name)) {
            this.removeProperty(PROPERTY_FORCEDFILENAME);
            oldName = this.getName();
        } else if (StringUtils.equals((String)oldName, (String)name)) {
            if (curForced == null) {
                return;
            }
            this.removeProperty(PROPERTY_FORCEDFILENAME);
            oldName = this.getName();
        } else {
            name = this.fixFilename(name);
            this.setProperty(PROPERTY_FORCEDFILENAME, name);
        }
        this.cachedName = null;
        String newName = this.getName();
        if (!StringUtils.equals((String)oldName, (String)newName)) {
            this.setLinkInfo(null);
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.NAME, newName));
            }
        }
    }

    public void setComment(String comment) {
        boolean changed = comment == null || comment.length() == 0 ? this.removeProperty(PROPERTY_COMMENT) : this.setProperty(PROPERTY_COMMENT, comment);
        if (changed && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.COMMENT, comment));
        }
    }

    public DownloadLink setSourcePluginPasswordList(List<String> sourcePluginPassword) {
        if (sourcePluginPassword == null || sourcePluginPassword.size() == 0) {
            this.removeProperty(PROPERTY_PWLIST);
        } else {
            this.setProperty(PROPERTY_PWLIST, sourcePluginPassword);
        }
        return this;
    }

    @Deprecated
    public DownloadLink setSourcePluginPasswordList(ArrayList<String> sourcePluginPassword) {
        return this.setSourcePluginPasswordList((List<String>)sourcePluginPassword);
    }

    public void setFinalFileName(String newfinalFileName) {
        String oldName = this.getName();
        if (!StringUtils.isEmpty((String)newfinalFileName)) {
            newfinalFileName = this.fixFilename(newfinalFileName);
            this.setProperty(PROPERTY_FINALFILENAME, newfinalFileName);
            this.cachedName = null;
            this.setName(newfinalFileName);
        } else {
            this.removeProperty(PROPERTY_FINALFILENAME);
        }
        this.cachedName = null;
        String newName = this.getName();
        if (!StringUtils.equals((String)oldName, (String)newName)) {
            this.setLinkInfo(null);
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.NAME, newName));
            }
        }
    }

    protected String fixFilename(String filename) {
        return LinknameCleaner.cleanFilename(filename);
    }

    @Deprecated
    public void setUrlDownload(String urlDownload) {
        this.setPluginPatternMatcher(urlDownload);
    }

    public void setPluginPatternMatcher(String pluginPattern) {
        String previousURLDownload = this.getPluginPatternMatcher();
        String previousLinkID = this.getLinkID();
        if (pluginPattern != null) {
            if (previousURLDownload != null && previousURLDownload.equals(pluginPattern)) {
                return;
            }
            this.urlDownload = pluginPattern;
        } else {
            this.urlDownload = null;
        }
        this.cachedName = null;
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.URL_CONTENT, pluginPattern));
        }
        if (previousLinkID == null && previousURLDownload != null && !previousURLDownload.equals(pluginPattern)) {
            this.setLinkID(previousURLDownload);
        }
    }

    protected void setPluginPatternMatcherUnsafe(String pluginPattern) {
        this.urlDownload = pluginPattern;
    }

    @Override
    public String toString() {
        UniqueAlltimeID lPreviousParentNodeID = this.getPreviousParentNodeID();
        String host = this.getHost();
        if (host == null) {
            host = "";
        }
        if (lPreviousParentNodeID == null) {
            return this.getName().concat("@").concat(host);
        }
        if (lPreviousParentNodeID.equals((Object)this.getParentNode().getUniqueID())) {
            return this.getName().concat("@").concat(host);
        }
        return this.getName().concat("@").concat(host).concat(" previousParentNode:").concat(lPreviousParentNodeID.toString());
    }

    public long getKnownDownloadSize() {
        long ret = this.getVerifiedFileSize();
        if (ret >= 0L) {
            return ret;
        }
        return this.downloadMax;
    }

    public String getDownloadPassword() {
        return this.getStringProperty(PROPERTY_PASS, null);
    }

    public void setDownloadPassword(String pass) {
        this.setDownloadPassword(pass, null);
    }

    public void setDownloadPassword(String pass, Boolean isPasswordProtected) {
        String oldPassword = this.getDownloadPassword();
        if (StringUtils.equals((String)pass, (String)oldPassword) || StringUtils.isEmpty((String)pass) && StringUtils.isEmpty((String)oldPassword)) {
            return;
        }
        if (StringUtils.isEmpty((String)pass)) {
            this.removeProperty(PROPERTY_PASS);
        } else {
            this.setProperty(PROPERTY_PASS, pass);
        }
        if (isPasswordProtected != null) {
            this.setPasswordProtected(isPasswordProtected);
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.DOWNLOAD_PASSWORD, pass));
        }
    }

    public boolean isPasswordProtected() {
        return this.getBooleanProperty(PROPERTY_PASSWORD_PROTECTED, false);
    }

    public void setPasswordProtected(boolean pwProtected) {
        if (pwProtected) {
            this.setProperty(PROPERTY_PASSWORD_PROTECTED, true);
        } else {
            this.removeProperty(PROPERTY_PASSWORD_PROTECTED);
        }
    }

    public void setMD5Hash(String md5) {
        this.setHashInfo(HashInfo.newInstanceSafe(md5, HashInfo.TYPE.MD5));
    }

    public HashInfo getHashInfo() {
        String hashInfo = this.getStringProperty(PROPERTY_HASHINFO, null);
        if (hashInfo != null) {
            return HashInfo.importFromString(hashInfo);
        }
        String sha1 = this.getStringProperty(PROPERTY_SHA1, null);
        if (sha1 != null) {
            return HashInfo.newInstanceSafe(sha1, HashInfo.TYPE.SHA1);
        }
        String sha256 = this.getStringProperty(PROPERTY_SHA256, null);
        if (sha256 != null) {
            return HashInfo.newInstanceSafe(sha256, HashInfo.TYPE.SHA256);
        }
        String md5 = this.getStringProperty(PROPERTY_MD5, null);
        if (md5 != null) {
            return HashInfo.newInstanceSafe(md5, HashInfo.TYPE.MD5);
        }
        return null;
    }

    public void addHashInfo(HashInfo hashInfo) {
        this.setHashInfo(hashInfo);
    }

    public void setHashInfo(HashInfo hashInfo) {
        HashInfo existingHash;
        boolean isForced;
        boolean bl = isForced = hashInfo != null && hashInfo.isForced();
        if (!isForced && (existingHash = this.getHashInfo()) != null && existingHash.isForced()) {
            return;
        }
        boolean changed = hashInfo == null || hashInfo.isNone() ? this.removeProperty(PROPERTY_HASHINFO) : this.setProperty(PROPERTY_HASHINFO, hashInfo.exportAsString());
        if (changed && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.HASHINFO, hashInfo));
        }
    }

    public void firePropertyChanged(DownloadLinkProperty.Property property, Object param) {
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, property, param));
        }
    }

    @Deprecated
    public String getMD5Hash() {
        HashInfo hashInfo = this.getHashInfo();
        if (hashInfo != null && HashInfo.TYPE.MD5.equals((Object)hashInfo.getType())) {
            return hashInfo.getHash();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginProgress(PluginProgress progress) {
        if (progress == null) {
            return;
        }
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            List<PluginProgress> lPluginProgress = this.pluginProgress;
            if (lPluginProgress == null) {
                lPluginProgress = new CopyOnWriteArrayList<PluginProgress>();
            }
            if (!lPluginProgress.contains(progress)) {
                lPluginProgress.add(0, progress);
            } else if (lPluginProgress.get(0) != progress) {
                lPluginProgress.add(0, progress);
                int index = lPluginProgress.lastIndexOf(progress);
                lPluginProgress.remove(index);
            } else {
                return;
            }
            this.pluginProgress = lPluginProgress;
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.PLUGIN_PROGRESS, progress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePluginProgress(PluginProgress remove) {
        PluginProgress latest;
        if (remove == null) {
            return false;
        }
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            List<PluginProgress> lPluginProgress = this.pluginProgress;
            if (lPluginProgress == null || !lPluginProgress.remove(remove)) {
                return false;
            }
            if (lPluginProgress.size() == 0) {
                latest = null;
                this.pluginProgress = null;
            } else {
                latest = lPluginProgress.get(0);
            }
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.PLUGIN_PROGRESS, latest));
        }
        return true;
    }

    public PluginProgress getPluginProgress() {
        List<PluginProgress> lPluginProgress = this.pluginProgress;
        if (lPluginProgress != null) {
            try {
                return lPluginProgress.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean hasPluginProgress(PluginProgress contains) {
        List<PluginProgress> lPluginProgress = this.pluginProgress;
        return lPluginProgress != null && lPluginProgress.contains(contains);
    }

    public void setSha1Hash(String sha1) {
        this.setHashInfo(HashInfo.newInstanceSafe(sha1, HashInfo.TYPE.SHA1));
    }

    public static String[] getDefaultDoNotChangeExistingKeys() {
        return (String[])DEFAULT_DO_NOT_CHANGE_EXISTING_KEYS.clone();
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.setProperties(properties, null);
    }

    public void setProperties(Map<String, Object> properties, String ... doNotChangeExistingKeys) {
        if (doNotChangeExistingKeys == null) {
            doNotChangeExistingKeys = DEFAULT_DO_NOT_CHANGE_EXISTING_KEYS;
        }
        if (doNotChangeExistingKeys == null || doNotChangeExistingKeys.length == 0 || this.getPropertiesSize() == 0) {
            super.setProperties(properties);
        } else {
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            for (String doNotChangeExistingKey : doNotChangeExistingKeys) {
                Object value = this.getProperty(doNotChangeExistingKey);
                if (value == null) continue;
                newProperties.put(doNotChangeExistingKey, value);
            }
            if (newProperties.size() == 0) {
                super.setProperties(properties);
            } else {
                for (Map.Entry entry : properties.entrySet()) {
                    if (newProperties.containsKey(entry.getKey())) continue;
                    newProperties.put((String)entry.getKey(), entry.getValue());
                }
                super.setProperties(newProperties);
            }
        }
    }

    public void setSha256Hash(String sha256) {
        this.setHashInfo(HashInfo.newInstanceSafe(sha256, HashInfo.TYPE.SHA256));
    }

    public void setMirrorID(long mirrorID) {
        if (mirrorID <= 0L) {
            this.removeProperty(PROPERTY_MIRRORID);
        } else {
            this.setProperty(PROPERTY_MIRRORID, mirrorID);
        }
    }

    public long getMirrorID() {
        return this.getLongProperty(PROPERTY_MIRRORID, -1L);
    }

    @Deprecated
    public String getSha1Hash() {
        HashInfo hashInfo = this.getHashInfo();
        if (hashInfo != null && HashInfo.TYPE.SHA1.equals((Object)hashInfo.getType())) {
            return hashInfo.getHash();
        }
        return null;
    }

    public void setMimeHint(CompiledFiletypeFilter.ExtensionsFilterInterface extensionFilter) {
        if (extensionFilter == null) {
            this.removeProperty(PROPERTY_MIME_HINT);
        } else {
            this.setProperty(PROPERTY_MIME_HINT, extensionFilter.name());
        }
    }

    @Override
    protected String dedupeValueString(String key, String value) {
        if (value == null) {
            return null;
        }
        if ("fixName".equals(key) || PROPERTY_FORCEDFILENAME.equals(key) || PROPERTY_FINALFILENAME.equals(key) || DownloadLinkProperty.Property.NAME.name().equals(key)) {
            String name = this.name;
            if (name != null && name.equals(value)) {
                return name;
            }
            name = this.getStringProperty(PROPERTY_FINALFILENAME, null);
            if (name != null && name.equals(value)) {
                return name;
            }
            name = this.getStringProperty(PROPERTY_FORCEDFILENAME, null);
            if (name != null && name.equals(value)) {
                return name;
            }
            name = this.getStringProperty("fixName", null);
            if (name != null && name.equals(value)) {
                return name;
            }
            return value;
        }
        if (PROPERTY_HASHINFO.equals(key) || PROPERTY_SHA1.equals(key) || PROPERTY_SHA256.equals(key) || PROPERTY_MD5.equals(key)) {
            return value;
        }
        if (PROPERTY_COMMENT.equals(key)) {
            return value;
        }
        if ("fid".equals(key) || PROPERTY_LINKDUPEID.equals(key) || "ORG_LINKID".equals(key)) {
            return value;
        }
        return super.dedupeValueString(key, value);
    }

    public String getMimeHint() {
        return this.getStringProperty(PROPERTY_MIME_HINT, null);
    }

    @Deprecated
    public String getSha256Hash() {
        HashInfo hashInfo = this.getHashInfo();
        if (hashInfo != null && HashInfo.TYPE.SHA256.equals((Object)hashInfo.getType())) {
            return hashInfo.getHash();
        }
        return null;
    }

    public void setLastModifiedTimestamp(long timestamp) {
        this.setProperty(PROPERTY_LAST_MODIFIED, timestamp);
    }

    public long getLastModifiedTimestamp() {
        return this.getLongProperty(PROPERTY_LAST_MODIFIED, -1L);
    }

    public void setVerifiedFileSize(long size) {
        if (size == this.getVerifiedFileSize()) {
            return;
        }
        this.setDownloadSize(size);
        boolean changed = size < 0L ? this.removeProperty(PROPERTY_VERIFIEDFILESIZE) : this.setProperty(PROPERTY_VERIFIEDFILESIZE, size);
        if (changed && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.DOWNLOADSIZE_VERIFIED, size));
        }
    }

    public long getVerifiedFileSize() {
        return this.getLongProperty(PROPERTY_VERIFIEDFILESIZE, -1L);
    }

    public void setResumeable(boolean b) {
        if (b == this.isResumeable()) {
            return;
        }
        this.setProperty(PROPERTY_RESUMEABLE, b);
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.RESUMABLE, b));
        }
    }

    public boolean isResumeable() {
        SingleDownloadController controller = this.getDownloadLinkController();
        if (controller != null) {
            DownloadLinkCandidate candidate = controller.getDownloadLinkCandidate();
            return candidate.getCachedAccount().getPlugin().isResumeable(this, candidate.getCachedAccount().getAccount());
        }
        PluginForHost plugin = this.getDefaultPlugin();
        if (plugin != null) {
            return plugin.isResumeable(this, null);
        }
        return false;
    }

    @Override
    public DomainInfo getDomainInfo() {
        DomainInfo domainInfo = this.domainInfo;
        if (domainInfo == null) {
            PluginForHost defaultPlugin = this.getDefaultPlugin();
            if (defaultPlugin != null) {
                domainInfo = defaultPlugin.getDomainInfo(this);
            }
            if (domainInfo == null) {
                domainInfo = DomainInfo.getInstance(this.getServiceHost(true));
            }
            this.domainInfo = domainInfo;
        }
        return domainInfo;
    }

    public void setDomainInfo(DomainInfo domainInfo) {
        this.domainInfo = domainInfo;
    }

    public String getServiceHost(boolean includeSubdomain) {
        String ret;
        PluginForHost defaultPlugin = this.getDefaultPlugin();
        if (defaultPlugin != null && (ret = defaultPlugin.getHost(this, null, includeSubdomain)) != null) {
            return ret;
        }
        return this.getHost();
    }

    @Override
    public FilePackage getParentNode() {
        return this.getFilePackage();
    }

    public synchronized void _setFilePackage(FilePackage filePackage) {
        if (filePackage == this.filePackage) {
            this.previousParent = null;
            return;
        }
        if (FilePackage.isDefaultFilePackage(filePackage)) {
            filePackage = null;
        }
        if (this.filePackage != null && filePackage != null) {
            this.filePackage.remove(this);
        }
        if (this.filePackage != null) {
            this.previousParent = this.filePackage.getUniqueID();
        }
        if (filePackage != null) {
            this.lastValidFilePackage = filePackage;
        }
        this.filePackage = filePackage;
    }

    @Override
    public UniqueAlltimeID getPreviousParentNodeID() {
        return this.previousParent;
    }

    @Override
    public void setParentNode(FilePackage parent) {
        this._setFilePackage(parent);
    }

    @Override
    public DownloadLink getDownloadLink() {
        return this;
    }

    public void setNodeChangeListener(AbstractNodeNotifier propertyListener) {
        this.propertyListener = propertyListener;
    }

    public AbstractNodeNotifier getNodeChangeListener() {
        return this.propertyListener;
    }

    public void setPriorityEnum(Priority priority) {
        if (priority == null) {
            priority = Priority.DEFAULT;
        }
        if (this.getPriorityEnum() != priority) {
            if (Priority.DEFAULT.equals((Object)priority)) {
                this.removeProperty(PROPERTY_PRIORITY);
            } else {
                this.setProperty(PROPERTY_PRIORITY, priority.name());
            }
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.PRIORITY, (Object)priority));
            }
        }
    }

    public String getArchiveID() {
        return this.getStringProperty(PROPERTY_ARCHIVE_ID);
    }

    public void setArchiveID(String id) {
        if (!StringUtils.equals((String)id, (String)this.getArchiveID())) {
            if (!StringUtils.isEmpty((String)id)) {
                this.setProperty(PROPERTY_ARCHIVE_ID, id);
                this.setPartOfAnArchive(Boolean.TRUE);
            } else {
                this.removeProperty(PROPERTY_ARCHIVE_ID);
                this.setPartOfAnArchive(null);
            }
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.ARCHIVE_ID, id));
            }
        } else if (StringUtils.isNotEmpty((String)id)) {
            this.setPartOfAnArchive(Boolean.TRUE);
        } else {
            this.setPartOfAnArchive(null);
        }
    }

    public ExtractionStatus getExtractionStatus() {
        ExtractionStatus lExtractionStatus = this.extractionStatus;
        if (lExtractionStatus != null) {
            if (ExtractionStatus.NA.equals((Object)lExtractionStatus)) {
                return null;
            }
            return lExtractionStatus;
        }
        String string = this.getStringProperty(PROPERTY_EXTRACTION_STATUS, null);
        try {
            if (string != null) {
                lExtractionStatus = ExtractionStatus.valueOf((String)string);
                if (lExtractionStatus == null || ExtractionStatus.RUNNING.equals((Object)lExtractionStatus)) {
                    this.extractionStatus = ExtractionStatus.NA;
                    return null;
                }
                this.extractionStatus = lExtractionStatus;
                if (ExtractionStatus.NA.equals((Object)lExtractionStatus)) {
                    return null;
                }
                return lExtractionStatus;
            }
            this.extractionStatus = ExtractionStatus.NA;
            return null;
        }
        catch (Exception e) {
            this.extractionStatus = ExtractionStatus.NA;
            return null;
        }
    }

    public void setExtractionStatus(ExtractionStatus newExtractionStatus) {
        if (this.extractionStatus != newExtractionStatus) {
            this.extractionStatus = newExtractionStatus;
            if (newExtractionStatus == null || ExtractionStatus.NA.equals((Object)newExtractionStatus)) {
                newExtractionStatus = null;
                this.removeProperty(PROPERTY_EXTRACTION_STATUS);
            } else {
                this.setProperty(PROPERTY_EXTRACTION_STATUS, newExtractionStatus.name());
            }
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.EXTRACTION_STATUS, newExtractionStatus));
            }
            return;
        }
    }

    public void setVariantSupport(boolean b) {
        if (b == this.hasVariantSupport()) {
            return;
        }
        if (b) {
            this.setProperty(VARIANT_SUPPORT, b);
        } else {
            this.removeProperty(VARIANT_SUPPORT);
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.VARIANTS_ENABLED, b));
        }
    }

    public void setGenericVariantSupport(boolean b) {
    }

    public boolean hasGenericVariantSupport() {
        return this.getBooleanProperty("GENERIC_VARIANTS", false);
    }

    @Override
    public boolean hasVariantSupport() {
        return this.getBooleanProperty(VARIANT_SUPPORT, false);
    }

    public static <T extends DownloadLinkDatabindingInterface> T bindData(final Property property, final String ID2, final Class<T> clazz) {
        DownloadLinkDatabindingInterface ret = (DownloadLinkDatabindingInterface)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public String getKey(Method method) {
                DownloadLinkDatabindingInterface.Key keyAnnotation = method.getAnnotation(DownloadLinkDatabindingInterface.Key.class);
                String key = null;
                if (keyAnnotation != null) {
                    key = keyAnnotation.value();
                }
                if (key == null) {
                    if (method.getName().startsWith("set")) {
                        key = method.getName().substring(3).replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase(Locale.ENGLISH);
                    } else if (method.getName().startsWith("is")) {
                        key = method.getName().substring(2).replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase(Locale.ENGLISH);
                    } else if (method.getName().startsWith("get")) {
                        key = method.getName().substring(3).replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase(Locale.ENGLISH);
                    } else {
                        return null;
                    }
                }
                if (ID2 != null) {
                    return ID2 + key;
                }
                return key;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object arg;
                if (method.getName().equals("reset")) {
                    if (!Clazz.isVoid(method.getReturnType())) {
                        throw new WTFException("reset must have void as return type.");
                    }
                    HashSet<String> reset = new HashSet<String>();
                    for (Method resetMethod : clazz.getDeclaredMethods()) {
                        String key = this.getKey(resetMethod);
                        if (key == null || !reset.add(key)) continue;
                        property.removeProperty(key);
                    }
                    return null;
                }
                String key = this.getKey(method);
                if (key == null) {
                    throw new WTFException("Only Setter and getter are allowed");
                }
                if (method.getName().startsWith("set")) {
                    if (method.getParameterTypes().length != 1) {
                        throw new WTFException("Setter " + method + " should have 1 parameter. instead: " + Arrays.toString(method.getParameterTypes()));
                    }
                    if (!Clazz.isVoid(method.getReturnType())) {
                        throw new WTFException("Setter " + method + " must not have any return type. Has: " + method.getReturnType());
                    }
                    Class<?> param = method.getParameterTypes()[0];
                    arg = args[0];
                    if (Clazz.isPrimitiveWrapper(param) && arg == null) {
                        property.removeProperty(key);
                        return null;
                    }
                    if (Clazz.isEnum(param)) {
                        if (arg == null) {
                            property.removeProperty(key);
                        } else {
                            property.setProperty(key, ((Enum)arg).name());
                        }
                        return null;
                    }
                } else {
                    Type returnType = method.getGenericReturnType();
                    if (method.getParameterTypes().length != 0) {
                        throw new WTFException("Getter " + method + " must not have any parameter. instead: " + Arrays.toString(method.getParameterTypes()));
                    }
                    if (Clazz.isVoid(method.getReturnType())) {
                        throw new WTFException("Getter " + method + " must have a return type. is Void.");
                    }
                    Object value = property.getProperty(key);
                    if (Clazz.isBoolean((Type)returnType)) {
                        if (value == null) {
                            if (Clazz.isPrimitiveWrapper((Type)returnType)) {
                                return null;
                            }
                            return false;
                        }
                        if (value instanceof Boolean) {
                            return value;
                        }
                    } else if (Clazz.isByte((Type)returnType)) {
                        if (value == null) {
                            if (Clazz.isPrimitiveWrapper((Type)returnType)) {
                                return null;
                            }
                            return (byte)0;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).byteValue();
                        }
                    } else if (Clazz.isDouble((Type)returnType)) {
                        if (value == null) {
                            if (Clazz.isPrimitiveWrapper((Type)returnType)) {
                                return null;
                            }
                            return 0.0;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).doubleValue();
                        }
                    } else if (Clazz.isEnum((Type)returnType)) {
                        if (value == null) {
                            return null;
                        }
                        if (value instanceof Enum) {
                            return value;
                        }
                        if (value instanceof String) {
                            return Enum.valueOf(((Enum)((Object)returnType)).getDeclaringClass(), (String)value);
                        }
                    } else if (Clazz.isFloat((Type)returnType)) {
                        if (value == null) {
                            if (Clazz.isPrimitiveWrapper((Type)returnType)) {
                                return null;
                            }
                            return Float.valueOf(0.0f);
                        }
                        if (value instanceof Number) {
                            return Float.valueOf(((Number)value).floatValue());
                        }
                    } else if (Clazz.isInteger((Type)returnType)) {
                        if (value == null) {
                            if (Clazz.isPrimitiveWrapper((Type)returnType)) {
                                return null;
                            }
                            return 0;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).intValue();
                        }
                    } else if (Clazz.isLong((Type)returnType)) {
                        if (value == null) {
                            if (Clazz.isPrimitiveWrapper((Type)returnType)) {
                                return null;
                            }
                            return 0L;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).longValue();
                        }
                    } else if (Clazz.isShort((Type)returnType)) {
                        if (value == null) {
                            if (Clazz.isPrimitiveWrapper((Type)returnType)) {
                                return null;
                            }
                            return (short)0;
                        }
                        if (value instanceof Number) {
                            return ((Number)value).shortValue();
                        }
                    } else if (Clazz.isString((Type)returnType)) {
                        if (value == null) {
                            return null;
                        }
                        if (value instanceof String) {
                            return value;
                        }
                    } else {
                        return value;
                    }
                    throw new WTFException("Cannot restore " + returnType + " from " + value);
                }
                property.setProperty(key, arg);
                return null;
            }
        });
        return (T)ret;
    }

    public <T extends DownloadLinkDatabindingInterface> T bindData(Class<T> clazz) {
        return DownloadLink.bindData(this, null, clazz);
    }

    public void firePropertyChange(DownloadLinkProperty downloadLinkProperty) {
        this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, downloadLinkProperty);
    }

    public void setVariants(List<? extends LinkVariant> list) {
        String variantsString = JSonStorage.serializeToJson(list);
        if (!StringUtils.equals((String)variantsString, (String)this.getStringProperty("VARIANTS"))) {
            this.setProperty("VARIANTS", variantsString);
            this.getTempProperties().removeProperty("VARIANTS");
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.VARIANTS, list));
            }
        }
    }

    public void setVariant(LinkVariant variant) {
        if (!StringUtils.equals((String)this.getStringProperty("VARIANT"), (String)variant._getUniqueId())) {
            PluginForHost plugin;
            this.setProperty("VARIANT", variant._getUniqueId());
            this.setVariantSupport(true);
            LinkVariant existingVariant = (LinkVariant)this.getTempProperties().getProperty("VARIANT");
            if (existingVariant != null && !variant._getUniqueId().equals(existingVariant._getUniqueId())) {
                this.getTempProperties().setProperty("VARIANT", null);
            }
            if ((plugin = this.getDefaultPlugin()) != null) {
                plugin.setLinkID(this, variant);
            } else {
                boolean isOriginal = variant == null || GenericVariants.ORIGINAL.equals(variant);
                String orgLinkID = this.getStringProperty("ORG_LINKID");
                if (isOriginal) {
                    if (orgLinkID != null) {
                        this.setLinkID(orgLinkID);
                    }
                } else if (orgLinkID == null) {
                    String linkID = this.getLinkID();
                    this.setProperty("ORG_LINKID", linkID);
                    this.setLinkID(linkID + "_" + variant._getUniqueId());
                } else {
                    this.setLinkID(orgLinkID + "_" + variant._getUniqueId());
                }
            }
            if (this.hasNotificationListener()) {
                this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.VARIANT, variant));
            }
        }
    }

    public <T extends LinkVariant> T getVariant(Class<T> type) {
        if (this.getBooleanProperty("GENERIC_VARIANTS", false).booleanValue() && !GenericVariants.class.equals(type)) {
            return null;
        }
        try {
            Object variant = this.getTempProperties().getProperty("VARIANT");
            if (variant != null && type.isAssignableFrom(variant.getClass())) {
                return (T)((LinkVariant)variant);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String variantID = this.getStringProperty("VARIANT");
        if (variantID != null) {
            try {
                List<T> variants = this.getVariants(type);
                if (variants != null) {
                    for (LinkVariant variant : variants) {
                        if (!variant._getUniqueId().equals(variantID) || !type.isAssignableFrom(variant.getClass())) continue;
                        this.getTempProperties().setProperty("VARIANT", variant);
                        return (T)variant;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Deprecated
    public boolean isGenericVariantSupport() {
        return this.hasGenericVariantSupport();
    }

    public <T extends LinkVariant> List<T> getVariants(final Class<T> type) {
        if (this.hasGenericVariantSupport() && !GenericVariants.class.equals(type)) {
            return null;
        }
        try {
            LinkVariant castTest;
            List variants = (List)this.getTempProperties().getProperty("VARIANTS");
            if (variants != null && variants.size() > 0 && type.isAssignableFrom((castTest = (LinkVariant)variants.get(0)).getClass())) {
                return variants;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String variantsID = this.getStringProperty("VARIANTS");
        if (variantsID != null) {
            try {
                ArrayList<LinkVariant> ret = new ArrayList<LinkVariant>();
                TypeRef tref = new TypeRef<ArrayList<T>>(){};
                ParameterizedType t = (ParameterizedType)tref.getType();
                ArrayList basic = (ArrayList)JSonStorage.restoreFromString((String)variantsID, (TypeRef)new TypeRef<ArrayList<Object>>(){});
                for (Object o : basic) {
                    LinkVariant restored = (LinkVariant)JSonStorage.convert(o, (TypeRef)new TypeRef<T>(){

                        public Type getType() {
                            return type;
                        }
                    });
                    ret.add(restored);
                }
                this.getTempProperties().setProperty("VARIANTS", ret);
                return ret;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setCustomExtension(String extension) {
        String old = this.getCustomExtension();
        this.setProperty("EXTENSION", extension);
        this.cachedName = null;
        if (!StringUtils.equals((String)old, (String)extension) && this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.NAME, extension));
        }
    }

    public String getCustomExtension() {
        return this.getStringProperty("EXTENSION");
    }

    public String getContentUrlOrPatternMatcher() {
        String ret = this.getContentUrl();
        if (StringUtils.isNotEmpty((String)ret)) {
            return ret;
        }
        return this.getPluginPatternMatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryEntry(HistoryEntry entry) {
        if (entry == null) {
            return;
        }
        int maxEntries = CFG_GENERAL.CFG.getMaxDownloadLinkHistoryEntries();
        if (maxEntries <= 0) {
            return;
        }
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            if (this.history == null) {
                this.history = new ArrayList<HistoryEntry>();
            }
            while (this.history.size() > maxEntries) {
                this.history.remove(0);
            }
            this.history.add(entry);
        }
        if (this.hasNotificationListener()) {
            this.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(this, DownloadLinkProperty.Property.HISTORY, entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HistoryEntry> getHistory() {
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            if (this.history != null) {
                return new ArrayList<HistoryEntry>(this.history);
            }
            return new ArrayList<HistoryEntry>(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryEntry getLatestHistoryEntry() {
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            if (this.history == null || this.history.size() == 0) {
                return null;
            }
            return this.history.get(this.history.size() - 1);
        }
    }

    public static enum AvailableStatus {
        UNCHECKED(_GUI.T.linkgrabber_onlinestatus_unchecked()),
        FALSE(_GUI.T.linkgrabber_onlinestatus_offline()),
        UNCHECKABLE(_GUI.T.linkgrabber_onlinestatus_uncheckable()),
        TRUE(_GUI.T.linkgrabber_onlinestatus_online());

        private final String exp;

        private AvailableStatus(String exp) {
            this.exp = exp;
        }

        public String getExplanation() {
            return this.exp;
        }
    }
}

