/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.lang.reflect.Type;
import java.util.Map;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.crypt.JDCrypt;
import jd.plugins.DownloadLink;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.TypeRef;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.controlling.UrlProtection;
import org.jdownloader.plugins.FinalLinkState;

public class DownloadLinkStorable
implements Storable {
    private static final byte[] KEY = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final String CRYPTED = "CRYPTED:";
    public static final TypeRef<DownloadLinkStorable> TYPE_REF = new TypeRef<DownloadLinkStorable>(){

        public Type getType() {
            return DownloadLinkStorable.class;
        }
    };
    private DownloadLink link;

    public DownloadLink.AvailableStatus getAvailablestatus() {
        return this.link.getAvailableStatus();
    }

    public void setAvailablestatus(DownloadLink.AvailableStatus availablestatus) {
        if (availablestatus != null) {
            this.link.setAvailableStatus(availablestatus);
        }
    }

    @StorableAllowPrivateAccessModifier
    private DownloadLinkStorable() {
        this.link = new DownloadLink(null, null, null, null, false);
    }

    public DownloadLinkStorable(DownloadLink link) {
        this.link = link;
    }

    public long getUID() {
        return this.link.getUniqueID().getID();
    }

    public void setUID(long id) {
        if (id != -1L) {
            this.link.getUniqueID().setID(id);
        }
    }

    public String getName() {
        return this.link.getName();
    }

    public void setName(String name) {
        this.link.setNameUnsafe(name);
    }

    @AllowNonStorableObjects
    public Map<String, Object> getProperties() {
        if (this.crypt()) {
            return null;
        }
        Map<String, Object> ret = this.link.getProperties();
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public void setProperties(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.link.setProperties(props);
    }

    public void _finalizeDeserialization(DownloadLink downloadLink) {
    }

    @Deprecated
    @StorableDeprecatedSince(value="2022-10-18T00:00+0200")
    public Map<String, String> getLinkStatus() {
        return null;
    }

    public void setFinalLinkState(String state) {
        if (state != null) {
            try {
                this.link.setFinalLinkStateUnsafe(FinalLinkState.valueOf(state));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public String getFinalLinkState() {
        FinalLinkState state = this.link.getFinalLinkState();
        if (state != null) {
            return state.name();
        }
        return null;
    }

    public void setLinkStatus(Map<String, String> status) {
        if (status != null) {
            try {
                int linkStatus = Integer.parseInt(status.get("status"));
                if (linkStatus == 2 || this.hasStatus(linkStatus, 2)) {
                    this.link.setFinalLinkState(FinalLinkState.FINISHED);
                } else if (linkStatus == 32 || this.hasStatus(linkStatus, 32)) {
                    this.link.setFinalLinkState(FinalLinkState.OFFLINE);
                } else if (linkStatus == 131072 || this.hasStatus(linkStatus, 131072)) {
                    this.link.setFinalLinkState(FinalLinkState.FAILED_FATAL);
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private boolean hasStatus(int is, int expected) {
        return (is & expected) != 0;
    }

    public long getSize() {
        return this.link.getView().getBytesTotal();
    }

    public void setSize(long size) {
        this.link.setDownloadSize(size);
    }

    public long getCurrent() {
        return this.link.getView().getBytesLoaded();
    }

    public void setCurrent(long current) {
        this.link.setDownloadCurrent(current);
    }

    public String getURL() {
        String url = this.link.getPluginPatternMatcher();
        if (StringUtils.isNotEmpty((String)url) && this.crypt()) {
            byte[] crypted = JDCrypt.encrypt(url, KEY);
            return CRYPTED + Base64.encodeToString((byte[])crypted, (boolean)false);
        }
        return url;
    }

    public void setURL(String url) {
        if (StringUtils.isEmpty((String)url)) {
            this.link.setPluginPatternMatcherUnsafe(null);
        } else if (url.startsWith(CRYPTED)) {
            byte[] bytes = Base64.decodeFast((String)url.substring(CRYPTED.length()));
            String url2 = JDCrypt.decrypt(bytes, KEY);
            this.link.setPluginPatternMatcherUnsafe(url2);
        } else {
            this.link.setPluginPatternMatcherUnsafe(url);
        }
    }

    public String getHost() {
        return this.link.getHost();
    }

    public void setHost(String host) {
        this.link.setHost(host);
    }

    public long[] getChunkProgress() {
        if (FinalLinkState.CheckFinished(this.link.getFinalLinkState())) {
            return null;
        }
        return this.link.getChunksProgress();
    }

    public void setChunkProgress(long[] p) {
        if (!FinalLinkState.CheckFinished(this.link.getFinalLinkState())) {
            this.link.setChunksProgress(p);
        }
    }

    public String getUrlProtection() {
        try {
            return this.link.getUrlProtection().name();
        }
        catch (Throwable e) {
            return UrlProtection.UNSET.name();
        }
    }

    public void setUrlProtection(String type) {
        try {
            this.link.setUrlProtection(UrlProtection.valueOf(type));
        }
        catch (Throwable e) {
            this.link.setUrlProtection(UrlProtection.UNSET);
        }
    }

    public boolean isEnabled() {
        return this.link.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.link.setEnabled(b);
    }

    public long getCreated() {
        return this.link.getCreated();
    }

    public void setCreated(long time) {
        this.link.setCreated(time);
    }

    public DownloadLink _getDownloadLink() {
        DownloadLink lLink = this.link;
        if (lLink != null) {
            lLink.setContainerUrl(LinkCrawler.cleanURL(lLink.getContainerUrl()));
            lLink.setReferrerUrl(LinkCrawler.cleanURL(lLink.getReferrerUrl()));
            lLink.setOriginUrl(LinkCrawler.cleanURL(lLink.getOriginUrl()));
            lLink.setContentUrl(LinkCrawler.cleanURL(lLink.getContentUrl()));
            this._finalizeDeserialization(lLink);
        }
        return lLink;
    }

    private boolean crypt() {
        switch (this.link.getUrlProtection()) {
            case PROTECTED_CONTAINER: 
            case PROTECTED_DECRYPTER: {
                return true;
            }
        }
        return false;
    }

    public String getPropertiesString() {
        if (this.crypt()) {
            Map<String, Object> properties = this.link.getProperties();
            if (properties == null || properties.isEmpty()) {
                return null;
            }
            byte[] crypted = JDCrypt.encrypt(JSonStorage.serializeToJson(properties), KEY);
            return CRYPTED + Base64.encodeToString((byte[])crypted, (boolean)false);
        }
        return null;
    }

    public void setPropertiesString(String propertiesString) {
        if (propertiesString != null && propertiesString.startsWith(CRYPTED)) {
            byte[] bytes = Base64.decodeFast((String)propertiesString.substring(CRYPTED.length()));
            Map properties = (Map)JSonStorage.restoreFromByteArray((byte[])JDCrypt.decrypt(bytes, KEY, KEY), (TypeRef)TypeRef.MAP);
            this.setProperties(properties);
        }
    }
}

