/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import jd.controlling.faviconcontroller.FavIconRequestor;
import jd.controlling.faviconcontroller.FavIcons;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.appwork.utils.images.IconIO;
import org.jdownloader.DomainInfo;
import org.jdownloader.api.RemoteAPIController;

public class FavitIcon
implements Icon,
FavIconRequestor,
IDIcon {
    private int width;
    private int height;
    private int size = 10;
    private final Icon icon;
    private Icon badge = null;
    private DomainInfo domainInfo;

    public FavitIcon(Icon icon, DomainInfo domainInfo) {
        this.width = icon.getIconWidth();
        this.size = this.width * 10 / 18;
        this.height = icon.getIconHeight();
        this.domainInfo = domainInfo;
        this.badge = IconIO.getScaledInstance((Icon)FavIcons.getFavIcon(domainInfo.getTld(), this), (int)this.size, (int)this.size);
        this.icon = icon;
    }

    public IconIdentifier getIdentifier() {
        IconIdentifier ret = new IconIdentifier("Favit");
        ret.add(new IconIdentifier("tld", this.domainInfo.getDomain()));
        if (this.icon instanceof IDIcon) {
            ret.add(((IDIcon)this.icon).getIdentifier());
        } else {
            ret.add(new IconIdentifier(null, RemoteAPIController.getInstance().getContentAPI().getIconKey(this.icon)));
        }
        return ret;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon back = this.icon;
        back.paintIcon(c, g, x - 0, y - 0);
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(Color.WHITE);
        Composite comp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
        Icon badge = this.badge;
        int xx = x + this.width - badge.getIconWidth();
        int yy = y + this.height - badge.getIconHeight();
        g2d.fill(new Ellipse2D.Float(xx, yy, badge.getIconWidth(), badge.getIconHeight()));
        badge.paintIcon(c, g, xx, yy);
        if (comp != null) {
            g2d.setComposite(comp);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public Icon setFavIcon(Icon icon) {
        if (icon != null) {
            this.badge = IconIO.getScaledInstance((Icon)icon, (int)this.size, (int)this.size);
        }
        return this;
    }
}

