/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import jd.PluginWrapper;
import jd.config.ConfigContainer;
import jd.config.SubConfiguration;
import jd.controlling.accountchecker.AccountChecker;
import jd.controlling.accountchecker.AccountCheckerThread;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkchecker.LinkCheckerThread;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.LinkCrawlerDeepInspector;
import jd.controlling.linkcrawler.LinkCrawlerThread;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.OfflineException;
import jd.http.Browser;
import jd.http.BrowserSettingsThread;
import jd.http.ProxySelectorInterface;
import jd.http.StaticProxySelector;
import jd.http.URLConnectionAdapter;
import jd.nutils.SimpleFTP;
import jd.nutils.encoding.Encoding;
import jd.plugins.Account;
import jd.plugins.DecrypterPlugin;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.MinimalMemoryJSonParser;
import jd.plugins.PluginBrowser;
import jd.plugins.PluginConfigPanelNG;
import jd.plugins.PluginDependencies;
import jd.plugins.PluginException;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.SiteTester;
import jd.plugins.components.SiteType;
import jd.utils.JDUtilities;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.ParserException;
import org.appwork.uio.CloseReason;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.jdownloader.auth.AuthenticationInfo;
import org.jdownloader.auth.Login;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.gui.dialog.AskForUserAndPasswordDialog;
import org.jdownloader.gui.dialog.AskUsernameAndPasswordDialogInterface;
import org.jdownloader.gui.notify.BasicNotify;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.UserIOProgress;
import org.jdownloader.plugins.config.AccountConfigInterface;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.translate._JDT;

public abstract class Plugin
implements ActionListener {
    public static final HTTPHeader OPEN_RANGE_REQUEST = new HTTPHeader("Range", "bytes=0-");
    public static final String HTTP_LINKS_HOST = "http links";
    public static final String DIRECT_HTTP_HOST = "DirectHTTP";
    public static final String FTP_HOST = "ftp";
    protected LogInterface logger = LogController.TRASH;
    protected final CopyOnWriteArrayList<File> cleanUpCaptchaFiles = new CopyOnWriteArrayList();
    private CrawledLink currentLink = null;
    private WeakReference<Account> currentAccount = null;
    private volatile ConfigContainer config;
    protected Browser br = null;
    private WeakReference<PluginConfigPanelNG> configPanel = null;
    protected List<Challenge<?>> challenges = null;
    protected final CopyOnWriteArrayList<Plugin> pluginInstances = new CopyOnWriteArrayList();
    private WeakReference<Plugin> parent = null;

    public void setLogger(LogInterface logger) {
        if (logger == null) {
            logger = LogController.TRASH;
        }
        this.logger = logger;
    }

    public static String buildHostsPatternPart(String[] domains) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("(?:");
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            if (i > 0) {
                pattern.append("|");
            }
            pattern.append(Pattern.quote(domain));
        }
        pattern.append(")");
        return pattern.toString();
    }

    public Browser createNewBrowserInstance() {
        return new PluginBrowser<Plugin>(this);
    }

    protected String getMappedHost(List<String[]> pluginDomains, String host) {
        for (String[] domains : pluginDomains) {
            for (String domain : domains) {
                if (!StringUtils.equalsIgnoreCase((String)host, (String)domain)) continue;
                return domains[0];
            }
        }
        return null;
    }

    protected Account setCurrentAccount(Account account) {
        Account currentAccount = this.getCurrentAccount();
        this.currentAccount = account != null && (currentAccount == null || currentAccount != account) ? new WeakReference<Account>(account) : null;
        return currentAccount;
    }

    protected Account getCurrentAccount() {
        Thread thread = Thread.currentThread();
        WeakReference<Account> currentAccount = this.currentAccount;
        if (currentAccount != null) {
            Account account = (Account)currentAccount.get();
            if (account != null) {
                return account;
            }
        } else if (thread instanceof SingleDownloadController) {
            Account account = ((SingleDownloadController)((Object)thread)).getAccount();
            if (account != null && StringUtils.equals((String)this.getHost(), (String)account.getHosterByPlugin())) {
                return account;
            }
        } else if (thread instanceof AccountCheckerThread) {
            Account account;
            AccountChecker.AccountCheckJob job = ((AccountCheckerThread)((Object)thread)).getJob();
            Account account2 = account = job != null ? job.getAccount() : null;
            if (account != null && StringUtils.equals((String)this.getHost(), (String)account.getHosterByPlugin())) {
                return account;
            }
        }
        return null;
    }

    protected boolean isAccountLoginCaptchaChallenge(Challenge<?> c) {
        Account currentAccount = this.getCurrentAccount();
        if (currentAccount != null && Thread.holdsLock(currentAccount)) {
            return true;
        }
        return c.isCreatedInsideAccountChecker() || c.isAccountLogin();
    }

    protected boolean looksLikeDownloadableContent(URLConnectionAdapter urlConnection) {
        return new LinkCrawlerDeepInspector(){

            @Override
            public List<CrawledLink> deepInspect(LinkCrawler lc, LinkCrawler.LinkCrawlerGeneration generation, Browser br, URLConnectionAdapter urlConnection, CrawledLink link) throws Exception {
                throw new PluginException(0x400000);
            }
        }.looksLikeDownloadableContent(urlConnection);
    }

    protected static String[] buildAnnotationNames(List<String[]> pluginDomains) {
        ArrayList<String> ret = new ArrayList<String>(pluginDomains.size());
        for (String[] domains : pluginDomains) {
            ret.add(domains[0]);
        }
        return ret.toArray(new String[0]);
    }

    public String getExtensionFromMimeType(String contentType) {
        List<CompiledFiletypeFilter.CompiledFiletypeExtension> fileTypeExtensions = CompiledFiletypeFilter.getByMimeType(contentType);
        if (fileTypeExtensions != null && fileTypeExtensions.size() > 0) {
            return fileTypeExtensions.get(0).getExtensionFromMimeType(contentType);
        }
        return null;
    }

    public String getExtensionFromMimeType(URLConnectionAdapter connection) {
        return this.getExtensionFromMimeType(connection.getContentType());
    }

    @Deprecated
    public static String getExtensionFromMimeTypeStatic(String contentType) {
        List<CompiledFiletypeFilter.CompiledFiletypeExtension> fileTypeExtensions = CompiledFiletypeFilter.getByMimeType(contentType);
        if (fileTypeExtensions != null && fileTypeExtensions.size() > 0) {
            return fileTypeExtensions.get(0).getExtensionFromMimeType(contentType);
        }
        return null;
    }

    protected String[] buildSupportedNames(List<String[]> pluginDomains) {
        for (String[] domains : pluginDomains) {
            if (!StringUtils.equalsIgnoreCase((String)this.getHost(), (String)domains[0])) continue;
            return domains;
        }
        throw new WTFException();
    }

    public abstract String getCrawlerLoggerID(CrawledLink var1);

    public abstract void runCaptchaDDosProtection(String var1) throws InterruptedException;

    protected String getBrowserReferrer() {
        LinkCrawler crawler = this.getCrawler();
        if (crawler != null) {
            return crawler.getReferrerUrl(this.getCurrentLink());
        }
        return null;
    }

    public CrawledLink getCurrentLink() {
        return this.currentLink;
    }

    public void setCurrentLink(CrawledLink currentLink) {
        this.currentLink = currentLink;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    protected LinkCrawler getCrawler() {
        LinkCrawler ret;
        if (Thread.currentThread() instanceof LinkCrawlerThread && (ret = ((LinkCrawlerThread)((Object)Thread.currentThread())).getCurrentLinkCrawler()) != null) {
            return ret;
        }
        return null;
    }

    public boolean isHandlingMultipleHosts() {
        return false;
    }

    public boolean isProxyRotationEnabled(boolean premiumDownload) {
        return !premiumDownload;
    }

    public static String extractFileNameFromURL(String filename) {
        int fileIndex;
        int anchorIndex;
        String ret = filename;
        if (StringUtils.isEmpty((String)ret)) {
            return null;
        }
        int queryIndex = ret.indexOf("?");
        if (queryIndex >= 0) {
            ret = ret.substring(0, queryIndex);
        }
        if ((anchorIndex = ret.indexOf("#")) >= 0) {
            ret = ret.substring(0, anchorIndex);
        }
        if ((fileIndex = Math.max(ret.lastIndexOf("/"), ret.lastIndexOf("\\"))) >= 0) {
            ret = ret.substring(fileIndex + 1);
        }
        ret = URLEncode.decodeURIComponent((String)ret);
        ret = Encoding.htmlOnlyDecode((String)ret);
        return ret;
    }

    @Deprecated
    public static String getFileNameFromDispositionHeader(URLConnectionAdapter urlConnection) {
        HTTPConnectionUtils.DispositionHeader dispositionHeader = Plugin.parseDispositionHeader(urlConnection);
        if (dispositionHeader != null) {
            return dispositionHeader.getFilename();
        }
        return null;
    }

    public static List<String[]> decodeURIComponentFindBestEncoding(String urlCoded, String ... tryEncodings) {
        if (StringUtils.isEmpty((String)urlCoded)) {
            return null;
        }
        ArrayList<String[]> results = new ArrayList<String[]>();
        ArrayList<String> encodings = new ArrayList<String>(Arrays.asList("UTF-8", "cp1251", "ISO-8859-5", "KOI8-R"));
        if (tryEncodings != null) {
            for (String tryEncoding : tryEncodings) {
                if (encodings.contains(tryEncoding)) continue;
                encodings.add(0, tryEncoding);
            }
        }
        for (String encoding : encodings) {
            try {
                results.add(new String[]{encoding, URLEncode.decodeURIComponent((String)urlCoded, (String)encoding, (boolean)true)});
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
        try {
            results.add(new String[]{"US_ASCII", new String(SimpleFTP.ENCODING.ASCII7BIT.toBytes(urlCoded), "US-ASCII")});
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        Collections.sort(results, new Comparator<String[]>(){

            @Override
            private final int compare(int x, int y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            private final int getWrongEncodingLevel(String string) {
                int ret = 0;
                String value = string;
                for (int index = 0; index < value.length(); ++index) {
                    char ch = value.charAt(index);
                    Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
                    if ('\ufffd' == ch || '\u2bd1' == ch) {
                        ++ret;
                        continue;
                    }
                    if (Character.UnicodeBlock.LATIN_1_SUPPLEMENT.equals(block)) {
                        int type = Character.getType(ch);
                        switch (type) {
                            case 1: 
                            case 2: {
                                break;
                            }
                            default: {
                                ++ret;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!Character.UnicodeBlock.BOX_DRAWING.equals(block)) continue;
                    ++ret;
                }
                return ret;
            }

            @Override
            public final int compare(String[] o1, String[] o2) {
                return this.compare(this.getWrongEncodingLevel(o1[1]), this.getWrongEncodingLevel(o2[1]));
            }
        });
        if (results.size() > 0) {
            return results;
        }
        return null;
    }

    public HTTPConnectionUtils.DispositionHeader getDispositionHeader(URLConnectionAdapter urlConnection) {
        return Plugin.parseDispositionHeader(urlConnection);
    }

    public static HTTPConnectionUtils.DispositionHeader parseDispositionHeader(URLConnectionAdapter urlConnection) {
        String contentDisposition = urlConnection.getHeaderField("Content-Disposition");
        HTTPConnectionUtils.DispositionHeader ret = HTTPConnectionUtils.parseDispositionHeader((String)contentDisposition);
        if (ret == null) {
            return null;
        }
        if (ret.getEncoding() != null || StringUtils.isEmpty((String)ret.getFilename()) || ret.getFilename().indexOf(37) == -1) {
            return ret;
        }
        List<String[]> results = Plugin.decodeURIComponentFindBestEncoding(ret.getFilename(), new String[0]);
        if (results != null && results.size() > 0) {
            String[] best = results.get(0);
            return new AutoDispositionHeader(ret.getHeader(), ret.getRaw(), best[1], Charset.forName(best[0]));
        }
        return ret;
    }

    public static String getFileNameFromURL(URL url) {
        return Plugin.extractFileNameFromURL(url.getPath());
    }

    public static String getFileNameExtensionFromURL(String url, String failover) {
        try {
            return Plugin.getFileNameExtensionFromString(new URL(url).getPath(), failover);
        }
        catch (MalformedURLException e) {
            return failover;
        }
    }

    public static String getFileNameExtensionFromString(String filename, String failover) {
        int lastIndex;
        String ret = filename != null ? Plugin.extractFileNameFromURL(filename) : null;
        int n = lastIndex = ret != null ? ret.lastIndexOf(".") : -1;
        if (lastIndex >= 0) {
            return ret.substring(lastIndex);
        }
        return failover;
    }

    @Deprecated
    public static String getFileNameExtensionFromURL(String url) {
        return Plugin.getFileNameExtensionFromURL(url, null);
    }

    public static String getFileNameExtensionFromString(String filename) {
        return Plugin.getFileNameExtensionFromString(filename, null);
    }

    public String getPluginVersionHash() {
        LinkedList pluginChain = new LinkedList();
        pluginChain.add(this.getClass());
        HashSet<Class> pluginDone = new HashSet<Class>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHost());
        sb.append(this.getVersion());
        while (pluginChain.size() > 0) {
            Class clazz = (Class)pluginChain.removeFirst();
            if (clazz == null || !Plugin.class.isAssignableFrom(clazz) || !pluginDone.add(clazz)) continue;
            HostPlugin hostPlugin = clazz.getAnnotation(HostPlugin.class);
            if (hostPlugin != null) {
                sb.append("\r\n");
                sb.append(clazz.getName());
                sb.append(hostPlugin.revision());
            } else {
                DecrypterPlugin decryptPlugin = clazz.getAnnotation(DecrypterPlugin.class);
                if (decryptPlugin != null) {
                    sb.append("\r\n");
                    sb.append(clazz.getName());
                    sb.append(decryptPlugin.revision());
                }
            }
            PluginDependencies pluginDependencies = clazz.getAnnotation(PluginDependencies.class);
            if (pluginDependencies != null) {
                pluginChain.addAll(Arrays.asList(pluginDependencies.dependencies()));
            }
            pluginChain.add(clazz.getSuperclass());
        }
        if (sb.length() > 0) {
            return Hash.getSHA256((String)sb.toString());
        }
        return null;
    }

    public static String getFileNameFromConnection(URLConnectionAdapter urlConnection) {
        Plugin plugin = Plugin.getCurrentActivePlugin();
        return Plugin.getFileNameFromSource(plugin, PluginForHost.FILENAME_SOURCE.CONNECTION, null, null, null, urlConnection);
    }

    protected static String getFileNameFromSource(Plugin plugin, PluginForHost.FILENAME_SOURCE source, DownloadLink link, String customName, String customExtension, URLConnectionAdapter con) {
        if (plugin != null) {
            return plugin.getFileNameFromSource(source, link, customName, customExtension, con);
        }
        return source.getFilename(null, link, customName, customExtension, con);
    }

    protected String getFileNameFromSource(PluginForHost.FILENAME_SOURCE source, DownloadLink link, String customName, String customExtension, URLConnectionAdapter con) {
        return source.getFilename(this, link, customName, customExtension, con);
    }

    protected String getExtensionFromConnection(URLConnectionAdapter connection) {
        if (connection == null) {
            return null;
        }
        String ret = null;
        String fileNameFromDispositionHeader = Plugin.getFileNameFromDispositionHeader(connection);
        if (fileNameFromDispositionHeader != null) {
            ret = Plugin.getFileNameExtensionFromString(fileNameFromDispositionHeader, null);
        }
        if (ret == null) {
            ret = this.getExtensionFromMimeType(connection);
        }
        if (ret == null) {
            ret = Plugin.getFileNameExtensionFromString(connection.getURL().getPath(), null);
        }
        return ret;
    }

    public String correctOrApplyFileNameExtension(String filenameOrg, String newExtension, URLConnectionAdapter connection) {
        String currentFileExtension;
        String extensionFromConnection;
        String newExtensionParam = newExtension;
        if (connection != null && (extensionFromConnection = this.getExtensionFromConnection(connection)) != null) {
            newExtension = extensionFromConnection;
        }
        if (filenameOrg == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)newExtension)) {
            return filenameOrg;
        }
        if (!newExtension.startsWith(".")) {
            newExtension = "." + newExtension;
        }
        if (!StringUtils.equalsIgnoreCase((String)newExtensionParam, (String)newExtension)) {
            return this.correctOrApplyFileNameExtension(filenameOrg, newExtension, connection);
        }
        CompiledFiletypeFilter.CompiledFiletypeExtension filetypeNew = CompiledFiletypeFilter.getExtensionsFilterInterface(newExtension);
        if (!filenameOrg.contains(".")) {
            if (this.allowFileNameExtension(filenameOrg, null, filetypeNew)) {
                return filenameOrg + newExtension;
            }
            this.logger.info("blocked new extension:" + newExtension + "|" + filetypeNew);
            return filenameOrg;
        }
        if (StringUtils.endsWithCaseInsensitive((String)filenameOrg, (String)newExtension)) {
            return filenameOrg;
        }
        if (filetypeNew == null) {
            this.logger.info("unknown new extension:" + newExtension);
            return filenameOrg;
        }
        int lastIndex = filenameOrg.lastIndexOf(".");
        String string = currentFileExtension = lastIndex < filenameOrg.length() ? filenameOrg.substring(lastIndex) : null;
        if (StringUtils.isEmpty((String)currentFileExtension)) {
            return filenameOrg;
        }
        CompiledFiletypeFilter.CompiledFiletypeExtension filetypeOld = CompiledFiletypeFilter.getExtensionsFilterInterface(currentFileExtension);
        if (filetypeOld == null) {
            if (this.allowFileNameExtension(filenameOrg, filetypeOld, filetypeNew)) {
                return filenameOrg + newExtension;
            }
            this.logger.info("blocked new extension:" + newExtension + "|" + filetypeNew);
            return filenameOrg;
        }
        if (filetypeNew.isValidExtension(currentFileExtension)) {
            return filenameOrg;
        }
        if (this.allowFileNameExtension(filenameOrg, filetypeOld, filetypeNew)) {
            String filenameWithoutExtension = filenameOrg.substring(0, lastIndex);
            return filenameWithoutExtension + newExtension;
        }
        return filenameOrg;
    }

    protected boolean allowFileNameExtension(String filenameOrg, CompiledFiletypeFilter.CompiledFiletypeExtension filetypeOld, CompiledFiletypeFilter.CompiledFiletypeExtension filetypeNew) {
        if (filetypeOld == null && filetypeNew != null) {
            if (!filenameOrg.contains(".")) {
                return !CompiledFiletypeFilter.ExecutableExtensions.EXE.isSameExtensionGroup(filetypeNew);
            }
            return this.allowFileNameExtension(filenameOrg, filetypeNew, filetypeNew);
        }
        if (filetypeNew != null) {
            return (CompiledFiletypeFilter.VideoExtensions.MP4.isSameExtensionGroup(filetypeOld) || CompiledFiletypeFilter.ImageExtensions.JPG.isSameExtensionGroup(filetypeOld) || CompiledFiletypeFilter.AudioExtensions.MP3.isSameExtensionGroup(filetypeOld)) && filetypeNew.isSameExtensionGroup(filetypeOld);
        }
        return false;
    }

    public String applyFilenameExtension(String filenameOrg, String newExtension) {
        if (filenameOrg == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)newExtension)) {
            return filenameOrg;
        }
        if (!newExtension.startsWith(".")) {
            newExtension = "." + newExtension;
        }
        if (StringUtils.endsWithCaseInsensitive((String)filenameOrg, (String)newExtension)) {
            return filenameOrg;
        }
        if (!filenameOrg.contains(".")) {
            return filenameOrg + newExtension;
        }
        int lastIndex = filenameOrg.lastIndexOf(".");
        String currentFileExtension = lastIndex < filenameOrg.length() ? filenameOrg.substring(lastIndex) : null;
        CompiledFiletypeFilter.CompiledFiletypeExtension filetypeOld = CompiledFiletypeFilter.getExtensionsFilterInterface(currentFileExtension);
        if (filetypeOld == null) {
            return filenameOrg + newExtension;
        }
        CompiledFiletypeFilter.CompiledFiletypeExtension filetypeNew = CompiledFiletypeFilter.getExtensionsFilterInterface(newExtension);
        if (filetypeNew != null) {
            if (filetypeNew.isValidExtension(currentFileExtension)) {
                return filenameOrg;
            }
            if (filetypeNew.isSameExtensionGroup(filetypeOld)) {
                String filenameWithoutExtension = filenameOrg.substring(0, lastIndex);
                return filenameWithoutExtension + newExtension;
            }
        }
        return filenameOrg + newExtension;
    }

    protected boolean isConnectionOffline(Throwable e) {
        Object br;
        Plugin plugin;
        HTTPProxy proxy = null;
        Browser.BrowserException browserException = (Browser.BrowserException)Exceptions.getInstanceof((Throwable)e, Browser.BrowserException.class);
        if (browserException != null && browserException.getRequest() != null) {
            proxy = browserException.getRequest().getProxy();
        }
        if (proxy == null && (plugin = Plugin.getCurrentActivePlugin()) != null && (br = plugin instanceof PluginForHost ? ((PluginForHost)plugin).getBrowser() : (plugin instanceof PluginForDecrypt ? ((PluginForDecrypt)plugin).getBrowser() : null)) != null && br.getRequest() != null) {
            proxy = br.getRequest().getProxy();
        }
        Object proxySelector = proxy != null ? new StaticProxySelector(proxy) : BrowserSettingsThread.getThreadProxySelector();
        BalancedWebIPCheck onlineCheck = new BalancedWebIPCheck((ProxySelectorInterface)proxySelector);
        try {
            onlineCheck.getExternalIP();
        }
        catch (OfflineException e2) {
            return true;
        }
        catch (IPCheckException iPCheckException) {
            // empty catch block
        }
        return false;
    }

    protected boolean isAbort() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof SingleDownloadController) {
            SingleDownloadController sdc = (SingleDownloadController)((Object)currentThread);
            return sdc.isAborting() || currentThread.isInterrupted();
        }
        return currentThread.isInterrupted();
    }

    protected Login requestLogins(String message, String realm, DownloadLink link) throws PluginException {
        if (message == null) {
            message = _JDT.T.Plugin_requestLogins_message();
        }
        UserIOProgress prg = new UserIOProgress(message);
        prg.setProgressSource(this);
        prg.setDisplayInProgressColumnEnabled(false);
        try {
            link.addPluginProgress(prg);
            final AskUsernameAndPasswordDialogInterface handle = (AskUsernameAndPasswordDialogInterface)UIOManager.I().show(AskUsernameAndPasswordDialogInterface.class, (UserIODefinition)new AskForUserAndPasswordDialog(message, link));
            if (handle.getCloseReason() == CloseReason.OK) {
                String password = handle.getPassword();
                if (StringUtils.isEmpty((String)password)) {
                    throw new PluginException(4, _JDT.T.plugins_errors_wrongpassword());
                }
                String username = handle.getUsername();
                if (StringUtils.isEmpty((String)username)) {
                    throw new PluginException(4, _JDT.T.plugins_errors_wrongusername());
                }
                AuthenticationInfo.Type type = StringUtils.startsWithCaseInsensitive((String)link.getPluginPatternMatcher(), (String)FTP_HOST) ? AuthenticationInfo.Type.FTP : AuthenticationInfo.Type.HTTP;
                Login login = new Login(type, realm, link.getHost(), username, password, false){

                    @Override
                    public boolean isRememberSelected() {
                        return handle.isRememberSelected();
                    }
                };
                return login;
            }
            throw new PluginException(131072, _JDT.T.plugins_errors_wrongpassword());
        }
        finally {
            link.removePluginProgress(prg);
        }
    }

    public Plugin() {
    }

    @Deprecated
    public Plugin(PluginWrapper wrapper) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canHandle(String data) {
        Matcher matcher;
        if (data == null) return false;
        Matcher matcher2 = matcher = this.getMatcher();
        synchronized (matcher2) {
            try {
                if (!matcher.reset(data).find()) return false;
                int matchLength = matcher.end() - matcher.start();
                boolean bl = matchLength > 0;
                return bl;
            }
            finally {
                matcher.reset("");
            }
        }
    }

    protected final PluginEnvironment getPluginEnvironment() {
        return PluginEnvironment.getPluginEnvironment();
    }

    public abstract Matcher getMatcher();

    public void clean() {
        while (this.pluginInstances.size() > 0) {
            try {
                Plugin plugin = this.pluginInstances.remove(0);
                if (plugin == null) continue;
                plugin.clean();
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        this.parent = null;
        this.currentAccount = null;
        try {
            this.cleanupLastChallengeResponse();
        }
        finally {
            this.br = null;
            while (this.cleanUpCaptchaFiles.size() > 0) {
                File clean = this.cleanUpCaptchaFiles.remove(0);
                if (clean == null || clean.delete() || !clean.exists()) continue;
                clean.deleteOnExit();
            }
        }
    }

    public <T> T restoreFromString(String json, TypeRef<T> typeRef) {
        if (TypeRef.HASHMAP == typeRef || TypeRef.LIST == typeRef || TypeRef.OBJECT == typeRef || TypeRef.MAP == typeRef) {
            try {
                if (json == null) {
                    return null;
                }
                if (Class.forName("org.appwork.storage.simplejson.JSonParser", false, this.getClass().getClassLoader()) != null) {
                    return (T)new MinimalMemoryJSonParser(json).parse();
                }
            }
            catch (ParserException e) {
                throw new JSonMapperException((Throwable)e);
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        return (T)JSonStorage.restoreFromString((String)json, typeRef);
    }

    public CrawledLink convert(DownloadLink link) {
        return new CrawledLink(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigContainer getConfig() {
        if (this.config != null) {
            return this.config;
        }
        Plugin plugin = this;
        synchronized (plugin) {
            if (this.config != null) {
                return this.config;
            }
            this.config = new ConfigContainer(null){
                private static final long serialVersionUID = -30947319320765343L;

                @Override
                public Icon getIcon() {
                    return new AbstractIcon("warning", 16);
                }

                @Override
                public String getTitle() {
                    return Plugin.this.getHost();
                }
            };
        }
        return this.config;
    }

    public boolean hasConfig() {
        ConfigContainer lconfig = this.config;
        if (lconfig != null && lconfig.getEntries() != null && lconfig.getEntries().size() > 0) {
            return true;
        }
        return this.getConfigInterface() != null;
    }

    @Deprecated
    protected boolean hasOldConfigContainer() {
        ConfigContainer lconfig = this.config;
        return lconfig != null && lconfig.getEntries() != null && lconfig.getEntries().size() > 0;
    }

    public abstract String getHost();

    public File getLocalCaptchaFile() {
        return this.getLocalCaptchaFile(".jpg");
    }

    public int getChallengeTimeout(Challenge<?> challenge) {
        return CFG_CAPTCHA.CFG.getDefaultChallengeTimeout();
    }

    public boolean keepAlive(Challenge<?> challenge) {
        return challenge != null && challenge instanceof RecaptchaV2Challenge;
    }

    protected Browser getCaptchaBrowser(Browser br) {
        Browser ret = br != null ? br.cloneBrowser() : this.createNewBrowserInstance();
        ret.getHeaders().put("Accept", "image/png,image/*;q=0.8,*/*;q=0.5");
        ret.getHeaders().put("Cache-Control", null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getCaptchaImage(String captchaAddress) throws Exception {
        if (captchaAddress == null) {
            throw new PluginException(0x400000);
        }
        if (StringUtils.startsWithCaseInsensitive((String)captchaAddress, (String)"data:")) {
            String imageType = new Regex(captchaAddress, "data:image/([^;]*)").getMatch(0);
            if (imageType == null || !imageType.matches("(?i)^(png|jpe?g|gif)$")) {
                throw new PluginException(0x400000);
            }
            File captchaFile = this.getLocalCaptchaFile("." + imageType);
            InputStream is = IO.dataUrlToInputStream((String)captchaAddress);
            try {
                IO.writeToFile((File)captchaFile, (byte[])IO.readStream((int)-1, (InputStream)is));
            }
            finally {
                is.close();
            }
            return captchaFile;
        }
        File captchaFile = this.getLocalCaptchaFile();
        Browser brc = this.getCaptchaBrowser(this.br);
        brc.getDownload(captchaFile, captchaAddress);
        return captchaFile;
    }

    public File getLocalCaptchaFile(String extension) {
        if (StringUtils.isEmpty((String)extension)) {
            extension = ".jpg";
        } else if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        Calendar calendar = Calendar.getInstance();
        String date = String.format("%1$td.%1$tm.%1$tY_%1$tH.%1$tM.%1$tS.", calendar) + new Random().nextInt(999);
        File dest = JDUtilities.getResourceFile("captchas/" + this.getHost() + "_" + date + extension, true);
        this.cleanUpCaptchaFiles.addIfAbsent(dest);
        return dest;
    }

    public abstract SubConfiguration getPluginConfig();

    public abstract Pattern getSupportedLinks();

    public abstract long getVersion();

    public void init() {
    }

    public String getDescription() {
        return null;
    }

    public boolean pluginAPI(String function, Object input, Object output) throws Exception {
        return false;
    }

    public PluginConfigPanelNG getConfigPanel() {
        PluginConfigPanelNG panel;
        PluginConfigPanelNG pluginConfigPanelNG = panel = this.configPanel == null ? null : (PluginConfigPanelNG)this.configPanel.get();
        if (panel == null) {
            panel = this.createConfigPanel();
            this.configPanel = new WeakReference<PluginConfigPanelNG>(panel);
        }
        return panel;
    }

    protected PluginConfigPanelNG createConfigPanel() {
        if (this.getConfigInterface() != null) {
            PluginConfigPanelNG ret = new PluginConfigPanelNG(){

                @Override
                public void updateContents() {
                }

                @Override
                public void save() {
                }
            };
            return ret;
        }
        return null;
    }

    public Class<? extends PluginConfigInterface> getConfigInterface() {
        for (Class<?> cls : this.getClass().getClasses()) {
            if (!PluginConfigInterface.class.isAssignableFrom(cls) || AccountConfigInterface.class.isAssignableFrom(cls)) continue;
            PluginHost anno = cls.getAnnotation(PluginHost.class);
            if (anno != null) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    Type pluginType = this instanceof PluginForDecrypt ? Type.CRAWLER : (this instanceof PluginForHost ? Type.HOSTER : null);
                    if (!StringUtils.equals((String)anno.host(), (String)this.getHost())) {
                        LogController.CL(true).log((Throwable)new Exception("Please check:" + cls + "|host missmatch:" + anno.host() + "!=" + this.getHost()));
                    }
                    if (pluginType != null && pluginType != anno.type()) {
                        LogController.CL(true).log((Throwable)new Exception("Please check:" + cls + "|type missmatch:" + (Object)((Object)anno.type()) + "!=" + (Object)((Object)pluginType)));
                    }
                }
                return cls;
            }
            return cls;
        }
        return null;
    }

    public boolean isProxyRotationEnabledForLinkCrawler() {
        return true;
    }

    public Boolean siteTesterDisabled() {
        return null;
    }

    public Boolean siteTester(SiteType.SiteTemplate siteTemplate, Plugin plugin, Browser br) {
        return SiteTester.siteTester(siteTemplate, plugin, br);
    }

    public SiteType.SiteTemplate siteTemplateType() {
        return null;
    }

    public String[] siteSupportedNames() {
        return new String[]{this.getHost()};
    }

    public String siteSupportedPath() {
        return null;
    }

    public List<Challenge<?>> getChallenges() {
        List<Challenge<?>> challenges = this.challenges;
        if (challenges == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(challenges);
    }

    public int getChallengeRound() {
        List<Challenge<?>> challenges = this.challenges;
        return challenges == null ? 0 : challenges.size();
    }

    public synchronized int addChallenge(Challenge<?> challenge) {
        ArrayList nchallenges = new ArrayList();
        List<Challenge<?>> old = this.challenges;
        if (old != null) {
            nchallenges.addAll(old);
        }
        nchallenges.add(challenge);
        this.challenges = nchallenges;
        return nchallenges.size() - 1;
    }

    public void invalidateLastChallengeResponse() {
        List<Challenge<?>> ch = this.challenges;
        if (ch != null) {
            for (Challenge<?> c : ch) {
                SolverJob<?> job = c.getJob();
                if (job == null) continue;
                job.invalidate();
            }
        }
    }

    protected PluginForHost getNewPluginForHostInstance(String host) throws PluginException {
        PluginFinder pluginFinder = new PluginFinder(this.getLogger());
        LazyHostPlugin lazyHostPlugin = pluginFinder._assignHost(host);
        if (lazyHostPlugin != null) {
            return (PluginForHost)this.getNewPluginInstance(lazyHostPlugin);
        }
        throw new PluginException(0x400000, "Could not find PluginForHost:" + host);
    }

    protected PluginForDecrypt getNewPluginForDecryptInstance(String host) throws PluginException {
        LazyCrawlerPlugin lazyCrawlerPlugin = CrawlerPluginController.getInstance().get(host);
        if (lazyCrawlerPlugin != null) {
            PluginForDecrypt ret = (PluginForDecrypt)this.getNewPluginInstance(lazyCrawlerPlugin);
            if (this instanceof PluginForDecrypt) {
                ret.setCrawler(((PluginForDecrypt)this).getCrawler());
                ret.setLinkCrawlerGeneration(((PluginForDecrypt)this).getLinkCrawlerGeneration());
            } else if (Thread.currentThread() instanceof LinkCrawlerThread) {
                LinkCrawlerThread lct = (LinkCrawlerThread)((Object)Thread.currentThread());
                ret.setCrawler(lct.getCurrentLinkCrawler());
                ret.setLinkCrawlerGeneration(lct.getLinkCrawlerGeneration());
            }
            if (ret.getCrawler() == null) {
                ret.setCrawler(new LinkCrawler(false, true));
            }
            return ret;
        }
        throw new PluginException(0x400000, "Could not find PluginForDecrypt:" + host);
    }

    public void setBrowser(Browser br) {
        this.br = br;
    }

    public Browser getBrowser() {
        return this.br;
    }

    protected <T> T getNewPluginInstance(LazyPlugin<?> lazyPlugin) throws PluginException {
        return this.getNewPluginInstance(lazyPlugin, PluginClassLoader.getThreadPluginClassLoaderChild());
    }

    private void setParentPlugin(Plugin parentPlugin) {
        if (parentPlugin != null && parentPlugin != this) {
            parentPlugin.pluginInstances.add(0, this);
            this.parent = new WeakReference<Plugin>(parentPlugin);
        } else {
            this.parent = null;
        }
    }

    protected Plugin getParentPlugin() {
        WeakReference<Plugin> parent = this.parent;
        if (parent != null) {
            return (Plugin)parent.get();
        }
        return null;
    }

    public static <T> T getNewPluginInstance(Plugin parentPlugin, LazyPlugin<?> lazyPlugin, PluginClassLoader.PluginClassLoaderChild classLoader) throws PluginException {
        if (lazyPlugin != null) {
            try {
                Object plugin = lazyPlugin.newInstance(classLoader, false);
                if (classLoader != null) {
                    if (parentPlugin != null) {
                        super.setParentPlugin(parentPlugin);
                        ((Plugin)plugin).setLogger(parentPlugin.getLogger());
                        ((Plugin)plugin).setBrowser(parentPlugin.getBrowser());
                    }
                    ((Plugin)plugin).init();
                }
                return (T)plugin;
            }
            catch (UpdateRequiredClassNotFoundException e) {
                throw new PluginException(0x400000, "Failed to create new instanceof:" + lazyPlugin, e);
            }
        }
        throw new IllegalArgumentException();
    }

    protected <T> T getNewPluginInstance(LazyPlugin<?> lazyPlugin, PluginClassLoader.PluginClassLoaderChild classLoader) throws PluginException {
        return Plugin.getNewPluginInstance(this, lazyPlugin, classLoader);
    }

    public static Plugin getCurrentActivePlugin() {
        Thread thread = Thread.currentThread();
        if (thread instanceof SingleDownloadController) {
            PluginForHost plugin = ((SingleDownloadController)((Object)thread)).getProcessingPlugin();
            if (plugin != null) {
                return plugin;
            }
            return ((SingleDownloadController)((Object)thread)).getDownloadLinkCandidate().getCachedAccount().getPlugin();
        }
        if (thread instanceof AccountCheckerThread) {
            AccountChecker.AccountCheckJob job = ((AccountCheckerThread)((Object)thread)).getJob();
            if (job != null) {
                return job.getAccount().getPlugin();
            }
            return null;
        }
        if (thread instanceof LinkCheckerThread) {
            return ((LinkCheckerThread)((Object)thread)).getPlugin();
        }
        if (thread instanceof LinkCrawlerThread) {
            Object owner = ((LinkCrawlerThread)((Object)thread)).getCurrentOwner();
            if (owner instanceof Plugin) {
                return (Plugin)owner;
            }
            return null;
        }
        return null;
    }

    public synchronized void cleanupLastChallengeResponse() {
        List<Challenge<?>> ch = this.challenges;
        this.challenges = null;
        if (ch == null || ch.size() == 0) {
            return;
        }
        for (Challenge<?> c : ch) {
            try {
                c.cleanup();
            }
            catch (Throwable e) {
                LogInterface logger = this.getLogger();
                if (logger != null) {
                    logger.log(e);
                    continue;
                }
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    public void validateLastChallengeResponse() {
        List<Challenge<?>> ch = this.challenges;
        if (ch == null || ch.size() == 0) {
            return;
        }
        Challenge<?> latest = ch.get(ch.size() - 1);
        SolverJob<?> job = latest.getJob();
        if (job != null) {
            job.validate();
        }
    }

    public boolean hasChallengeResponse() {
        List<Challenge<?>> challenges = this.challenges;
        return challenges != null && challenges.size() > 0;
    }

    protected void displayBubbleNotification(String title, String text) {
        this.displayBubbleNotification(title, text, new AbstractIcon("info", 32));
    }

    protected void displayBubbleNotification(final String title, final String text, final Icon icon) {
        BubbleNotify.getInstance().show(new BubbleNotify.AbstractNotifyWindowFactory(){

            @Override
            public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
                return new BasicNotify(title, text, icon == null ? new AbstractIcon("info", 32) : icon);
            }
        });
    }

    public static enum PluginEnvironment {
        UNKNOWN,
        DOWNLOAD,
        CRAWLER,
        LINK_CHECK,
        ACCOUNT_CHECK;


        public static PluginEnvironment getPluginEnvironment() {
            Thread thread = Thread.currentThread();
            if (thread instanceof SingleDownloadController) {
                return DOWNLOAD;
            }
            if (thread instanceof LinkCrawlerThread) {
                return CRAWLER;
            }
            if (thread instanceof LinkCheckerThread) {
                return LINK_CHECK;
            }
            if (thread instanceof AccountCheckerThread) {
                return ACCOUNT_CHECK;
            }
            return UNKNOWN;
        }
    }

    public static class AutoDispositionHeader
    extends HTTPConnectionUtils.DispositionHeader {
        private AutoDispositionHeader(String header, String raw, String filename, Charset encoding) {
            super(header, raw, filename, encoding);
        }
    }
}

