/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.components;

import jd.config.Property;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import jd.plugins.MultiHostHost;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import org.appwork.exceptions.WTFException;

public class MultiHosterManagement {
    private final String host;

    public MultiHosterManagement(String host) {
        this.host = host;
    }

    protected String getErrorProperty() {
        return this.getHost().replaceAll("https?://|\\.|\\-", "") + "_failedtimes_";
    }

    private String getHost() {
        String host;
        Plugin plugin = Plugin.getCurrentActivePlugin();
        String string = host = plugin != null ? plugin.getHost() : this.host;
        if (host == null) {
            throw new WTFException();
        }
        return host;
    }

    public void putError(Object account, DownloadLink downloadLink, Long timeout, String reason) throws PluginException {
        MultiHostHost mhost;
        Account acc;
        AccountInfo ai;
        if (account != null && account instanceof Account && (ai = (acc = (Account)account).getAccountInfo()) != null && (mhost = ai.getMultihostSupportedHost(downloadLink.getHost())) != null) {
            mhost.setErrorStatus(reason, timeout);
            ai.updateMultihostSupportedHost(mhost);
        }
        throw new PluginException(4, reason);
    }

    public void handleErrorGeneric(Account account, DownloadLink downloadLink, String error, int maxRetries) throws PluginException, InterruptedException {
        this.handleErrorGeneric(account, downloadLink, error, maxRetries, 3600000L);
    }

    public void handleErrorGeneric(Account account, DownloadLink downloadLink, String error, int maxRetries, long errorWait) throws PluginException, InterruptedException {
        if (downloadLink == null) {
            throw new PluginException(256, PluginException.VALUE_ID_PREMIUM_TEMP_DISABLE);
        }
        String errorID = this.getErrorProperty() + error;
        int timesFailed = downloadLink.getIntegerProperty(errorID, 0);
        if (timesFailed < maxRetries) {
            downloadLink.setProperty(errorID, ++timesFailed);
            long waitPeriod = 5 * timesFailed;
            do {
                downloadLink.getLinkStatus().setStatusText("Small wait: " + waitPeriod + " secs");
                Thread.sleep(1000L);
            } while (--waitPeriod > 0L);
            downloadLink.getLinkStatus().setStatusText("");
            throw new PluginException(4, "Retry " + timesFailed + "/" + maxRetries + ": " + error);
        }
        downloadLink.setProperty(errorID, Property.NULL);
        String errorPrefix = maxRetries <= 1 ? "" : "Too many failed attempts: >= " + maxRetries + ": ";
        this.putError(account, downloadLink, errorWait, errorPrefix + error);
    }
}

