/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.plugins.download.Downloadable;
import jd.plugins.download.HashInfo;
import jd.plugins.download.HashResult;
import jd.plugins.download.RAFDownload;
import jd.plugins.download.raf.FileBytesMap;
import jd.plugins.download.raf.HTTPDownloader;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.plugins.HashCheckPluginProgress;
import org.jdownloader.settings.GeneralSettings;

public abstract class DownloadInterface {
    protected boolean fixWrongContentDispositionHeader = false;
    protected boolean allowFilenameFromURL = true;
    protected Request initialRequest = null;
    protected static final List<AtomicBoolean> HASHCHECK_QUEUE = new ArrayList<AtomicBoolean>();
    protected static final int MAX_CONCURRENT_HASH_CHECKS = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getMaxConcurrentHashChecks();

    @Deprecated
    public void setFilenameFix(boolean b) {
        this.fixWrongContentDispositionHeader = b;
    }

    public void setAllowFilenameFromURL(boolean b) {
        this.allowFilenameFromURL = b;
    }

    public static final boolean isNewHTTPCore() {
        return HTTPDownloader.class.isAssignableFrom(RAFDownload.class);
    }

    public abstract ManagedThrottledConnectionHandler getManagedConnetionHandler();

    public void setInitialRequest(Request initialRequest) {
        if (initialRequest == null) {
            throw new IllegalArgumentException("initialRequest is null!");
        }
        this.initialRequest = initialRequest;
    }

    public abstract URLConnectionAdapter connect(Browser var1) throws Exception;

    public abstract long getTotalLinkBytesLoadedLive();

    public FileBytesMap.FileBytesMapView getCacheMapView() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected HashResult getHashResult(Downloadable downloadable, File file) throws InterruptedException {
        if (!downloadable.isHashCheckEnabled()) {
            return null;
        }
        if (!((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isHashCheckEnabled()) {
            return null;
        }
        int maxConcurrent = MAX_CONCURRENT_HASH_CHECKS;
        int nextWaitIndex = maxConcurrent - 1;
        AtomicBoolean waitLock = new AtomicBoolean(false);
        List<AtomicBoolean> list = HASHCHECK_QUEUE;
        synchronized (list) {
            HASHCHECK_QUEUE.add(waitLock);
            waitLock.set(HASHCHECK_QUEUE.indexOf(waitLock) > nextWaitIndex);
        }
        HashCheckPluginProgress hashWait = new HashCheckPluginProgress(null, Color.YELLOW.darker().darker(), null);
        downloadable.addPluginProgress(hashWait);
        if (waitLock.get()) {
            AtomicBoolean atomicBoolean = waitLock;
            synchronized (atomicBoolean) {
                if (waitLock.get()) {
                    waitLock.wait();
                }
            }
        }
        HashInfo hashInfo = downloadable.getHashInfo();
        downloadable.removePluginProgress(hashWait);
        HashResult hashResult = downloadable.getHashResult(hashInfo, file);
        if (hashResult != null) {
            downloadable.getLogger().info(hashResult.toString());
            if (hashResult.getFinalLinkState().isFinished()) {
                downloadable.setHashInfo(hashResult.getHashInfo());
            }
        }
        HashResult hashResult2 = hashResult;
        downloadable.removePluginProgress(hashWait);
        Object object = HASHCHECK_QUEUE;
        synchronized (object) {
            boolean callNext = HASHCHECK_QUEUE.indexOf(waitLock) <= nextWaitIndex;
            HASHCHECK_QUEUE.remove(waitLock);
            waitLock = HASHCHECK_QUEUE.size() > nextWaitIndex && callNext ? HASHCHECK_QUEUE.get(nextWaitIndex) : null;
        }
        if (waitLock != null) {
            object = waitLock;
            synchronized (object) {
                waitLock.set(false);
                waitLock.notifyAll();
            }
        }
        return hashResult2;
        {
            catch (Throwable throwable) {
                try {
                    downloadable.removePluginProgress(hashWait);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object object2 = HASHCHECK_QUEUE;
                    synchronized (object2) {
                        boolean callNext = HASHCHECK_QUEUE.indexOf(waitLock) <= nextWaitIndex;
                        HASHCHECK_QUEUE.remove(waitLock);
                        waitLock = HASHCHECK_QUEUE.size() > nextWaitIndex && callNext ? HASHCHECK_QUEUE.get(nextWaitIndex) : null;
                    }
                    if (waitLock != null) {
                        object2 = waitLock;
                        synchronized (object2) {
                            waitLock.set(false);
                            waitLock.notifyAll();
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }

    public abstract boolean startDownload() throws Exception;

    public abstract URLConnectionAdapter getConnection();

    public abstract void stopDownload();

    public abstract boolean externalDownloadStop();

    public abstract long getStartTimeStamp();

    public abstract void close();

    public abstract Downloadable getDownloadable();

    public abstract boolean isResumedDownload();

    @Deprecated
    public class Chunk {
        @Deprecated
        public Chunk(long startByte, long endByte, URLConnectionAdapter connection, DownloadInterface dl) {
        }

        @Deprecated
        public long getStartByte() {
            return -1L;
        }

        @Deprecated
        public long getEndByte() {
            return -1L;
        }
    }
}

