/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import jd.controlling.downloadcontroller.DiskSpaceManager;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkDatabindingInterface;
import jd.plugins.FilePackage;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.Downloadable;
import jd.plugins.download.HashInfo;
import jd.plugins.download.HashResult;
import jd.plugins.download.PureJavaCrc32C;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;
import org.bouncycastle.crypto.io.DigestInputStream;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.HashCheckPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;

public class DownloadLinkDownloadable
implements Downloadable {
    private static volatile boolean crcHashingInProgress = false;
    private final DownloadLink downloadLink;
    private final PluginForHost plugin;
    private final Browser contextBrowser;

    public DownloadLinkDownloadable(DownloadLink downloadLink) {
        this(downloadLink, null);
    }

    public DownloadLinkDownloadable(DownloadLink downloadLink, Browser br) {
        this.downloadLink = downloadLink;
        this.plugin = downloadLink.getLivePlugin();
        this.contextBrowser = br;
    }

    @Override
    public DownloadLink getDownloadLink() {
        return this.downloadLink;
    }

    @Override
    public void setResumeable(boolean value) {
        this.getDownloadLink().setResumeable(value);
    }

    @Override
    public Browser getContextBrowser() {
        if (this.contextBrowser != null) {
            return this.contextBrowser.cloneBrowser();
        }
        return this.getPlugin().getBrowser().cloneBrowser();
    }

    @Override
    public LogInterface getLogger() {
        return this.getPlugin().getLogger();
    }

    @Override
    public void setDownloadInterface(DownloadInterface di) {
        this.getPlugin().setDownloadInterface(di);
    }

    @Override
    public long getVerifiedFileSize() {
        return this.getDownloadLink().getView().getBytesTotalVerified();
    }

    @Override
    public boolean isServerComaptibleForByteRangeRequest() {
        return this.getDownloadLink().getBooleanProperty("ServerComaptibleForByteRangeRequest", false);
    }

    @Override
    public String getHost() {
        URLConnectionAdapter connection;
        DownloadInterface dli = this.getDownloadInterface();
        if (dli != null && (connection = dli.getConnection()) != null) {
            return connection.getURL().getHost();
        }
        return this.getDownloadLink().getHost();
    }

    @Override
    public boolean isDebug() {
        return this.getPlugin().getBrowser().isDebug();
    }

    @Override
    public void setDownloadTotalBytes(long l) {
        this.getDownloadLink().setDownloadSize(l);
    }

    @Override
    public SingleDownloadController getDownloadLinkController() {
        return this.getDownloadLink().getDownloadLinkController();
    }

    @Override
    public void setLinkStatus(int finished) {
        this.getDownloadLinkController().getLinkStatus().setStatus(finished);
    }

    @Override
    public void setVerifiedFileSize(long length) {
        this.getDownloadLink().setVerifiedFileSize(length);
    }

    @Override
    public void validateLastChallengeResponse() {
        this.getPlugin().validateLastChallengeResponse();
    }

    @Override
    public void setConnectionHandler(ManagedThrottledConnectionHandler managedConnetionHandler) {
        this.getDownloadLinkController().getConnectionHandler().addConnectionHandler(managedConnetionHandler);
    }

    @Override
    public void removeConnectionHandler(ManagedThrottledConnectionHandler managedConnetionHandler) {
        this.getDownloadLinkController().getConnectionHandler().removeConnectionHandler(managedConnetionHandler);
    }

    @Override
    public void setAvailable(DownloadLink.AvailableStatus status) {
        this.getDownloadLink().setAvailableStatus(status);
    }

    @Override
    public String getFinalFileName() {
        return this.getDownloadLink().getFinalFileName();
    }

    @Override
    public void setFinalFileName(String newfinalFileName) {
        this.getDownloadLink().setFinalFileName(newfinalFileName);
    }

    @Override
    public boolean checkIfWeCanWrite(final ExceptionRunnable runOkay, ExceptionRunnable runFailed) throws Exception {
        SingleDownloadController dlc = this.getDownloadLinkController();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        DownloadWatchDog.getInstance().localFileCheck(dlc, new ExceptionRunnable(){

            @Override
            public void run() throws Exception {
                runOkay.run();
                atomicBoolean.set(true);
            }
        }, runFailed);
        return atomicBoolean.get();
    }

    @Override
    public void lockFiles(File ... files) throws FileIsLockedException {
        SingleDownloadController dlc = this.getDownloadLinkController();
        for (File f : files) {
            dlc.lockFile(f);
        }
    }

    @Override
    public void unlockFiles(File ... files) {
        SingleDownloadController dlc = this.getDownloadLinkController();
        for (File f : files) {
            dlc.unlockFile(f);
        }
    }

    @Override
    public void addDownloadTime(long ms) {
        this.getDownloadLink().addDownloadTime(ms);
    }

    @Override
    public void setLinkStatusText(String label) {
        this.getDownloadLinkController().getLinkStatus().setStatusText(label);
    }

    @Override
    public long getDownloadTotalBytes() {
        return this.getDownloadLink().getView().getBytesTotalEstimated();
    }

    @Override
    public void setDownloadBytesLoaded(long bytes) {
        this.getDownloadLink().setDownloadCurrent(bytes);
    }

    @Override
    public boolean isHashCheckEnabled() {
        HashInfo hashInfo;
        if (!this.getDownloadLink().getBooleanProperty("ALLOW_HASHCHECK", true).booleanValue()) {
            return false;
        }
        return this.getClass() != DownloadLinkDownloadable.class || this.isValidHashInfo(hashInfo = this.getHashInfo());
    }

    protected boolean isValidHashInfo(HashInfo hashInfo) {
        return hashInfo != null && !HashInfo.TYPE.NONE.equals((Object)hashInfo.getType());
    }

    @Override
    public String getName() {
        return this.getDownloadLink().getName();
    }

    @Override
    public long getKnownDownloadSize() {
        return this.getDownloadLink().getView().getBytesTotal();
    }

    @Override
    public void addPluginProgress(PluginProgress progress) {
        this.getDownloadLink().addPluginProgress(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashResult getHashResult(HashInfo hashInfo, File outputPartFile) {
        if (!this.isValidHashInfo(hashInfo)) {
            return null;
        }
        type = hashInfo.getType();
        hashProgress = new HashCheckPluginProgress(outputPartFile, Color.YELLOW.darker(), type);
        hashProgress.setProgressSource(this);
        try {
            this.addPluginProgress(hashProgress);
            b = new byte[524288];
            hashFile = null;
            fis = null;
            try {
                read = 0;
                currentPosition = 0L;
                switch (4.$SwitchMap$jd$plugins$download$HashInfo$TYPE[type.ordinal()]) {
                    case 3: {
                        try {
                            fis = new FileInputStream(outputPartFile);
                            DownloadLinkDownloadable.crcHashingInProgress = true;
                            is = new DigestInputStream((InputStream)fis, (Digest)new WhirlpoolDigest());
                            while ((read = is.read(b)) >= 0) {
                                hashProgress.setCurrent(currentPosition += (long)read);
                            }
                            hashBytes = new byte[is.getDigest().getDigestSize()];
                            is.getDigest().doFinal(hashBytes, 0);
                            hashFile = HexFormatter.byteArrayToHex((byte[])hashBytes);
                            is.close();
                            DownloadLinkDownloadable.crcHashingInProgress = false;
                            ** break;
lbl30:
                            // 1 sources

                            break;
                        }
                        catch (Throwable e) {
                            try {
                                this.getLogger().log(e);
                                break;
                            }
                            catch (Throwable var13_23) {
                                throw var13_23;
                            }
                            finally {
                                DownloadLinkDownloadable.crcHashingInProgress = false;
                            }
                        }
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        try {
                            fis = new FileInputStream(outputPartFile);
                            DownloadLinkDownloadable.crcHashingInProgress = true;
                            is = new java.security.DigestInputStream(fis, MessageDigest.getInstance(type.getDigest()));
                            while ((read = is.read(b)) >= 0) {
                                hashProgress.setCurrent(currentPosition += (long)read);
                            }
                            hashFile = HexFormatter.byteArrayToHex((byte[])is.getMessageDigest().digest());
                            is.close();
                            DownloadLinkDownloadable.crcHashingInProgress = false;
                            ** break;
lbl52:
                            // 1 sources

                            break;
                        }
                        catch (Throwable e) {
                            try {
                                this.getLogger().log(e);
                                break;
                            }
                            catch (Throwable var14_26) {
                                throw var14_26;
                            }
                            finally {
                                DownloadLinkDownloadable.crcHashingInProgress = false;
                            }
                        }
                    }
                    case 1: 
                    case 2: {
                        try {
                            fis = new FileInputStream(outputPartFile);
                            DownloadLinkDownloadable.crcHashingInProgress = true;
                            switch (4.$SwitchMap$jd$plugins$download$HashInfo$TYPE[type.ordinal()]) {
                                case 1: {
                                    checksum = new CRC32();
                                    ** break;
                                }
                                case 2: {
                                    checksum = PureJavaCrc32C.newCRC32CChecksumInstance();
                                    ** break;
                                }
                            }
                            hashBytes = null;
                            DownloadLinkDownloadable.crcHashingInProgress = false;
                            return hashBytes;
lbl76:
                            // 2 sources

                        }
                        catch (Throwable e) {
                            try {
                                this.getLogger().log(e);
                                break;
                            }
                            catch (Throwable var16_28) {
                                throw var16_28;
                            }
                            finally {
                                DownloadLinkDownloadable.crcHashingInProgress = false;
                            }
                        }
                    }
                    {
                        cis = new CheckedInputStream(fis, checksum);
                        while ((read = cis.read(b)) >= 0) {
                            hashProgress.setCurrent(currentPosition += (long)read);
                        }
                        value = cis.getChecksum().getValue();
                        cis.close();
                        longBytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
                        hashFile = HexFormatter.byteArrayToHex((byte[])longBytes);
                        DownloadLinkDownloadable.crcHashingInProgress = false;
                        ** break;
lbl96:
                        // 1 sources

                        break;
                    }
                    case 10: {
                        var11_18 = null;
                        return var11_18;
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable var8_9) {}
                }
            }
            var8_10 = new HashResult(hashInfo, hashFile);
            return var8_10;
        }
        finally {
            this.removePluginProgress(hashProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashInfo getHashInfo() {
        HashInfo hashInfo = this.getDownloadLink().getHashInfo();
        if (hashInfo != null) {
            return hashInfo;
        }
        String name = this.getName();
        ArrayList<HashInfo> hashInfos = new ArrayList<HashInfo>();
        for (Object type : HashInfo.TYPE.values()) {
            String hash;
            if (!type.isAutoMode() || (hash = new Regex(name, ".*?\\[([A-Fa-f0-9]{" + type.getSize() + "})\\]").getMatch(0)) == null) continue;
            hashInfos.add(new HashInfo(hash, (HashInfo.TYPE)((Object)type), false));
        }
        FilePackage filePackage = this.getDownloadLink().getFilePackage();
        if (!FilePackage.isDefaultFilePackage(filePackage)) {
            ArrayList<Object> checkSumFiles = new ArrayList<Object>();
            boolean readL = filePackage.getModifyLock().readLock();
            try {
                for (DownloadLink dl : filePackage.getChildren()) {
                    File file;
                    String fileName;
                    if (dl == this.getDownloadLink() || !FinalLinkState.CheckFinished(dl.getFinalLinkState()) || !(fileName = (file = this.getFileOutput(dl, false)).getName()).matches(".*\\.(sfv|md5|sha1|sha256|sha512)$") || !file.isFile() || checkSumFiles.contains(file)) continue;
                    checkSumFiles.add(file);
                }
            }
            finally {
                filePackage.getModifyLock().readUnlock(readL);
            }
            File[] files = new File(filePackage.getDownloadDirectory()).listFiles();
            if (files != null) {
                for (File file : files) {
                    String fileName = file.getName();
                    if (!fileName.matches(".*\\.(sfv|md5|sha1|sha256|sha512)$") || !file.isFile() || checkSumFiles.contains(file)) continue;
                    checkSumFiles.add(file);
                }
            }
            for (File file : checkSumFiles) {
                try {
                    String[] lines;
                    String content;
                    if (file.length() >= 524288L || !StringUtils.isNotEmpty((String)(content = IO.readFileToString((File)file)))) continue;
                    for (String line : lines = Regex.getLines((String)content)) {
                        if (line.startsWith(";") || !line.contains(name)) continue;
                        for (HashInfo.TYPE type : HashInfo.TYPE.values()) {
                            String hash;
                            if (!type.isAutoMode() || (hash = new Regex(line, "(?:^|\\s+)([A-Fa-f0-9]{" + type.getSize() + "})(\\s+|$)").getMatch(0)) == null) continue;
                            hashInfos.add(new HashInfo(hash, type));
                        }
                    }
                }
                catch (IOException e) {
                    this.getLogger().log((Throwable)e);
                }
            }
        }
        if (hashInfos.size() == 1) {
            return (HashInfo)hashInfos.get(0);
        }
        if (hashInfos.size() > 1) {
            HashInfo best = null;
            for (HashInfo info : hashInfos) {
                if (best == null) {
                    best = info;
                    continue;
                }
                if (info.isStrongerThan(best) && (info.isTrustworthy() || !best.isTrustworthy())) {
                    best = info;
                    continue;
                }
                if (!info.isTrustworthy() || best.isTrustworthy()) continue;
                best = info;
            }
            return best;
        }
        return null;
    }

    private File getFileOutput(DownloadLink link, boolean ignoreCustom) {
        SingleDownloadController controller = link.getDownloadLinkController();
        if (controller == null) {
            return new File(link.getFileOutput(false, ignoreCustom));
        }
        return controller.getFileOutput(false, ignoreCustom);
    }

    @Override
    @Deprecated
    public long[] getChunksProgress() {
        return this.getDownloadLink().getView().getChunksProgress();
    }

    @Override
    @Deprecated
    public void setChunksProgress(long[] ls) {
        this.getDownloadLink().setChunksProgress(ls);
    }

    public PluginForHost getPlugin() {
        return this.plugin;
    }

    @Override
    public void setHashResult(HashResult result) {
        this.getDownloadLinkController().setHashResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean rename(final File outputPartFile, final File outputCompleteFile) throws InterruptedException {
        boolean renameOkay;
        block10: {
            renameOkay = false;
            for (int retry = 5; retry > 0 && !(renameOkay = outputPartFile.renameTo(outputCompleteFile)); --retry) {
                Thread.sleep(1000L);
            }
            if (renameOkay) return renameOkay;
            this.getLogger().severe("Could not rename file " + outputPartFile + " to " + outputCompleteFile);
            this.getLogger().severe("Try copy workaround!");
            DiskSpaceReservation reservation = new DiskSpaceReservation(){

                @Override
                public long getSize() {
                    return outputPartFile.length() - outputCompleteFile.length();
                }

                @Override
                public File getDestination() {
                    return outputCompleteFile;
                }

                @Override
                public Object getOwner() {
                    return DownloadLinkDownloadable.this;
                }

                @Override
                public LogInterface getLogger() {
                    return DownloadLinkDownloadable.this.getLogger();
                }
            };
            try {
                try {
                    DiskSpaceManager.DISKSPACERESERVATIONRESULT result = DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().checkAndReserve(reservation, this);
                    switch (result) {
                        case OK: 
                        case UNSUPPORTED: {
                            IO.copyFile((File)outputPartFile, (File)outputCompleteFile);
                            renameOkay = true;
                            outputPartFile.delete();
                            break;
                        }
                    }
                }
                finally {
                    DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().free(reservation, this);
                }
            }
            catch (Throwable e) {
                this.getLogger().log(e);
                if (!outputCompleteFile.exists() || outputCompleteFile.length() == outputPartFile.length()) break block10;
                FileCreationManager.getInstance().delete(outputCompleteFile, null);
            }
        }
        if (!renameOkay) {
            this.getLogger().severe("Copy workaround: :(");
            return renameOkay;
        }
        this.getLogger().severe("Copy workaround: :)");
        return renameOkay;
    }

    @Override
    public void waitForNextConnectionAllowed() throws InterruptedException {
        this.getPlugin().waitForNextConnectionAllowed(this.getDownloadLink());
    }

    @Override
    public boolean isInterrupted() {
        SingleDownloadController sdc = this.getDownloadLinkController();
        return sdc != null && sdc.isAborting();
    }

    @Override
    public String getFileOutput() {
        return this.getFileOutput(this.getDownloadLink(), false).getAbsolutePath();
    }

    @Override
    public int getLinkStatus() {
        return this.getDownloadLinkController().getLinkStatus().getStatus();
    }

    @Override
    public String getFileOutputPart() {
        return this.getFileOutput() + ".part";
    }

    @Override
    public String getFinalFileOutput() {
        return this.getFileOutput(this.getDownloadLink(), true).getAbsolutePath();
    }

    @Override
    public boolean isResumable() {
        return this.getDownloadLink().isResumeable();
    }

    @Override
    public DiskSpaceReservation createDiskSpaceReservation() {
        return new DiskSpaceReservation(){

            @Override
            public long getSize() {
                File partFile = new File(DownloadLinkDownloadable.this.getFileOutputPart());
                long doneSize = Math.max(partFile.exists() ? partFile.length() : 0L, DownloadLinkDownloadable.this.getDownloadBytesLoaded());
                return DownloadLinkDownloadable.this.getKnownDownloadSize() - Math.max(0L, doneSize);
            }

            @Override
            public File getDestination() {
                return new File(DownloadLinkDownloadable.this.getFileOutput());
            }

            @Override
            public Object getOwner() {
                return DownloadLinkDownloadable.this;
            }

            @Override
            public LogInterface getLogger() {
                return DownloadLinkDownloadable.this.getLogger();
            }
        };
    }

    @Override
    public void checkAndReserve(DiskSpaceReservation reservation) throws Exception {
        DiskSpaceManager.DISKSPACERESERVATIONRESULT result = DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().checkAndReserve(reservation, this.getDownloadLinkController());
        switch (result) {
            case FAILED: {
                throw new SkipReasonException(SkipReason.DISK_FULL);
            }
            case INVALIDDESTINATION: {
                throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
            }
        }
    }

    @Override
    public void free(DiskSpaceReservation reservation) {
        DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().free(reservation, this.getDownloadLinkController());
    }

    @Override
    public long getDownloadBytesLoaded() {
        return this.getDownloadLink().getView().getBytesLoaded();
    }

    @Override
    public boolean removePluginProgress(PluginProgress remove) {
        return this.getDownloadLink().removePluginProgress(remove);
    }

    @Override
    public <T> T getDataBindingInterface(Class<? extends DownloadLinkDatabindingInterface> T2) {
        return (T)this.getDownloadLink().bindData(T2);
    }

    protected HTTPConnectionUtils.DispositionHeader parseDispositionHeader(URLConnectionAdapter connection) {
        PluginForHost plugin = this.getPlugin();
        if (plugin != null) {
            return plugin.getDispositionHeader(connection);
        }
        return Plugin.parseDispositionHeader(connection);
    }

    protected String getFileNameFromURL(URLConnectionAdapter connection) {
        return Plugin.getFileNameFromURL(connection.getURL());
    }

    protected String getExtensionFromMimeType(URLConnectionAdapter connection) {
        PluginForHost plugin = this.getPlugin();
        if (plugin != null) {
            return plugin.getExtensionFromMimeType(connection);
        }
        return null;
    }

    protected String correctOrApplyFileNameExtension(String name, URLConnectionAdapter connection) {
        PluginForHost plugin = this.getPlugin();
        if (plugin != null) {
            return plugin.correctOrApplyFileNameExtension(name, null, connection);
        }
        return name;
    }

    protected boolean isAllowFilenameFromURL(URLConnectionAdapter connection) {
        DownloadInterface dl = this.getDownloadInterface();
        return dl != null && dl.allowFilenameFromURL;
    }

    protected boolean isFixWrongEncoding(URLConnectionAdapter connection, String fileName) {
        DownloadInterface dl = this.getDownloadInterface();
        return dl != null && dl.fixWrongContentDispositionHeader;
    }

    protected String fixWrongEncoding(URLConnectionAdapter connection, String fileName) {
        List<String[]> results = Plugin.decodeURIComponentFindBestEncoding(fileName, new String[0]);
        if (results != null && results.size() > 0) {
            return results.get(0)[1];
        }
        return fileName;
    }

    @Override
    public void updateFinalFileName() {
        String newFinalFilename;
        String existingFinalFilename = this.getFinalFileName();
        LogInterface logger = this.getLogger();
        DownloadInterface dl = this.getDownloadInterface();
        URLConnectionAdapter connection = dl.getConnection();
        HTTPConnectionUtils.DispositionHeader dispositonHeader = this.parseDispositionHeader(connection);
        if (dispositonHeader != null && StringUtils.isNotEmpty((String)dispositonHeader.getFilename())) {
            if (existingFinalFilename == null) {
                String fileNameFromDispositionHeader = dispositonHeader.getFilename();
                String newFinalFilename2 = dispositonHeader.getEncoding() == null && this.isFixWrongEncoding(connection, fileNameFromDispositionHeader) ? this.fixWrongEncoding(connection, fileNameFromDispositionHeader) : fileNameFromDispositionHeader;
                logger.info("updateFinalFileName: set to '" + newFinalFilename2 + "' from connection:" + dispositonHeader + "|Content-Type:" + connection.getContentType() + "|fixEncoding:" + !StringUtils.equals((String)newFinalFilename2, (String)fileNameFromDispositionHeader));
                this.setFinalFileName(newFinalFilename2);
            }
            return;
        }
        if (existingFinalFilename == null && this.isAllowFilenameFromURL(connection) && StringUtils.isNotEmpty((String)this.getFileNameFromURL(connection))) {
            String fileNameFromURL = this.getFileNameFromURL(connection);
            newFinalFilename = this.isFixWrongEncoding(connection, fileNameFromURL) ? this.fixWrongEncoding(connection, fileNameFromURL) : fileNameFromURL;
            logger.info("updateFinalFileName: set to '" + newFinalFilename + "' from url:" + connection.getURL().getPath() + "|Content-Type:" + connection.getContentType() + "|fixEncoding:" + !StringUtils.equals((String)newFinalFilename, (String)fileNameFromURL));
            this.setFinalFileName(newFinalFilename);
        }
        if (StringUtils.isNotEmpty((String)this.getName())) {
            String name = this.getName();
            newFinalFilename = this.correctOrApplyFileNameExtension(name, connection);
            if (StringUtils.equals((String)existingFinalFilename, (String)newFinalFilename)) {
                return;
            }
            if (!StringUtils.equals((String)name, (String)newFinalFilename)) {
                logger.info("updateFinalFileName: correct from '" + name + "' to '" + newFinalFilename + "'|Content-Type:" + connection.getContentType());
            }
            this.setFinalFileName(newFinalFilename);
        }
    }

    protected String decodeURIComponent(String name, String charSet) {
        try {
            if (StringUtils.isEmpty((String)charSet)) {
                charSet = "UTF-8";
            }
            return URLEncode.decodeURIComponent((String)name, (String)charSet, (boolean)true);
        }
        catch (IllegalArgumentException ignore) {
            this.getLogger().log((Throwable)ignore);
        }
        catch (UnsupportedEncodingException ignore) {
            this.getLogger().log((Throwable)ignore);
        }
        return name;
    }

    @Override
    public DownloadInterface getDownloadInterface() {
        return this.getPlugin().getDownloadInterface();
    }

    @Override
    public void setHashInfo(HashInfo hashInfo) {
        if (hashInfo == null) {
            return;
        }
        if (!hashInfo.isTrustworthy()) {
            return;
        }
        HashInfo existingHashInfo = this.getHashInfo();
        if (existingHashInfo == null || hashInfo.equals(existingHashInfo) || hashInfo.isStrongerThan(existingHashInfo)) {
            this.getDownloadLink().setHashInfo(hashInfo);
        }
    }

    @Override
    public int getChunks() {
        return this.getDownloadLink().getChunks();
    }

    public static boolean isCrcHashingInProgress() {
        return crcHashingInProgress;
    }
}

