/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.util.Locale;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.formatter.HexFormatter;

public class HashInfo {
    private final String hash;
    private final TYPE type;
    private final boolean trustworthy;
    private final boolean forced;

    public boolean isStrongerThan(HashInfo hashInfo) {
        if (hashInfo != null) {
            return this.getType().ordinal() < hashInfo.getType().ordinal();
        }
        return true;
    }

    public String getHash() {
        return this.hash;
    }

    public TYPE getType() {
        return this.type;
    }

    public boolean isNone() {
        return TYPE.NONE.equals((Object)this.type);
    }

    public boolean isTrustworthy() {
        return this.trustworthy;
    }

    public boolean isForced() {
        return this.forced;
    }

    public String exportAsString() {
        return (Object)((Object)this.getType()) + "|" + (this.isTrustworthy() ? "1" : "0") + "|" + (this.isForced() ? "1" : "0") + "|" + this.getHash();
    }

    public static HashInfo parse(String hash) {
        return HashInfo.parse(hash, null);
    }

    public static HashInfo parse(String hash, TYPE type) {
        return HashInfo.parse(hash, type, true, false);
    }

    public static HashInfo parse(String hash, boolean isTrustWorthy, boolean isForced) {
        return HashInfo.parse(hash, null, isTrustWorthy, isForced);
    }

    public static HashInfo parse(String hash, TYPE requestedType, boolean isTrustWorthy, boolean isForced) {
        if (requestedType == null && (hash.contains(":") || hash.contains("]"))) {
            try {
                String[] hashInfos = new Regex(hash, "^\\s*(?:\\[\\s*(.*?)\\s*]|(.*?)\\s*:)\\s*([a-fA-F0-9]+)").getRow(0);
                if (hashInfos == null || hashInfos.length != 3) {
                    return null;
                }
                requestedType = hashInfos[0] != null ? TYPE.valueOf(hashInfos[0].replace("-", "")) : TYPE.valueOf(hashInfos[1].replace("-", ""));
                hash = hashInfos[2];
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (hash == null) {
            return null;
        }
        if (requestedType != null && requestedType.getSize() == hash.length()) {
            return new HashInfo(hash, requestedType, isTrustWorthy, isForced);
        }
        if (requestedType == null) {
            for (TYPE type : TYPE.values()) {
                if (!type.isAutoMode() || type.getSize() != hash.length()) continue;
                return new HashInfo(hash, type, isTrustWorthy, isForced);
            }
        }
        return null;
    }

    public static HashInfo importFromString(String hashInfo) {
        if (hashInfo != null) {
            try {
                String[] parts = hashInfo.split("\\|");
                if (parts != null) {
                    if (parts.length == 3) {
                        TYPE type = TYPE.valueOf(parts[0]);
                        boolean trustworthy = "1".equals(parts[1]);
                        return new HashInfo(parts[2], type, trustworthy);
                    }
                    if (parts.length == 4) {
                        TYPE type = TYPE.valueOf(parts[0]);
                        boolean trustworthy = "1".equals(parts[1]);
                        boolean forced = "1".equals(parts[2]);
                        return new HashInfo(parts[3], type, trustworthy, forced);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public HashInfo(String hash, TYPE type, boolean trustworthy, boolean forced) {
        if (type == null) {
            throw new IllegalArgumentException("type is missing");
        }
        this.type = type;
        if (TYPE.NONE.equals((Object)type)) {
            this.hash = "";
        } else {
            String hexHash;
            if (StringUtils.isEmpty((String)hash)) {
                throw new IllegalArgumentException("hash is empty:" + (Object)((Object)type) + "-" + hash);
            }
            if (hash.matches("^[a-fA-f0-9]{2,}$")) {
                hexHash = hash;
            } else if (hash.matches("^[a-zA-Z0-9\\+/]+={0,2}$")) {
                byte[] raw = Base64.decode((String)hash);
                String string = hexHash = raw != null ? HexFormatter.byteArrayToHex((byte[])raw) : null;
                if (hexHash == null || hexHash.length() != type.getSize()) {
                    throw new IllegalArgumentException("invalid hash size:" + (Object)((Object)type) + "-" + hash);
                }
            } else {
                throw new IllegalArgumentException("unsupported encoding:" + (Object)((Object)type) + "-" + hash);
            }
            if (StringUtils.isEmpty((String)hexHash)) {
                throw new IllegalArgumentException("hash is empty:" + (Object)((Object)type) + "-" + hash);
            }
            if (hexHash.length() < type.getSize()) {
                this.hash = String.format("%0" + (type.getSize() - hexHash.length()) + "d%s", 0, hexHash);
            } else {
                if (hexHash.length() > type.getSize()) {
                    throw new IllegalArgumentException("invalid hash size:" + (Object)((Object)type) + "-" + hash);
                }
                this.hash = hexHash.toLowerCase(Locale.ENGLISH);
            }
        }
        this.trustworthy = trustworthy;
        this.forced = forced;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HashInfo) {
            HashInfo other = (HashInfo)obj;
            return other.getType().equals((Object)this.getType()) && other.getHash().equals(this.getHash());
        }
        return false;
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    public HashInfo(String hash, TYPE type, boolean trustworthy) {
        this(hash, type, trustworthy, false);
    }

    public HashInfo(String hash, TYPE type) {
        this(hash, type, true);
    }

    public static HashInfo newInstanceSafe(String hash, TYPE type) {
        return HashInfo.newInstanceSafe(hash, type, true);
    }

    public static HashInfo newInstanceSafe(String hash, TYPE type, boolean trustworthy) {
        return HashInfo.newInstanceSafe(hash, type, trustworthy, false);
    }

    public static HashInfo newInstanceSafe(String hash, TYPE type, boolean trustworthy, boolean forced) {
        try {
            return new HashInfo(hash, type, trustworthy, forced);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String toString() {
        return "HashInfo:TYPE:" + (Object)((Object)this.type) + "|Hash:" + this.hash + "|Trustworthy:" + this.trustworthy + "|Forced:" + this.forced;
    }

    public static enum TYPE {
        SHA512("SHA-512", 128),
        WHIRLPOOL("WHIRLPOOL", 128, false),
        SHA384("SHA-384", 96),
        SHA256("SHA-256", 64),
        SHA224("SHA-224", 56),
        SHA1("SHA1", 40),
        MD5("MD5", 32),
        CRC32C("CRC32C", 8, false),
        CRC32("CRC32", 8),
        NONE("NONE", 0, false);

        private final String digest;
        private final int size;
        private final boolean autoMode;

        protected boolean isAutoMode() {
            return this.autoMode;
        }

        public final String getDigest() {
            return this.digest;
        }

        private TYPE(String digest, int size) {
            this(digest, size, true);
        }

        private TYPE(String digest, int size, boolean autoMode) {
            this.digest = digest;
            this.size = size;
            this.autoMode = autoMode;
        }

        public final int getSize() {
            return this.size;
        }
    }
}

