/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import jd.plugins.download.HashInfo;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.FinalLinkState;

public class HashResult {
    private final HashInfo hashInfo;
    private final String fileHash;

    public String getFileHash() {
        return this.fileHash;
    }

    public HashResult(HashInfo hashInfo, String fileHash) {
        this.hashInfo = hashInfo;
        this.fileHash = fileHash;
    }

    public FinalLinkState getFinalLinkState() {
        if (this.match()) {
            switch (this.getHashInfo().getType()) {
                case WHIRLPOOL: {
                    return FinalLinkState.FINISHED_WHIRLPOOL;
                }
                case SHA512: {
                    return FinalLinkState.FINISHED_SHA512;
                }
                case SHA384: {
                    return FinalLinkState.FINISHED_SHA384;
                }
                case SHA256: {
                    return FinalLinkState.FINISHED_SHA256;
                }
                case SHA224: {
                    return FinalLinkState.FINISHED_SHA224;
                }
                case SHA1: {
                    return FinalLinkState.FINISHED_SHA1;
                }
                case MD5: {
                    return FinalLinkState.FINISHED_MD5;
                }
                case CRC32: {
                    return FinalLinkState.FINISHED_CRC32;
                }
            }
            return FinalLinkState.FINISHED;
        }
        switch (this.getHashInfo().getType()) {
            case WHIRLPOOL: {
                return FinalLinkState.FAILED_WHIRLPOOL;
            }
            case SHA512: {
                return FinalLinkState.FAILED_SHA512;
            }
            case SHA384: {
                return FinalLinkState.FAILED_SHA384;
            }
            case SHA256: {
                return FinalLinkState.FAILED_SHA256;
            }
            case SHA224: {
                return FinalLinkState.FAILED_SHA224;
            }
            case SHA1: {
                return FinalLinkState.FAILED_SHA1;
            }
            case MD5: {
                return FinalLinkState.FAILED_MD5;
            }
            case CRC32: {
                return FinalLinkState.FAILED_CRC32;
            }
        }
        return FinalLinkState.FAILED;
    }

    public boolean match() {
        return StringUtils.equalsIgnoreCase((String)this.hashInfo.getHash(), (String)this.fileHash);
    }

    public HashInfo getHashInfo() {
        return this.hashInfo;
    }

    public String toString() {
        return "HashInfo: " + this.hashInfo + "|HashResult:" + this.getFileHash() + "=" + this.match();
    }
}

