/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.SimpleFTP;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import jd.plugins.download.HashResult;
import jd.plugins.download.SparseFile;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.jna.windows.FileSystemHelper;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.translate._JDT;

public class SimpleFTPDownloadInterface
extends DownloadInterface {
    private final Downloadable downloadable;
    private final ManagedThrottledConnectionHandler connectionHandler;
    private final LogInterface logger;
    private final SimpleFTP simpleFTP;
    private String filePath;
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private File outputCompleteFile;
    private File outputFinalCompleteFile;
    private File outputPartFile;
    protected PluginException caughtPluginException = null;
    protected long totalLinkBytesLoaded = -1L;
    protected final AtomicLong totalLinkBytesLoadedLive = new AtomicLong(0L);
    private long startTimeStamp = -1L;
    private long lastModifiedTimeStamp = -1L;
    private boolean resumed = false;

    public SimpleFTPDownloadInterface(SimpleFTP simpleFTP, final DownloadLink link, String filePath) {
        this.connectionHandler = new ManagedThrottledConnectionHandler();
        final String host = SocketConnection.getHostName((SocketAddress)simpleFTP.getControlSocket().getSocket().getRemoteSocketAddress());
        this.downloadable = new DownloadLinkDownloadable(link){

            @Override
            public boolean isResumable() {
                return link.getBooleanProperty("RESUME", true);
            }

            @Override
            public void setResumeable(boolean value) {
                link.setProperty("RESUME", value);
                super.setResumeable(value);
            }

            @Override
            public String getHost() {
                return host;
            }
        };
        if (!link.hasProperty("PROPERTY_RESUMEABLE")) {
            this.downloadable.setResumeable(true);
        }
        this.filePath = filePath;
        this.logger = this.downloadable.getLogger();
        this.downloadable.setDownloadInterface(this);
        this.simpleFTP = simpleFTP;
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    private void createOutputFiles() throws SkipReasonException {
        try {
            String fileOutput = this.downloadable.getFileOutput();
            this.logger.info("createOutputChannel for " + fileOutput);
            String finalFileOutput = this.downloadable.getFinalFileOutput();
            this.outputFinalCompleteFile = this.outputCompleteFile = new File(fileOutput);
            if (!fileOutput.equals(finalFileOutput)) {
                this.outputFinalCompleteFile = new File(finalFileOutput);
            }
            this.outputPartFile = new File(this.downloadable.getFileOutputPart());
            try {
                if (Application.getJavaVersion() >= Application.JAVA17) {
                    SparseFile.createSparseFile(this.outputPartFile);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        throw new WTFException("Not needed for SimpleFTPDownloadInterface");
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.totalLinkBytesLoadedLive.get();
    }

    /*
     * Exception decompiling
     */
    protected void download(String filename, boolean resume) throws IOException, PluginException, SkipReasonException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void close(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDownload() throws Exception {
        block22: {
            boolean bl;
            try {
                this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
                final DiskSpaceReservation reservation = this.downloadable.createDiskSpaceReservation();
                DownloadPluginProgress downloadPluginProgress = null;
                try {
                    if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

                        @Override
                        public void run() throws Exception {
                            SimpleFTPDownloadInterface.this.downloadable.checkAndReserve(reservation);
                            SimpleFTPDownloadInterface.this.createOutputFiles();
                            try {
                                SimpleFTPDownloadInterface.this.downloadable.lockFiles(SimpleFTPDownloadInterface.this.outputCompleteFile, SimpleFTPDownloadInterface.this.outputFinalCompleteFile, SimpleFTPDownloadInterface.this.outputPartFile);
                            }
                            catch (FileIsLockedException e) {
                                SimpleFTPDownloadInterface.this.downloadable.unlockFiles(SimpleFTPDownloadInterface.this.outputCompleteFile, SimpleFTPDownloadInterface.this.outputFinalCompleteFile, SimpleFTPDownloadInterface.this.outputPartFile);
                                throw new PluginException(8192, null, e);
                            }
                        }
                    }, null)) {
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                    }
                    this.startTimeStamp = System.currentTimeMillis();
                    downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
                    this.downloadable.addPluginProgress(downloadPluginProgress);
                    this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                    this.download(this.filePath, this.downloadable.isResumable());
                }
                catch (Throwable throwable) {
                    try {
                        this.downloadable.free(reservation);
                    }
                    catch (Throwable e) {
                        LogSource.exception((LogInterface)this.logger, (Throwable)e);
                    }
                    try {
                        long startTimeStamp = this.getStartTimeStamp();
                        if (startTimeStamp > 0L) {
                            this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.downloadable.removePluginProgress(downloadPluginProgress);
                    throw throwable;
                }
                try {
                    this.downloadable.free(reservation);
                }
                catch (Throwable e) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)e);
                }
                try {
                    long startTimeStamp = this.getStartTimeStamp();
                    if (startTimeStamp > 0L) {
                        this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                    }
                }
                catch (Throwable startTimeStamp) {
                    // empty catch block
                }
                this.downloadable.removePluginProgress(downloadPluginProgress);
                if (!this.isDownloadComplete()) break block22;
                this.logger.info("Download is complete");
                HashResult hashResult = this.getHashResult(this.downloadable, this.outputPartFile);
                if (hashResult != null) {
                    this.logger.info(hashResult.toString());
                    this.downloadable.setHashResult(hashResult);
                }
                if (hashResult == null || hashResult.match()) {
                    this.downloadable.setVerifiedFileSize(this.outputPartFile.length());
                } else if (hashResult.getHashInfo().isTrustworthy()) {
                    throw new PluginException(16384, _JDT.T.system_download_doCRC2_failed((Object)hashResult.getHashInfo().getType()));
                }
                this.finalizeDownload(this.outputPartFile, this.outputCompleteFile);
                this.downloadable.setLinkStatus(2);
                bl = true;
            }
            catch (Throwable throwable) {
                this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                this.cleanupDownladInterface();
                throw throwable;
            }
            this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
            this.cleanupDownladInterface();
            return bl;
        }
        if (!this.externalDownloadStop()) {
            throw new PluginException(512, _JDT.T.download_error_message_incomplete());
        }
        boolean bl = false;
        this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
        this.cleanupDownladInterface();
        return bl;
    }

    private boolean isDownloadComplete() throws Exception {
        long verifiedFileSize = this.downloadable.getVerifiedFileSize();
        if (verifiedFileSize >= 0L) {
            if (this.totalLinkBytesLoaded > verifiedFileSize && this.resumed) {
                this.logger.severe("It seems the ftp server has buggy REST support: transfered=" + this.totalLinkBytesLoaded + " fileSize=" + verifiedFileSize);
                this.outputPartFile.delete();
                this.downloadable.setDownloadBytesLoaded(0L);
                this.downloadable.setResumeable(false);
                throw new PluginException(4);
            }
            return this.totalLinkBytesLoaded == verifiedFileSize;
        }
        return !this.externalDownloadStop() && !this.isTerminated();
    }

    private boolean isTerminated() {
        return this.terminated.get();
    }

    private void finalizeDownload(File outputPartFile, File outputCompleteFile) throws Exception {
        if (this.downloadable.rename(outputPartFile, outputCompleteFile)) {
            try {
                if (this.lastModifiedTimeStamp != -1L) {
                    outputCompleteFile.setLastModified(this.lastModifiedTimeStamp);
                } else {
                    outputCompleteFile.setLastModified(System.currentTimeMillis());
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            try {
                if (CrossSystem.isWindows()) {
                    this.logger.info("Removed SparseFlag:" + outputCompleteFile + "|" + FileSystemHelper.FSCTL_SET_SPARSE(outputCompleteFile, false));
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        } else {
            throw new PluginException(16384, _JDT.T.system_download_errors_couldnotrename(), 2L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(PluginException pluginException) {
        SimpleFTPDownloadInterface simpleFTPDownloadInterface = this;
        synchronized (simpleFTPDownloadInterface) {
            if (this.externalDownloadStop()) {
                return;
            }
            LogSource.exception((LogInterface)this.logger, (Throwable)pluginException);
            if (this.caughtPluginException == null) {
                this.caughtPluginException = pluginException;
            }
        }
        this.terminate();
    }

    private void cleanupDownladInterface() {
        try {
            this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.simpleFTP.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected long getFileSize() {
        return this.downloadable.getVerifiedFileSize();
    }

    public boolean handleErrors() throws PluginException {
        if (this.externalDownloadStop()) {
            return false;
        }
        if (this.getFileSize() > 0L && this.totalLinkBytesLoaded != this.getFileSize()) {
            if (this.totalLinkBytesLoaded > this.getFileSize()) {
                this.logger.severe("Filesize: " + this.getFileSize() + " Loaded: " + this.totalLinkBytesLoaded);
                if (this.caughtPluginException == null) {
                    this.downloadable.setLinkStatus(2);
                }
                return true;
            }
            this.logger.severe("Filesize: " + this.getFileSize() + " Loaded: " + this.totalLinkBytesLoaded);
            this.logger.severe("DOWNLOAD INCOMPLETE DUE TO FILESIZECHECK");
            if (this.caughtPluginException != null) {
                throw this.caughtPluginException;
            }
            throw new PluginException(512, _JDT.T.download_error_message_incomplete());
        }
        if (this.caughtPluginException == null) {
            this.downloadable.setLinkStatus(2);
            this.downloadable.setVerifiedFileSize(this.outputCompleteFile.length());
            return true;
        }
        throw this.caughtPluginException;
    }

    @Override
    public URLConnectionAdapter getConnection() {
        throw new WTFException("Not needed for SimpleFTPDownloadInterface");
    }

    @Override
    public void stopDownload() {
        if (!this.abort.getAndSet(true)) {
            this.logger.info("externalStop recieved");
            this.terminate();
        }
    }

    protected void terminate() {
        if (!this.terminated.getAndSet(true) && !this.externalDownloadStop()) {
            this.logger.severe("A critical Downloaderror occured. Terminate...");
        }
    }

    @Override
    public boolean externalDownloadStop() {
        return this.abort.get();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public void close() {
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    @Override
    public boolean isResumedDownload() {
        return this.resumed;
    }
}

