/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ChunkRange {
    private final long from;
    private final Long to;
    private final AtomicLong loaded = new AtomicLong(0L);
    private final AtomicBoolean validLoaded = new AtomicBoolean(false);
    private final boolean rangeRequested;

    public long getFrom() {
        return this.from;
    }

    public Long getTo() {
        return this.to;
    }

    public long getLength() {
        Long to = this.getTo();
        if (to == null || to < 0L) {
            return -1L;
        }
        long from = this.getFrom();
        return to - from + 1L;
    }

    public boolean isRangeRequested() {
        return this.rangeRequested;
    }

    public void reset() {
        this.validLoaded.set(false);
        this.loaded.set(0L);
    }

    public boolean isValidLoaded() {
        return this.validLoaded.get();
    }

    public void setValidLoaded(boolean validLoaded) {
        this.validLoaded.set(validLoaded);
    }

    public ChunkRange() {
        this.rangeRequested = false;
        this.from = 0L;
        this.to = null;
    }

    public ChunkRange(long from) {
        this(from, null);
    }

    public String getRangeHeaderContent(boolean openEnd) {
        long from = this.getFrom();
        Long to = this.getTo();
        if (from < 0L) {
            return null;
        }
        if (to == null || to < 0L || openEnd) {
            return "bytes=" + from + "-";
        }
        return "bytes=" + from + "-" + to;
    }

    public ChunkRange(long from, Long to) {
        if (from < 0L) {
            throw new IllegalArgumentException("from(" + from + ") < 0");
        }
        if (to != null && to >= 0L && from > to) {
            throw new IllegalArgumentException("from(" + from + ") > to(" + to + ")");
        }
        this.rangeRequested = true;
        this.from = from;
        this.to = to;
    }

    public long getLoaded() {
        return this.loaded.get();
    }

    public long getPosition() {
        return this.from + this.getLoaded();
    }

    public void incLoaded(long incr) {
        if (incr > 0L) {
            this.loaded.addAndGet(incr);
        }
    }

    public String toString() {
        return "ChunkRange: " + this.getFrom() + "-" + this.getTo() + "/" + this.getLength() + "|" + this.getLoaded() + "=" + this.isValidLoaded();
    }
}

