/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jd.plugins.download.raf.FileBytesMapViewInterface;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;

public class FileBytesMap {
    protected final ArrayList<FileBytesMapEntry> fileBytesMapEntries = new ArrayList();
    protected static final Comparator<FileBytesMapEntry> sorter = new Comparator<FileBytesMapEntry>(){

        @Override
        private int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(FileBytesMapEntry o1, FileBytesMapEntry o2) {
            return this.compare(o1.getBegin(), o2.getBegin());
        }
    };
    protected volatile long finalSize = -1L;
    protected volatile long markedBytes = 0L;

    protected ArrayList<FileBytesMapEntry> getFileBytesMapEntries() {
        return this.fileBytesMapEntries;
    }

    public long getFinalSize() {
        return this.finalSize;
    }

    public synchronized void set(FileBytesMapViewInterface fileBytesMapInfo) {
        this.reset();
        this.setFinalSize(fileBytesMapInfo.getFinalSize());
        for (long[] markedArea : fileBytesMapInfo.getMarkedAreas()) {
            this.mark(markedArea[0], markedArea[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(FileBytesMap fileBytesMap) {
        FileBytesMap fileBytesMap2 = fileBytesMap;
        synchronized (fileBytesMap2) {
            this.reset();
            this.setFinalSize(fileBytesMap.getFinalSize());
            ArrayList<FileBytesMapEntry> mapEntries = fileBytesMap.getFileBytesMapEntries();
            for (int index = 0; index < mapEntries.size(); ++index) {
                FileBytesMapEntry fileBytesMapEntry = (FileBytesMapEntry)mapEntries.get(index);
                this.mark(fileBytesMapEntry.getBegin(), fileBytesMapEntry.getLength());
            }
        }
    }

    public void setFinalSize(long finalSize) {
        this.finalSize = Math.max(-1L, finalSize);
    }

    public synchronized void resetMarkedBytesLive() {
        this.markedBytes = 0L;
    }

    public static void main(String[] args) {
        FileBytesMap test = new FileBytesMap();
        test.setFinalSize(100L);
        test.mark(0L, 10L);
        System.out.println(test);
        long begin = 4L;
        int length = 10;
        long skip = test.skippable(begin, length);
        if (skip < (long)length) {
            System.out.println("Skip:" + skip + "|Mark:" + test.mark(begin += (long)((int)skip), length -= (int)skip));
            System.out.println(test);
        } else {
            System.out.println("Skip:" + skip);
        }
    }

    public synchronized long skippable(long markedAreaBegin, long markedAreaLength) {
        long markedAreaEnd = markedAreaBegin + markedAreaLength - 1L;
        for (int index = 0; index < this.fileBytesMapEntries.size(); ++index) {
            FileBytesMapEntry currentFileBytesMapEntry = this.fileBytesMapEntries.get(index);
            if (markedAreaBegin < currentFileBytesMapEntry.getBegin() || markedAreaBegin > currentFileBytesMapEntry.getEnd()) continue;
            if (markedAreaEnd <= currentFileBytesMapEntry.getEnd()) {
                return markedAreaLength;
            }
            long skippable = currentFileBytesMapEntry.getEnd() - markedAreaBegin + 1L;
            return skippable;
        }
        return 0L;
    }

    public synchronized long mark(long markedAreaBegin, long markedAreaLength) {
        if (markedAreaLength <= 0L) {
            throw new IllegalArgumentException("invalid length");
        }
        long markedAreaEnd = markedAreaBegin + markedAreaLength - 1L;
        long finalSize = this.getFinalSize();
        if (finalSize >= 0L && markedAreaEnd + 1L > finalSize) {
            throw new IllegalArgumentException("invalid mark:finalSize:" + finalSize + "|markEnd:" + (markedAreaEnd + 1L));
        }
        int checkOverlapIndex = -1;
        for (int index = 0; index < this.fileBytesMapEntries.size(); ++index) {
            FileBytesMapEntry currentFileBytesMapEntry = this.fileBytesMapEntries.get(index);
            if (markedAreaBegin >= currentFileBytesMapEntry.getBegin() && markedAreaBegin <= currentFileBytesMapEntry.getEnd()) {
                if (markedAreaEnd <= currentFileBytesMapEntry.getEnd()) {
                    return -markedAreaLength;
                }
                markedAreaLength = markedAreaEnd - currentFileBytesMapEntry.getEnd();
                currentFileBytesMapEntry.modifyLength(markedAreaLength);
                this.markedBytes += markedAreaLength;
                checkOverlapIndex = index;
                break;
            }
            if (markedAreaBegin != currentFileBytesMapEntry.getEnd() + 1L) continue;
            currentFileBytesMapEntry.modifyLength(markedAreaLength);
            this.markedBytes += markedAreaLength;
            checkOverlapIndex = index;
            break;
        }
        if (checkOverlapIndex >= 0) {
            if (checkOverlapIndex < this.fileBytesMapEntries.size() - 1) {
                FileBytesMapEntry baseFileBytesMapEntry = this.fileBytesMapEntries.get(checkOverlapIndex);
                Iterator<FileBytesMapEntry> it = this.fileBytesMapEntries.subList(checkOverlapIndex + 1, this.fileBytesMapEntries.size()).iterator();
                while (it.hasNext()) {
                    FileBytesMapEntry nextFileBytesMapEntry = it.next();
                    if (baseFileBytesMapEntry.getEnd() >= nextFileBytesMapEntry.getBegin()) {
                        it.remove();
                        if (nextFileBytesMapEntry.getEnd() <= baseFileBytesMapEntry.getEnd()) {
                            this.markedBytes -= nextFileBytesMapEntry.getLength();
                            markedAreaLength -= nextFileBytesMapEntry.getLength();
                            continue;
                        }
                        long markedBytesOffset = baseFileBytesMapEntry.getEnd() - nextFileBytesMapEntry.getBegin() + 1L;
                        this.markedBytes -= markedBytesOffset;
                        long lengthOffset = nextFileBytesMapEntry.getEnd() - baseFileBytesMapEntry.getEnd();
                        baseFileBytesMapEntry.modifyLength(lengthOffset);
                        markedAreaLength += lengthOffset;
                        continue;
                    }
                    if (nextFileBytesMapEntry.getBegin() != baseFileBytesMapEntry.getEnd() + 1L) break;
                    it.remove();
                    baseFileBytesMapEntry.modifyLength(nextFileBytesMapEntry.getLength());
                    markedAreaLength += nextFileBytesMapEntry.getLength();
                }
            }
            return markedAreaLength;
        }
        this.fileBytesMapEntries.add(new FileBytesMapEntry(markedAreaBegin, markedAreaLength));
        this.markedBytes += markedAreaLength;
        Collections.sort(this.fileBytesMapEntries, sorter);
        return markedAreaLength;
    }

    public synchronized List<Long[]> getUnMarkedAreas() {
        ArrayList<Long[]> ret = new ArrayList<Long[]>();
        for (int index = 0; index < this.fileBytesMapEntries.size(); ++index) {
            FileBytesMapEntry currentMapEntry = this.fileBytesMapEntries.get(index);
            long unMarkedBegin = currentMapEntry.getEnd() + 1L;
            if (index + 1 < this.fileBytesMapEntries.size()) {
                FileBytesMapEntry nextMapEntry = this.fileBytesMapEntries.get(index + 1);
                ret.add(new Long[]{unMarkedBegin, nextMapEntry.getBegin() - 1L});
                continue;
            }
            long finalSize = this.getFinalSize();
            if (finalSize >= 0L) {
                if (unMarkedBegin >= finalSize) continue;
                ret.add(new Long[]{unMarkedBegin, finalSize - 1L});
                continue;
            }
            ret.add(new Long[]{unMarkedBegin, -1L});
        }
        if (this.fileBytesMapEntries.size() == 0) {
            long finalSize = this.getFinalSize();
            if (finalSize == 0L) {
                return ret;
            }
            if (finalSize > 0L) {
                ret.add(new Long[]{0L, finalSize - 1L});
            } else {
                ret.add(new Long[]{0L, -1L});
            }
        }
        return ret;
    }

    public synchronized void reset() {
        this.fileBytesMapEntries.clear();
        this.markedBytes = 0L;
        this.finalSize = -1L;
    }

    public synchronized long getSize() {
        long size = this.getFinalSize();
        if (size >= 0L) {
            return size;
        }
        if (this.fileBytesMapEntries.size() > 0) {
            long end = this.fileBytesMapEntries.get(this.fileBytesMapEntries.size() - 1).getEnd();
            return end + 1L;
        }
        return -1L;
    }

    public synchronized long getUnMarkedBytes() {
        return Math.max(0L, this.getSize()) - this.getMarkedBytes();
    }

    public long getMarkedBytesLive() {
        return this.markedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        FileBytesMap fileBytesMap = this;
        synchronized (fileBytesMap) {
            sb.append("FileBytesMap: " + this.getMarkedBytesLive() + "/" + this.getSize());
            sb.append("\r\n");
            sb.append("Marked:");
            sb.append(this.fileBytesMapEntries.toString());
            sb.append("\r\n");
            sb.append("UnMarked:");
            ArrayList<FileBytesMapEntry> unMarkedAreas = new ArrayList<FileBytesMapEntry>();
            for (Long[] unMarkedArea : this.getUnMarkedAreas()) {
                if (unMarkedArea[0] >= unMarkedArea[1]) continue;
                unMarkedAreas.add(new FileBytesMapEntry(unMarkedArea[0], unMarkedArea[1] - unMarkedArea[0] + 1L));
            }
            sb.append(unMarkedAreas.toString());
        }
        return sb.toString();
    }

    public synchronized long getMarkedBytes() {
        long ret = 0L;
        for (int index = 0; index < this.fileBytesMapEntries.size(); ++index) {
            FileBytesMapEntry fileBytesMapEntry = this.fileBytesMapEntries.get(index);
            ret += fileBytesMapEntry.getLength();
        }
        return ret;
    }

    public static class FileBytesMapView
    implements FileBytesMapViewInterface {
        protected final long finalSize;
        protected final long marked;
        protected final long size;
        protected final long[][] markedAreas;

        @Override
        public long[][] getMarkedAreas() {
            return this.markedAreas;
        }

        @Override
        public long getFinalSize() {
            return this.finalSize;
        }

        public long getSize() {
            return this.size;
        }

        public long getUnMarkedBytes() {
            return Math.max(0L, this.getSize()) - this.getMarkedBytes();
        }

        public long getMarkedBytes() {
            return this.marked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileBytesMapView(FileBytesMap fileBytesMap) {
            FileBytesMap fileBytesMap2 = fileBytesMap;
            synchronized (fileBytesMap2) {
                this.finalSize = fileBytesMap.getFinalSize();
                ArrayList<FileBytesMapEntry> mapEntries = fileBytesMap.getFileBytesMapEntries();
                this.markedAreas = new long[mapEntries.size()][2];
                for (int index = 0; index < mapEntries.size(); ++index) {
                    FileBytesMapEntry fileBytesMapEntry = (FileBytesMapEntry)mapEntries.get(index);
                    this.markedAreas[index][0] = fileBytesMapEntry.getBegin();
                    this.markedAreas[index][1] = fileBytesMapEntry.getLength();
                }
                this.marked = fileBytesMap.getMarkedBytes();
                this.size = fileBytesMap.getSize();
            }
        }
    }

    public static class FileBytesMapViewInterfaceStorable
    implements Storable {
        protected long finalSize = -1L;
        protected List<Long[]> markedAreas = null;

        public long getFinalSize() {
            return this.finalSize;
        }

        public void setFinalSize(long finalSize) {
            this.finalSize = finalSize;
        }

        public List<Long[]> getMarkedAreas() {
            return this.markedAreas;
        }

        public void setMarkedAreas(List<Long[]> markedAreas) {
            this.markedAreas = markedAreas;
        }

        @StorableAllowPrivateAccessModifier
        private FileBytesMapViewInterfaceStorable() {
        }

        public FileBytesMapViewInterfaceStorable(FileBytesMapViewInterface fileBytesMapInfo) {
            this.finalSize = fileBytesMapInfo.getFinalSize();
            this.markedAreas = new ArrayList<Long[]>(fileBytesMapInfo.getMarkedAreas().length);
            for (long[] markedArea : fileBytesMapInfo.getMarkedAreas()) {
                this.markedAreas.add(new Long[]{markedArea[0], markedArea[1]});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileBytesMapViewInterfaceStorable(FileBytesMap fileBytesMap) {
            FileBytesMap fileBytesMap2 = fileBytesMap;
            synchronized (fileBytesMap2) {
                this.finalSize = fileBytesMap.getFinalSize();
                ArrayList<FileBytesMapEntry> mapEntries = fileBytesMap.getFileBytesMapEntries();
                this.markedAreas = new ArrayList<Long[]>(mapEntries.size());
                for (int index = 0; index < mapEntries.size(); ++index) {
                    FileBytesMapEntry fileBytesMapEntry = (FileBytesMapEntry)mapEntries.get(index);
                    this.markedAreas.add(new Long[]{fileBytesMapEntry.getBegin(), fileBytesMapEntry.getLength()});
                }
            }
        }
    }

    private static final class FileBytesMapEntry {
        private final long begin;
        private volatile long length = 0L;
        private volatile long end = 0L;

        private FileBytesMapEntry(long begin) {
            this(begin, 0L);
        }

        private FileBytesMapEntry(long begin, long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("length is negative");
            }
            this.begin = begin;
            this.modifyLength(length);
        }

        private final void updateEnd() {
            this.end = this.getBegin() + this.getLength() - 1L;
        }

        private final long getBegin() {
            return this.begin;
        }

        private final long getEnd() {
            return this.end;
        }

        private final long getLength() {
            return this.length;
        }

        private final void modifyLength(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("length is negative");
            }
            this.length += length;
            this.updateEnd();
        }

        public String toString() {
            return this.getBegin() + "-" + this.getEnd() + "=" + this.getLength();
        }
    }
}

