/*
 * Decompiled with CFR 0.152.
 */
package jd.websocket;

import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jd.http.Request;
import jd.http.RequestHeader;
import jd.http.URLConnectionAdapterDirectImpl;
import jd.http.requests.GetRequest;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;

public class WebSocketRequest
extends GetRequest {
    private static final HTTPHeader SEC_WEBSOCKET_VERSION_HEADER = new HTTPHeader("Sec-WebSocket-Version", "13");
    private static final String UPGRADE_VALUE = "Upgrade";
    private static final HTTPHeader CONNECTION_UPGRADE_HEADER = new HTTPHeader("Connection", "Upgrade");
    private static final HTTPHeader UPGRADE_HEADER = new HTTPHeader("Upgrade", "websocket");
    public static final String WEBSOCKET_ACCEPT_HASH_PREFIX = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private HTTPHeader secWebSocketKeyHeader = null;

    public WebSocketRequest(Request cloneRequest) {
        super(cloneRequest);
    }

    public WebSocketRequest(String url) throws IOException {
        super(url.replaceFirst("(^ws)", "http"));
    }

    public WebSocketRequest(URL url) throws IOException {
        super(url);
    }

    protected HTTPHeader getSecWebSocketKeyHeader() {
        if (this.secWebSocketKeyHeader == null) {
            this.secWebSocketKeyHeader = new HTTPHeader("Sec-WebSocket-Key", Base64.encodeToString((byte[])Hash.getSHA1((String)Long.toString(System.nanoTime())).getBytes(), (boolean)false).substring(0, 24));
        }
        return this.secWebSocketKeyHeader;
    }

    private HTTPHeader getConnectionUpgradeHeader(RequestHeader requestHeaders) {
        String key = CONNECTION_UPGRADE_HEADER.getKey();
        if (requestHeaders.contains(key)) {
            HTTPHeader ret = requestHeaders.getHeader(key);
            if (StringUtils.contains((String)ret.getValue(), (String)UPGRADE_VALUE)) {
                return ret;
            }
            return new HTTPHeader(CONNECTION_UPGRADE_HEADER.getKey(), ret.getValue() + ", " + UPGRADE_VALUE);
        }
        return CONNECTION_UPGRADE_HEADER;
    }

    protected RequestHeader getDefaultRequestHeader(URL url) {
        RequestHeader ret = super.getDefaultRequestHeader(url);
        ret.put(this.getConnectionUpgradeHeader(ret));
        ret.put(SEC_WEBSOCKET_VERSION_HEADER);
        ret.put(this.getSecWebSocketKeyHeader());
        ret.put(UPGRADE_HEADER);
        return ret;
    }

    public RequestHeader getHeaders() {
        RequestHeader ret = super.getHeaders();
        ret.put(SEC_WEBSOCKET_VERSION_HEADER);
        ret.put(this.getSecWebSocketKeyHeader());
        ret.put(UPGRADE_HEADER);
        ret.put(this.getConnectionUpgradeHeader(ret));
        return ret;
    }

    protected boolean verifySecWebSocketAccept(String accept) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        byte[] digest = md.digest((this.getSecWebSocketKeyHeader().getValue() + WEBSOCKET_ACCEPT_HASH_PREFIX).getBytes("UTF-8"));
        return StringUtils.equalsIgnoreCase((String)Base64.encodeToString((byte[])digest, (boolean)false), (String)accept);
    }

    public void preRequest() throws IOException {
        if (this.httpConnection instanceof URLConnectionAdapterDirectImpl) {
            URLConnectionAdapterDirectImpl httpConnection = (URLConnectionAdapterDirectImpl)this.httpConnection;
            httpConnection.setKeepAlive(HTTPConnectionImpl.KEEPALIVE.DISABLED);
        }
    }

    protected boolean requireOutputStream() {
        return true;
    }

    protected Request connect() throws IOException {
        Request ret = super.connect();
        if (this.getHttpConnection().getResponseCode() != 101) {
            throw new IOException("Switching Protocols failed:" + this.getHttpConnection().getResponseCode() + " " + this.getHttpConnection().getResponseMessage());
        }
        String secWebSocketAccept = this.getResponseHeader("Sec-WebSocket-Accept");
        if (!this.verifySecWebSocketAccept(secWebSocketAccept)) {
            throw new IOException("Sec-WebSocket-Accept: invalid");
        }
        if (!StringUtils.equalsIgnoreCase((String)this.getResponseHeader(UPGRADE_HEADER.getKey()), (String)"websocket")) {
            throw new IOException("Invalid/Missing Upgrade header");
        }
        if (!StringUtils.containsIgnoreCase((String)this.getResponseHeader(CONNECTION_UPGRADE_HEADER.getKey()), (String)UPGRADE_VALUE)) {
            throw new IOException("Invalid/Missing Connection header");
        }
        return ret;
    }
}

