/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.actions;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.appwork.swing.action.BasicAction;
import org.appwork.utils.images.IconIO;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;

public abstract class AppAction
extends BasicAction {
    protected String iconKey;
    protected int size;
    private boolean visible = true;
    public static final String VISIBLE = "visible";

    public void setAccelerator(int vkQ, int ctrlDownMask) {
        this.setAccelerator(KeyStroke.getKeyStroke(vkQ, ctrlDownMask));
    }

    public void setAccelerator(int vkQ) {
        this.setAccelerator(vkQ, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public void setIconKey(String iconKey) {
        this.iconKey = iconKey;
        this.setIconSizes(18);
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public AppAction setIconSizes(int size) {
        this.size = size;
        return this;
    }

    public Object getValue(String key) {
        if (this.iconKey != null && "SwingLargeIconKey".equalsIgnoreCase(key)) {
            return NewTheme.I().getIcon(this.iconKey, this.size);
        }
        if (this.iconKey != null && "SmallIcon".equalsIgnoreCase(key)) {
            return NewTheme.I().getIcon(this.iconKey, this.size);
        }
        return super.getValue(key);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void addVisibilityPropertyChangeListener(JComponent component) {
        final WeakReference<JComponent> weakComponent = new WeakReference<JComponent>(component);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean newVisible;
                JComponent component = (JComponent)weakComponent.get();
                if (component == null) {
                    AppAction.this.removePropertyChangeListener(this);
                    return;
                }
                if (evt.getPropertyName() == AppAction.VISIBLE && (newVisible = Boolean.TRUE.equals(evt.getNewValue())) != component.isVisible()) {
                    component.setVisible(newVisible);
                    component.firePropertyChange(AppAction.VISIBLE, !newVisible, newVisible);
                }
            }
        });
    }

    public void setVisible(boolean newValue) {
        if (this.visible == newValue) {
            return;
        }
        boolean oldValue = this.visible;
        this.visible = newValue;
        this.firePropertyChange(VISIBLE, oldValue, newValue);
    }

    public Icon getIcon(int size) {
        Icon actionIcon = null;
        String iconKey = this.getIconKey();
        if (NewTheme.I().hasIcon(iconKey)) {
            actionIcon = new AbstractIcon(iconKey, size);
        } else {
            Icon icon = (Icon)this.getValue("SwingLargeIconKey");
            if (icon == null && (icon = this.getSmallIcon()) != null) {
                actionIcon = IconIO.getScaledInstance((Icon)icon, (int)size, (int)size);
            }
        }
        return actionIcon;
    }
}

