/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.cnl2;

import java.awt.Dialog;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Icon;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcollector.LinkOriginDetails;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.CrawledLinkModifiers;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.UnknownCrawledLinkHandler;
import jd.controlling.linkcrawler.modifier.CommentModifier;
import jd.controlling.linkcrawler.modifier.DownloadFolderModifier;
import jd.controlling.linkcrawler.modifier.PackageNameModifier;
import jd.http.Browser;
import jd.plugins.DownloadLink;
import jd.utils.JDUtilities;
import net.sf.image4j.codec.ico.ICOEncoder;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.api.RemoteAPIConfig;
import org.jdownloader.api.cnl2.Cnl2APIBasics;
import org.jdownloader.api.cnl2.Cnl2APIFlash;
import org.jdownloader.api.cnl2.CnlQueryStorable;
import org.jdownloader.api.cnl2.translate.ExternInterfaceTranslation;
import org.jdownloader.api.myjdownloader.MyJDownloaderRequestInterface;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettings;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_MYJD;

public class ExternInterfaceImpl
implements Cnl2APIBasics,
Cnl2APIFlash {
    private static final String jdpath = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + File.separator + "JDownloader.jar";

    @Override
    public void crossdomainxml(RemoteAPIResponse response) throws InternalApiException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\r\n");
        sb.append("<!DOCTYPE cross-domain-policy SYSTEM \"http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd\">\r\n");
        sb.append("<cross-domain-policy>\r\n");
        sb.append("<allow-access-from domain=\"*\" />\r\n");
        sb.append("</cross-domain-policy>\r\n");
        this.writeString(response, null, sb.toString(), false);
    }

    private void writeString(RemoteAPIResponse response, RemoteAPIRequest request, String string, boolean wrapCallback) throws InternalApiException {
        OutputStream out = null;
        try {
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html", false));
            out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)false, (boolean)true);
            if (wrapCallback && request.getJqueryCallback() != null) {
                if (string == null) {
                    string = "";
                }
                string = "{\"content\": \"" + string.trim() + "\"}";
            }
            out.write(string.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            throw new InternalApiException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void jdcheckjs(RemoteAPIRequest request, RemoteAPIResponse response) throws InternalApiException {
        StringBuilder sb = new StringBuilder();
        sb.append("jdownloader=true;\r\n");
        sb.append("var version='" + JDUtilities.getRevision() + "';\r\n");
        this.writeString(response, null, sb.toString(), false);
    }

    @Override
    public void jdcheckjson(RemoteAPIRequest request, RemoteAPIResponse response) throws InternalApiException {
        MyJDownloaderSettings set = CFG_MYJD.CFG;
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("version", JDUtilities.getRevision());
        obj.put("deviceId", set.getUniqueDeviceIDV2());
        obj.put("name", set.getDeviceName());
        this.writeString(response, null, JSonStorage.getMapper().objectToString(obj), false);
    }

    @Override
    public void addcrypted2(RemoteAPIResponse response, RemoteAPIRequest request) throws InternalApiException {
        try {
            CnlQueryStorable cnl = new CnlQueryStorable();
            cnl.setCrypted(request.getParameterbyKey("crypted"));
            cnl.setJk(request.getParameterbyKey("jk"));
            cnl.setKey(request.getParameterbyKey("k"));
            if (StringUtils.isEmpty((String)cnl.getCrypted()) || StringUtils.isEmpty((String)cnl.getJk()) && StringUtils.isEmpty((String)cnl.getKey())) {
                this.writeString(response, request, "failed\r\n", true);
                return;
            }
            String[] passwords = request.getParametersbyKey("passwords[]");
            if (passwords == null) {
                passwords = request.getParametersbyKey("passwords");
            }
            if (passwords != null) {
                cnl.setPasswords(Arrays.asList(passwords));
            }
            cnl.setSource(request.getParameterbyKey("source"));
            this.addcnl(response, request, cnl);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.writeString(response, request, "failed " + e.getMessage() + "\r\n", true);
        }
    }

    private String sourceWorkaround(String source) {
        block3: {
            if (source != null) {
                try {
                    return new URL(source).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!source.contains("filecrypt.cc")) break block3;
                    return "http://filecrypt.cc";
                }
            }
        }
        return source;
    }

    @Override
    public void addcrypted2Remote(RemoteAPIResponse response, RemoteAPIRequest request, String crypted, String jk, String source) {
        try {
            source = this.sourceWorkaround(source);
            this.askPermission(request, source, null);
            if (StringUtils.isEmpty((String)crypted) || StringUtils.isEmpty((String)jk)) {
                return;
            }
            String dummyCNL = this.createDummyCNL(crypted, jk, null);
            LinkCollectingJob job = new LinkCollectingJob(LinkOriginDetails.getInstance(LinkOrigin.CNL, request.getRequestHeaders().getValue("user-agent")), dummyCNL);
            job.setCustomSourceUrl(source);
            LinkCollector.getInstance().addCrawlerJob(job);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String cleanupPackageName(RemoteAPIRequest request, String name) throws IOException {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        String ret = name.replaceFirst("\\s*-\\s*[a-z0-9\\-]+\\.[a-z]{2,3}\\s*$", "");
        return ret;
    }

    private String getPackageName(RemoteAPIRequest request) throws IOException {
        String ret = request.getParameterbyKey("package");
        if (StringUtils.isNotEmpty((String)ret)) {
            return this.cleanupPackageName(request, ret);
        }
        ret = request.getParameterbyKey("source");
        if (ret != null && !ret.matches("^([a-z0-9\\-]+\\.){1,}[a-z0-9]+$") && StringUtils.containsIgnoreCase((String)request.getParameterbyKey("passwords"), (String)"filecrypt.cc")) {
            return this.cleanupPackageName(request, ret);
        }
        return null;
    }

    @Override
    public void addcnl(RemoteAPIResponse response, RemoteAPIRequest request, final CnlQueryStorable cnl) throws InternalApiException {
        try {
            String packageName = this.getPackageName(request);
            if (packageName != null) {
                cnl.setPackageName(packageName);
            }
            this.askPermission(request, cnl.getSource(), cnl.isPermission());
            ArrayList<LinkCollectingJob> jobs = new ArrayList<LinkCollectingJob>();
            if (StringUtils.isNotEmpty((String)cnl.getCrypted()) && (StringUtils.isNotEmpty((String)cnl.getJk()) || StringUtils.isNotEmpty((String)cnl.getKey()))) {
                String jk = cnl.getJk();
                String dummyCNL = this.createDummyCNL(cnl.getCrypted(), jk, cnl.getKey());
                jobs.add(new LinkCollectingJob(LinkOriginDetails.getInstance(LinkOrigin.CNL, request.getRequestHeaders().getValue("user-agent")), dummyCNL));
            }
            if (StringUtils.isNotEmpty((String)cnl.getUrls())) {
                String urls = cnl.getUrls();
                jobs.add(new LinkCollectingJob(LinkOriginDetails.getInstance(LinkOrigin.CNL, request.getRequestHeaders().getValue("user-agent")), urls));
            }
            if (jobs.size() > 0) {
                ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
                if (cnl.getAutostart() != null) {
                    modifiers.add(new CrawledLinkModifier(){

                        @Override
                        public boolean modifyCrawledLink(CrawledLink link) {
                            link.setAutoConfirmEnabled(cnl.getAutostart());
                            link.setAutoStartEnabled(cnl.getAutostart());
                            return true;
                        }
                    });
                }
                if (cnl.getPasswords() != null && cnl.getPasswords().size() > 0) {
                    for (LinkCollectingJob job : jobs) {
                        job.setArchivPasswords(cnl.getPasswords());
                    }
                    modifiers.add(new CrawledLinkModifier(){

                        @Override
                        public boolean modifyCrawledLink(CrawledLink link) {
                            link.getArchiveInfo().getExtractionPasswords().addAll(cnl.getPasswords());
                            return true;
                        }
                    });
                }
                if (StringUtils.isNotEmpty((String)cnl.getComment())) {
                    modifiers.add(new CommentModifier(cnl.getComment()));
                }
                if (StringUtils.isNotEmpty((String)cnl.getPackageName())) {
                    PackageNameModifier mod = new PackageNameModifier(cnl.getPackageName(), false);
                    modifiers.add(mod);
                }
                if (StringUtils.isNotEmpty((String)cnl.getDir())) {
                    modifiers.add(new DownloadFolderModifier(cnl.getDir(), false));
                }
                if (StringUtils.isNotEmpty((String)cnl.getReferrer())) {
                    modifiers.add(new CrawledLinkModifier(){

                        @Override
                        public boolean modifyCrawledLink(CrawledLink link) {
                            DownloadLink downloadLink = link.getDownloadLink();
                            if (downloadLink != null) {
                                downloadLink.setReferrerUrl(cnl.getReferrer());
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (StringUtils.isNotEmpty((String)cnl.getSource())) {
                    modifiers.add(new CrawledLinkModifier(){

                        @Override
                        public boolean modifyCrawledLink(CrawledLink link) {
                            DownloadLink downloadLink = link.getDownloadLink();
                            if (downloadLink != null) {
                                downloadLink.setOriginUrl(cnl.getSource());
                                return true;
                            }
                            return false;
                        }
                    });
                }
                CrawledLinkModifiers modifier = modifiers.size() > 0 ? new CrawledLinkModifiers(modifiers) : null;
                for (LinkCollectingJob job : jobs) {
                    job.addPrePackagizerModifier(modifier);
                    LinkCollector.getInstance().addCrawlerJob(job);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getLongerString(String a, String b) {
        if (a != null && b != null) {
            if (a.length() > b.length()) {
                return a;
            }
            return b;
        }
        if (a != null && b == null) {
            return a;
        }
        if (b != null && a == null) {
            return b;
        }
        return null;
    }

    private void clickAndLoad2Add(LinkOriginDetails origin, String urls, RemoteAPIRequest request) throws IOException {
        String finalPasswords = request.getParameterbyKey("passwords");
        String source = request.getParameterbyKey("source");
        String referer = request.getRequestHeaders().getValue("Referer");
        String linkComment = request.getParameterbyKey("comment");
        LinkCollectingJob job = new LinkCollectingJob(origin, urls);
        String finalDestination = request.getParameterbyKey("dir");
        String packageName = this.getPackageName(request);
        if (source != null && !StringUtils.startsWithCaseInsensitive((String)source, (String)"http://") && !StringUtils.startsWithCaseInsensitive((String)source, (String)"https://")) {
            source = null;
        }
        if (source != null) {
            job.setCustomSourceUrl(this.getLongerString(source, referer));
        } else {
            job.setCustomSourceUrl(referer);
        }
        String finalPackageName = packageName;
        String finalComment = linkComment;
        ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
        ArrayList<CrawledLinkModifier> requiredPreModifiers = new ArrayList<CrawledLinkModifier>();
        if (StringUtils.isNotEmpty((String)finalDestination)) {
            modifiers.add(new DownloadFolderModifier(finalDestination, true));
        }
        if (StringUtils.isNotEmpty((String)finalPackageName)) {
            PackageNameModifier mod = new PackageNameModifier(finalPackageName, true);
            modifiers.add(mod);
            requiredPreModifiers.add(mod);
        }
        if (StringUtils.isNotEmpty((String)finalComment)) {
            modifiers.add(new CommentModifier(finalComment));
        }
        if (StringUtils.isNotEmpty((String)finalPasswords)) {
            final ArrayList<String> pws = new ArrayList<String>();
            pws.add(finalPasswords);
            job.setArchivPasswords(pws);
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.getArchiveInfo().getExtractionPasswords().addAll(pws);
                    return true;
                }
            });
        }
        if (modifiers.size() > 0) {
            if (StringUtils.isNotEmpty((String)finalPackageName) || StringUtils.isNotEmpty((String)finalDestination)) {
                job.addPrePackagizerModifier(new CrawledLinkModifiers(requiredPreModifiers));
                job.addPostPackagizerModifier(new CrawledLinkModifiers(modifiers));
            } else {
                job.addPrePackagizerModifier(new CrawledLinkModifiers(modifiers));
            }
        }
        LinkCollector.getInstance().addCrawlerJob(job);
    }

    private String createDummyCNL(String crypted, String jk, String k) throws UnsupportedEncodingException {
        HashMap<String, String> infos = new HashMap<String, String>();
        infos.put("crypted", crypted);
        if (jk != null) {
            infos.put("jk", jk);
        }
        if (k != null) {
            infos.put("k", k);
        }
        String json = JSonStorage.toString(infos);
        return "http://dummycnl.jdownloader.org/" + HexFormatter.byteArrayToHex((byte[])json.getBytes("UTF-8"));
    }

    @Override
    public void add(RemoteAPIResponse response, RemoteAPIRequest request) throws InternalApiException {
        try {
            this.askPermission(request, null, null);
            String urls = request.getParameterbyKey("urls");
            if (StringUtils.isEmpty((String)urls) && request.getParameters() != null && request.getParameters().length >= 4) {
                urls = request.getParameters()[3];
            }
            if (StringUtils.isNotEmpty((String)urls)) {
                this.clickAndLoad2Add(LinkOriginDetails.getInstance(LinkOrigin.CNL, request.getRequestHeaders().getValue("user-agent")), urls, request);
            }
            this.writeString(response, request, "success\r\n", true);
        }
        catch (Throwable e) {
            this.writeString(response, request, "failed " + e.getMessage() + "\r\n", true);
        }
    }

    @Override
    public void add(RemoteAPIRequest request, RemoteAPIResponse response, String fromFallback, String password, String source, String url) throws InternalApiException {
        this.add(request, response, password, source, url);
    }

    @Override
    public void add(RemoteAPIRequest request, RemoteAPIResponse response, String passwordParam, String sourceParam, String urlParam) throws InternalApiException {
        try {
            String source = null;
            boolean keyValueParams = request.getParameterbyKey("urls") != null;
            try {
                if (keyValueParams) {
                    source = request.getParameterbyKey("source");
                } else if (request.getParameters() != null && request.getParameters().length >= 3) {
                    source = request.getParameters()[2];
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (source == null) {
                source = sourceParam;
            }
            this.askPermission(request, source, null);
            String urls = null;
            try {
                if (keyValueParams) {
                    urls = request.getParameterbyKey("urls");
                } else if (request.getParameters() != null && request.getParameters().length >= 4) {
                    urls = request.getParameters()[3];
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (urls == null) {
                urls = urlParam;
            }
            String passwords = null;
            try {
                if (keyValueParams) {
                    passwords = request.getParameterbyKey("passwords");
                } else if (request.getParameters() != null && request.getParameters().length >= 2) {
                    passwords = request.getParameters()[1];
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (passwords == null) {
                passwords = passwordParam;
            }
            String finalPasswords = passwords;
            String finalComment = request.getParameterbyKey("comment");
            LinkCollectingJob job = new LinkCollectingJob(LinkOriginDetails.getInstance(LinkOrigin.CNL, request.getRequestHeaders().getValue("user-agent")), urls);
            String finalDestination = request.getParameterbyKey("dir");
            job.setCustomSourceUrl(source);
            String finalPackageName = this.getPackageName(request);
            ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
            ArrayList<CrawledLinkModifier> requiredPreModifiers = new ArrayList<CrawledLinkModifier>();
            if (StringUtils.isNotEmpty((String)finalDestination)) {
                modifiers.add(new DownloadFolderModifier(finalDestination, true));
            }
            if (StringUtils.isNotEmpty((String)finalPackageName)) {
                PackageNameModifier mod = new PackageNameModifier(finalPackageName, true);
                modifiers.add(mod);
                requiredPreModifiers.add(mod);
            }
            if (StringUtils.isNotEmpty((String)finalComment)) {
                modifiers.add(new CommentModifier(finalComment));
            }
            if (request.getParameterbyKey("autostart") != null) {
                final Boolean finalAutostart = "true".equals(request.getParameterbyKey("autostart"));
                modifiers.add(new CrawledLinkModifier(){

                    @Override
                    public boolean modifyCrawledLink(CrawledLink link) {
                        link.setAutoConfirmEnabled(finalAutostart);
                        link.setAutoStartEnabled(finalAutostart);
                        return true;
                    }
                });
            }
            if (StringUtils.isNotEmpty((String)finalPasswords)) {
                final ArrayList<String> pws = new ArrayList<String>();
                pws.add(finalPasswords);
                job.setArchivPasswords(pws);
                modifiers.add(new CrawledLinkModifier(){

                    @Override
                    public boolean modifyCrawledLink(CrawledLink link) {
                        link.getArchiveInfo().getExtractionPasswords().addAll(pws);
                        return true;
                    }
                });
            }
            if (modifiers.size() > 0) {
                if (StringUtils.isNotEmpty((String)finalPackageName) || StringUtils.isNotEmpty((String)finalDestination)) {
                    job.addPrePackagizerModifier(new CrawledLinkModifiers(requiredPreModifiers));
                    job.addPostPackagizerModifier(new CrawledLinkModifiers(modifiers));
                } else {
                    job.addPrePackagizerModifier(new CrawledLinkModifiers(modifiers));
                }
            }
            LinkCollector.getInstance().addCrawlerJob(job);
        }
        catch (Throwable e) {
            this.writeString(response, request, "failed " + e.getMessage() + "\r\n", true);
        }
    }

    @Override
    public void addcrypted(RemoteAPIResponse response, RemoteAPIRequest request) throws InternalApiException {
        try {
            this.askPermission(request, null, null);
            String dlcContent = request.getParameterbyKey("crypted");
            if (dlcContent == null) {
                throw new IllegalArgumentException("no DLC Content available");
            }
            String dlc = dlcContent.trim().replace(" ", "+");
            File tmp = Application.getTempResource((String)("jd_" + System.currentTimeMillis() + ".dlc"));
            IO.writeToFile((File)tmp, (byte[])dlc.getBytes("UTF-8"));
            String url = tmp.toURI().toString();
            this.clickAndLoad2Add(LinkOriginDetails.getInstance(LinkOrigin.CNL, request.getRequestHeaders().getValue("user-agent")), url, request);
            this.writeString(response, request, "success\r\n", true);
        }
        catch (Throwable e) {
            this.writeString(response, request, "failed " + e.getMessage() + "\r\n", true);
        }
    }

    private synchronized void askPermission(RemoteAPIRequest request, String fallbackSource, Boolean byPassPermission) throws IOException, DialogNoAnswerException {
        ArrayList<String> allowed;
        if (!Boolean.FALSE.equals(byPassPermission) && request.getHttpRequest() instanceof MyJDownloaderRequestInterface) {
            return;
        }
        HTTPHeader jdrandomNumber = request.getRequestHeaders().get("jd.randomnumber");
        if (jdrandomNumber != null && jdrandomNumber.getValue() != null && jdrandomNumber.getValue().equalsIgnoreCase(System.getProperty("jd.randomNumber"))) {
            return;
        }
        HTTPHeader referer = request.getRequestHeaders().get("Referer");
        String check = null;
        if (referer != null && (check = referer.getValue()) != null) {
            try {
                URL url = new URL(check);
                if (StringUtils.startsWithCaseInsensitive((String)url.getPath(), (String)"/flashgot") && InetAddress.getByName(url.getHost()).isLoopbackAddress()) {
                    return;
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        String app = "unknown application";
        HTTPHeader agent = request.getRequestHeaders().get("User-Agent");
        if (agent != null && agent.getValue() != null) {
            app = agent.getValue().replaceAll("\\(.*\\)", "");
        }
        String url = null;
        if (referer != null) {
            url = referer.getValue();
        }
        if (url == null && (url = request.getParameterbyKey("source")) != null && !url.matches("^([a-z0-9\\-]+\\.){1,}[a-z0-9]+$") && StringUtils.containsIgnoreCase((String)request.getParameterbyKey("passwords"), (String)"filecrypt.cc")) {
            url = "filecrypt.cc";
        }
        if (url == null) {
            url = fallbackSource;
        }
        if (url != null) {
            url = Browser.getHost((String)url);
        }
        if ((allowed = ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).getExternInterfaceAuth()) != null && url != null && allowed.contains(url)) {
            return;
        }
        String from = url != null ? url : app;
        ConfirmDialog d = new ConfirmDialog(0, ExternInterfaceTranslation.T.jd_plugins_optional_interfaces_jdflashgot_security_title(from), ExternInterfaceTranslation.T.jd_plugins_optional_interfaces_jdflashgot_security_message(), null, ExternInterfaceTranslation.T.jd_plugins_optional_interfaces_jdflashgot_security_btn_allow(), ExternInterfaceTranslation.T.jd_plugins_optional_interfaces_jdflashgot_security_btn_deny()){

            public Dialog.ModalityType getModalityType() {
                return Dialog.ModalityType.MODELESS;
            }
        };
        ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
        if (url != null) {
            if (allowed == null) {
                allowed = new ArrayList();
            }
            allowed.add(url);
            ((RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class)).setExternInterfaceAuth(allowed);
        }
    }

    @Override
    public void alive(RemoteAPIResponse response, RemoteAPIRequest request) throws InternalApiException {
        this.writeString(response, request, "JDownloader\r\n", true);
    }

    @Override
    public void favicon(RemoteAPIResponse response) throws InternalApiException {
        OutputStream out = null;
        try {
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "image/x-icon", false));
            out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, null, (boolean)false, (boolean)false);
            AbstractIcon logo = new AbstractIcon("logo/jd_logo_128_128", 32);
            ICOEncoder.write((BufferedImage)IconIO.toBufferedImage((Icon)logo), (OutputStream)out);
        }
        catch (Throwable e) {
            throw new InternalApiException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable logo) {}
        }
    }

    private String getValue(String[] values, int index) {
        if (values != null && index >= 0 && index < values.length && StringUtils.isNotEmpty((String)values[index])) {
            return values[index];
        }
        return null;
    }

    @Override
    public void flashgot(RemoteAPIResponse response, RemoteAPIRequest request) throws InternalApiException {
        try {
            this.askPermission(request, null, null);
            StringBuilder sb = new StringBuilder();
            sb.append(jdpath + "\r\n");
            sb.append("java -Xmx512m -jar " + jdpath + "\r\n");
            String[] urls = Regex.getLines((String)request.getParameterbyKey("urls"));
            if (urls != null && urls.length > 0) {
                String[] desc = Regex.getLines((String)request.getParameterbyKey("descriptions"));
                String[] fnames = Regex.getLines((String)request.getParameterbyKey("fnames"));
                String cookies = request.getParameterbyKey("cookies");
                String post = request.getParameterbyKey("postData");
                final String referer = request.getParameterbyKey("referer");
                String[] downloadPasswords = Regex.getLines((String)request.getParameterbyKey("dpass"));
                String[] archivePasswords = Regex.getLines((String)request.getParameterbyKey("apass"));
                final Boolean finalAutostart = request.getParameterbyKey("autostart") != null ? Boolean.valueOf("1".equals(request.getParameterbyKey("autostart"))) : null;
                LinkCollectingJob job = new LinkCollectingJob(LinkOriginDetails.getInstance(LinkOrigin.FLASHGOT, request.getRequestHeaders().getValue("user-agent")), null);
                String finalPackageName = request.getParameterbyKey("package");
                ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
                ArrayList<CrawledLinkModifier> requiredPreModifiers = new ArrayList<CrawledLinkModifier>();
                String dir = request.getParameterbyKey("dir");
                if (dir != null && dir.matches("^[a-zA-Z]{1}:$")) {
                    dir = dir + "/";
                }
                if (archivePasswords != null) {
                    final HashSet<String> pws = new HashSet<String>();
                    for (String p : archivePasswords) {
                        if (!StringUtils.isNotEmpty((String)p)) continue;
                        pws.add(p);
                    }
                    if (pws.size() > 0) {
                        job.setArchivPasswords(new ArrayList<String>(pws));
                        modifiers.add(new CrawledLinkModifier(){

                            @Override
                            public boolean modifyCrawledLink(CrawledLink link) {
                                link.getArchiveInfo().getExtractionPasswords().addAll(pws);
                                return true;
                            }
                        });
                    }
                }
                if (finalAutostart != null) {
                    modifiers.add(new CrawledLinkModifier(){

                        @Override
                        public boolean modifyCrawledLink(CrawledLink link) {
                            link.setAutoConfirmEnabled(finalAutostart);
                            link.setAutoStartEnabled(finalAutostart);
                            return true;
                        }
                    });
                }
                if (StringUtils.isNotEmpty((String)finalPackageName)) {
                    PackageNameModifier mod = new PackageNameModifier(finalPackageName, true);
                    modifiers.add(mod);
                    requiredPreModifiers.add(mod);
                }
                if (StringUtils.isNotEmpty((String)dir)) {
                    modifiers.add(new DownloadFolderModifier(dir, true));
                }
                if (modifiers.size() > 0) {
                    if (requiredPreModifiers.size() > 0) {
                        job.addPrePackagizerModifier(new CrawledLinkModifiers(requiredPreModifiers));
                    }
                    job.addPostPackagizerModifier(new CrawledLinkModifiers(modifiers));
                }
                UnknownCrawledLinkHandler unknownCrawledLinkHandler = new UnknownCrawledLinkHandler(){

                    @Override
                    public void unhandledCrawledLink(CrawledLink link, LinkCrawler lc) {
                        DownloadLink dl = link.getDownloadLink();
                        if (dl != null && !StringUtils.startsWithCaseInsensitive((String)dl.getPluginPatternMatcher(), (String)"directhttp://")) {
                            dl.setPluginPatternMatcher("directhttp://" + dl.getPluginPatternMatcher());
                        }
                    }
                };
                ArrayList<CrawledLink> links = new ArrayList<CrawledLink>();
                for (int index = 0; index < urls.length; ++index) {
                    DownloadLink downloadLink = new DownloadLink(null, null, null, urls[index], true);
                    downloadLink.setReferrerUrl(referer);
                    downloadLink.setDownloadPassword(this.getValue(downloadPasswords, index));
                    downloadLink.setComment(this.getValue(desc, index));
                    downloadLink.setForcedFileName(this.getValue(fnames, index));
                    if (StringUtils.isNotEmpty((String)cookies)) {
                        downloadLink.setProperty("cookies", cookies);
                    }
                    if (StringUtils.isNotEmpty((String)post)) {
                        downloadLink.setProperty("post", post);
                    }
                    CrawledLink crawledLink = new CrawledLink(downloadLink);
                    crawledLink.setOrigin(job.getOrigin());
                    crawledLink.setSourceJob(job);
                    if (StringUtils.isNotEmpty((String)referer)) {
                        crawledLink.setCustomCrawledLinkModifier(new CrawledLinkModifier(){

                            @Override
                            public boolean modifyCrawledLink(CrawledLink link) {
                                DownloadLink dl = link.getDownloadLink();
                                if (dl != null && StringUtils.isEmpty((String)dl.getReferrerUrl())) {
                                    dl.setReferrerUrl(referer);
                                    return true;
                                }
                                return false;
                            }
                        });
                    }
                    crawledLink.setUnknownHandler(unknownCrawledLinkHandler);
                    links.add(crawledLink);
                }
                LinkCollector.getInstance().addCrawlerJob(links, job);
            }
            this.writeString(response, request, sb.toString(), true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalApiException(e);
        }
    }
}

