/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.dialog;

import org.appwork.uio.UserIODefinition;
import org.jdownloader.controlling.UniqueAlltimeID;

public class ApiHandle {
    private final UniqueAlltimeID id = new UniqueAlltimeID();
    private final long created = System.currentTimeMillis();
    private volatile boolean disposed = false;
    private final UserIODefinition impl;
    private final Thread thread;
    private final Class<? extends UserIODefinition> iface;
    private volatile UserIODefinition answer;

    public UserIODefinition getAnswer() {
        return this.answer;
    }

    public UserIODefinition getImpl() {
        return this.impl;
    }

    public long getCreated() {
        return this.created;
    }

    public UniqueAlltimeID getUniqueAlltimeID() {
        return this.id;
    }

    public ApiHandle(Class<? extends UserIODefinition> iface, UserIODefinition impl, Thread thread) {
        this.thread = thread;
        this.impl = impl;
        this.iface = iface;
    }

    public Class<? extends UserIODefinition> getIface() {
        return this.iface;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException {
        while (true) {
            ApiHandle apiHandle = this;
            synchronized (apiHandle) {
                if (this.disposed || this.answer != null) {
                    return;
                }
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApiHandle apiHandle = this;
        synchronized (apiHandle) {
            this.disposed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnswer(UserIODefinition ret) {
        ApiHandle apiHandle = this;
        synchronized (apiHandle) {
            this.answer = ret;
            this.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

