/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.dialog;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.RemoteAPIEventsSender;
import org.appwork.remoteapi.events.SimpleEventObject;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.uio.CloseReason;
import org.appwork.uio.In;
import org.appwork.uio.Out;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.dialog.ApiHandle;
import org.jdownloader.api.dialog.BadOrderException;
import org.jdownloader.api.dialog.DialogApiInterface;
import org.jdownloader.api.dialog.DialogInfo;
import org.jdownloader.api.dialog.DialogTypeInfo;
import org.jdownloader.api.dialog.InvalidIdException;
import org.jdownloader.api.dialog.RemoteAPIIOHandlerWrapper;
import org.jdownloader.api.dialog.TypeNotFoundException;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.bindings.interfaces.DialogInterface;

public class DialogApiImpl
implements EventPublisher,
DialogApiInterface {
    private final RemoteAPIIOHandlerWrapper callback;
    private final LogSource logger;
    private final Map<UniqueAlltimeID, ApiHandle> map = new HashMap<UniqueAlltimeID, ApiHandle>();
    private final String[] eventIDs;
    private final CopyOnWriteArraySet<RemoteAPIEventsSender> eventSenders = new CopyOnWriteArraySet();

    public DialogApiImpl(RemoteAPIIOHandlerWrapper remoteAPIHandlerWrapper) {
        RemoteAPIController.validateInterfaces(DialogApiInterface.class, DialogInterface.class);
        this.callback = remoteAPIHandlerWrapper;
        this.logger = LogController.getInstance().getLogger(DialogApiImpl.class.getName());
        this.eventIDs = new String[]{Event.NEW.toString(), Event.EXPIRED.toString()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends UserIODefinition> ApiHandle enqueue(Class<T> class1, T impl) {
        if (class1 == null) {
            return null;
        }
        if (!impl.isRemoteAPIEnabled() && !Application.isHeadless()) {
            return null;
        }
        final ApiHandle ret = new ApiHandle(class1, impl, Thread.currentThread());
        final long dialogID = ret.getUniqueAlltimeID().getID();
        Map<UniqueAlltimeID, ApiHandle> map = this.map;
        synchronized (map) {
            this.map.put(ret.getUniqueAlltimeID(), ret);
        }
        new Thread("Dialog(" + (Object)((Object)ret.getUniqueAlltimeID()) + "): " + ((AbstractDialog)impl).getTitle()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (DialogApiImpl.this.eventSenders.size() > 0) {
                        Object eventObject = new SimpleEventObject((EventPublisher)DialogApiImpl.this, Event.NEW.toString(), (Object)dialogID, Long.toString(dialogID));
                        for (RemoteAPIEventsSender eventSender : DialogApiImpl.this.eventSenders) {
                            eventSender.publishEvent((EventObject)eventObject, null);
                        }
                    }
                    ret.waitFor();
                }
                catch (Exception e) {
                    DialogApiImpl.this.logger.log((Throwable)e);
                }
                finally {
                    try {
                        if (DialogApiImpl.this.eventSenders.size() > 0) {
                            SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)DialogApiImpl.this, Event.EXPIRED.toString(), (Object)dialogID, Long.toString(dialogID));
                            for (RemoteAPIEventsSender eventSender : DialogApiImpl.this.eventSenders) {
                                eventSender.publishEvent((EventObject)eventObject, null);
                            }
                        }
                    }
                    finally {
                        Map map = DialogApiImpl.this.map;
                        synchronized (map) {
                            DialogApiImpl.this.map.remove((Object)ret.getUniqueAlltimeID());
                        }
                        if (DialogApiImpl.this.callback != null) {
                            DialogApiImpl.this.callback.onHandlerDone(ret);
                        }
                    }
                }
            }
        }.start();
        return ret;
    }

    public String[] getPublisherEventIDs() {
        return this.eventIDs;
    }

    public String getPublisherName() {
        return "dialogs";
    }

    public void register(RemoteAPIEventsSender eventsAPI) {
        this.eventSenders.add(eventsAPI);
    }

    public void unregister(RemoteAPIEventsSender eventsAPI) {
        this.eventSenders.remove(eventsAPI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DialogInfo get(long dialogID, boolean icons, boolean properties) throws InvalidIdException {
        String icon;
        ApiHandle handle;
        Map<UniqueAlltimeID, ApiHandle> map = this.map;
        synchronized (map) {
            handle = this.map.get((Object)new UniqueAlltimeID(dialogID));
        }
        if (handle == null) {
            throw new InvalidIdException(dialogID);
        }
        DialogInfo ret = new DialogInfo();
        ret.setType(handle.getIface().getName());
        if (properties) {
            for (Method m : handle.getIface().getMethods()) {
                m.setAccessible(true);
                if (m.getParameterTypes().length > 0 || m.getAnnotation(Out.class) == null) continue;
                try {
                    Object value;
                    if (m.getName().startsWith("get")) {
                        value = m.invoke((Object)handle.getImpl(), new Object[0]);
                        if (value == null) continue;
                        ret.put(m.getName().substring(3).toLowerCase(Locale.ENGLISH), value);
                        continue;
                    }
                    if (m.getName().startsWith("is")) {
                        value = m.invoke((Object)handle.getImpl(), new Object[0]);
                        if (value == null) continue;
                        ret.put(m.getName().substring(2).toLowerCase(Locale.ENGLISH), value);
                        continue;
                    }
                    value = m.invoke((Object)handle.getImpl(), new Object[0]);
                    if (value == null) continue;
                    ret.put(m.getName().toLowerCase(Locale.ENGLISH), value);
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            }
            if (handle.getImpl() instanceof AbstractDialog && ((AbstractDialog)handle.getImpl()).isCountdownFlagEnabled()) {
                ret.put("timeout", ((AbstractDialog)handle.getImpl()).getCountdown());
            }
        }
        if (icons && handle.getImpl() instanceof AbstractDialog && (icon = ((AbstractDialog)handle.getImpl()).getIconDataUrl()) != null) {
            ret.put("icon", icon);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] list() {
        ArrayList<ApiHandle> list;
        Map<UniqueAlltimeID, ApiHandle> map = this.map;
        synchronized (map) {
            list = new ArrayList<ApiHandle>(this.map.values());
        }
        Collections.sort(list, new Comparator<ApiHandle>(){

            @Override
            public int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            @Override
            public int compare(ApiHandle o1, ApiHandle o2) {
                return this.compare(o1.getUniqueAlltimeID().getID(), o2.getUniqueAlltimeID().getID());
            }
        });
        long[] ret = new long[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i).getUniqueAlltimeID().getID();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void answer(long dialogID, final HashMap<String, Object> data) throws BadOrderException, InvalidIdException {
        ApiHandle handle;
        Map<UniqueAlltimeID, ApiHandle> map = this.map;
        synchronized (map) {
            for (ApiHandle ah : this.map.values()) {
                if (ah.getUniqueAlltimeID().getID() <= dialogID) continue;
                throw new BadOrderException(ah.getUniqueAlltimeID().getID());
            }
            handle = this.map.get((Object)new UniqueAlltimeID(dialogID));
        }
        if (handle == null) {
            throw new InvalidIdException(dialogID);
        }
        final CloseReason closeReason = CloseReason.valueOf((String)data.get("closereason").toString().toUpperCase(Locale.ENGLISH));
        UserIODefinition ret = (UserIODefinition)Proxy.newProxyInstance(DialogApiImpl.class.getClassLoader(), new Class[]{handle.getIface()}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("throwCloseExceptions".equals(method.getName())) {
                    switch (closeReason) {
                        case CANCEL: {
                            throw new DialogCanceledException(4);
                        }
                        case CLOSE: {
                            throw new DialogCanceledException(64);
                        }
                        case TIMEOUT: {
                            throw new DialogCanceledException(96);
                        }
                        case INTERRUPT: {
                            throw new DialogCanceledException(320);
                        }
                    }
                    return null;
                }
                String key = method.getName().toLowerCase(Locale.ENGLISH);
                if (key.startsWith("get")) {
                    key = key.substring(3);
                } else if (key.startsWith("is")) {
                    key = key.substring(2);
                }
                Object value = data.get(key);
                if ("dontshowagainselected".equals(key) && value == null) {
                    value = data.get("dontshowagain");
                }
                String json = JSonStorage.serializeToJson(value);
                Object retValue = JSonStorage.restoreFromString((String)json, (TypeRef)new TypeRef(method.getGenericReturnType()){});
                return retValue;
            }
        });
        handle.setAnswer(ret);
    }

    @Override
    public DialogTypeInfo getTypeInfo(String dialogType) throws TypeNotFoundException {
        DialogTypeInfo ret = new DialogTypeInfo();
        try {
            Class<?> cls = Class.forName(dialogType);
            for (Method m : cls.getMethods()) {
                m.setAccessible(true);
                if (m.getParameterTypes().length > 0) continue;
                try {
                    if (m.getName().startsWith("get")) {
                        if (m.getAnnotation(Out.class) != null) {
                            ret.addOut(m.getName().substring(3).toLowerCase(Locale.ENGLISH), m.getGenericReturnType().toString());
                        }
                        if (m.getAnnotation(In.class) == null) continue;
                        ret.addIn(m.getName().substring(3).toLowerCase(Locale.ENGLISH), m.getGenericReturnType().toString());
                        continue;
                    }
                    if (m.getName().startsWith("is")) {
                        if (m.getAnnotation(Out.class) != null) {
                            ret.addOut(m.getName().substring(2).toLowerCase(Locale.ENGLISH), m.getGenericReturnType().toString());
                        }
                        if (m.getAnnotation(In.class) == null) continue;
                        ret.addIn(m.getName().substring(2).toLowerCase(Locale.ENGLISH), m.getGenericReturnType().toString());
                        continue;
                    }
                    if (m.getAnnotation(Out.class) != null) {
                        ret.addOut(m.getName().toLowerCase(Locale.ENGLISH), m.getGenericReturnType().toString());
                    }
                    if (m.getAnnotation(In.class) == null) continue;
                    ret.addIn(m.getName().toLowerCase(Locale.ENGLISH), m.getGenericReturnType().toString());
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            }
        }
        catch (ClassNotFoundException e1) {
            throw new TypeNotFoundException();
        }
        return ret;
    }

    public static enum Event {
        NEW,
        EXPIRED;

    }
}

