/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.extraction;

import java.util.HashMap;
import org.appwork.remoteapi.annotations.ApiDoc;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.jdownloader.extensions.extraction.Archive;

public class ArchiveStatusStorable
implements Storable {
    private String archiveId = null;
    private long controllerId = -1L;
    private ControllerStatus controllerStatus = ControllerStatus.NA;
    private String type = null;
    private String archiveName = null;
    private HashMap<String, ArchiveFileStatus> states = null;

    public static void main(String[] args) {
        System.out.println(JSonStorage.serializeToJson((Object)new ArchiveStatusStorable()));
    }

    @ApiDoc(value="The status of the controller")
    public ControllerStatus getControllerStatus() {
        return this.controllerStatus;
    }

    public void setControllerStatus(ControllerStatus controllerStatus) {
        this.controllerStatus = controllerStatus;
    }

    @ApiDoc(value="-1 or the controller ID if any controller is active. Used in cancelExtraction?<ControllerID> ")
    public long getControllerId() {
        return this.controllerId;
    }

    public void setControllerId(long controllerId) {
        this.controllerId = controllerId;
    }

    public ArchiveStatusStorable() {
    }

    public ArchiveStatusStorable(HashMap<String, ArchiveFileStatus> states) {
        this(null, null, states);
    }

    public ArchiveStatusStorable(String archiveId, String name, HashMap<String, ArchiveFileStatus> states) {
        this.setStates(states);
        this.setArchiveId(archiveId);
        this.archiveName = name;
    }

    public ArchiveStatusStorable(Archive archive, HashMap<String, ArchiveFileStatus> states) {
        this.setStates(states);
        this.setArchiveId(archive.getArchiveID());
        this.setArchiveName(archive.getName());
        if (archive.getArchiveType() != null) {
            this.setType(archive.getArchiveType().name());
        } else if (archive.getSplitType() != null) {
            this.setType(archive.getSplitType().name());
        }
    }

    @ApiDoc(value="ID to adress the archive. Used for example for extraction/getArchiveSettings?[<ARCHIVE_ID_1>,<ARCHIVE_ID_2>,...]")
    public String getArchiveId() {
        return this.archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    @ApiDoc(value="Map Keys: Filename of the Part-File. Values: ArchiveFileStatus\r\nExample: \r\n{\r\n\"archive.part1.rar\":\"COMPLETE\",\r\n\"archive.part2.rar\":\"MISSING\"\r\n}")
    public HashMap<String, ArchiveFileStatus> getStates() {
        return this.states;
    }

    public void setStates(HashMap<String, ArchiveFileStatus> states) {
        this.states = states;
    }

    @ApiDoc(value="Type of the archive. e.g. \"GZIP_SINGLE\", \"RAR_MULTI\",\"RAR_SINGLE\",.... ")
    public String getType() {
        return this.type;
    }

    public void setType(String archiveType) {
        this.type = archiveType;
    }

    public static enum ControllerStatus {
        RUNNING,
        QUEUED,
        NA;

    }

    public static enum ArchiveFileStatus {
        COMPLETE,
        INCOMPLETE,
        MISSING;

    }
}

