/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.extraction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.utils.StringUtils;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.extraction.ArchiveSettingsAPIStorable;
import org.jdownloader.api.extraction.ArchiveStatusStorable;
import org.jdownloader.api.extraction.ExtractionAPI;
import org.jdownloader.api.utils.PackageControllerUtils;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveController;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ArchiveSettings;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.MissingArchiveFile;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.myjdownloader.client.bindings.interfaces.ExtractionInterface;

public class ExtractionAPIImpl
implements ExtractionAPI {
    private final PackageControllerUtils<FilePackage, DownloadLink> packageControllerDownloadList;
    private final PackageControllerUtils<CrawledPackage, CrawledLink> packageControllerLinkCollector;

    public ExtractionAPIImpl() {
        RemoteAPIController.validateInterfaces(ExtractionAPI.class, ExtractionInterface.class);
        this.packageControllerDownloadList = new PackageControllerUtils<FilePackage, DownloadLink>(DownloadController.getInstance());
        this.packageControllerLinkCollector = new PackageControllerUtils<CrawledPackage, CrawledLink>(LinkCollector.getInstance());
    }

    @Override
    public void addArchivePassword(String password) {
        ExtractionExtension extension = ArchiveValidator.EXTENSION;
        if (extension != null) {
            extension.addPassword(password);
        }
    }

    @Override
    public HashMap<String, Boolean> startExtractionNow(long[] linkIds, long[] packageIds) {
        List<Archive> archives;
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        ExtractionExtension extension = ArchiveValidator.EXTENSION;
        if (extension != null && (archives = this.getArchives(linkIds, packageIds)).size() > 0) {
            for (Archive archive : archives) {
                try {
                    ExtractionController controller;
                    DummyArchive da = extension.createDummyArchive(archive);
                    if (da == null || !da.isComplete() || (controller = extension.addToQueue(archive, true)) == null) continue;
                    ret.put(controller.getUniqueID().toString(), true);
                }
                catch (CheckException checkException) {}
            }
        }
        return ret;
    }

    private List<Archive> getArchives(long[] linkIds, long[] packageIds) {
        ExtractionExtension extension = ArchiveValidator.EXTENSION;
        ArrayList<Archive> ret = new ArrayList<Archive>();
        if (extension != null) {
            List archives;
            SelectionInfo<CrawledPackage, CrawledLink> linkCollectorSelection;
            List archives2;
            SelectionInfo<FilePackage, DownloadLink> downloadListSelection = this.packageControllerDownloadList.getSelectionInfo(linkIds, packageIds);
            if (downloadListSelection != null && !downloadListSelection.isEmpty() && (archives2 = ArchiveValidator.getArchivesFromPackageChildren(downloadListSelection.getChildren())) != null) {
                ret.addAll(archives2);
            }
            if ((linkCollectorSelection = this.packageControllerLinkCollector.getSelectionInfo(linkIds, packageIds)) != null && !linkCollectorSelection.isEmpty() && (archives = ArchiveValidator.getArchivesFromPackageChildren(linkCollectorSelection.getChildren())) != null) {
                ret.addAll(archives);
            }
        }
        return ret;
    }

    @Override
    public List<ArchiveStatusStorable> getArchiveInfo(long[] linkIds, long[] packageIds) {
        List<Archive> archives;
        ArrayList<ArchiveStatusStorable> ret = new ArrayList<ArchiveStatusStorable>();
        ExtractionExtension extension = ArchiveValidator.EXTENSION;
        if (extension != null && (archives = this.getArchives(linkIds, packageIds)).size() > 0) {
            List jobs = extension.getJobQueue().getJobs();
            for (Archive archive : archives) {
                ArchiveStatusStorable archiveStatus = new ArchiveStatusStorable(archive, this.getArchiveFileStatusMap(archive));
                for (ExtractionController controller : jobs) {
                    if (!controller.isSameArchive(archive)) continue;
                    archiveStatus.setControllerId(controller.getUniqueID().getID());
                    if (controller.gotStarted()) {
                        archiveStatus.setControllerStatus(ArchiveStatusStorable.ControllerStatus.RUNNING);
                        break;
                    }
                    archiveStatus.setControllerStatus(ArchiveStatusStorable.ControllerStatus.QUEUED);
                    break;
                }
                ret.add(archiveStatus);
            }
        }
        return ret;
    }

    private HashMap<String, ArchiveStatusStorable.ArchiveFileStatus> getArchiveFileStatusMap(Archive archive) {
        HashMap<String, ArchiveStatusStorable.ArchiveFileStatus> extractionStates = new HashMap<String, ArchiveStatusStorable.ArchiveFileStatus>();
        for (ArchiveFile file : archive.getArchiveFiles()) {
            if (file instanceof MissingArchiveFile) {
                extractionStates.put(file.getName(), ArchiveStatusStorable.ArchiveFileStatus.MISSING);
                continue;
            }
            if (Boolean.TRUE.equals(file.isComplete())) {
                extractionStates.put(file.getName(), ArchiveStatusStorable.ArchiveFileStatus.COMPLETE);
                continue;
            }
            extractionStates.put(file.getName(), ArchiveStatusStorable.ArchiveFileStatus.INCOMPLETE);
        }
        return extractionStates;
    }

    @Override
    public boolean cancelExtraction(long controllerID) {
        List jobs;
        ExtractionExtension extension = ArchiveValidator.EXTENSION;
        if (extension != null && (jobs = extension.getJobQueue().getJobs()) != null) {
            for (ExtractionController controller : jobs) {
                if (controller.getUniqueID().getID() != controllerID) continue;
                return extension.cancel(controller);
            }
        }
        return false;
    }

    @Override
    public List<ArchiveStatusStorable> getQueue() {
        ArrayList<ArchiveStatusStorable> ret = new ArrayList<ArchiveStatusStorable>();
        ExtractionExtension extension = ArchiveValidator.EXTENSION;
        if (extension != null) {
            List jobs = extension.getJobQueue().getJobs();
            for (ExtractionController controller : jobs) {
                Archive archive = controller.getArchive();
                ArchiveStatusStorable archiveStatus = new ArchiveStatusStorable(archive.getArchiveID(), archive.getName(), this.getArchiveFileStatusMap(archive));
                archiveStatus.setControllerId(controller.getUniqueID().getID());
                if (controller.gotStarted()) {
                    archiveStatus.setControllerStatus(ArchiveStatusStorable.ControllerStatus.RUNNING);
                } else {
                    archiveStatus.setControllerStatus(ArchiveStatusStorable.ControllerStatus.QUEUED);
                }
                ret.add(archiveStatus);
            }
        }
        return ret;
    }

    @Override
    public List<ArchiveSettingsAPIStorable> getArchiveSettings(String[] archiveIds) throws BadParameterException {
        ArrayList<ArchiveSettingsAPIStorable> ret = new ArrayList<ArchiveSettingsAPIStorable>();
        ExtractionExtension extension = ArchiveValidator.EXTENSION;
        if (extension != null && archiveIds != null) {
            for (String archiveId : archiveIds) {
                ArchiveSettings settings = ArchiveController.getInstance().getArchiveSettings(archiveId, null);
                ret.add(this.createStorable(archiveId, settings));
            }
        }
        return ret;
    }

    @Override
    public boolean setArchiveSettings(String archiveId, ArchiveSettingsAPIStorable remoteSettings) throws BadParameterException {
        if (remoteSettings == null) {
            throw new BadParameterException("settings == null");
        }
        if (StringUtils.isEmpty((String)archiveId)) {
            throw new BadParameterException("invalid archive id");
        }
        ArchiveSettings localSettings = ArchiveController.getInstance().getArchiveSettings(archiveId, null);
        if (localSettings != null) {
            if (remoteSettings.getAutoExtract() != null) {
                localSettings.setAutoExtract(BooleanStatus.convert((Boolean)remoteSettings.getAutoExtract()));
            }
            if (remoteSettings.getRemoveDownloadLinksAfterExtraction() != null) {
                localSettings.setRemoveDownloadLinksAfterExtraction(BooleanStatus.convert((Boolean)remoteSettings.getRemoveDownloadLinksAfterExtraction()));
            }
            if (remoteSettings.getRemoveFilesAfterExtraction() != null) {
                localSettings.setRemoveFilesAfterExtraction(BooleanStatus.convert((Boolean)remoteSettings.getRemoveFilesAfterExtraction()));
            }
            if (!StringUtils.isEmpty((String)remoteSettings.getExtractPath())) {
                localSettings.setExtractPath(remoteSettings.getExtractPath());
            }
            if (!StringUtils.isEmpty((String)remoteSettings.getFinalPassword())) {
                localSettings.setFinalPassword(remoteSettings.getFinalPassword());
            }
            if (remoteSettings.getPasswords() != null) {
                localSettings.setPasswords(remoteSettings.getPasswords());
            }
            return true;
        }
        throw new BadParameterException("unknown archive id");
    }

    private ArchiveSettingsAPIStorable createStorable(String archiveId, ArchiveSettings settings) {
        ArchiveSettingsAPIStorable storable = new ArchiveSettingsAPIStorable();
        storable.setArchiveId(archiveId);
        storable.setAutoExtract(BooleanStatus.convert((BooleanStatus)settings.getAutoExtract()));
        storable.setExtractPath(settings.getExtractPath());
        storable.setFinalPassword(settings.getFinalPassword());
        storable.setPasswords(settings.getPasswords());
        storable.setRemoveDownloadLinksAfterExtraction(BooleanStatus.convert((BooleanStatus)settings.getRemoveDownloadLinksAfterExtraction()));
        storable.setRemoveFilesAfterExtraction(BooleanStatus.convert((BooleanStatus)settings.getRemoveFilesAfterExtraction()));
        return storable;
    }
}

